/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.PlatformUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;

public class PrismSettings {
    public static boolean verbose;
    public static boolean debug;
    public static boolean trace;
    public static boolean printAllocs;
    public static boolean isVsyncEnabled;
    public static boolean dirtyOptsEnabled;
    public static boolean threadCheck;
    public static boolean cacheSimpleShapes;
    public static boolean cacheComplexShapes;
    public static boolean tessShapes;
    public static boolean tessShapesAA;
    public static boolean useNewImageLoader;
    public static String[] tryOrder;
    public static int numSamples;
    public static int prismStatFrequency;
    public static boolean doPiscesText;
    public static boolean doOpenPiscesText;
    public static boolean doT2KText;
    public static String refType;
    public static boolean forceRepaint;
    public static boolean isEmbededDevice;
    public static boolean noFallback;
    public static boolean showDirtyRegions;
    public static boolean showCull;
    public static boolean shutdownHook;
    public static int minTextureSize;
    public static int dirtyRegionCount;
    public static boolean disableBadDriverWarning;
    public static boolean forceGPU;
    public static int maxTextureSize;
    public static boolean allowHiDPIScaling;

    public static int parseInt(String string, int n, int n2, String string2) {
        block4: {
            if (string != null) {
                if ("true".equals(string)) {
                    return n2;
                }
                try {
                    return Integer.parseInt(string);
                }
                catch (Exception exception) {
                    if (string2 == null) break block4;
                    System.err.println(string2);
                }
            }
        }
        return n;
    }

    private static void checkSettings() {
        String string;
        isVsyncEnabled = "true".equals(System.getProperty("prism.vsync", "true")) && !Boolean.getBoolean("javafx.animation.fullspeed");
        dirtyOptsEnabled = "true".equals(System.getProperty("prism.dirtyopts", "true"));
        Integer n = Integer.getInteger("prism.dirtyregioncount");
        dirtyRegionCount = n != null ? n : 6;
        threadCheck = "true".equals(System.getProperty("prism.threadcheck", "false"));
        showDirtyRegions = Boolean.getBoolean("prism.showdirty");
        showCull = Boolean.getBoolean("prism.showcull");
        forceRepaint = Boolean.getBoolean("prism.forcerepaint");
        noFallback = Boolean.getBoolean("prism.noFallback");
        String string2 = System.getProperty("prism.cacheshapes", "complex");
        if ("all".equals(string2) || "true".equals(string2)) {
            cacheSimpleShapes = true;
            cacheComplexShapes = true;
        } else if ("complex".equals(string2)) {
            cacheSimpleShapes = false;
            cacheComplexShapes = true;
        }
        tessShapes = Boolean.getBoolean("prism.tess");
        tessShapesAA = Boolean.getBoolean("prism.tessaa");
        if (tessShapesAA) {
            tessShapes = true;
        }
        String string3 = System.getProperty("prism.newiio", "true");
        useNewImageLoader = "true".equals(string3);
        verbose = Boolean.getBoolean("prism.verbose");
        prismStatFrequency = PrismSettings.parseInt(System.getProperty("prism.printStats"), 0, 1, "Try -Dprism.printStats=<true or number>");
        debug = Boolean.getBoolean("prism.debug");
        trace = Boolean.getBoolean("prism.trace");
        printAllocs = Boolean.getBoolean("prism.printallocs");
        disableBadDriverWarning = Boolean.getBoolean("prism.disableBadDriverWarning");
        forceGPU = Boolean.getBoolean("prism.forceGPU");
        numSamples = 0;
        String string4 = System.getProperty("prism.order");
        tryOrder = string4 != null ? PrismSettings.split(string4, ",") : (PlatformUtil.isWindows() ? new String[]{"d3d", "j2d"} : (PlatformUtil.isMac() ? new String[]{"es2", "j2d"} : (PlatformUtil.isLinux() ? new String[]{"es2", "j2d"} : new String[]{"j2d"})));
        String string5 = System.getProperty("prism.multisample");
        if (string5 != null) {
            if ("true".equals(string5)) {
                numSamples = 2;
            } else {
                try {
                    numSamples = Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    System.err.println("Try -Dprism.multisample=<true|2|4|8>");
                }
            }
            if (numSamples > 0) {
                System.out.println("Enabling multisampling with " + numSamples + " samples per pixel");
            }
        }
        String string6 = System.getProperty("prism.text", "t2k");
        doPiscesText = "pisces".equals(string6);
        doOpenPiscesText = "openpisces".equals(string6);
        boolean bl = doT2KText = !doPiscesText && !doOpenPiscesText;
        if (doT2KText) {
            string6 = "t2k";
        }
        refType = System.getProperty("prism.reftype");
        shutdownHook = PlatformUtil.isUnix() ? ((string = System.getProperty("prism.shutdownHook")) == null ? true : Boolean.getBoolean("prism.shutdownHook")) : Boolean.getBoolean("prism.shutdownHook");
        isEmbededDevice = Boolean.getBoolean("prism.device");
        string = System.getProperty("prism.allowhidpi", "true");
        allowHiDPIScaling = "true".equals(string);
        if (verbose) {
            System.out.print("Prism pipeline init order: ");
            for (String string7 : tryOrder) {
                System.out.print(string7 + " ");
            }
            System.out.println("");
            System.out.println("Using " + string6 + " for text rasterization");
            if (dirtyOptsEnabled) {
                System.out.println("Using dirty region optimizations");
            } else {
                System.out.println("Not using dirty region optimizations");
            }
            if (allowHiDPIScaling) {
                System.out.println("Opting in for HiDPI pixel scaling");
            } else {
                System.out.println("Not opting in for HiDPI pixel scaling");
            }
        }
        maxTextureSize = 4096;
        String string8 = System.getProperty("prism.maxTextureSize");
        if (string8 != null) {
            try {
                int exception = Integer.parseInt(string8);
                if (exception <= 0) {
                    exception = Integer.MAX_VALUE;
                }
                maxTextureSize = exception;
            }
            catch (Exception string82) {
                System.err.println("Try -Dprism.maxTextureSize=<number>");
            }
        }
        if (isEmbededDevice) {
            minTextureSize = 0;
            String string9 = System.getProperty("prism.mintexturesize");
            if (string9 != null) {
                try {
                    minTextureSize = Integer.parseInt(string9);
                }
                catch (Exception exception) {
                    System.err.println("Try -Dprism.mintexturesize=<number>");
                }
            }
        }
    }

    private static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrismSettings.checkSettings();
                return null;
            }
        });
    }
}

