/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActiveQueue {
    private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName());
    private static final ReferenceQueue<Impl> ACTIVE = new ReferenceQueue();
    private static Reference<Impl> activeReferenceQueue = new WeakReference<Object>(null);

    private ActiveQueue() {
    }

    public static synchronized ReferenceQueue<Object> queue() {
        Impl impl = activeReferenceQueue.get();
        if (impl == null) {
            impl = new Impl();
            activeReferenceQueue = new WeakReference<Impl>(impl, ACTIVE);
            Daemon.ping();
        }
        return impl;
    }

    private static <T extends Throwable> T reportError(T t) throws IllegalStateException {
        LOGGER.log(Level.WARNING, "Cannot hack ReferenceQueue to fix bug #206621!", t);
        return t;
    }

    private static final class Daemon
    extends Thread {
        private static Daemon running;

        public Daemon() {
            super("Active Reference Queue Daemon");
        }

        static synchronized void ping() {
            if (running == null) {
                Daemon daemon = new Daemon();
                daemon.setPriority(1);
                daemon.setDaemon(true);
                daemon.start();
                LOGGER.fine("starting thread");
                running = daemon;
            }
        }

        static synchronized boolean isActive() {
            return running != null;
        }

        static synchronized void wakeUp() {
            if (running != null) {
                running.interrupt();
            }
        }

        static synchronized Impl obtainQueue() {
            Impl impl = (Impl)activeReferenceQueue.get();
            if (impl == null) {
                running = null;
            }
            return impl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 6 sources

                    {
                        if ((var1_1 = Daemon.obtainQueue()) == null) {
                            return;
                        }
                        var3_4 = var1_1.lock();
                        synchronized (var3_4) {
                            var2_3 = var1_1.pollSuper();
                            var1_1 = null;
                            if (var2_3 == null) {
                                ActiveQueue.access$100().remove(0x7FFFFFFFL);
                                continue;
                            }
                        }
                        ActiveQueue.access$200().finer("dequeued reference");
                        if (!(var2_3 instanceof Runnable)) {
                            ActiveQueue.access$200().log(Level.WARNING, "A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): {0}", var2_3.getClass());
                            continue;
                        }
                        try {
                            ((Runnable)var2_3).run();
                        }
                        catch (ThreadDeath var3_5) {
                            throw var3_5;
                        }
                        catch (Throwable var3_6) {
                            ActiveQueue.access$200().log(Level.WARNING, "Cannot process " + var2_3, var3_6);
                        }
                        finally {
                            var2_3 = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var1_2) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }

    private static final class Impl
    extends ReferenceQueue<Object> {
        private static final Field LOCK;
        private final Object myLock;

        Impl() {
            Object object = this;
            try {
                if (LOCK != null) {
                    object = LOCK.get(ACTIVE);
                    LOCK.set(this, object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ActiveQueue.reportError(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ActiveQueue.reportError(illegalAccessException);
            }
            this.myLock = object;
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long l) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        final Object lock() {
            return this.myLock;
        }

        final Reference<? extends Object> pollSuper() throws IllegalArgumentException, InterruptedException {
            return super.poll();
        }

        static {
            Field field = null;
            try {
                field = ReferenceQueue.class.getDeclaredField("lock");
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                ActiveQueue.reportError(throwable);
            }
            LOCK = field;
        }
    }
}

