/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.internal.TIFFImageWriter;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.core.writer.xmlgraphics.BaseTiffImageWriterAdapter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.PdfToMultipleTiffParameters;

final class MultipleOutputTiffImageWriterAdapter
extends BaseTiffImageWriterAdapter<PdfToMultipleTiffParameters> {
    private ImageWriter adaptedWriter = new TIFFImageWriter();

    private MultipleOutputTiffImageWriterAdapter() {
    }

    @Override
    public void openWriteDestination(OutputStream destination, PdfToMultipleTiffParameters params) {
        this.setOutputStream(destination);
    }

    @Override
    public void write(RenderedImage image, PdfToMultipleTiffParameters params) throws TaskIOException {
        if (this.getOutputDestination() == null) {
            throw new TaskIOException("Cannot call write before opening the write destination");
        }
        ImageWriterParams imageWriterParams = this.newImageWriterParams(params, params.getCompressionType());
        try {
            this.adaptedWriter.writeImage(image, this.getOutputDestination(), imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException(e);
        }
    }

    @Override
    public boolean supportMultiImage() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.adaptedWriter = null;
        super.close();
    }

    static final class MultipleOutputTiffImageWriterAdapterBuilder
    implements ImageWriter.ImageWriterBuilder<PdfToMultipleTiffParameters> {
        MultipleOutputTiffImageWriterAdapterBuilder() {
        }

        public MultipleOutputTiffImageWriterAdapter build() {
            return new MultipleOutputTiffImageWriterAdapter();
        }
    }
}

