/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.sambox.component.PdfAlternateMixer;
import org.sejda.model.exception.TaskException;
import org.sejda.model.parameter.AlternateMixParameters;
import org.sejda.model.task.BaseTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternateMixTask
extends BaseTask<AlternateMixParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AlternateMixTask.class);
    private PdfAlternateMixer mixer = null;
    private SingleOutputWriter outputWriter;

    @Override
    public void before(AlternateMixParameters parameters) {
        this.mixer = new PdfAlternateMixer(parameters.getFirstInput(), parameters.getSecondInput());
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(AlternateMixParameters parameters) throws TaskException {
        this.mixer.mix(this.getNotifiableTaskMetadata());
        this.mixer.setVersionOnPDDocument(parameters.getVersion());
        this.mixer.setCompress(parameters.isCompress());
        File tmpFile = IOUtils.createTemporaryPdfBuffer();
        LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
        this.mixer.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly(this.mixer);
        this.outputWriter.setOutput(FileOutput.file(tmpFile).name(parameters.getOutputName()));
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Alternate mix with step first document {} and step second document {} completed.", (Object)parameters.getFirstInput().getStep(), (Object)parameters.getSecondInput().getStep());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.mixer);
    }
}

