/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sejda.impl.sambox.component.PdfTextExtractorByArea;
import org.sejda.model.TopLeftRectangularBox;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.split.NextOutputStrategy;
import org.sejda.model.split.SplitPages;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByTextChangesOutputStrategy
implements NextOutputStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByTextChangesOutputStrategy.class);
    private SplitPages delegate;
    private Collection<Integer> pages;
    private Map<Integer, String> textByPage = new HashMap<Integer, String>();

    public SplitByTextChangesOutputStrategy(PDDocument document, TopLeftRectangularBox area, String startsWith, String endsWith) throws TaskIOException {
        this.pages = this.findPageToSplitAt(document, area, startsWith, endsWith);
        this.delegate = new SplitPages(this.pages);
    }

    Collection<Integer> findPageToSplitAt(PDDocument document, TopLeftRectangularBox area, String startsWith, String endsWith) throws TaskIOException {
        HashSet<Integer> pagesToSplitAt = new HashSet<Integer>();
        String prevPageText = null;
        for (int pageNumber = 1; pageNumber <= document.getNumberOfPages(); ++pageNumber) {
            boolean someChanges;
            PDPage page = document.getDocumentCatalog().getPages().get(pageNumber - 1);
            String pageText = org.sejda.core.support.util.StringUtils.nbspAsWhitespace(this.extractTextFromPageArea(page, area)).trim();
            if (StringUtils.isNotBlank(startsWith)) {
                if (!pageText.startsWith(startsWith)) {
                    LOG.debug("Detected page text does not match specified prefix: '{}' on '{}'", (Object)startsWith, (Object)pageText);
                    pageText = "";
                } else {
                    pageText = pageText.substring(startsWith.length()).trim();
                }
            }
            if (StringUtils.isNotBlank(endsWith)) {
                if (!pageText.endsWith(endsWith)) {
                    LOG.debug("Detected page text does not match specified suffix: '{}' on '{}'", (Object)pageText);
                    pageText = "";
                } else {
                    pageText = pageText.substring(0, pageText.length() - endsWith.length()).trim();
                }
            }
            boolean noChanges = prevPageText == null || StringUtils.isBlank(pageText) || prevPageText.equals(pageText);
            boolean bl = someChanges = !noChanges;
            if (someChanges) {
                LOG.debug("Text changed from {} to {} on page {} in area: {}", prevPageText, pageText, pageNumber, area);
                pagesToSplitAt.add(pageNumber - 1);
            }
            if (StringUtils.isNotBlank(pageText)) {
                prevPageText = pageText;
            }
            this.textByPage.put(pageNumber, pageText);
        }
        return pagesToSplitAt;
    }

    String extractTextFromPageArea(PDPage page, TopLeftRectangularBox area) throws TaskIOException {
        String text = new PdfTextExtractorByArea().extractTextFromArea(page, area.asRectangle());
        String result = StringUtils.defaultIfBlank(text, "");
        result = StringUtils.strip(result);
        return result;
    }

    Collection<Integer> getPages() {
        return this.pages;
    }

    @Override
    public void ensureIsValid() throws TaskExecutionException {
        this.delegate.ensureIsValid();
    }

    @Override
    public boolean isOpening(Integer page) {
        return this.delegate.isOpening(page);
    }

    @Override
    public boolean isClosing(Integer page) {
        return this.delegate.isClosing(page);
    }

    public String getTextByPage(int page) {
        return this.textByPage.get(page);
    }
}

