/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;

public class HighlightHelper {
    private final Set<OsmPrimitive> highlightedPrimitives = new HashSet<OsmPrimitive>();

    public boolean highlight(Collection<? extends OsmPrimitive> collection) {
        return this.highlight(collection, false);
    }

    public boolean highlight(Collection<? extends OsmPrimitive> collection, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            Iterator<? extends OsmPrimitive> iterator = this.highlightedPrimitives.iterator();
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = iterator.next();
                if (collection.contains(osmPrimitive)) continue;
                osmPrimitive.setHighlighted(false);
                iterator.remove();
                bl2 = true;
            }
        }
        for (OsmPrimitive osmPrimitive : collection) {
            bl2 |= this.setHighlight(osmPrimitive, true);
        }
        return bl2;
    }

    public boolean highlightOnly(Collection<? extends OsmPrimitive> collection) {
        return this.highlight(collection, true);
    }

    public boolean highlightOnly(OsmPrimitive osmPrimitive) {
        return this.highlight(Collections.singleton(osmPrimitive), true);
    }

    public boolean setHighlight(OsmPrimitive osmPrimitive, boolean bl) {
        return this.setHighlight(osmPrimitive, bl, new HashSet<Relation>());
    }

    private boolean setHighlight(OsmPrimitive osmPrimitive, boolean bl, Set<Relation> set) {
        if (osmPrimitive instanceof Relation) {
            Relation relation = (Relation)osmPrimitive;
            set.add(relation);
            boolean bl2 = false;
            for (OsmPrimitive osmPrimitive2 : relation.getMemberPrimitives()) {
                if (osmPrimitive2 instanceof Relation && set.contains(osmPrimitive2)) continue;
                bl2 |= this.setHighlight(osmPrimitive2, bl, set);
            }
            return bl2;
        }
        if (bl) {
            if (this.highlightedPrimitives.add(osmPrimitive)) {
                osmPrimitive.setHighlighted(true);
                return true;
            }
        } else if (this.highlightedPrimitives.remove(osmPrimitive)) {
            osmPrimitive.setHighlighted(false);
            return true;
        }
        return false;
    }

    public void clear() {
        for (OsmPrimitive osmPrimitive : this.highlightedPrimitives) {
            osmPrimitive.setHighlighted(false);
        }
        this.highlightedPrimitives.clear();
    }

    public void findAllHighlighted() {
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            this.highlightedPrimitives.addAll(dataSet.allNonDeletedPrimitives());
        }
    }

    public static void clearAllHighlighted() {
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            for (OsmPrimitive osmPrimitive : dataSet.allNonDeletedPrimitives()) {
                osmPrimitive.setHighlighted(false);
            }
        }
    }
}

