/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.Row;
import org.python.icu.util.Freezable;
import org.python.icu.util.ICUCloneNotSupportedException;
import org.python.icu.util.LocalePriorityList;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;
import org.python.icu.util.UResourceBundleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleMatcher {
    private static boolean DEBUG = false;
    private static final ULocale UNKNOWN_LOCALE = new ULocale("und");
    private static final double DEFAULT_THRESHOLD = 0.5;
    private final ULocale defaultLanguage;
    private final double threshold;
    Map<ULocale, Row.R2<ULocale, Double>> maximizedLanguageToWeight = new LinkedHashMap<ULocale, Row.R2<ULocale, Double>>();
    LanguageMatcherData matcherData;
    private static final LanguageMatcherData defaultWritten;
    private static HashMap<String, String> canonicalMap;

    public LocaleMatcher(LocalePriorityList languagePriorityList) {
        this(languagePriorityList, defaultWritten);
    }

    public LocaleMatcher(String languagePriorityListString) {
        this(LocalePriorityList.add(languagePriorityListString).build());
    }

    @Deprecated
    public LocaleMatcher(LocalePriorityList languagePriorityList, LanguageMatcherData matcherData) {
        this(languagePriorityList, matcherData, 0.5);
    }

    @Deprecated
    public LocaleMatcher(LocalePriorityList languagePriorityList, LanguageMatcherData matcherData, double threshold) {
        this.matcherData = matcherData == null ? defaultWritten : matcherData;
        for (ULocale language : languagePriorityList) {
            this.add(language, languagePriorityList.getWeight(language));
        }
        Iterator<ULocale> it = languagePriorityList.iterator();
        this.defaultLanguage = it.hasNext() ? it.next() : null;
        this.threshold = threshold;
    }

    public double match(ULocale desired, ULocale desiredMax, ULocale supported, ULocale supportedMax) {
        return this.matcherData.match(desired, desiredMax, supported, supportedMax);
    }

    public ULocale canonicalize(ULocale ulocale) {
        String lang = ulocale.getLanguage();
        String lang2 = canonicalMap.get(lang);
        String script = ulocale.getScript();
        String script2 = canonicalMap.get(script);
        String region = ulocale.getCountry();
        String region2 = canonicalMap.get(region);
        if (lang2 != null || script2 != null || region2 != null) {
            return new ULocale(lang2 == null ? lang : lang2, script2 == null ? script : script2, region2 == null ? region : region2);
        }
        return ulocale;
    }

    public ULocale getBestMatch(LocalePriorityList languageList) {
        double bestWeight = 0.0;
        ULocale bestTableMatch = null;
        for (ULocale language : languageList) {
            Row.R2<ULocale, Double> matchRow = this.getBestMatchInternal(language);
            double weight = (Double)matchRow.get1() * languageList.getWeight(language);
            if (!(weight > bestWeight)) continue;
            bestWeight = weight;
            bestTableMatch = (ULocale)matchRow.get0();
        }
        if (bestWeight < this.threshold) {
            bestTableMatch = this.defaultLanguage;
        }
        return bestTableMatch;
    }

    public ULocale getBestMatch(String languageList) {
        return this.getBestMatch(LocalePriorityList.add(languageList).build());
    }

    public ULocale getBestMatch(ULocale ulocale) {
        return (ULocale)this.getBestMatchInternal(ulocale).get0();
    }

    @Deprecated
    public ULocale getBestMatch(ULocale ... ulocales) {
        return this.getBestMatch(LocalePriorityList.add(ulocales).build());
    }

    public String toString() {
        return "{" + this.defaultLanguage + ", " + this.maximizedLanguageToWeight + "}";
    }

    private Row.R2<ULocale, Double> getBestMatchInternal(ULocale languageCode) {
        languageCode = this.canonicalize(languageCode);
        ULocale maximized = this.addLikelySubtags(languageCode);
        if (DEBUG) {
            System.out.println("\n" + languageCode + ";\t" + maximized);
        }
        double bestWeight = 0.0;
        ULocale bestTableMatch = null;
        for (ULocale tableKey : this.maximizedLanguageToWeight.keySet()) {
            double weight;
            Row.R2<ULocale, Double> row = this.maximizedLanguageToWeight.get(tableKey);
            double match = this.match(languageCode, maximized, tableKey, (ULocale)row.get0());
            if (DEBUG) {
                System.out.println("\t" + tableKey + ";\t" + row.toString() + ";\t" + match + "\n");
            }
            if (!((weight = match * (Double)row.get1()) > bestWeight)) continue;
            bestWeight = weight;
            bestTableMatch = tableKey;
        }
        if (bestWeight < this.threshold) {
            bestTableMatch = this.defaultLanguage;
        }
        return Row.R2.of(bestTableMatch, bestWeight);
    }

    private void add(ULocale language, Double weight) {
        language = this.canonicalize(language);
        Row.R2<ULocale, Double> row = Row.of(this.addLikelySubtags(language), weight);
        this.maximizedLanguageToWeight.put(language, row);
    }

    private ULocale addLikelySubtags(ULocale languageCode) {
        if (languageCode.equals(UNKNOWN_LOCALE)) {
            return UNKNOWN_LOCALE;
        }
        ULocale result = ULocale.addLikelySubtags(languageCode);
        if (result == null || result.equals(languageCode)) {
            String language = languageCode.getLanguage();
            String script = languageCode.getScript();
            String region = languageCode.getCountry();
            return new ULocale((language.length() == 0 ? "und" : language) + "_" + (script.length() == 0 ? "Zzzz" : script) + "_" + (region.length() == 0 ? "ZZ" : region));
        }
        return result;
    }

    @Deprecated
    public static ICUResourceBundle getICUSupplementalData() {
        ICUResourceBundle suppData = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt54b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        return suppData;
    }

    @Deprecated
    public static double match(ULocale a, ULocale b) {
        LocaleMatcher matcher = new LocaleMatcher("");
        return matcher.match(a, matcher.addLikelySubtags(a), b, matcher.addLikelySubtags(b));
    }

    static {
        canonicalMap = new HashMap();
        canonicalMap.put("iw", "he");
        canonicalMap.put("mo", "ro");
        canonicalMap.put("tl", "fil");
        ICUResourceBundle suppData = LocaleMatcher.getICUSupplementalData();
        ICUResourceBundle languageMatching = suppData.findTopLevel("languageMatching");
        ICUResourceBundle written = (ICUResourceBundle)languageMatching.get("written");
        defaultWritten = new LanguageMatcherData();
        TreeSet<DataHack> hack = new TreeSet<DataHack>();
        LocaleMatcher.defaultWritten.addDistance("en_*_US", "en_*_*", 97);
        LocaleMatcher.defaultWritten.addDistance("en_*_GB", "en_*_*", 98);
        LocaleMatcher.defaultWritten.addDistance("es_*_ES", "es_*_*", 97);
        LocaleMatcher.defaultWritten.addDistance("es_*_419", "es_*_*", 99);
        LocaleMatcher.defaultWritten.addDistance("es_*_*", "es_*_*", 98);
        UResourceBundleIterator iter = written.getIterator();
        while (iter.hasNext()) {
            ICUResourceBundle item = (ICUResourceBundle)iter.next();
            hack.add(new DataHack(item.getString(0), item.getString(1), Integer.parseInt(item.getString(2))));
        }
        for (DataHack dataHack : hack) {
            LocaleMatcher.defaultWritten.addDistance(dataHack.source, dataHack.target, dataHack.percent);
        }
        defaultWritten.freeze();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DataHack
    implements Comparable<DataHack> {
        final String source;
        final String target;
        int percent;
        static final Pattern STAR_KEEP = Pattern.compile("([^_]+)(?:_[^_]+(?:_[^_]+)?)?");

        public DataHack(String source, String target, int percent) {
            this.source = source;
            this.target = target.equals("de_CH") ? "de" : target;
            this.percent = percent;
        }

        @Override
        public int compareTo(DataHack other) {
            String otherTarget;
            String otherSource;
            int diff = this.getUnderbars(this.source) - this.getUnderbars(other.source);
            if (0 != diff) {
                return diff;
            }
            String thisSource = this.source.replace('*', '\u00fe');
            diff = thisSource.compareTo(otherSource = other.source.replace('*', '\u00fe'));
            if (0 != diff) {
                return diff;
            }
            String thisTarget = this.target.replace('*', '\u00fe');
            diff = thisTarget.compareTo(otherTarget = other.target.replace('*', '\u00fe'));
            if (0 != diff) {
                return diff;
            }
            diff = this.source.compareTo(other.source);
            if (0 != diff) {
                return diff;
            }
            return this.target.compareTo(other.target);
        }

        private int getUnderbars(String source2) {
            int pos = source2.indexOf(95);
            if (pos < 0) {
                return 0;
            }
            return (pos = source2.indexOf(95, pos + 1)) < 0 ? 1 : 2;
        }

        public String toString() {
            return this.source + ", " + this.target + " => " + this.percent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class LanguageMatcherData
    implements Freezable<LanguageMatcherData> {
        ScoreData languageScores = new ScoreData(Level.language);
        ScoreData scriptScores = new ScoreData(Level.script);
        ScoreData regionScores = new ScoreData(Level.region);
        private volatile boolean frozen = false;

        @Deprecated
        public LanguageMatcherData() {
        }

        @Deprecated
        public String toString() {
            return this.languageScores + "\n\t" + this.scriptScores + "\n\t" + this.regionScores;
        }

        @Deprecated
        public double match(ULocale a, ULocale aMax, ULocale b, ULocale bMax) {
            double diff = 0.0;
            diff += this.languageScores.getScore(a, aMax, a.getLanguage(), aMax.getLanguage(), b, bMax, b.getLanguage(), bMax.getLanguage());
            diff += this.scriptScores.getScore(a, aMax, a.getScript(), aMax.getScript(), b, bMax, b.getScript(), bMax.getScript());
            diff += this.regionScores.getScore(a, aMax, a.getCountry(), aMax.getCountry(), b, bMax, b.getCountry(), bMax.getCountry());
            if (!a.getVariant().equals(b.getVariant())) {
                diff += 0.01;
            }
            if (diff < 0.0) {
                diff = 0.0;
            } else if (diff > 1.0) {
                diff = 1.0;
            }
            if (DEBUG) {
                System.out.println("\t\t\tTotal Distance\t" + diff);
            }
            return 1.0 - diff;
        }

        @Deprecated
        private LanguageMatcherData addDistance(String desired, String supported, int percent) {
            return this.addDistance(desired, supported, percent, false, null);
        }

        @Deprecated
        public LanguageMatcherData addDistance(String desired, String supported, int percent, String comment) {
            return this.addDistance(desired, supported, percent, false, comment);
        }

        @Deprecated
        public LanguageMatcherData addDistance(String desired, String supported, int percent, boolean oneway) {
            return this.addDistance(desired, supported, percent, oneway, null);
        }

        private LanguageMatcherData addDistance(String desired, String supported, int percent, boolean oneway, String comment) {
            LocalePatternMatcher supportedMatcher;
            Level supportedLen;
            if (DEBUG) {
                System.out.println("\t<languageMatch desired=\"" + desired + "\"" + " supported=\"" + supported + "\"" + " percent=\"" + percent + "\"" + (oneway ? " oneway=\"true\"" : "") + "/>" + (comment == null ? "" : "\t<!-- " + comment + " -->"));
            }
            double score = 1.0 - (double)percent / 100.0;
            LocalePatternMatcher desiredMatcher = new LocalePatternMatcher(desired);
            Level desiredLen = desiredMatcher.getLevel();
            if (desiredLen != (supportedLen = (supportedMatcher = new LocalePatternMatcher(supported)).getLevel())) {
                throw new IllegalArgumentException("Lengths unequal: " + desired + ", " + supported);
            }
            Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data = Row.of(desiredMatcher, supportedMatcher, score);
            Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data2 = oneway ? null : Row.of(supportedMatcher, desiredMatcher, score);
            switch (desiredLen) {
                case language: {
                    String dlanguage = desiredMatcher.getLanguage();
                    String slanguage = supportedMatcher.getLanguage();
                    this.languageScores.addDataToScores(dlanguage, slanguage, data);
                    if (oneway) break;
                    this.languageScores.addDataToScores(slanguage, dlanguage, data2);
                    break;
                }
                case script: {
                    String dscript = desiredMatcher.getScript();
                    String sscript = supportedMatcher.getScript();
                    this.scriptScores.addDataToScores(dscript, sscript, data);
                    if (oneway) break;
                    this.scriptScores.addDataToScores(sscript, dscript, data2);
                    break;
                }
                case region: {
                    String dregion = desiredMatcher.getRegion();
                    String sregion = supportedMatcher.getRegion();
                    this.regionScores.addDataToScores(dregion, sregion, data);
                    if (oneway) break;
                    this.regionScores.addDataToScores(sregion, dregion, data2);
                }
            }
            return this;
        }

        @Override
        @Deprecated
        public LanguageMatcherData cloneAsThawed() {
            try {
                LanguageMatcherData result = (LanguageMatcherData)this.clone();
                result.languageScores = this.languageScores.cloneAsThawed();
                result.scriptScores = this.scriptScores.cloneAsThawed();
                result.regionScores = this.regionScores.cloneAsThawed();
                result.frozen = false;
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new ICUCloneNotSupportedException(e);
            }
        }

        @Override
        @Deprecated
        public LanguageMatcherData freeze() {
            return this;
        }

        @Override
        @Deprecated
        public boolean isFrozen() {
            return this.frozen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScoreData
    implements Freezable<ScoreData> {
        private static final double maxUnequal_changeD_sameS = 0.5;
        private static final double maxUnequal_changeEqual = 0.75;
        LinkedHashSet<Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double>> scores = new LinkedHashSet();
        final Level level;
        private volatile boolean frozen = false;

        public ScoreData(Level level) {
            this.level = level;
        }

        void addDataToScores(String desired, String supported, Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data) {
            this.scores.add(data);
        }

        double getScore(ULocale desiredLocale, ULocale dMax, String desiredRaw, String desiredMax, ULocale supportedLocale, ULocale sMax, String supportedRaw, String supportedMax) {
            double distance = 0.0;
            if (!desiredMax.equals(supportedMax)) {
                distance = this.getRawScore(dMax, sMax);
            } else if (!desiredRaw.equals(supportedRaw)) {
                distance += 0.001;
            }
            return distance;
        }

        private double getRawScore(ULocale desiredLocale, ULocale supportedLocale) {
            if (DEBUG) {
                System.out.println("\t\t\t" + (Object)((Object)this.level) + " Raw Score:\t" + desiredLocale + ";\t" + supportedLocale);
            }
            for (Row.R3 r3 : this.scores) {
                if (!((LocalePatternMatcher)r3.get0()).matches(desiredLocale) || !((LocalePatternMatcher)r3.get1()).matches(supportedLocale)) continue;
                if (DEBUG) {
                    System.out.println("\t\t\t\tFOUND\t" + r3);
                }
                return (Double)r3.get2();
            }
            if (DEBUG) {
                System.out.println("\t\t\t\tNOTFOUND\t" + this.level.worst);
            }
            return this.level.worst;
        }

        public String toString() {
            StringBuilder result = new StringBuilder().append((Object)this.level);
            for (Row.R3 r3 : this.scores) {
                result.append("\n\t\t").append(r3);
            }
            return result.toString();
        }

        @Override
        public ScoreData cloneAsThawed() {
            try {
                ScoreData result = (ScoreData)this.clone();
                result.scores = (LinkedHashSet)result.scores.clone();
                result.frozen = false;
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new ICUCloneNotSupportedException(e);
            }
        }

        @Override
        public ScoreData freeze() {
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Level {
        language(0.99),
        script(0.2),
        region(0.04);

        final double worst;

        private Level(double d) {
            this.worst = d;
        }
    }

    private static class LocalePatternMatcher {
        private String lang;
        private String script;
        private String region;
        private Level level;
        static Pattern pattern = Pattern.compile("([a-z]{1,8}|\\*)(?:[_-]([A-Z][a-z]{3}|\\*))?(?:[_-]([A-Z]{2}|[0-9]{3}|\\*))?");

        public LocalePatternMatcher(String toMatch) {
            Matcher matcher = pattern.matcher(toMatch);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Bad pattern: " + toMatch);
            }
            this.lang = matcher.group(1);
            this.script = matcher.group(2);
            this.region = matcher.group(3);
            Level level = this.region != null ? Level.region : (this.level = this.script != null ? Level.script : Level.language);
            if (this.lang.equals("*")) {
                this.lang = null;
            }
            if (this.script != null && this.script.equals("*")) {
                this.script = null;
            }
            if (this.region != null && this.region.equals("*")) {
                this.region = null;
            }
        }

        boolean matches(ULocale ulocale) {
            if (this.lang != null && !this.lang.equals(ulocale.getLanguage())) {
                return false;
            }
            if (this.script != null && !this.script.equals(ulocale.getScript())) {
                return false;
            }
            return this.region == null || this.region.equals(ulocale.getCountry());
        }

        public Level getLevel() {
            return this.level;
        }

        public String getLanguage() {
            return this.lang == null ? "*" : this.lang;
        }

        public String getScript() {
            return this.script == null ? "*" : this.script;
        }

        public String getRegion() {
            return this.region == null ? "*" : this.region;
        }

        public String toString() {
            String result = this.getLanguage();
            if (this.level != Level.language) {
                result = result + "-" + this.getScript();
                if (this.level != Level.script) {
                    result = result + "-" + this.getRegion();
                }
            }
            return result;
        }
    }
}

