/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.context;

import java.util.Map;
import org.sejda.core.Sejda;
import org.sejda.core.context.DefaultTasksRegistry;
import org.sejda.core.context.TasksRegistry;
import org.sejda.core.context.XmlConfigurationStrategy;
import org.sejda.core.context.XmlConfigurationStreamProvider;
import org.sejda.core.notification.strategy.NotificationStrategy;
import org.sejda.model.exception.ConfigurationException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfiguration.class);
    private Class<? extends NotificationStrategy> notificationStrategy;
    private TasksRegistry tasksRegistry;
    private boolean validation;
    private boolean ignoreXmlConfiguration;

    private GlobalConfiguration() {
        LOG.info("Configuring Sejda {}", (Object)Sejda.VERSION);
        this.initialize();
        if (LOG.isDebugEnabled()) {
            this.logConfiguredTasks();
        }
    }

    private void logConfiguredTasks() {
        LOG.trace("Configured tasks:");
        for (Map.Entry<Class<? extends TaskParameters>, Class<? extends Task>> entry : this.tasksRegistry.getTasks().entrySet()) {
            LOG.trace(String.format("%s executed by -> %s", entry.getKey(), entry.getValue()));
        }
    }

    private void initialize() {
        XmlConfigurationStrategy configStrategy;
        this.tasksRegistry = new DefaultTasksRegistry();
        try {
            configStrategy = XmlConfigurationStrategy.newInstance(new XmlConfigurationStreamProvider());
        }
        catch (ConfigurationException e) {
            throw new SejdaRuntimeException("Unable to complete Sejda configuration ", e);
        }
        this.notificationStrategy = configStrategy.getNotificationStrategy();
        LOG.trace("Notification strategy: {}", (Object)this.notificationStrategy);
        this.validation = configStrategy.isValidation();
        LOG.trace("Validation: {}", (Object)this.validation);
        this.ignoreXmlConfiguration = configStrategy.isIgnoreXmlConfiguration();
        LOG.trace("Validation, ignore xml configuration: {}", (Object)this.ignoreXmlConfiguration);
        Map<Class<? extends TaskParameters>, Class<? extends Task>> userTasks = configStrategy.getTasksMap();
        for (Map.Entry<Class<? extends TaskParameters>, Class<? extends Task>> entry : userTasks.entrySet()) {
            this.tasksRegistry.addTask(entry.getKey(), entry.getValue());
        }
    }

    static GlobalConfiguration getInstance() {
        return GlobalConfigurationHolder.CONFIGURATION;
    }

    Class<? extends NotificationStrategy> getNotificationStrategy() {
        return this.notificationStrategy;
    }

    TasksRegistry getTasksRegistry() {
        return this.tasksRegistry;
    }

    boolean isValidation() {
        return this.validation;
    }

    boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    private static final class GlobalConfigurationHolder {
        static final GlobalConfiguration CONFIGURATION = new GlobalConfiguration();

        private GlobalConfigurationHolder() {
        }
    }
}

