/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

import org.mozilla.javascript.v8dtoa.CachedPowers;
import org.mozilla.javascript.v8dtoa.DiyFp;
import org.mozilla.javascript.v8dtoa.DoubleHelper;
import org.mozilla.javascript.v8dtoa.FastDtoaBuilder;

public class FastDtoa {
    static final int kFastDtoaMaximalLength = 17;
    static final int minimal_target_exponent = -60;
    static final int maximal_target_exponent = -32;
    static final int kTen4 = 10000;
    static final int kTen5 = 100000;
    static final int kTen6 = 1000000;
    static final int kTen7 = 10000000;
    static final int kTen8 = 100000000;
    static final int kTen9 = 1000000000;

    static boolean roundWeed(FastDtoaBuilder fastDtoaBuilder, long l, long l2, long l3, long l4, long l5) {
        long l6 = l - l5;
        long l7 = l + l5;
        while (l3 < l6 && l2 - l3 >= l4 && (l3 + l4 < l6 || l6 - l3 >= l3 + l4 - l6)) {
            fastDtoaBuilder.decreaseLast();
            l3 += l4;
        }
        if (l3 < l7 && l2 - l3 >= l4 && (l3 + l4 < l7 || l7 - l3 > l3 + l4 - l7)) {
            return false;
        }
        return 2L * l5 <= l3 && l3 <= l2 - 4L * l5;
    }

    static long biggestPowerTen(int n, int n2) {
        int n3;
        int n4;
        switch (n2) {
            case 30: 
            case 31: 
            case 32: {
                if (1000000000 <= n) {
                    n4 = 1000000000;
                    n3 = 9;
                    break;
                }
            }
            case 27: 
            case 28: 
            case 29: {
                if (100000000 <= n) {
                    n4 = 100000000;
                    n3 = 8;
                    break;
                }
            }
            case 24: 
            case 25: 
            case 26: {
                if (10000000 <= n) {
                    n4 = 10000000;
                    n3 = 7;
                    break;
                }
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (1000000 <= n) {
                    n4 = 1000000;
                    n3 = 6;
                    break;
                }
            }
            case 17: 
            case 18: 
            case 19: {
                if (100000 <= n) {
                    n4 = 100000;
                    n3 = 5;
                    break;
                }
            }
            case 14: 
            case 15: 
            case 16: {
                if (10000 <= n) {
                    n4 = 10000;
                    n3 = 4;
                    break;
                }
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (1000 <= n) {
                    n4 = 1000;
                    n3 = 3;
                    break;
                }
            }
            case 7: 
            case 8: 
            case 9: {
                if (100 <= n) {
                    n4 = 100;
                    n3 = 2;
                    break;
                }
            }
            case 4: 
            case 5: 
            case 6: {
                if (10 <= n) {
                    n4 = 10;
                    n3 = 1;
                    break;
                }
            }
            case 1: 
            case 2: 
            case 3: {
                if (1 <= n) {
                    n4 = 1;
                    n3 = 0;
                    break;
                }
            }
            case 0: {
                n4 = 0;
                n3 = -1;
                break;
            }
            default: {
                n4 = 0;
                n3 = 0;
            }
        }
        return (long)n4 << 32 | 0xFFFFFFFFL & (long)n3;
    }

    private static boolean uint64_lte(long l, long l2) {
        return l == l2 || l < l2 ^ l < 0L ^ l2 < 0L;
    }

    static boolean digitGen(DiyFp diyFp, DiyFp diyFp2, DiyFp diyFp3, FastDtoaBuilder fastDtoaBuilder, int n) {
        int n2;
        assert (diyFp.e() == diyFp2.e() && diyFp2.e() == diyFp3.e());
        assert (FastDtoa.uint64_lte(diyFp.f() + 1L, diyFp3.f() - 1L));
        assert (-60 <= diyFp2.e() && diyFp2.e() <= -32);
        long l = 1L;
        DiyFp diyFp4 = new DiyFp(diyFp.f() - l, diyFp.e());
        DiyFp diyFp5 = new DiyFp(diyFp3.f() + l, diyFp3.e());
        DiyFp diyFp6 = DiyFp.minus(diyFp5, diyFp4);
        DiyFp diyFp7 = new DiyFp(1L << -diyFp2.e(), diyFp2.e());
        int n3 = (int)(diyFp5.f() >>> -diyFp7.e() & 0xFFFFFFFFL);
        long l2 = diyFp5.f() & diyFp7.f() - 1L;
        long l3 = FastDtoa.biggestPowerTen(n3, 64 - -diyFp7.e());
        int n4 = (int)(l3 >>> 32 & 0xFFFFFFFFL);
        int n5 = (int)(l3 & 0xFFFFFFFFL);
        int n6 = n5 + 1;
        while (n6 > 0) {
            n2 = n3 / n4;
            fastDtoaBuilder.append((char)(48 + n2));
            --n6;
            long l4 = ((long)(n3 %= n4) << -diyFp7.e()) + l2;
            if (l4 < diyFp6.f()) {
                fastDtoaBuilder.point = fastDtoaBuilder.end - n + n6;
                return FastDtoa.roundWeed(fastDtoaBuilder, DiyFp.minus(diyFp5, diyFp2).f(), diyFp6.f(), l4, (long)n4 << -diyFp7.e(), l);
            }
            n4 /= 10;
        }
        do {
            l2 *= 5L;
            l *= 5L;
            diyFp6.setF(diyFp6.f() * 5L);
            diyFp6.setE(diyFp6.e() + 1);
            diyFp7.setF(diyFp7.f() >>> 1);
            diyFp7.setE(diyFp7.e() + 1);
            n2 = (int)(l2 >>> -diyFp7.e() & 0xFFFFFFFFL);
            fastDtoaBuilder.append((char)(48 + n2));
            --n6;
        } while ((l2 &= diyFp7.f() - 1L) >= diyFp6.f());
        fastDtoaBuilder.point = fastDtoaBuilder.end - n + n6;
        return FastDtoa.roundWeed(fastDtoaBuilder, DiyFp.minus(diyFp5, diyFp2).f() * l, diyFp6.f(), l2, diyFp7.f(), l);
    }

    static boolean grisu3(double d, FastDtoaBuilder fastDtoaBuilder) {
        long l = Double.doubleToLongBits(d);
        DiyFp diyFp = DoubleHelper.asNormalizedDiyFp(l);
        DiyFp diyFp2 = new DiyFp();
        DiyFp diyFp3 = new DiyFp();
        DoubleHelper.normalizedBoundaries(l, diyFp2, diyFp3);
        assert (diyFp3.e() == diyFp.e());
        DiyFp diyFp4 = new DiyFp();
        int n = CachedPowers.getCachedPower(diyFp.e() + 64, -60, -32, diyFp4);
        assert (-60 <= diyFp.e() + diyFp4.e() + 64 && -32 >= diyFp.e() + diyFp4.e() + 64);
        DiyFp diyFp5 = DiyFp.times(diyFp, diyFp4);
        assert (diyFp5.e() == diyFp3.e() + diyFp4.e() + 64);
        DiyFp diyFp6 = DiyFp.times(diyFp2, diyFp4);
        DiyFp diyFp7 = DiyFp.times(diyFp3, diyFp4);
        return FastDtoa.digitGen(diyFp6, diyFp5, diyFp7, fastDtoaBuilder, n);
    }

    public static boolean dtoa(double d, FastDtoaBuilder fastDtoaBuilder) {
        assert (d > 0.0);
        assert (!Double.isNaN(d));
        assert (!Double.isInfinite(d));
        return FastDtoa.grisu3(d, fastDtoaBuilder);
    }

    public static String numberToString(double d) {
        FastDtoaBuilder fastDtoaBuilder = new FastDtoaBuilder();
        return FastDtoa.numberToString(d, fastDtoaBuilder) ? fastDtoaBuilder.format() : null;
    }

    public static boolean numberToString(double d, FastDtoaBuilder fastDtoaBuilder) {
        fastDtoaBuilder.reset();
        if (d < 0.0) {
            fastDtoaBuilder.append('-');
            d = -d;
        }
        return FastDtoa.dtoa(d, fastDtoaBuilder);
    }
}

