/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInfo {
    protected static final Log log = LogFactory.getLog(FontInfo.class);
    private Map<String, Typeface> usedFonts = null;
    private Map<FontTriplet, String> triplets = new HashMap<FontTriplet, String>();
    private Map<FontTriplet, Integer> tripletPriorities = new HashMap<FontTriplet, Integer>();
    private Map<String, Typeface> fonts = new HashMap<String, Typeface>();
    private Map<FontTriplet, Map<Integer, Font>> fontInstanceCache = null;
    private FontEventListener eventListener = null;

    public FontInfo() {
        this.usedFonts = new HashMap<String, Typeface>();
    }

    public void setEventListener(FontEventListener listener) {
        this.eventListener = listener;
    }

    public boolean isSetupValid() {
        this.tripletPriorities = null;
        return this.triplets.containsKey(Font.DEFAULT_FONT);
    }

    public void addFontProperties(String name, String family, String style, int weight) {
        this.addFontProperties(name, FontInfo.createFontKey(family, style, weight));
    }

    public void addFontProperties(String name, String[] families, String style, int weight) {
        for (int i = 0; i < families.length; ++i) {
            this.addFontProperties(name, families[i], style, weight);
        }
    }

    public void addFontProperties(String internalFontKey, FontTriplet triplet) {
        if (log.isDebugEnabled()) {
            log.debug("Registering: " + triplet + " under " + internalFontKey);
        }
        String oldName = this.triplets.get(triplet);
        int newPriority = triplet.getPriority();
        if (oldName != null) {
            int oldPriority = this.tripletPriorities.get(triplet);
            if (oldPriority < newPriority) {
                this.logDuplicateFont(triplet, false, oldName, oldPriority, internalFontKey, newPriority);
                return;
            }
            this.logDuplicateFont(triplet, true, oldName, oldPriority, internalFontKey, newPriority);
        }
        this.triplets.put(triplet, internalFontKey);
        this.tripletPriorities.put(triplet, newPriority);
    }

    private void logDuplicateFont(FontTriplet triplet, boolean replacing, String oldKey, int oldPriority, String newKey, int newPriority) {
        if (log.isDebugEnabled()) {
            log.debug(triplet + (replacing ? ": Replacing " : ": Not replacing ") + this.fonts.get(this.triplets.get(triplet)).getFullName() + " (priority=" + oldPriority + ") by " + this.fonts.get(newKey).getFullName() + " (priority=" + newPriority + ")");
        }
    }

    public void addMetrics(String internalFontKey, FontMetrics metrics) {
        if (metrics instanceof Typeface) {
            ((Typeface)metrics).setEventListener(this.eventListener);
        }
        this.fonts.put(internalFontKey, (Typeface)metrics);
    }

    private FontTriplet fontLookup(String family, String style, int weight, boolean substitutable) {
        FontTriplet startKey;
        FontTriplet fontTriplet;
        String internalFontKey;
        if (log.isTraceEnabled()) {
            log.trace("Font lookup: " + family + " " + style + " " + weight + (substitutable ? " substitutable" : ""));
        }
        if ((internalFontKey = this.getInternalFontKey(fontTriplet = (startKey = FontInfo.createFontKey(family, style, weight)))) == null) {
            fontTriplet = this.fuzzyFontLookup(family, style, weight, startKey, substitutable);
        }
        if (fontTriplet != null) {
            if (fontTriplet != startKey) {
                this.notifyFontReplacement(startKey, fontTriplet);
            }
            return fontTriplet;
        }
        return null;
    }

    private FontTriplet fuzzyFontLookup(String family, String style, int weight, FontTriplet startKey, boolean substitutable) {
        FontTriplet key;
        String internalFontKey = null;
        if (!family.equals(startKey.getName()) && (internalFontKey = this.getInternalFontKey(key = FontInfo.createFontKey(family, style, weight))) != null) {
            return key;
        }
        key = this.findAdjustWeight(family, style, weight);
        if (key != null) {
            internalFontKey = this.getInternalFontKey(key);
        }
        if (!substitutable && internalFontKey == null) {
            return null;
        }
        if (internalFontKey == null && style != "normal") {
            key = FontInfo.createFontKey(family, "normal", weight);
            internalFontKey = this.getInternalFontKey(key);
        }
        if (internalFontKey == null && style != "normal" && (key = this.findAdjustWeight(family, "normal", weight)) != null) {
            internalFontKey = this.getInternalFontKey(key);
        }
        if (internalFontKey == null) {
            return this.fuzzyFontLookup("any", style, weight, startKey, false);
        }
        if (key == null && internalFontKey == null) {
            key = Font.DEFAULT_FONT;
            internalFontKey = this.getInternalFontKey(key);
        }
        if (internalFontKey != null) {
            return key;
        }
        return null;
    }

    public void useFont(String internalName) {
        this.usedFonts.put(internalName, this.fonts.get(internalName));
    }

    private Map<FontTriplet, Map<Integer, Font>> getFontInstanceCache() {
        if (this.fontInstanceCache == null) {
            this.fontInstanceCache = new HashMap<FontTriplet, Map<Integer, Font>>();
        }
        return this.fontInstanceCache;
    }

    public Font getFontInstance(FontTriplet triplet, int fontSize) {
        Integer size;
        Font font;
        Map<Integer, Font> sizes = this.getFontInstanceCache().get(triplet);
        if (sizes == null) {
            sizes = new HashMap<Integer, Font>();
            this.getFontInstanceCache().put(triplet, sizes);
        }
        if ((font = sizes.get(size = Integer.valueOf(fontSize))) == null) {
            String fontKey = this.getInternalFontKey(triplet);
            this.useFont(fontKey);
            FontMetrics metrics = this.getMetricsFor(fontKey);
            font = new Font(fontKey, triplet, metrics, fontSize);
            sizes.put(size, font);
        }
        return font;
    }

    private List<FontTriplet> getTripletsForName(String fontName) {
        ArrayList<FontTriplet> matchedTriplets = new ArrayList<FontTriplet>();
        for (FontTriplet triplet : this.triplets.keySet()) {
            String tripletName = triplet.getName();
            if (!tripletName.toLowerCase().equals(fontName.toLowerCase())) continue;
            matchedTriplets.add(triplet);
        }
        return matchedTriplets;
    }

    public Font getFontInstanceForAWTFont(java.awt.Font awtFont) {
        String awtFontName = awtFont.getName();
        String awtFontFamily = awtFont.getFamily();
        String awtFontStyle = awtFont.isItalic() ? "italic" : "normal";
        int awtFontWeight = awtFont.isBold() ? 700 : 400;
        FontTriplet matchedTriplet = null;
        List<FontTriplet> triplets = this.getTripletsForName(awtFontName);
        if (!triplets.isEmpty()) {
            for (FontTriplet triplet : triplets) {
                boolean weightMatched;
                boolean styleMatched = triplet.getStyle().equals(awtFontStyle);
                boolean bl = weightMatched = triplet.getWeight() == awtFontWeight;
                if (!styleMatched || !weightMatched) continue;
                matchedTriplet = triplet;
                break;
            }
        }
        if (matchedTriplet == null) {
            if (awtFontFamily.equals("sanserif")) {
                awtFontFamily = "sans-serif";
            }
            matchedTriplet = this.fontLookup(awtFontFamily, awtFontStyle, awtFontWeight);
        }
        int fontSize = Math.round(awtFont.getSize2D() * 1000.0f);
        return this.getFontInstance(matchedTriplet, fontSize);
    }

    public FontTriplet fontLookup(String family, String style, int weight) {
        return this.fontLookup(family, style, weight, true);
    }

    private List<FontTriplet> fontLookup(String[] families, String style, int weight, boolean substitutable) {
        ArrayList<FontTriplet> matchingTriplets = new ArrayList<FontTriplet>();
        FontTriplet triplet = null;
        for (int i = 0; i < families.length; ++i) {
            triplet = this.fontLookup(families[i], style, weight, substitutable);
            if (triplet == null) continue;
            matchingTriplets.add(triplet);
        }
        return matchingTriplets;
    }

    public FontTriplet[] fontLookup(String[] families, String style, int weight) {
        if (families.length == 0) {
            throw new IllegalArgumentException("Specify at least one font family");
        }
        List<FontTriplet> matchedTriplets = this.fontLookup(families, style, weight, false);
        if (matchedTriplets.size() == 0) {
            matchedTriplets = this.fontLookup(families, style, weight, true);
        }
        if (matchedTriplets.size() == 0) {
            StringBuffer sb = new StringBuffer();
            int c = families.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(families[i]);
            }
            throw new IllegalStateException("fontLookup must return an array with at least one FontTriplet on the last call. Lookup: " + sb.toString());
        }
        FontTriplet[] fontTriplets = new FontTriplet[matchedTriplets.size()];
        matchedTriplets.toArray(fontTriplets);
        return fontTriplets;
    }

    private void notifyFontReplacement(FontTriplet replacedKey, FontTriplet newKey) {
        if (this.eventListener != null) {
            this.eventListener.fontSubstituted(this, replacedKey, newKey);
        }
    }

    public void notifyStrokingSVGTextAsShapes(String fontFamily) {
        if (this.eventListener != null) {
            this.eventListener.svgTextStrokedAsShapes(this, fontFamily);
        }
    }

    public FontTriplet findAdjustWeight(String family, String style, int weight) {
        FontTriplet key = null;
        String f = null;
        int newWeight = weight;
        if (newWeight < 400) {
            while (f == null && newWeight > 100) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = this.getInternalFontKey(key);
            }
            newWeight = weight;
            while (f == null && newWeight < 400) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = this.getInternalFontKey(key);
            }
        } else if (newWeight == 400 || newWeight == 500) {
            key = FontInfo.createFontKey(family, style, 400);
            f = this.getInternalFontKey(key);
        } else if (newWeight > 500) {
            while (f == null && newWeight < 1000) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = this.getInternalFontKey(key);
            }
            newWeight = weight;
            while (f == null && newWeight > 400) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = this.getInternalFontKey(key);
            }
        }
        if (f == null && weight != 400) {
            key = FontInfo.createFontKey(family, style, 400);
            f = this.getInternalFontKey(key);
        }
        if (f != null) {
            return key;
        }
        return null;
    }

    public boolean hasFont(String family, String style, int weight) {
        FontTriplet key = FontInfo.createFontKey(family, style, weight);
        return this.triplets.containsKey(key);
    }

    public String getInternalFontKey(FontTriplet triplet) {
        return this.triplets.get(triplet);
    }

    public static FontTriplet createFontKey(String family, String style, int weight) {
        return new FontTriplet(family, style, weight);
    }

    public Map<String, Typeface> getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Map<FontTriplet, String> getFontTriplets() {
        return this.triplets;
    }

    public Map<String, Typeface> getUsedFonts() {
        return this.usedFonts;
    }

    public FontMetrics getMetricsFor(String fontName) {
        Typeface metrics = this.fonts.get(fontName);
        this.usedFonts.put(fontName, metrics);
        return metrics;
    }

    public List<FontTriplet> getTripletsFor(String fontName) {
        ArrayList<FontTriplet> foundTriplets = new ArrayList<FontTriplet>();
        for (Map.Entry<FontTriplet, String> tripletEntry : this.triplets.entrySet()) {
            if (!fontName.equals(tripletEntry.getValue())) continue;
            foundTriplets.add(tripletEntry.getKey());
        }
        return foundTriplets;
    }

    public FontTriplet getTripletFor(String fontName) {
        List<FontTriplet> foundTriplets = this.getTripletsFor(fontName);
        if (foundTriplets.size() > 0) {
            Collections.sort(foundTriplets);
            return foundTriplets.get(0);
        }
        return null;
    }

    public String getFontStyleFor(String fontName) {
        FontTriplet triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.getStyle();
        }
        return "";
    }

    public int getFontWeightFor(String fontName) {
        FontTriplet triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.getWeight();
        }
        return 0;
    }

    public void dumpAllTripletsToSystemOut() {
        System.out.print(this.toString());
    }

    public String toString() {
        TreeSet<String> entries = new TreeSet<String>();
        for (FontTriplet triplet : this.triplets.keySet()) {
            String key = this.getInternalFontKey(triplet);
            FontMetrics metrics = this.getMetricsFor(key);
            entries.add(triplet.toString() + " -> " + key + " -> " + metrics.getFontName() + "\n");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String str : entries) {
            stringBuffer.append(str);
        }
        return stringBuffer.toString();
    }
}

