/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.alternatemix;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.alternatemix.AlternateMixOptionsPane;
import org.pdfsam.alternatemix.AlternateMixParametersBuilder;
import org.pdfsam.alternatemix.AlternateMixSingleSelectionPane;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.module.PdfsamModule;
import org.pdfsam.ui.io.BrowsablePdfOutputField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.input.PdfFileSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@PdfsamModule
public class AlternateMixModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "alternatemix";
    private AlternateMixSingleSelectionPane firstDocument;
    private AlternateMixSingleSelectionPane secondDocument;
    private BrowsablePdfOutputField destinationFileField;
    private PdfDestinationPane destinationPane;
    private AlternateMixOptionsPane optionsPane = new AlternateMixOptionsPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.MERGE).name(DefaultI18nContext.getInstance().i18n("Alternate Mix")).description(DefaultI18nContext.getInstance().i18n("Merge two PDF documents taking pages alternately in straight or reverse order.")).priority(ModulePriority.DEFAULT.getPriority()).supportURL("http://www.pdfsam.org/alternate-mix").build();

    @Inject
    public AlternateMixModule(@Named(value="alternatemixfield") BrowsablePdfOutputField destinationFileField, @Named(value="alternatemixpane") PdfDestinationPane destinationPane) {
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
        this.firstDocument = new AlternateMixSingleSelectionPane(this.id()){

            @Override
            void onValidSource(AlternateMixParametersBuilder builder, PdfFileSource source) {
                builder.first(source);
            }
        };
        this.firstDocument.setId("firstDocumentMix");
        this.firstDocument.setPromptText(DefaultI18nContext.getInstance().i18n("Select or drag and drop the first PDF you want to mix"));
        this.firstDocument.addOnLoaded(d -> this.optionsPane.setFirstDocumentMaxPages(d.pages().getValue()));
        this.secondDocument = new AlternateMixSingleSelectionPane(this.id()){

            @Override
            void onValidSource(AlternateMixParametersBuilder builder, PdfFileSource source) {
                builder.second(source);
            }
        };
        this.secondDocument.setId("secondDocumentMix");
        this.secondDocument.setPromptText(DefaultI18nContext.getInstance().i18n("Select or drag and drop the second PDF you want to mix"));
        this.secondDocument.addOnLoaded(d -> this.optionsPane.setSecondDocumentMaxPages(d.pages().getValue()));
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public void onSaveWorkspace(Map<String, String> data) {
        this.firstDocument.saveStateTo(data);
        this.secondDocument.saveStateTo(data);
        this.optionsPane.saveStateTo(data);
        this.destinationFileField.saveStateTo((Map)data);
        this.destinationPane.saveStateTo(data);
    }

    @Override
    public void onLoadWorkspace(Map<String, String> data) {
        this.firstDocument.restoreStateFrom(data);
        this.secondDocument.restoreStateFrom(data);
        this.optionsPane.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom((Map)data);
        this.destinationPane.restoreStateFrom(data);
    }

    @Override
    protected Pane getInnerPanel(Pane footer) {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        pane.getChildren().addAll((Object[])new Node[]{this.firstDocument, this.secondDocument, Views.titledPane(DefaultI18nContext.getInstance().i18n("Mix settings"), (Node)this.optionsPane), Views.titledPane(DefaultI18nContext.getInstance().i18n("Destination file"), (Node)this.destinationPane), footer});
        return pane;
    }

    @Override
    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @Override
    public Node graphic() {
        return new ImageView("alternate_mix.png");
    }

    protected AlternateMixParametersBuilder getBuilder(Consumer<String> onError) {
        AlternateMixParametersBuilder builder = new AlternateMixParametersBuilder();
        this.firstDocument.apply(builder, onError);
        this.secondDocument.apply(builder, onError);
        this.destinationFileField.apply(builder, onError);
        this.destinationPane.apply(builder, onError);
        this.optionsPane.apply(builder, onError);
        return builder;
    }

    @Configuration
    public static class ModuleConfig {
        @Bean(name={"alternatemixfield"})
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Bean(name={"alternatemixpane"})
        public PdfDestinationPane destinationPane(@Named(value="alternatemixfield") BrowsablePdfOutputField outputField, UserContext userContext) {
            return new PdfDestinationPane(outputField, AlternateMixModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[0]);
        }
    }
}

