/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.about;

import com.sun.javafx.runtime.VersionInfo;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.Arrays;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.ObjectCollectionWriter;
import org.pdfsam.ui.commons.UrlButton;
import org.pdfsam.ui.support.Style;

@Named
public class AboutDashboardPane
extends HBox {
    @Inject
    public AboutDashboardPane(Pdfsam pdfsam) {
        this.getStyleClass().add((Object)"dashboard-container");
        VBox left = new VBox(5.0);
        this.addSectionTitle(pdfsam.name(), (Pane)left);
        Label copyright = new Label(pdfsam.property(ConfigurableProperty.COPYRIGHT));
        GlyphsDude.setIcon((Labeled)copyright, (GlyphIcons)FontAwesomeIcon.COPYRIGHT);
        left.getChildren().addAll((Object[])new Node[]{new Label(String.format("ver. %s", pdfsam.property(ConfigurableProperty.VERSION))), copyright});
        this.addHyperlink(null, pdfsam.property(ConfigurableProperty.LICENSE_URL), pdfsam.property(ConfigurableProperty.LICENSE_NAME), (Pane)left);
        this.addHyperlink(FontAwesomeIcon.HOME, pdfsam.property(ConfigurableProperty.HOME_URL), pdfsam.property(ConfigurableProperty.HOME_LABEL), (Pane)left);
        this.addHyperlink(FontAwesomeIcon.RSS_SQUARE, pdfsam.property(ConfigurableProperty.FEED_URL), DefaultI18nContext.getInstance().i18n("Subscribe to the official news feed"), (Pane)left);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Environment"), (Pane)left);
        Label runtime = new Label(String.format("%s %s", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
        Label fxRuntime = new Label(String.format("JavaFX %s", VersionInfo.getRuntimeVersion()));
        Label memory = new Label(DefaultI18nContext.getInstance().i18n("Max memory {0}", FileUtils.byteCountToDisplaySize(Runtime.getRuntime().maxMemory())));
        Button copyButton = new Button(DefaultI18nContext.getInstance().i18n("Copy to clipboard"));
        GlyphsDude.setIcon((Labeled)copyButton, (GlyphIcons)FontAwesomeIcon.COPY);
        copyButton.getStyleClass().addAll((Object[])Style.BUTTON.css());
        copyButton.setId("copyEnvDetails");
        copyButton.setOnAction(a -> {
            ClipboardContent content = new ClipboardContent();
            ObjectCollectionWriter.writeContent(Arrays.asList(pdfsam.name(), pdfsam.property(ConfigurableProperty.VERSION), runtime.getText(), fxRuntime.getText(), memory.getText())).to(content);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        left.getChildren().addAll((Object[])new Node[]{runtime, fxRuntime, memory, copyButton});
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Thanks to"), (Pane)left);
        this.addHyperlink(null, "http://www.pdfsam.org/thanks_to", DefaultI18nContext.getInstance().i18n("The open source projects making PDFsam possible"), (Pane)left);
        VBox right = new VBox(5.0);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Support"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.BUG, pdfsam.property(ConfigurableProperty.TRACKER_URL), DefaultI18nContext.getInstance().i18n("Bug and feature requests"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.QUESTION_CIRCLE, pdfsam.property(ConfigurableProperty.SUPPORT_URL), DefaultI18nContext.getInstance().i18n("Support"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.YOUTUBE_PLAY, pdfsam.property(ConfigurableProperty.QUICKSTART_URL), DefaultI18nContext.getInstance().i18n("Play the \"get started\" video"), (Pane)right);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Contribute"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.GITHUB, pdfsam.property(ConfigurableProperty.SCM_URL), DefaultI18nContext.getInstance().i18n("Fork PDFsam on GitHub"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.FLAG_ALT, pdfsam.property(ConfigurableProperty.TRANSLATE_URL), DefaultI18nContext.getInstance().i18n("Translate"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.DOLLAR, pdfsam.property(ConfigurableProperty.DONATE_URL), DefaultI18nContext.getInstance().i18n("Donate"), (Pane)right);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Social"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.TWITTER_SQUARE, pdfsam.property(ConfigurableProperty.TWITTER_URL), DefaultI18nContext.getInstance().i18n("Follow us on Twitter"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.GOOGLE_PLUS_SQUARE, pdfsam.property(ConfigurableProperty.GPLUS_URL), DefaultI18nContext.getInstance().i18n("Follow us on Google Plus"), (Pane)right);
        this.addHyperlink(FontAwesomeIcon.FACEBOOK_SQUARE, pdfsam.property(ConfigurableProperty.FACEBOOK_URL), DefaultI18nContext.getInstance().i18n("Like us on Facebook"), (Pane)right);
        this.getChildren().addAll((Object[])new Node[]{left, right});
    }

    private void addSectionTitle(String title, Pane pane) {
        Label label = new Label(title);
        label.getStyleClass().add((Object)"section-title");
        pane.getChildren().add((Object)label);
    }

    private void addHyperlink(FontAwesomeIcon icon, String url, String text, Pane pane) {
        UrlButton button = UrlButton.styledUrlButton(text, url, icon);
        button.getStyleClass().setAll((Object[])new String[]{"pdfsam-hyperlink"});
        pane.getChildren().add((Object)button);
    }
}

