/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.io.File;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.commons.RemoveSelectedEvent;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.module.ModuleOwnedButton;
import org.pdfsam.ui.selection.multiple.ClearSelectionTableEvent;
import org.pdfsam.ui.selection.multiple.SelectionChangedEvent;
import org.pdfsam.ui.selection.multiple.move.MoveSelectedEvent;
import org.pdfsam.ui.selection.multiple.move.MoveType;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

class SelectionTableToolbar
extends ToolBar
implements ModuleOwned {
    private String ownerModule = "";

    public SelectionTableToolbar(String ownerModule, boolean canMove) {
        this.ownerModule = StringUtils.defaultString(ownerModule);
        this.getItems().addAll((Object[])new Node[]{new AddButton(ownerModule), new ClearButton(ownerModule), new RemoveButton(ownerModule)});
        if (canMove) {
            this.getItems().addAll((Object[])new Node[]{new MoveUpButton(ownerModule), new MoveDownButton(ownerModule)});
        }
        this.getStyleClass().add((Object)"selection-tool-bar");
    }

    @Override
    public String getOwnerModule() {
        return this.ownerModule;
    }

    static class MoveDownButton
    extends BaseMoveSelectedButton {
        public MoveDownButton(String ownerModule) {
            super(ownerModule, MoveType.DOWN);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Moves down selected documents")));
            this.setText(DefaultI18nContext.getInstance().i18n("Move _Down"));
        }
    }

    static class MoveUpButton
    extends BaseMoveSelectedButton {
        public MoveUpButton(String ownerModule) {
            super(ownerModule, MoveType.UP);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Moves up selected documents")));
            this.setText(DefaultI18nContext.getInstance().i18n("Move _Up"));
        }
    }

    private static class BaseMoveSelectedButton
    extends ModuleOwnedButton {
        private MoveType type;

        public BaseMoveSelectedButton(String ownerModule, MoveType type) {
            super(ownerModule);
            this.type = type;
            this.setDisable(true);
            this.setOnAction(this::moveOnClick);
            StaticStudio.eventStudio().addAnnotatedListeners(this);
        }

        public void moveOnClick(ActionEvent event) {
            StaticStudio.eventStudio().broadcast(new MoveSelectedEvent(this.type), this.getOwnerModule());
        }

        @EventListener
        public void disableIfCannotMoveDown(SelectionChangedEvent event) {
            this.setDisable(!event.canMove(this.type));
        }
    }

    static class ClearButton
    extends ModuleOwnedButton {
        public ClearButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Removes every document")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Clear"));
            this.setOnAction(this::clear);
        }

        public void clear(ActionEvent event) {
            StaticStudio.eventStudio().broadcast(new ClearSelectionTableEvent(), this.getOwnerModule());
        }
    }

    static class RemoveButton
    extends ModuleOwnedButton {
        public RemoveButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Removes selected documents")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Remove"));
            this.setOnAction(this::removeSelected);
            this.setDisable(true);
            StaticStudio.eventStudio().addAnnotatedListeners(this);
        }

        public void removeSelected(ActionEvent event) {
            StaticStudio.eventStudio().broadcast(new RemoveSelectedEvent(), this.getOwnerModule());
        }

        @EventListener
        public void disableIfNoSelection(SelectionChangedEvent event) {
            this.setDisable(event.isClearSelection());
        }
    }

    static class AddButton
    extends ModuleOwnedButton {
        public AddButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Add documents to the table")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Add"));
            this.setOnAction(this::loadDocuments);
        }

        public void loadDocuments(ActionEvent event) {
            RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(FileType.PDF, DefaultI18nContext.getInstance().i18n("Select pdf documents to load"));
            List<File> chosenFiles = fileChooser.showOpenMultipleDialog(this.getScene().getWindow());
            if (chosenFiles != null && !chosenFiles.isEmpty()) {
                PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.getOwnerModule());
                chosenFiles.stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(loadEvent::add);
                StaticStudio.eventStudio().broadcast(loadEvent, this.getOwnerModule());
            }
        }
    }
}

