/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.imageio.ImageIOJPEGImageWriter;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.core.writer.xmlgraphics.AbstractImageWriterAdapter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.PdfToJpegParameters;

final class JpegImageWriterAdapter
extends AbstractImageWriterAdapter<PdfToJpegParameters> {
    private org.apache.xmlgraphics.image.writer.ImageWriter adaptedWriter = new ImageIOJPEGImageWriter(){

        @Override
        protected ImageWriteParam getDefaultWriteParam(ImageWriter iiowriter, RenderedImage image, ImageWriterParams params) {
            ImageWriteParam param = super.getDefaultWriteParam(iiowriter, image, params);
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
            return param;
        }
    };

    private JpegImageWriterAdapter() {
    }

    @Override
    public void openWriteDestination(OutputStream destination, PdfToJpegParameters params) {
        this.setOutputStream(destination);
    }

    @Override
    public void write(RenderedImage image, PdfToJpegParameters params) throws TaskIOException {
        if (this.getOutputDestination() == null) {
            throw new TaskIOException("Cannot call write before opening the write destination");
        }
        ImageWriterParams imageWriterParams = this.newImageWriterParams(params);
        try {
            this.adaptedWriter.writeImage(image, this.getOutputDestination(), imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException(e);
        }
    }

    @Override
    public boolean supportMultiImage() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.adaptedWriter = null;
        super.close();
    }

    private ImageWriterParams newImageWriterParams(PdfToJpegParameters params) {
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setResolution(params.getResolutionInDpi());
        return imageWriterParams;
    }

    static final class JpegImageWriterAdapterBuilder
    implements ImageWriter.ImageWriterBuilder<PdfToJpegParameters> {
        JpegImageWriterAdapterBuilder() {
        }

        public JpegImageWriterAdapter build() {
            return new JpegImageWriterAdapter();
        }
    }
}

