/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.SetHeaderFooterParameters;
import org.sejda.model.pdf.TextStampPattern;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHeaderFooterWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SetHeaderFooterWriter.class);
    private PDDocumentHandler documentHandler;
    private PageTextWriter headerFooterWriter;
    private int totalPages;

    public SetHeaderFooterWriter(PDDocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
        this.headerFooterWriter = new PageTextWriter(documentHandler.getUnderlyingPDDocument());
        this.totalPages = documentHandler.getNumberOfPages();
    }

    public void write(SetHeaderFooterParameters parameters, int currentFileCounter) throws TaskIOException {
        PDFont font = ObjectUtils.defaultIfNull(FontUtils.getStandardType1Font(parameters.getFont()), PDType1Font.HELVETICA);
        Double fontSize = ObjectUtils.defaultIfNull(parameters.getFontSize(), 10.0);
        HorizontalAlign hAlign = ObjectUtils.defaultIfNull(parameters.getHorizontalAlign(), HorizontalAlign.CENTER);
        VerticalAlign vAlign = ObjectUtils.defaultIfNull(parameters.getVerticalAlign(), VerticalAlign.BOTTOM);
        String what = vAlign == VerticalAlign.BOTTOM ? "footer" : "header";
        Set pages = parameters.getPageRange().getPages(this.totalPages);
        Integer labelPageNumber = parameters.getPageCountStartFrom();
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            int pageNumber = (Integer)iterator.next();
            if (labelPageNumber == null) {
                labelPageNumber = pageNumber;
            }
            String batesSeq = null;
            if (parameters.getBatesSequence() != null) {
                batesSeq = parameters.getBatesSequence().next();
            }
            String label = new TextStampPattern().withPage(labelPageNumber, this.totalPages).withBatesSequence(batesSeq).withFileSequence(String.valueOf(currentFileCounter)).build(parameters.getPattern());
            try {
                LOG.debug("Applying {} '{}' to document page {}", what, label, pageNumber);
                this.headerFooterWriter.write(this.documentHandler.getPage(pageNumber), hAlign, vAlign, label, font, fontSize, parameters.getColor());
                Integer n = labelPageNumber;
                Integer n2 = labelPageNumber = Integer.valueOf(labelPageNumber + 1);
            }
            catch (PageNotFoundException ex) {
                String warning = String.format("Page %d was skipped, could not be processed", pageNumber);
                LOG.warn(warning, ex);
            }
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

