/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlExpectationsHelper {
    public void assertNode(String content, Matcher<? super Node> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssertionErrors.assertThat("Body content", document, matcher);
    }

    private Document parseXmlString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xml));
        return documentBuilder.parse(inputSource);
    }

    public void assertSource(String content, Matcher<? super Source> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssertionErrors.assertThat("Body content", new DOMSource(document), matcher);
    }

    public void assertXmlEqual(String expected, String actual) throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        Document control = XMLUnit.buildControlDocument((String)expected);
        Document test = XMLUnit.buildTestDocument((String)actual);
        Diff diff = new Diff(control, test);
        if (!diff.similar()) {
            AssertionErrors.fail("Body content " + diff.toString());
        }
    }
}

