/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.input.IndirectObjectsProvider;
import org.sejda.sambox.input.ObjectsFullScanner;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.xref.CompressedXrefEntry;
import org.sejda.sambox.xref.Xref;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.sambox.xref.XrefType;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyIndirectObjectsProvider
implements IndirectObjectsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LazyIndirectObjectsProvider.class);
    private Xref xref = new Xref();
    private ObjectsFullScanner scanner;
    private Map<COSObjectKey, COSBase> store = new ConcurrentHashMap<COSObjectKey, COSBase>();
    private SecurityHandler securityHandler = null;
    private COSParser parser;

    LazyIndirectObjectsProvider() {
    }

    @Override
    public COSBase get(COSObjectKey key) {
        if (Objects.isNull(this.store.get(key))) {
            this.parseObject(key);
        }
        return this.store.get(key);
    }

    @Override
    public void release(COSObjectKey key) {
        this.store.remove(key);
    }

    @Override
    public XrefEntry addEntryIfAbsent(XrefEntry entry) {
        XrefEntry retVal = this.xref.addIfAbsent(entry);
        if (retVal == null) {
            LOG.trace("Added xref entry " + entry);
        }
        return retVal;
    }

    @Override
    public XrefEntry addEntry(XrefEntry entry) {
        LOG.trace("Added xref entry " + entry);
        return this.xref.add(entry);
    }

    @Override
    public LazyIndirectObjectsProvider initializeWith(COSParser parser) {
        Objects.requireNonNull(parser);
        this.parser = parser;
        this.scanner = new ObjectsFullScanner(parser);
        return this;
    }

    @Override
    public LazyIndirectObjectsProvider initializeWith(SecurityHandler handler) {
        this.securityHandler = handler;
        return this;
    }

    private void parseObject(COSObjectKey key) {
        XrefEntry xrefEntry = this.xref.get(key);
        if (Objects.nonNull(xrefEntry)) {
            try {
                this.doParse(xrefEntry);
            }
            catch (IOException e) {
                LOG.warn("An error occurred while parsing " + xrefEntry, e);
                this.doParseFallbackObject(key);
            }
        } else {
            LOG.warn("Unable to find xref data for {}", (Object)key);
            this.doParseFallbackObject(key);
        }
    }

    private void doParseFallbackObject(COSObjectKey key) {
        LOG.info("Trying fallback strategy for " + key);
        XrefEntry xrefEntry = this.scanner.entries().get(key);
        if (Objects.nonNull(xrefEntry)) {
            try {
                this.doParse(xrefEntry);
            }
            catch (IOException e) {
                LOG.warn("Unable to find fallback xref entry for " + key, e);
            }
        } else {
            LOG.warn("Unable to find fallback xref entry for " + key);
        }
    }

    private void doParse(XrefEntry xrefEntry) throws IOException {
        LOG.trace("Parsing indirect object " + xrefEntry);
        if (xrefEntry.getType() == XrefType.IN_USE) {
            this.parseInUseEntry(xrefEntry);
        }
        if (xrefEntry.getType() == XrefType.COMPRESSED) {
            this.parseCompressedEntry(xrefEntry);
        }
        LOG.trace("Parsing done");
    }

    private void parseInUseEntry(XrefEntry xrefEntry) throws IOException {
        this.parser.position(xrefEntry.getByteOffset());
        this.parser.skipExpectedIndirectObjectDefinition(xrefEntry.key());
        this.parser.skipSpaces();
        COSBase found = this.parser.nextParsedToken();
        this.parser.skipSpaces();
        if (this.parser.isNextToken("stream")) {
            RequireUtils.requireIOCondition(found instanceof COSDictionary, "Found stream with missing dictionary");
            found = this.parser.nextStream((COSDictionary)found);
            if (this.parser.skipTokenIfValue("endstream")) {
                LOG.warn("Found double 'endstream' token for " + xrefEntry);
            }
        }
        if (this.securityHandler != null) {
            LOG.trace("Decrypting entry {}", (Object)xrefEntry);
            this.securityHandler.decrypt(found, xrefEntry.getObjectNumber(), xrefEntry.getGenerationNumber());
        }
        if (!this.parser.skipTokenIfValue("endobj")) {
            LOG.warn("Missing 'endobj' token for " + xrefEntry);
        }
        this.store.put(xrefEntry.key(), Optional.ofNullable(found).orElse(COSNull.NULL));
    }

    private void parseCompressedEntry(XrefEntry xrefEntry) throws IOException {
        XrefEntry containingStreamEntry = this.xref.get(new COSObjectKey(((CompressedXrefEntry)xrefEntry).getObjectStreamNumber(), 0));
        RequireUtils.requireIOCondition(Objects.nonNull(containingStreamEntry) && containingStreamEntry.getType() != XrefType.COMPRESSED, "Expected an uncompressed indirect object reference for the ObjectStream");
        this.parseObject(containingStreamEntry.key());
        COSBase stream = this.store.get(containingStreamEntry.key()).getCOSObject();
        if (!(stream instanceof COSStream)) {
            throw new IOException("Expected an object stream instance for " + containingStreamEntry);
        }
        this.parseObjectStream(containingStreamEntry, (COSStream)stream);
    }

    private void parseObjectStream(XrefEntry containingStreamEntry, COSStream stream) throws IOException {
        try (COSParser streamParser = new COSParser(stream.getUnfilteredSource(), this);){
            int numberOfObjects = stream.getInt(COSName.N);
            RequireUtils.requireIOCondition(numberOfObjects >= 0, "Missing or negative required objects stream size");
            long firstOffset = stream.getLong(COSName.FIRST);
            RequireUtils.requireIOCondition(firstOffset >= 0L, "Missing or negative required bytes offset of the fist object in the objects stream");
            TreeMap<Long, Long> entries = new TreeMap<Long, Long>();
            for (int i = 0; i < numberOfObjects; ++i) {
                long number = streamParser.readObjectNumber();
                long offset = firstOffset + streamParser.readLong();
                entries.put(offset, number);
            }
            LOG.trace("Found " + entries.size() + " entries in object stream of size " + streamParser.source().size());
            for (Map.Entry entry : entries.entrySet()) {
                COSObjectKey key;
                COSBase object;
                LOG.trace("Parsing compressed object " + entry.getValue() + " at offset " + entry.getKey());
                streamParser.position((Long)entry.getKey());
                if (streamParser.skipTokenIfValue("obj")) {
                    LOG.warn("Unexptected 'obj' token in objects stream");
                }
                if ((object = streamParser.nextParsedToken()) != null && containingStreamEntry.owns(this.xref.get(key = new COSObjectKey((Long)entry.getValue(), 0)))) {
                    LOG.trace("Parsed compressed object " + key + " " + object.getClass());
                    this.store.put(key, object);
                }
                if (!streamParser.skipTokenIfValue("endobj")) continue;
                LOG.warn("Unexptected 'endobj' token in objects stream");
            }
        }
        IOUtils.close(stream);
    }

    @Override
    public void close() {
        this.store.values().stream().filter(o -> o instanceof Closeable).map(o -> (Closeable)((Object)o)).forEach(IOUtils::closeQuietly);
        this.store.clear();
    }

    @Override
    public String id() {
        return this.parser.source().id();
    }
}

