/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.input.AbstractXrefStreamParser;
import org.sejda.sambox.input.AbstractXrefTableParser;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.input.ObjectsFullScanner;
import org.sejda.sambox.input.XrefFullScanner;
import org.sejda.sambox.util.Charsets;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XrefParser {
    private static final Logger LOG = LoggerFactory.getLogger(XrefParser.class);
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    private static final String STARTXREF = "startxref";
    private COSDictionary trailer = new COSDictionary();
    private AbstractXrefStreamParser xrefStreamParser;
    private AbstractXrefTableParser xrefTableParser;
    private COSParser parser;

    public XrefParser(COSParser parser) {
        this.parser = parser;
        this.xrefStreamParser = new AbstractXrefStreamParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefParser.this.trailer.mergeWithoutOverwriting(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                this.parser().provider().addEntryIfAbsent(entry);
            }
        };
        this.xrefTableParser = new AbstractXrefTableParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefParser.this.trailer.mergeWithoutOverwriting(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                this.parser().provider().addEntryIfAbsent(entry);
            }
        };
    }

    public void parse() throws IOException {
        long xrefOffset = this.findXrefOffset();
        if (xrefOffset <= 0L || !this.parseXref(xrefOffset)) {
            XrefFullScanner fallbackFullScanner = new XrefFullScanner(this.parser);
            XrefFullScanner.XrefScanOutcome xrefScanStatus = fallbackFullScanner.scan();
            if (xrefScanStatus != XrefFullScanner.XrefScanOutcome.NOT_FOUND) {
                this.trailer = fallbackFullScanner.trailer();
            }
            if (xrefScanStatus != XrefFullScanner.XrefScanOutcome.FOUND) {
                LOG.warn("Xref full scan encountered some errors, now performing objects full scan");
                ObjectsFullScanner objectsFullScanner = new ObjectsFullScanner(this.parser){

                    @Override
                    protected void onNonObjectDefinitionLine(long offset, String line) throws IOException {
                        if (line != null && line.startsWith("trailer")) {
                            LOG.debug("Parsing trailer at " + offset);
                            XrefParser.this.parser.position(offset);
                            XrefParser.this.parser.skipExpected("trailer");
                            XrefParser.this.parser.skipSpaces();
                            XrefParser.this.trailer.merge(XrefParser.this.parser.nextDictionary());
                            XrefParser.this.parser.skipSpaces();
                        }
                    }
                };
                objectsFullScanner.entries().values().stream().forEach(this.parser.provider()::addEntry);
            }
        }
    }

    private final long findXrefOffset() throws IOException {
        int chunkSize = (int)Math.min(this.parser.length(), 2048L);
        long startPosition = this.parser.length() - (long)chunkSize;
        this.parser.position(startPosition);
        byte[] buffer = new byte[chunkSize];
        this.parser.source().read(ByteBuffer.wrap(buffer));
        int relativeIndex = new String(buffer, Charsets.ISO_8859_1).lastIndexOf(STARTXREF);
        if (relativeIndex < 0) {
            LOG.warn("Unable to find 'startxref' keyword");
            return -1L;
        }
        this.parser.position(startPosition + (long)relativeIndex + (long)STARTXREF.length());
        this.parser.skipSpaces();
        long xrefOffset = this.parser.readLong();
        LOG.debug("Found xref offset at " + xrefOffset);
        return xrefOffset;
    }

    private boolean parseXref(long xrefOffset) {
        try {
            return this.doParseXref(xrefOffset);
        }
        catch (IOException e) {
            LOG.warn("An error occurred while parsing the xref, applying fallback strategy", e);
            return false;
        }
    }

    private boolean doParseXref(long xrefOffset) throws IOException {
        if (!this.isValidXrefOffset(xrefOffset)) {
            LOG.warn("Offset '" + xrefOffset + "' doesn't point to an xref table or stream, applying fallback strategy");
            return false;
        }
        while (xrefOffset > -1L) {
            if (!this.isValidXrefOffset(xrefOffset)) {
                LOG.warn("Offset '" + xrefOffset + "' doesn't point to an xref table or stream, applying fallback strategy");
                return false;
            }
            this.parser.position(xrefOffset);
            this.parser.skipSpaces();
            if (this.parser.isNextToken("xref")) {
                COSDictionary trailer = this.xrefTableParser.parse(xrefOffset);
                long streamOffset = trailer.getLong(COSName.XREF_STM);
                if (streamOffset > 0L) {
                    if (!this.isValidXrefStreamOffset(streamOffset)) {
                        LOG.warn("Offset '" + streamOffset + "' doesn't point to an xref stream, applying fallback strategy");
                        return false;
                    }
                    trailer.setLong(COSName.XREF_STM, streamOffset);
                    this.xrefStreamParser.parse(streamOffset);
                }
                xrefOffset = trailer.getLong(COSName.PREV);
                continue;
            }
            COSDictionary streamDictionary = this.xrefStreamParser.parse(xrefOffset);
            xrefOffset = streamDictionary.getLong(COSName.PREV);
        }
        return true;
    }

    private boolean isValidXrefOffset(long xrefOffset) throws IOException {
        if (this.isValidXrefStreamOffset(xrefOffset)) {
            return true;
        }
        this.parser.position(xrefOffset);
        return this.parser.isNextToken("xref");
    }

    private boolean isValidXrefStreamOffset(long xrefStreamOffset) throws IOException {
        this.parser.position(xrefStreamOffset);
        try {
            this.parser.skipIndirectObjectDefinition();
            this.parser.skipSpaces();
            COSDictionary xrefStreamDictionary = this.parser.nextDictionary();
            this.parser.position(xrefStreamOffset);
            return xrefStreamDictionary.getCOSName(COSName.TYPE).equals(COSName.XREF);
        }
        catch (IOException exception) {
            return false;
        }
    }

    public COSDictionary trailer() {
        return this.trailer;
    }
}

