/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.image;

import java.io.File;
import java.io.IOException;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;

public final class CCITTFactory {
    private CCITTFactory() {
    }

    public static PDImageXObject createFromFile(File file) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(SeekableSources.seekableSourceFrom(file), 0);
    }

    public static PDImageXObject createFromFile(File file, int number) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(SeekableSources.seekableSourceFrom(file), number);
    }

    private static PDImageXObject createFromRandomAccessImpl(SeekableSource source, int number) throws IOException {
        COSDictionary decodeParms = new COSDictionary();
        SeekableSource tiffView = CCITTFactory.extractFromTiff(source, decodeParms, number);
        if (tiffView != null) {
            PDImageXObject pdImage = new PDImageXObject(tiffView.asInputStream(), COSName.CCITTFAX_DECODE, decodeParms.getInt(COSName.COLUMNS), decodeParms.getInt(COSName.ROWS), 1, PDDeviceGray.INSTANCE);
            COSStream dict = pdImage.getCOSObject();
            dict.setItem(COSName.DECODE_PARMS, (COSBase)decodeParms);
            return pdImage;
        }
        return null;
    }

    private static SeekableSource extractFromTiff(SeekableSource source, COSDictionary params, int number) throws IOException {
        source.position(0L);
        char endianess = (char)source.read();
        if ((char)source.read() != endianess) {
            throw new IOException("Not a valid tiff file");
        }
        if (endianess != 'M' && endianess != 'I') {
            throw new IOException("Not a valid tiff file");
        }
        int magicNumber = CCITTFactory.readshort(endianess, source);
        if (magicNumber != 42) {
            throw new IOException("Not a valid tiff file");
        }
        int address = CCITTFactory.readlong(endianess, source);
        source.position(address);
        for (int i = 0; i < number; ++i) {
            int numtags = CCITTFactory.readshort(endianess, source);
            if (numtags > 50) {
                throw new IOException("Not a valid tiff file");
            }
            source.position(address + 2 + numtags * 12);
            address = CCITTFactory.readlong(endianess, source);
            if (address == 0) {
                return null;
            }
            source.position(address);
        }
        int numtags = CCITTFactory.readshort(endianess, source);
        if (numtags > 50) {
            throw new IOException("Not a valid tiff file");
        }
        int k = -1000;
        int dataoffset = 0;
        int datalength = 0;
        block18: for (int i = 0; i < numtags; ++i) {
            int tag = CCITTFactory.readshort(endianess, source);
            int type = CCITTFactory.readshort(endianess, source);
            int count = CCITTFactory.readlong(endianess, source);
            int val = CCITTFactory.readlong(endianess, source);
            if (endianess == 'M') {
                switch (type) {
                    case 1: {
                        val >>= 24;
                        break;
                    }
                    case 3: {
                        val >>= 16;
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
            switch (tag) {
                case 256: {
                    params.setInt(COSName.COLUMNS, val);
                    continue block18;
                }
                case 257: {
                    params.setInt(COSName.ROWS, val);
                    continue block18;
                }
                case 259: {
                    if (val == 4) {
                        k = -1;
                    }
                    if (val != 3) continue block18;
                    k = 0;
                    continue block18;
                }
                case 262: {
                    if (val != 1) continue block18;
                    params.setBoolean(COSName.BLACK_IS_1, true);
                    continue block18;
                }
                case 266: {
                    if (val == 1) continue block18;
                    throw new IOException("FillOrder " + val + " is not supported");
                }
                case 273: {
                    if (count != 1) continue block18;
                    dataoffset = val;
                    continue block18;
                }
                case 279: {
                    if (count != 1) continue block18;
                    datalength = val;
                    continue block18;
                }
                case 292: {
                    if ((val & 1) != 0) {
                        k = 50;
                    }
                    if ((val & 4) != 0) {
                        throw new IOException("CCITT Group 3 'uncompressed mode' is not supported");
                    }
                    if ((val & 2) == 0) continue block18;
                    throw new IOException("CCITT Group 3 'fill bits before EOL' is not supported");
                }
                case 324: {
                    if (count != 1) continue block18;
                    dataoffset = val;
                    continue block18;
                }
                case 325: {
                    if (count != 1) continue block18;
                    datalength = val;
                    continue block18;
                }
            }
        }
        if (k == -1000) {
            throw new IOException("First image in tiff is not CCITT T4 or T6 compressed");
        }
        if (dataoffset == 0) {
            throw new IOException("First image in tiff is not a single tile/strip");
        }
        params.setInt(COSName.K, k);
        source.position(dataoffset);
        return source.view(dataoffset, datalength);
    }

    private static int readshort(char endianess, SeekableSource source) throws IOException {
        if (endianess == 'I') {
            return source.read() | source.read() << 8;
        }
        return source.read() << 8 | source.read();
    }

    private static int readlong(char endianess, SeekableSource source) throws IOException {
        if (endianess == 'I') {
            return source.read() | source.read() << 8 | source.read() << 16 | source.read() << 24;
        }
        return source.read() << 24 | source.read() << 16 | source.read() << 8 | source.read();
    }
}

