/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;

public abstract class PDButton
extends PDTerminalField {
    static final int FLAG_RADIO = 32768;
    static final int FLAG_PUSHBUTTON = 65536;
    static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDButton(PDAcroForm acroForm) {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.BTN);
    }

    PDButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isPushButton() {
        return this.getCOSObject().getFlag(COSName.FF, 65536);
    }

    public void setPushButton(boolean pushbutton) {
        this.getCOSObject().setFlag(COSName.FF, 65536, pushbutton);
    }

    public boolean isRadioButton() {
        return this.getCOSObject().getFlag(COSName.FF, 32768);
    }

    public void setRadioButton(boolean radiobutton) {
        this.getCOSObject().setFlag(COSName.FF, 32768, radiobutton);
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    @Override
    public void setValue(String value) throws IOException {
        this.checkValue(value);
        this.getCOSObject().setName(COSName.V, value);
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceEntry appearanceEntry = widget.getAppearance().getNormalAppearance();
            if (((COSDictionary)appearanceEntry.getCOSObject()).containsKey(value)) {
                widget.getCOSObject().setName(COSName.AS, value);
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
        }
        this.applyChange();
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public void setDefaultValue(String value) {
        this.checkValue(value);
        this.getCOSObject().setName(COSName.DV, value);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public List<String> getExportValues() {
        COSBase value = this.getInheritableAttribute(COSName.OPT);
        if (value instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)value).getString());
            return array;
        }
        if (value instanceof COSArray) {
            return COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        }
        return Collections.emptyList();
    }

    public void setExportValues(List<String> values) {
        if (values != null && !values.isEmpty()) {
            COSArray cosValues = COSArrayList.convertStringListToCOSStringCOSArray(values);
            this.getCOSObject().setItem(COSName.OPT, (COSBase)cosValues);
        } else {
            this.getCOSObject().removeItem(COSName.OPT);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceDictionary appearance = widget.getAppearance();
            if (appearance == null || appearance.getNormalAppearance() == null) {
                throw new UnsupportedOperationException("Appearance generation is not implemented yet, see PDFBOX-2849");
            }
            PDAppearanceEntry appearanceEntry = widget.getAppearance().getNormalAppearance();
            String value = this.getValue();
            if (((COSDictionary)appearanceEntry.getCOSObject()).containsKey(value)) {
                widget.getCOSObject().setName(COSName.AS, value);
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
        }
    }

    public Set<String> getOnValues() {
        HashSet<String> onValues = new HashSet<String>();
        List<PDAnnotationWidget> widgets = this.getWidgets();
        for (PDAnnotationWidget widget : widgets) {
            PDAppearanceEntry normalAppearance;
            PDAppearanceDictionary apDictionary = widget.getAppearance();
            if (apDictionary == null || (normalAppearance = apDictionary.getNormalAppearance()) == null) continue;
            Set<COSName> entries = normalAppearance.getSubDictionary().keySet();
            for (COSName entry : entries) {
                if (COSName.Off.compareTo(entry) == 0) continue;
                onValues.add(entry.getName());
            }
        }
        return onValues;
    }

    void checkValue(String value) throws IllegalArgumentException {
        Set<String> onValues = this.getOnValues();
        if (COSName.Off.getName().compareTo(value) != 0 && !onValues.contains(value)) {
            throw new IllegalArgumentException("value '" + value + "' is not a valid option for the field " + this.getFullyQualifiedName() + ", valid values are: " + onValues + " and " + COSName.Off.getName());
        }
    }
}

