/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenDeployment
implements MavenDeployment {
    private Set<PublishArtifact> attachedArtifacts;
    private final PublishArtifact pomArtifact;
    private final PublishArtifact mainArtifact;

    public DefaultMavenDeployment(PublishArtifact pomArtifact, PublishArtifact mainArtifact, Iterable<? extends PublishArtifact> attachedArtifacts) {
        this.pomArtifact = pomArtifact;
        this.mainArtifact = mainArtifact;
        this.attachedArtifacts = Sets.newLinkedHashSet(attachedArtifacts);
    }

    @Override
    public void addArtifact(PublishArtifact artifact) {
        this.attachedArtifacts.add(artifact);
    }

    @Override
    public PublishArtifact getPomArtifact() {
        return this.pomArtifact;
    }

    @Override
    public Set<PublishArtifact> getArtifacts() {
        HashSet<PublishArtifact> artifacts = new HashSet<PublishArtifact>();
        artifacts.addAll(this.attachedArtifacts);
        if (this.mainArtifact != null) {
            artifacts.add(this.mainArtifact);
        }
        artifacts.add(this.pomArtifact);
        return artifacts;
    }

    @Override
    public PublishArtifact getMainArtifact() {
        return this.mainArtifact;
    }

    @Override
    public Set<PublishArtifact> getAttachedArtifacts() {
        return this.attachedArtifacts;
    }
}

