/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javajs.util.T3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;

class Node
extends Element {
    int dim;
    float minLeft;
    float maxLeft;
    Element eleLeft;
    float minRight;
    float maxRight;
    Element eleRight;

    Node(Bspt bspt, int level, Leaf leafLeft) {
        this.bspt = bspt;
        if (level == bspt.treeDepth) {
            bspt.treeDepth = level + 1;
        }
        if (leafLeft.count != 2) {
            throw new NullPointerException();
        }
        this.dim = level % bspt.dimMax;
        leafLeft.sort(this.dim);
        Leaf leafRight = new Leaf(bspt, leafLeft, 1);
        this.minLeft = Node.getDimensionValue(leafLeft.tuples[0], this.dim);
        this.maxLeft = Node.getDimensionValue(leafLeft.tuples[leafLeft.count - 1], this.dim);
        this.minRight = Node.getDimensionValue(leafRight.tuples[0], this.dim);
        this.maxRight = Node.getDimensionValue(leafRight.tuples[leafRight.count - 1], this.dim);
        this.eleLeft = leafLeft;
        this.eleRight = leafRight;
        this.count = 2;
    }

    @Override
    Element addTuple(int level, T3 tuple) {
        float dimValue = Node.getDimensionValue(tuple, this.dim);
        ++this.count;
        boolean addLeft = dimValue < this.maxLeft ? true : (dimValue > this.minRight ? false : (dimValue == this.maxLeft ? (dimValue == this.minRight ? this.eleLeft.count < this.eleRight.count : true) : (dimValue == this.minRight ? false : this.eleLeft.count < this.eleRight.count)));
        if (addLeft) {
            if (dimValue < this.minLeft) {
                this.minLeft = dimValue;
            } else if (dimValue > this.maxLeft) {
                this.maxLeft = dimValue;
            }
            this.eleLeft = this.eleLeft.addTuple(level + 1, tuple);
        } else {
            if (dimValue < this.minRight) {
                this.minRight = dimValue;
            } else if (dimValue > this.maxRight) {
                this.maxRight = dimValue;
            }
            this.eleRight = this.eleRight.addTuple(level + 1, tuple);
        }
        return this;
    }

    static float getDimensionValue(T3 pt, int dim) {
        switch (dim) {
            case 0: {
                return pt.x;
            }
            case 1: {
                return pt.y;
            }
        }
        return pt.z;
    }
}

