/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import org.jmol.render.FontLineShapeRenderer;
import org.jmol.shape.Bbcage;
import org.jmol.shape.FontLineShape;
import org.jmol.util.BoxInfo;

abstract class CageRenderer
extends FontLineShapeRenderer {
    protected final P3[] p3Screens = new P3[8];
    protected char[] tickEdges;
    protected boolean isSlab;
    protected boolean isPolymer;
    private P3 pt;

    CageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.p3Screens[i] = new P3();
        }
        this.pt = new P3();
    }

    protected void renderCage(int mad, P3[] vertices, P3[] axisPoints, int firstLine, int allowedEdges0, int allowedEdges1, float scale) {
        this.g3d.setC(this.colix);
        FontLineShape fls = (FontLineShape)this.shape;
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.font3d = this.vwr.gdata.getFont3DScaled(fls.font3d, this.imageFontScaling);
        float zSum = 0.0f;
        int i = 8;
        while (--i >= 0) {
            this.pt.setT(vertices[i]);
            if (scale != 1.0f) {
                this.pt.sub(vertices[0]);
                this.pt.scaleAdd2(scale, this.pt, vertices[0]);
            }
            this.tm.transformPtNoClip(this.pt, this.p3Screens[i]);
            zSum += this.p3Screens[i].z;
        }
        int diameter = this.getDiameter((int)Math.floor(zSum / 8.0f), mad);
        int axisPt = 2;
        char edge = '\u0000';
        allowedEdges0 &= this.isPolymer ? 1 : (this.isSlab ? 85 : 255);
        allowedEdges1 &= this.isPolymer ? 16 : (this.isSlab ? 85 : 255);
        for (int i2 = firstLine * 2; i2 < 24; i2 += 2) {
            boolean drawTicks;
            byte edge0 = BoxInfo.edges[i2];
            byte edge1 = BoxInfo.edges[i2 + 1];
            if (axisPoints != null && edge0 == 0) {
                this.tm.transformPtNoClip(axisPoints[axisPt--], this.p3Screens[0]);
            }
            if ((allowedEdges0 & 1 << edge0) == 0 || (allowedEdges1 & 1 << edge1) == 0) continue;
            boolean bl = drawTicks = fls.tickInfos != null && (edge = this.tickEdges[i2 >> 1]) != '\u0000';
            if (drawTicks) {
                this.checkTickTemps();
                this.tickA.setT(vertices[edge0]);
                this.tickB.setT(vertices[edge1]);
                float start = 0.0f;
                if (this.shape instanceof Bbcage) {
                    switch (edge) {
                        case 'x': {
                            start = this.tickA.x;
                            break;
                        }
                        case 'y': {
                            start = this.tickA.y;
                            break;
                        }
                        case 'z': {
                            start = this.tickA.z;
                        }
                    }
                }
                this.tickInfo = fls.tickInfos["xyz".indexOf(edge) + 1];
                if (this.tickInfo == null) {
                    this.tickInfo = fls.tickInfos[0];
                }
                if (this.tickInfo == null) {
                    drawTicks = false;
                } else {
                    this.tickInfo.first = start;
                }
            }
            this.renderLine(this.p3Screens[edge0], this.p3Screens[edge1], diameter, drawTicks);
        }
    }
}

