/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.Viewer;

public class SmilesExt {
    private ScriptEval e;
    private SmilesMatcherInterface sm;

    public SmilesExt init(Object se) {
        this.e = (ScriptEval)se;
        this.sm = this.e.vwr.getSmilesMatcher();
        return this;
    }

    public float getSmilesCorrelation(BS bsA, BS bsB, String smiles, Lst<P3> ptsA, Lst<P3> ptsB, M4 m4, Lst<BS> vReturn, boolean asMap, int[][] mapSet, P3 center, boolean bestMap, int flags) throws ScriptException {
        float tolerance = mapSet == null ? 0.1f : Float.MAX_VALUE;
        try {
            int i;
            if (ptsA == null) {
                ptsA = new Lst();
                ptsB = new Lst();
            }
            M4 m = new M4();
            P3 c = new P3();
            Atom[] atoms = this.e.vwr.ms.at;
            int ac = this.e.vwr.ms.ac;
            int[][] maps = this.sm.getCorrelationMaps(smiles, (Node[])atoms, ac, bsA, flags | 8);
            if (maps == null) {
                this.e.evalError(this.sm.getLastException(), null);
            }
            if (maps.length == 0) {
                return Float.NaN;
            }
            int[] mapFirst = maps[0];
            for (i = 0; i < mapFirst.length; ++i) {
                ptsA.addLast((Object)atoms[mapFirst[i]]);
            }
            maps = this.sm.getCorrelationMaps(smiles, (Node[])atoms, ac, bsB, flags);
            if (maps == null) {
                this.e.evalError(this.sm.getLastException(), null);
            }
            if (maps.length == 0) {
                return Float.NaN;
            }
            Logger.info((String)(maps.length + " mappings found"));
            if (bestMap || !asMap) {
                int i2;
                float lowestStdDev = Float.MAX_VALUE;
                int[] mapBest = null;
                for (i2 = 0; i2 < maps.length; ++i2) {
                    ptsB.clear();
                    for (int j = 0; j < maps[i2].length; ++j) {
                        ptsB.addLast((Object)atoms[maps[i2][j]]);
                    }
                    Interface.getInterface((String)"javajs.util.Eigen", (Viewer)this.e.vwr, (String)"script");
                    float stddev = ptsB.size() == 1 ? 0.0f : Measure.getTransformMatrix4((Lst)ptsA, (Lst)ptsB, (M4)m, null);
                    Logger.info((String)("getSmilesCorrelation stddev=" + stddev));
                    if (vReturn != null && stddev < tolerance) {
                        BS bs = new BS();
                        for (int j = 0; j < maps[i2].length; ++j) {
                            bs.set(maps[i2][j]);
                        }
                        vReturn.addLast((Object)bs);
                    }
                    if (!(stddev < lowestStdDev)) continue;
                    mapBest = maps[i2];
                    if (m4 != null) {
                        m4.setM4(m);
                    }
                    if (center != null) {
                        center.setT((T3)c);
                    }
                    lowestStdDev = stddev;
                }
                if (mapSet != null) {
                    mapSet[0] = mapFirst;
                    mapSet[1] = mapBest;
                }
                ptsB.clear();
                for (i2 = 0; i2 < mapBest.length; ++i2) {
                    ptsB.addLast((Object)atoms[mapBest[i2]]);
                }
                return lowestStdDev;
            }
            for (i = 0; i < maps.length; ++i) {
                for (int j = 0; j < maps[i].length; ++j) {
                    ptsB.addLast((Object)atoms[maps[i][j]]);
                }
            }
        }
        catch (Exception ex) {
            this.e.evalError(ex.getMessage(), null);
        }
        return 0.0f;
    }

    public Object getSmilesMatches(String pattern, String smiles, BS bsSelected, BS bsMatch3D, int flags, boolean asOneBitset, boolean firstMatchOnly) throws ScriptException {
        BS[] b;
        if (pattern.length() == 0 || pattern.endsWith("///") || pattern.equals("H") || pattern.equals("top") || pattern.equalsIgnoreCase("NOAROMATIC")) {
            try {
                return this.e.vwr.getSmilesOpt(bsSelected, 0, 0, flags | (pattern.equals("H") ? 4096 : 0) | (pattern.equals("top") ? 8192 : 0) | (pattern.equalsIgnoreCase("NOAROMATIC") ? 16 : 0), pattern.endsWith("///") ? pattern : null);
            }
            catch (Exception ex) {
                this.e.evalError(ex.getMessage(), null);
            }
        }
        if (bsMatch3D == null) {
            boolean isSmarts = (flags & 2) == 2;
            try {
                if (smiles != null) {
                    int[][] map = this.sm.find(pattern, smiles, (isSmarts ? 2 : 1) | (firstMatchOnly ? 8 : 0));
                    if (!asOneBitset) {
                        return !firstMatchOnly ? map : (map.length == 0 ? (Object)new int[0] : (Object)map[0]);
                    }
                    BS bs = new BS();
                    for (int j = 0; j < map.length; ++j) {
                        int[] a = map[j];
                        int k = a.length;
                        while (--k >= 0) {
                            if (a[k] < 0) continue;
                            bs.set(a[k]);
                        }
                    }
                    if (!isSmarts) {
                        return new int[bs.cardinality()];
                    }
                    int[] iarray = new int[bs.cardinality()];
                    int pt = 0;
                    int i = bs.nextSetBit(0);
                    while (i >= 0) {
                        iarray[pt++] = i;
                        i = bs.nextSetBit(i + 1);
                    }
                    return iarray;
                }
                b = this.sm.getSubstructureSetArray(pattern, (Node[])this.e.vwr.ms.at, this.e.vwr.ms.ac, bsSelected, null, flags);
            }
            catch (Exception ex) {
                this.e.evalError(ex.getMessage(), null);
                return null;
            }
        } else {
            Lst vReturn = new Lst();
            float stddev = this.getSmilesCorrelation(bsMatch3D, bsSelected, pattern, null, null, null, (Lst<BS>)vReturn, false, null, null, false, flags);
            if (Float.isNaN(stddev)) {
                return asOneBitset ? new BS() : new BS[]{};
            }
            this.e.showString("RMSD " + stddev + " Angstroms");
            b = (BS[])vReturn.toArray((Object[])new BS[vReturn.size()]);
        }
        if (asOneBitset) {
            BS bs = new BS();
            for (int j = 0; j < b.length; ++j) {
                bs.or(b[j]);
            }
            return bs;
        }
        Lst list = new Lst();
        for (int j = 0; j < b.length; ++j) {
            list.addLast((Object)b[j]);
        }
        return list;
    }

    public float[] getFlexFitList(BS bs1, BS bs2, String smiles1, boolean isSmarts) throws ScriptException {
        int[][] bondMap2;
        int[][] mapSet = AU.newInt2((int)2);
        this.getSmilesCorrelation(bs1, bs2, smiles1, null, null, null, null, false, mapSet, null, false, isSmarts ? 2 : 1);
        if (mapSet[0] == null) {
            return null;
        }
        int[][] bondMap1 = this.e.vwr.ms.getDihedralMap(mapSet[0]);
        int[][] nArray = bondMap2 = bondMap1 == null ? (int[][])null : this.e.vwr.ms.getDihedralMap(mapSet[1]);
        if (bondMap2 == null || bondMap2.length != bondMap1.length) {
            return null;
        }
        float[][] angles = new float[bondMap1.length][3];
        Atom[] atoms = this.e.vwr.ms.at;
        SmilesExt.getTorsions(atoms, bondMap2, angles, 0);
        SmilesExt.getTorsions(atoms, bondMap1, angles, 1);
        float[] data = new float[bondMap1.length * 6];
        int pt = 0;
        for (int i = 0; i < bondMap1.length; ++i) {
            int[] map = bondMap1[i];
            data[pt++] = map[0];
            data[pt++] = map[1];
            data[pt++] = map[2];
            data[pt++] = map[3];
            data[pt++] = angles[i][0];
            data[pt++] = angles[i][1];
        }
        return data;
    }

    private static void getTorsions(Atom[] atoms, int[][] bondMap, float[][] diff, int pt) {
        int i = bondMap.length;
        while (--i >= 0) {
            int[] map = bondMap[i];
            float v = Measure.computeTorsion((T3)atoms[map[0]], (T3)atoms[map[1]], (T3)atoms[map[2]], (T3)atoms[map[3]], (boolean)true);
            if (pt == 1) {
                if (v - diff[i][0] > 180.0f) {
                    v -= 360.0f;
                } else if (v - diff[i][0] <= -180.0f) {
                    v += 360.0f;
                }
            }
            diff[i][pt] = v;
        }
    }
}

