/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Logger;
import org.jmol.util.MeshSlicer;

public class MeshCapper {
    private MeshSlicer slicer;
    private boolean dumping;
    private Map<Integer, CapVertex> capMap;
    private Lst<CapVertex> vertices;
    private Lst<CapVertex[]> lstRegions;
    private static final int DESCENDER = 0;
    private static final int ASCENDER = 1;
    private static final int LAST = 2;
    private int nTriangles;
    private int nRegions;
    private Lst<int[]> lstTriangles;
    private int nPoints;

    public MeshCapper set(MeshSlicer slicer) {
        this.slicer = slicer;
        this.dumping = Logger.debugging;
        return this;
    }

    void clear() {
        this.capMap = new Hashtable<Integer, CapVertex>();
        this.vertices = new Lst();
    }

    public int[][] triangulatePolygon(P3[] points) {
        this.clear();
        this.nPoints = points.length;
        CapVertex v0 = null;
        for (int i = 0; i < this.nPoints; ++i) {
            CapVertex v = new CapVertex(points[i], i);
            this.vertices.addLast(v);
            if (v0 != null) {
                v0.link(v);
            }
            v0 = v;
        }
        v0.link((CapVertex)this.vertices.get(0));
        this.lstTriangles = new Lst();
        this.createCap(null);
        int[][] a = AU.newInt2(this.lstTriangles.size());
        int i = this.lstTriangles.size();
        while (--i >= 0) {
            a[i] = (int[])this.lstTriangles.get(i);
        }
        return a;
    }

    void addEdge(int ipt1, int ipt2, int thisSet) {
        CapVertex v1 = this.addPoint(thisSet, ipt1);
        CapVertex v2 = this.addPoint(thisSet, ipt2);
        v1.link(v2);
    }

    private CapVertex addPoint(int thisSet, int i) {
        Integer ii = i;
        CapVertex v = this.capMap.get(ii);
        if (v == null) {
            T3 pt = this.slicer.m.vs[i];
            i = this.slicer.addIntersectionVertex(pt, 0.0f, -1, thisSet, null, -1, -1);
            v = new CapVertex(pt, i);
            this.vertices.addLast(v);
            this.capMap.put(ii, v);
        }
        if (this.dumping) {
            Logger.info(i + "\t" + this.slicer.m.vs[i]);
        }
        return v;
    }

    private T3 getInputPoint(CapVertex v) {
        return this.slicer == null ? P3.newP(v) : this.slicer.m.vs[v.ipt];
    }

    private void outputTriangle(int ipt1, int ipt2, int ipt3) {
        if (this.slicer == null) {
            int mask = 0;
            if (this.isEdge(ipt1, ipt2)) {
                mask |= 1;
            }
            if (this.isEdge(ipt2, ipt3)) {
                mask |= 2;
            }
            if (this.isEdge(ipt3, ipt1)) {
                mask |= 4;
            }
            this.lstTriangles.addLast(new int[]{ipt1, ipt2, ipt3, mask});
        } else {
            this.slicer.addTriangle(ipt1, ipt2, ipt3);
        }
    }

    private boolean isEdge(int i, int j) {
        return j == (i + 1) % this.nPoints;
    }

    private CapVertex[] test(CapVertex[] vs) {
        return vs;
    }

    void createCap(V3 norm) {
        V3 vac;
        this.capMap = null;
        CapVertex[] vs = new CapVertex[this.vertices.size()];
        if (vs.length < 3) {
            return;
        }
        V3 vab = V3.newVsub((T3)this.vertices.get(0), (T3)this.vertices.get(1));
        if (norm == null) {
            vac = V3.newVsub((T3)this.vertices.get(0), (T3)this.vertices.get(this.vertices.size() - 1));
        } else {
            vac = V3.newV(norm);
            vac.cross(vac, vab);
        }
        Quat q = Quat.getQuaternionFrameV(vab, vac, null, false);
        M3 m3 = q.getMatrix();
        M4 m4 = M4.newMV(m3, (T3)this.vertices.get(0));
        M4 m4inv = M4.newM4(m4).invert();
        this.vertices.toArray(vs);
        this.vertices = null;
        int i = vs.length;
        while (--i >= 0) {
            m4inv.rotTrans2(vs[i], vs[i]);
        }
        vs = this.test(vs);
        Logger.info("MeshCapper using " + vs.length + " vertices");
        CapVertex v0 = vs[0].sort(vs);
        if (v0 == null) {
            Logger.error("two identical points -- aborting");
            return;
        }
        this.lstRegions = new Lst();
        CapVertex v = v0;
        try {
            while ((v = this.process(v)) != v0) {
            }
        }
        catch (Exception e) {
            System.out.println("MeshCapper exception " + e);
            e.printStackTrace();
        }
        if (this.slicer != null) {
            this.clear();
        }
        Logger.info("MeshCapper created " + this.nTriangles + " triangles " + this.nRegions + " regions");
    }

    private CapVertex process(CapVertex v) {
        boolean isAscending;
        CapVertex q = v.qnext;
        v.qnext = null;
        if (this.dumping) {
            Logger.info(v.toString());
        }
        if (v.prev == v.next) {
            return q;
        }
        if (v.next == null) {
            System.out.println("OHO");
        }
        boolean isDescending = v.prev.region != null;
        boolean bl = isAscending = v.next.region != null;
        if (this.dumping) {
            Logger.info("#" + (isAscending ? v.next.id : "    ") + "    " + (isDescending ? v.prev.id : "") + "\n#" + (isAscending ? "   \\" : "    ") + (isDescending ? "    /\n" : "\n") + "#    " + v.id);
        }
        if (!isDescending && !isAscending) {
            CapVertex last = this.getLastPoint(v);
            if (last == null) {
                this.newRegion(v);
                return q;
            }
            CapVertex p = this.processSplit(v, last);
            p.qnext = q;
            q = p;
            isAscending = true;
        }
        if (isDescending) {
            this.processMonotonic(v, true);
        }
        if (isAscending) {
            this.processMonotonic(v, false);
        }
        if (isDescending && isAscending) {
            if (v.prev.prev == v.next) {
                this.lstRegions.removeObj(v.region);
                this.addTriangle(v.prev, v, v.next, "end");
                MeshCapper.clearV(v.prev);
                MeshCapper.clearV(v.next);
            } else {
                v.region = null;
            }
        }
        return q;
    }

    private static void clearV(CapVertex v) {
        if (v != null) {
            v.clear();
        }
    }

    private void processMonotonic(CapVertex v, boolean isDescending) {
        CapVertex vEdge = isDescending ? v.prev : v.next;
        v.region = vEdge.region;
        CapVertex last = v.region[2];
        if (last == v) {
            this.lstRegions.removeObj(v.region);
            return;
        }
        if (last == vEdge) {
            CapVertex v2;
            CapVertex v1 = last;
            CapVertex capVertex = v2 = isDescending ? v1.prev : v1.next;
            while (v2 != v && v2.qnext == null && isDescending == v.x > v.interpolateX(v2, v1)) {
                if (isDescending) {
                    this.addTriangle(v2, v1, v, "same desc " + v.ipt);
                    v1 = v2;
                    v2 = v2.prev;
                    continue;
                }
                this.addTriangle(v, v1, v2, "same asc " + v.ipt);
                v1 = v2;
                v2 = v2.next;
            }
        } else {
            CapVertex v2 = vEdge;
            do {
                CapVertex v1 = v2;
                if (isDescending) {
                    v2 = v1.prev;
                    this.addTriangle(v2, v1, v, "opp desc " + v.id);
                    continue;
                }
                v2 = v1.next;
                this.addTriangle(v, v1, v2, "opp asc " + v.id);
            } while (v2 != last && v2 != v && v2.qnext == null);
            if (last.region == null) {
                this.lstRegions.removeObj(v.region);
                CapVertex capVertex = isDescending ? last.prev : last.next;
                last.region = capVertex.region;
                v.region = capVertex.region;
            }
        }
        CapVertex capVertex = v;
        v.region[isDescending ? 0 : 1] = capVertex;
        v.region[2] = capVertex;
    }

    private CapVertex processSplit(CapVertex v, CapVertex last) {
        CapVertex pv = last.cloneV();
        if (this.dumping) {
            pv.id = pv.id + "a";
        }
        CapVertex p = v.cloneV();
        if (this.dumping) {
            p.id = p.id + "a";
        }
        if (last.region == null) {
            last.region = last.next.region;
            pv.region = last.prev.region;
        } else {
            this.newRegion(last);
            CapVertex cv = last;
            while (cv.next.region != null) {
                cv.next.region = cv.region;
                cv.region[0] = cv = cv.next;
            }
        }
        CapVertex[] r = pv.region;
        if (r[2] == last) {
            r[2] = pv;
        }
        r[0] = pv;
        if (r[1] == last) {
            r[1] = pv;
        }
        v.link(last);
        pv.prev.link(pv);
        pv.link(p);
        p.link(p.next);
        return p;
    }

    private void newRegion(CapVertex v) {
        ++this.nRegions;
        v.region = new CapVertex[]{v, v, v};
        this.lstRegions.addLast(v.region);
    }

    private CapVertex getLastPoint(CapVertex v) {
        CapVertex closest = null;
        float ymin = Float.MAX_VALUE;
        int i = this.lstRegions.size();
        while (--i >= 0) {
            boolean isOK;
            CapVertex[] r = (CapVertex[])this.lstRegions.get(i);
            CapVertex d = r[0];
            if (d == r[1]) continue;
            boolean isEdge = d.region != null;
            boolean bl = isOK = (isEdge ? v.interpolateX(d, d.next) : d.x) < v.x;
            if (isEdge && closest != null && closest.x != d.x && isOK == closest.x < d.x) {
                closest = null;
                ymin = Float.MAX_VALUE;
            }
            if (!isOK) continue;
            CapVertex a = r[1];
            isEdge = a.region != null;
            boolean bl2 = isOK = (isEdge ? v.interpolateX(a, a.prev) : a.x) >= v.x;
            if (isEdge && closest != null && closest.x != a.x && isOK == closest.x > a.x) {
                closest = null;
                ymin = Float.MAX_VALUE;
            }
            if (!isOK || !(r[2].y < ymin)) continue;
            ymin = r[2].y;
            closest = r[2];
        }
        return closest;
    }

    private boolean checkWinding(CapVertex v0, CapVertex v1, CapVertex v2) {
        return (v1.x - v0.x) * (v2.y - v0.y) > (v1.y - v0.y) * (v2.x - v0.x);
    }

    private void addTriangle(CapVertex v0, CapVertex v1, CapVertex v2, String note) {
        ++this.nTriangles;
        if (this.checkWinding(v0, v1, v2)) {
            if (this.dumping) {
                this.drawTriangle(this.nTriangles, v0, v1, v2, "red");
            }
            this.outputTriangle(v0.ipt, v1.ipt, v2.ipt);
        } else if (this.dumping) {
            Logger.info("#!!!BAD WINDING " + note);
        }
        v1.link(null);
    }

    private void drawTriangle(int index, CapVertex v0, CapVertex v1, CapVertex v2, String color) {
        T3 p0 = this.getInputPoint(v0);
        T3 p1 = this.getInputPoint(v1);
        T3 p2 = this.getInputPoint(v2);
        Logger.info("draw " + color + index + "/* " + v0.id + " " + v1.id + " " + v2.id + " */" + p0 + p1 + p2 + " color " + color);
    }

    private class CapVertex
    extends T3
    implements Cloneable,
    Comparator<CapVertex> {
        int ipt;
        String id = "";
        protected CapVertex qnext;
        CapVertex prev;
        CapVertex next;
        CapVertex[] region;
        protected int ok = 1;
        boolean disabled;

        CapVertex(T3 p, int i) {
            this.ipt = i;
            this.id = "" + i;
            this.setT(p);
        }

        public CapVertex cloneV() {
            try {
                return (CapVertex)this.clone();
            }
            catch (Exception e) {
                return null;
            }
        }

        public CapVertex sort(CapVertex[] vs) {
            int n;
            CapVertex v0 = null;
            CapVertex v1 = null;
            int i = n = vs.length;
            while (--i >= 0) {
                if (vs[i].next == null) {
                    if (v0 == null) {
                        v1 = vs[i];
                        continue;
                    }
                    vs[i].link(v0);
                    v0 = null;
                    continue;
                }
                if (vs[i].prev != null) continue;
                if (v1 == null) {
                    v0 = vs[i];
                    continue;
                }
                v1.link(vs[i]);
                v1 = null;
            }
            this.ok = 0;
            while (this.ok == 0) {
                this.ok = 1;
                Arrays.sort(vs, this);
                System.out.println(this.ok);
            }
            i = n;
            while (--i >= 0) {
                if (vs[i].x == Float.MAX_VALUE) {
                    n = i;
                }
                vs[i].qnext = vs[(i + 1) % n];
            }
            vs[n - 1].qnext = vs[0];
            return vs[0];
        }

        @Override
        public int compare(CapVertex v1, CapVertex v2) {
            return v1.y < v2.y ? 1 : (v1.y > v2.y || v1.x < v2.x ? -1 : (v1.x > v2.x ? 1 : this.disable(v1, v2)));
        }

        private int disable(CapVertex v1, CapVertex v2) {
            if (v2.x == Float.MAX_VALUE) {
                return 0;
            }
            CapVertex v = v1.x == Float.MAX_VALUE ? v1 : v2;
            v.x = Float.MAX_VALUE;
            v.y = -3.4028235E38f;
            v.link(null);
            this.ok = 0;
            return v1.x > v2.x ? 1 : -1;
        }

        protected float interpolateX(CapVertex v1, CapVertex v2) {
            float dy12 = v2.y - v1.y;
            float dx12 = v2.x - v1.x;
            return dy12 != 0.0f ? v1.x + (this.y - v1.y) * dx12 / dy12 : (dx12 > 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        }

        protected void link(CapVertex v) {
            if (v == null) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.clear();
            } else {
                this.next = v;
                v.prev = this;
            }
        }

        protected void clear() {
            this.prev = null;
            this.next = null;
            this.qnext = null;
            this.region = null;
        }

        private String dumpRegion() {
            String s = "\n#REGION d=" + this.region[0].id + " a=" + this.region[1].id + " last=" + this.region[2].id + "\n# ";
            CapVertex v = this.region[1];
            while (true) {
                s = s + v.id + " ";
                if (v == this.region[0]) break;
                v = v.next;
            }
            return s + "\n";
        }

        @Override
        public String toString() {
            return "draw p" + this.id + " {" + this.x + " " + this.y + " " + this.z + "} # " + (this.prev == null ? "null" : this.prev.id) + (this.next == null ? " null" : " " + this.next.id) + (this.region == null ? "" : this.dumpRegion());
        }
    }
}

