/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public final class Iso2022Converter {
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String UTF_8 = "UTF-8";
    private static final byte LATIN_CAPITAL_A = 65;
    private static final int DOT = 14844066;
    private static final byte LATIN_CAPITAL_G = 71;
    private static final byte PERCENT_SIGN = 37;
    private static final byte ESC = 27;

    @Nullable
    public static String convertISO2022CharsetToJavaCharset(@NotNull byte[] byArray) {
        if (byArray.length > 2 && byArray[0] == 27 && byArray[1] == 37 && byArray[2] == 71) {
            return UTF_8;
        }
        if (byArray.length > 3 && byArray[0] == 27 && (byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16) == 14844066 && byArray[4] == 65) {
            return ISO_8859_1;
        }
        return null;
    }

    @Nullable
    static String guessEncoding(@NotNull byte[] byArray) {
        String[] stringArray;
        for (String string : stringArray = new String[]{UTF_8, System.getProperty("file.encoding"), ISO_8859_1}) {
            CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
            try {
                charsetDecoder.decode(ByteBuffer.wrap(byArray));
                return string;
            }
            catch (CharacterCodingException characterCodingException) {
            }
        }
        return null;
    }

    private Iso2022Converter() {
    }
}

