/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.access.AbstractCacheAccess;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.InvalidArgumentException;
import org.apache.commons.jcs.access.exception.InvalidHandleException;
import org.apache.commons.jcs.access.exception.ObjectExistsException;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheAccess<K, V>
extends AbstractCacheAccess<K, V>
implements ICacheAccess<K, V> {
    private static final Log log = LogFactory.getLog(CacheAccess.class);

    public CacheAccess(CompositeCache<K, V> compositeCache) {
        super(compositeCache);
    }

    @Override
    public V get(K k) {
        ICacheElement iCacheElement = this.getCacheControl().get(k);
        return iCacheElement != null ? (V)iCacheElement.getVal() : null;
    }

    @Override
    public Map<K, V> getMatching(String string) {
        HashMap hashMap = new HashMap();
        Map map = this.getCacheControl().getMatching(string);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                ICacheElement iCacheElement = entry.getValue();
                if (iCacheElement == null) continue;
                hashMap.put(entry.getKey(), iCacheElement.getVal());
            }
        }
        return hashMap;
    }

    @Override
    public ICacheElement<K, V> getCacheElement(K k) {
        return this.getCacheControl().get(k);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getCacheElements(Set<K> set) {
        return this.getCacheControl().getMultiple(set);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatchingCacheElements(String string) {
        return this.getCacheControl().getMatching(string);
    }

    @Override
    public void putSafe(K k, V v) {
        if (this.getCacheControl().get(k) != null) {
            throw new ObjectExistsException("putSafe failed.  Object exists in the cache for key [" + k + "].  Remove first or use a non-safe put to override the value.");
        }
        this.put(k, v);
    }

    @Override
    public void put(K k, V v) {
        this.put(k, v, this.getCacheControl().getElementAttributes());
    }

    @Override
    public void put(K k, V v, IElementAttributes iElementAttributes) {
        if (k == null) {
            throw new InvalidArgumentException("Key must not be null");
        }
        if (v == null) {
            throw new InvalidArgumentException("Value must not be null");
        }
        try {
            CacheElement<K, V> cacheElement = new CacheElement<K, V>(this.getCacheControl().getCacheName(), k, v);
            cacheElement.setElementAttributes(iElementAttributes);
            this.getCacheControl().update(cacheElement);
        }
        catch (IOException iOException) {
            throw new CacheException(iOException);
        }
    }

    @Override
    public void remove(K k) {
        this.getCacheControl().remove(k);
    }

    @Override
    public void resetElementAttributes(K k, IElementAttributes iElementAttributes) {
        ICacheElement iCacheElement = this.getCacheControl().get(k);
        if (iCacheElement == null) {
            throw new InvalidHandleException("Object for name [" + k + "] is not in the cache");
        }
        this.put(iCacheElement.getKey(), iCacheElement.getVal(), iElementAttributes);
    }

    @Override
    public IElementAttributes getElementAttributes(K k) {
        IElementAttributes iElementAttributes = null;
        try {
            iElementAttributes = this.getCacheControl().getElementAttributes(k);
        }
        catch (IOException iOException) {
            log.error("Failure getting element attributes", iOException);
        }
        return iElementAttributes;
    }
}

