/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskElementDescriptor;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs.utils.struct.LRUMap;
import org.apache.commons.jcs.utils.timing.ElapsedTimer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockDiskKeyStore<K> {
    private static final Log log = LogFactory.getLog(BlockDiskKeyStore.class);
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private Map<K, int[]> keyHash;
    private final File keyFile;
    protected final String logCacheName;
    private final String fileName;
    private final int maxKeySize;
    protected final BlockDiskCache<K, ?> blockDiskCache;
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private int blockSize;

    public BlockDiskKeyStore(BlockDiskCacheAttributes blockDiskCacheAttributes, BlockDiskCache<K, ?> blockDiskCache) {
        this.blockDiskCacheAttributes = blockDiskCacheAttributes;
        this.logCacheName = "Region [" + this.blockDiskCacheAttributes.getCacheName() + "] ";
        this.fileName = this.blockDiskCacheAttributes.getCacheName();
        this.maxKeySize = blockDiskCacheAttributes.getMaxKeySize();
        this.blockDiskCache = blockDiskCache;
        this.diskLimitType = blockDiskCacheAttributes.getDiskLimitType();
        this.blockSize = blockDiskCacheAttributes.getBlockSizeBytes();
        File file = blockDiskCacheAttributes.getDiskPath();
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Cache file root directory [" + file + "]");
        }
        this.keyFile = new File(file, this.fileName + ".key");
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Key File [" + this.keyFile.getAbsolutePath() + "]");
        }
        if (this.keyFile.length() > 0L) {
            this.loadKeys();
            if (!this.verify()) {
                log.warn(this.logCacheName + "Key File is invalid. Resetting file.");
                this.initKeyMap();
                this.reset();
            }
        } else {
            this.initKeyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveKeys() {
        try {
            ElapsedTimer elapsedTimer = new ElapsedTimer();
            int n = this.keyHash.size();
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Saving keys to [" + this.keyFile.getAbsolutePath() + "], key count [" + n + "]");
            }
            File file = this.keyFile;
            synchronized (file) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.keyFile);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
                try {
                    if (!this.verify()) {
                        throw new IOException("Inconsistent key file");
                    }
                    for (Map.Entry<K, int[]> entry : this.keyHash.entrySet()) {
                        BlockDiskElementDescriptor<K> blockDiskElementDescriptor = new BlockDiskElementDescriptor<K>();
                        blockDiskElementDescriptor.setKey(entry.getKey());
                        blockDiskElementDescriptor.setBlocks(entry.getValue());
                        objectOutputStream.writeUnshared(blockDiskElementDescriptor);
                    }
                }
                finally {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
            }
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Finished saving keys. It took " + elapsedTimer.getElapsedTimeString() + " to store " + n + " keys.  Key file length [" + this.keyFile.length() + "]");
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Problem storing keys.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        File file = this.keyFile;
        synchronized (file) {
            this.clearMemoryMap();
            this.saveKeys();
        }
    }

    protected void clearMemoryMap() {
        this.keyHash.clear();
    }

    private void initKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = this.diskLimitType == IDiskCacheAttributes.DiskLimitType.SIZE ? new LRUMapSizeLimited(this.maxKeySize) : new LRUMapCountLimited(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Set maxKeySize to: '" + this.maxKeySize + "'");
            }
        } else {
            this.keyHash = new HashMap<K, int[]>();
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Set maxKeySize to unlimited'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() {
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Loading keys for " + this.keyFile.toString());
        }
        try {
            this.initKeyMap();
            HashMap hashMap = new HashMap();
            File file = this.keyFile;
            synchronized (file) {
                FileInputStream fileInputStream = new FileInputStream(this.keyFile);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
                ObjectInputStreamClassLoaderAware objectInputStreamClassLoaderAware = new ObjectInputStreamClassLoaderAware(bufferedInputStream, null);
                try {
                    try {
                        while (true) {
                            BlockDiskElementDescriptor blockDiskElementDescriptor;
                            if ((blockDiskElementDescriptor = (BlockDiskElementDescriptor)objectInputStreamClassLoaderAware.readObject()) == null) {
                                continue;
                            }
                            hashMap.put(blockDiskElementDescriptor.getKey(), blockDiskElementDescriptor.getBlocks());
                        }
                    }
                    catch (EOFException eOFException) {
                        objectInputStreamClassLoaderAware.close();
                    }
                }
                catch (Throwable throwable) {
                    objectInputStreamClassLoaderAware.close();
                    throw throwable;
                }
            }
            if (!hashMap.isEmpty()) {
                this.keyHash.putAll(hashMap);
                if (log.isDebugEnabled()) {
                    log.debug(this.logCacheName + "Found " + hashMap.size() + " in keys file.");
                }
                if (log.isInfoEnabled()) {
                    log.info(this.logCacheName + "Loaded keys from [" + this.fileName + "], key count: " + this.keyHash.size() + "; up to " + this.maxKeySize + " will be available.");
                }
            }
        }
        catch (Exception exception) {
            log.error(this.logCacheName + "Problem loading keys for file " + this.fileName, exception);
        }
    }

    public Set<Map.Entry<K, int[]>> entrySet() {
        return this.keyHash.entrySet();
    }

    public Set<K> keySet() {
        return this.keyHash.keySet();
    }

    public int size() {
        return this.keyHash.size();
    }

    public int[] get(K k) {
        return this.keyHash.get(k);
    }

    public void put(K k, int[] nArray) {
        this.keyHash.put(k, nArray);
    }

    public int[] remove(K k) {
        return this.keyHash.remove(k);
    }

    private boolean verify() {
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<K, int[]> object : this.keyHash.entrySet()) {
            for (int n : object.getValue()) {
                HashSet<K> hashSet = (HashSet<K>)treeMap.get(n);
                if (hashSet == null) {
                    hashSet = new HashSet<K>();
                    treeMap.put(n, hashSet);
                } else if (!log.isDebugEnabled()) {
                    return false;
                }
                hashSet.add(object.getKey());
            }
        }
        boolean bl = true;
        if (log.isDebugEnabled()) {
            for (Object object : treeMap.entrySet()) {
                log.debug("Block " + object.getKey() + ":" + object.getValue());
                if (((Set)object.getValue()).size() <= 1) continue;
                bl = false;
            }
            return bl;
        }
        return bl;
    }

    public class LRUMapCountLimited
    extends LRUMap<K, int[]> {
        public static final String TAG = "orig-lru-count";

        public LRUMapCountLimited(int n) {
            super(n);
        }

        @Override
        protected void processRemovedLRU(K k, int[] nArray) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(nArray);
            if (log.isDebugEnabled()) {
                log.debug(BlockDiskKeyStore.this.logCacheName + "Removing key: [" + k + "] from key store.");
                log.debug(BlockDiskKeyStore.this.logCacheName + "Key store size: [" + super.size() + "].");
            }
        }
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, int[]> {
        public static final String TAG = "orig-lru-size";
        private AtomicInteger contentSize;
        private int maxSize;

        public LRUMapSizeLimited() {
            this(-1);
        }

        public LRUMapSizeLimited(int n) {
            this.maxSize = n;
            this.contentSize = new AtomicInteger(0);
        }

        private void subLengthFromCacheSize(int[] nArray) {
            this.contentSize.addAndGet(nArray.length * BlockDiskKeyStore.this.blockSize / -1024 - 1);
        }

        private void addLengthToCacheSize(int[] nArray) {
            this.contentSize.addAndGet(nArray.length * BlockDiskKeyStore.this.blockSize / 1024 + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] put(K k, int[] nArray) {
            int[] nArray2 = null;
            try {
                nArray2 = super.put(k, nArray);
            }
            finally {
                if (nArray != null) {
                    this.addLengthToCacheSize(nArray);
                }
                if (nArray2 != null) {
                    this.subLengthFromCacheSize(nArray2);
                }
            }
            return nArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] remove(Object object) {
            int[] nArray = null;
            try {
                int[] nArray2 = nArray = (int[])super.remove(object);
                return nArray2;
            }
            finally {
                if (nArray != null) {
                    this.subLengthFromCacheSize(nArray);
                }
            }
        }

        @Override
        protected void processRemovedLRU(K k, int[] nArray) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(nArray);
            if (log.isDebugEnabled()) {
                log.debug(BlockDiskKeyStore.this.logCacheName + "Removing key: [" + k + "] from key store.");
                log.debug(BlockDiskKeyStore.this.logCacheName + "Key store size: [" + super.size() + "].");
            }
            if (nArray != null) {
                this.subLengthFromCacheSize(nArray);
            }
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.get() > this.maxSize && this.size() > 1;
        }
    }
}

