/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class DataSource {
    public final Bounds bounds;
    public final String origin;

    public DataSource(Bounds bounds, String string) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "bounds");
        this.bounds = bounds;
        this.origin = string;
    }

    public int hashCode() {
        return Objects.hash(this.bounds, this.origin);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataSource dataSource = (DataSource)object;
        return Objects.equals(this.bounds, dataSource.bounds) && Objects.equals(this.origin, dataSource.origin);
    }

    public String toString() {
        return "DataSource [bounds=" + this.bounds + ", origin=" + this.origin + ']';
    }

    public static Area getDataSourceArea(Collection<DataSource> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : collection) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public static List<Bounds> getDataSourceBounds(Collection<DataSource> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Bounds> arrayList = new ArrayList<Bounds>(collection.size());
        for (DataSource dataSource : collection) {
            if (dataSource.bounds == null) continue;
            arrayList.add(dataSource.bounds);
        }
        return arrayList;
    }
}

