/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class DatasetEventManager
implements MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    private static final DatasetEventManager instance = new DatasetEventManager();
    private final Queue<AbstractDatasetChangedEvent> eventsInEDT = new LinkedBlockingQueue<AbstractDatasetChangedEvent>();
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> normalListeners = new CopyOnWriteArrayList();
    private final DataSetListener myListener = new DataSetListenerAdapter(this);
    private final Runnable edtRunnable = new EdtRunnable();

    public static DatasetEventManager getInstance() {
        return instance;
    }

    public DatasetEventManager() {
        MapView.addEditLayerChangeListener(this);
    }

    public void addDatasetListener(DataSetListener dataSetListener, FireMode fireMode) {
        if (fireMode == FireMode.IN_EDT || fireMode == FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new ListenerInfo(dataSetListener, fireMode == FireMode.IN_EDT_CONSOLIDATED));
        } else {
            this.normalListeners.addIfAbsent(new ListenerInfo(dataSetListener, false));
        }
    }

    public void removeDatasetListener(DataSetListener dataSetListener) {
        ListenerInfo listenerInfo = new ListenerInfo(dataSetListener, false);
        this.inEDTListeners.remove(listenerInfo);
        this.normalListeners.remove(listenerInfo);
    }

    @Override
    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        if (osmDataLayer != null) {
            osmDataLayer.data.removeDataSetListener(this.myListener);
        }
        if (osmDataLayer2 != null) {
            osmDataLayer2.data.addDataSetListener(this.myListener);
            this.processDatasetEvent(new DataChangedEvent(osmDataLayer2.data));
        } else {
            this.processDatasetEvent(new DataChangedEvent(null));
        }
    }

    private static void fireEvents(List<ListenerInfo> list, AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        for (ListenerInfo listenerInfo : list) {
            if (listenerInfo.consolidate) continue;
            abstractDatasetChangedEvent.fire(listenerInfo.listener);
        }
    }

    private static void fireConsolidatedEvents(List<ListenerInfo> list, AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        for (ListenerInfo listenerInfo : list) {
            if (!listenerInfo.consolidate) continue;
            abstractDatasetChangedEvent.fire(listenerInfo.listener);
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        DatasetEventManager.fireEvents(this.normalListeners, abstractDatasetChangedEvent);
        this.eventsInEDT.add(abstractDatasetChangedEvent);
        SwingUtilities.invokeLater(this.edtRunnable);
    }

    private static class ListenerInfo {
        private final DataSetListener listener;
        private final boolean consolidate;

        ListenerInfo(DataSetListener dataSetListener, boolean bl) {
            this.listener = dataSetListener;
            this.consolidate = bl;
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ListenerInfo listenerInfo = (ListenerInfo)object;
            return Objects.equals(this.listener, listenerInfo.listener);
        }
    }

    public static enum FireMode {
        IMMEDIATELY,
        IN_EDT,
        IN_EDT_CONSOLIDATED;

    }

    private final class EdtRunnable
    implements Runnable {
        private EdtRunnable() {
        }

        @Override
        public void run() {
            while (!DatasetEventManager.this.eventsInEDT.isEmpty()) {
                AbstractDatasetChangedEvent abstractDatasetChangedEvent;
                DataSet dataSet = null;
                AbstractDatasetChangedEvent abstractDatasetChangedEvent2 = null;
                while ((abstractDatasetChangedEvent = (AbstractDatasetChangedEvent)DatasetEventManager.this.eventsInEDT.poll()) != null) {
                    List<AbstractDatasetChangedEvent> list;
                    DatasetEventManager.fireEvents(DatasetEventManager.this.inEDTListeners, abstractDatasetChangedEvent);
                    if (abstractDatasetChangedEvent2 != null && dataSet != abstractDatasetChangedEvent.getDataset()) {
                        DatasetEventManager.fireConsolidatedEvents(DatasetEventManager.this.inEDTListeners, abstractDatasetChangedEvent2);
                        abstractDatasetChangedEvent2 = null;
                    }
                    dataSet = abstractDatasetChangedEvent.getDataset();
                    if (abstractDatasetChangedEvent instanceof DataChangedEvent) {
                        List<AbstractDatasetChangedEvent> list2;
                        list = (DataChangedEvent)abstractDatasetChangedEvent;
                        if (((DataChangedEvent)((Object)list)).getEvents() == null) {
                            abstractDatasetChangedEvent2 = list;
                            continue;
                        }
                        if (abstractDatasetChangedEvent2 == null) {
                            abstractDatasetChangedEvent2 = new DataChangedEvent(dataSet, ((DataChangedEvent)((Object)list)).getEvents());
                            continue;
                        }
                        if (abstractDatasetChangedEvent2 instanceof DataChangedEvent) {
                            list2 = ((DataChangedEvent)abstractDatasetChangedEvent2).getEvents();
                            if (list2 == null) continue;
                            list2.addAll(((DataChangedEvent)((Object)list)).getEvents());
                            continue;
                        }
                        list2 = abstractDatasetChangedEvent2;
                        abstractDatasetChangedEvent2 = new DataChangedEvent(dataSet, ((DataChangedEvent)((Object)list)).getEvents());
                        ((DataChangedEvent)abstractDatasetChangedEvent2).getEvents().add((AbstractDatasetChangedEvent)((Object)list2));
                        continue;
                    }
                    if (abstractDatasetChangedEvent2 == null) {
                        abstractDatasetChangedEvent2 = abstractDatasetChangedEvent;
                        continue;
                    }
                    if (abstractDatasetChangedEvent2 instanceof DataChangedEvent) {
                        list = ((DataChangedEvent)abstractDatasetChangedEvent2).getEvents();
                        if (list == null) continue;
                        list.add(abstractDatasetChangedEvent);
                        continue;
                    }
                    abstractDatasetChangedEvent2 = new DataChangedEvent(dataSet, new ArrayList<AbstractDatasetChangedEvent>(Arrays.asList(abstractDatasetChangedEvent2)));
                }
                DatasetEventManager.fireConsolidatedEvents(DatasetEventManager.this.inEDTListeners, abstractDatasetChangedEvent2);
            }
        }
    }
}

