/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.List;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;

public abstract class LayerPositionStrategy {
    public static final LayerPositionStrategy IN_FRONT = new LayerPositionStrategy(){

        @Override
        public int getPosition(LayerManager layerManager) {
            return 0;
        }
    };
    public static final LayerPositionStrategy AFTER_LAST_DATA_LAYER = LayerPositionStrategy.afterLast(new Predicate<Layer>(){

        @Override
        public boolean evaluate(Layer layer) {
            return layer instanceof OsmDataLayer || layer instanceof ValidatorLayer;
        }
    });
    public static final LayerPositionStrategy AFTER_LAST_VALIDATION_LAYER = LayerPositionStrategy.afterLast(new Predicate<Layer>(){

        @Override
        public boolean evaluate(Layer layer) {
            return layer instanceof ValidatorLayer;
        }
    });
    public static final LayerPositionStrategy BEFORE_FIRST_BACKGROUND_LAYER = LayerPositionStrategy.inFrontOfFirst(new Predicate<Layer>(){

        @Override
        public boolean evaluate(Layer layer) {
            return layer.isBackgroundLayer();
        }
    });

    public static LayerPositionStrategy inFrontOf(Layer layer) {
        return LayerPositionStrategy.inFrontOfFirst(Predicates.equalTo(layer));
    }

    public static LayerPositionStrategy inFrontOfFirst(final Predicate<Layer> predicate) {
        return new LayerPositionStrategy(){

            @Override
            public int getPosition(LayerManager layerManager) {
                List<Layer> list = layerManager.getLayers();
                for (int i = 0; i < list.size(); ++i) {
                    if (!predicate.evaluate(list.get(i))) continue;
                    return i;
                }
                return list.size();
            }
        };
    }

    public static LayerPositionStrategy afterLast(final Predicate<Layer> predicate) {
        return new LayerPositionStrategy(){

            @Override
            public int getPosition(LayerManager layerManager) {
                List<Layer> list = layerManager.getLayers();
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (!predicate.evaluate(list.get(i))) continue;
                    return i + 1;
                }
                return 0;
            }
        };
    }

    public abstract int getPosition(LayerManager var1);
}

