/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.DateFormat;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ImageViewerDialog
extends ToggleDialog
implements MapView.LayerChangeListener {
    private static final String COMMAND_ZOOM = "zoom";
    private static final String COMMAND_CENTERVIEW = "centre";
    private static final String COMMAND_NEXT = "next";
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_REMOVE_FROM_DISK = "removefromdisk";
    private static final String COMMAND_PREVIOUS = "previous";
    private static final String COMMAND_COLLAPSE = "collapse";
    private static final String COMMAND_FIRST = "first";
    private static final String COMMAND_LAST = "last";
    private static final String COMMAND_COPY_PATH = "copypath";
    private final ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView;
    private static volatile ImageViewerDialog dialog;
    private boolean collapseButtonClicked;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnCollapse;
    private JToggleButton tbCentre;
    private transient GeoImageLayer currentLayer;
    private transient ImageEntry currentEntry;

    static void newInstance() {
        dialog = new ImageViewerDialog();
    }

    public static ImageViewerDialog getInstance() {
        if (dialog == null) {
            throw new AssertionError((Object)"a new instance needs to be created first");
        }
        return dialog;
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images", new Object[0]), "geoimage", I18n.tr("Display geotagged images", new Object[0]), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Tool: {0}", I18n.tr("Display geotagged images", new Object[0])), 89, 5003), 200);
        this.build();
        MapView.addLayerChangeListener(this);
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.imgDisplay, "Center");
        Dimension dimension = new Dimension(26, 26);
        ImageAction imageAction = new ImageAction(COMMAND_PREVIOUS, ImageProvider.get("dialogs", COMMAND_PREVIOUS), I18n.tr("Previous", new Object[0]));
        this.btnPrevious = new JButton(imageAction);
        this.btnPrevious.setPreferredSize(dimension);
        Shortcut shortcut = Shortcut.registerShortcut("geoimage:previous", I18n.tr("Geoimage: {0}", I18n.tr("Show previous Image", new Object[0])), 33, 5003);
        Main.registerActionShortcut(imageAction, shortcut);
        this.btnPrevious.getInputMap(2).put(shortcut.getKeyStroke(), "Previous Image");
        this.btnPrevious.getActionMap().put("Previous Image", imageAction);
        this.btnPrevious.setEnabled(false);
        String string = I18n.tr("Remove photo from layer", new Object[0]);
        ImageAction imageAction2 = new ImageAction(COMMAND_REMOVE, ImageProvider.get("dialogs", "delete"), string);
        JButton jButton = new JButton(imageAction2);
        jButton.setPreferredSize(dimension);
        Shortcut shortcut2 = Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr("Geoimage: {0}", I18n.tr("Remove photo from layer", new Object[0])), 127, 5005);
        Main.registerActionShortcut(imageAction2, shortcut2);
        jButton.getInputMap(2).put(shortcut2.getKeyStroke(), string);
        jButton.getActionMap().put(string, imageAction2);
        ImageAction imageAction3 = new ImageAction(COMMAND_REMOVE_FROM_DISK, ImageProvider.get("dialogs", "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk", new Object[0]));
        JButton jButton2 = new JButton(imageAction3);
        jButton2.setPreferredSize(dimension);
        Shortcut shortcut3 = Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr("Geoimage: {0}", I18n.tr("Delete File from disk", new Object[0])), 127, 5009);
        Main.registerActionShortcut(imageAction3, shortcut3);
        jButton2.getInputMap(2).put(shortcut3.getKeyStroke(), "Delete image file from disk");
        jButton2.getActionMap().put("Delete image file from disk", imageAction3);
        ImageAction imageAction4 = new ImageAction(COMMAND_COPY_PATH, ImageProvider.get("copy"), I18n.tr("Copy image path", new Object[0]));
        JButton jButton3 = new JButton(imageAction4);
        jButton3.setPreferredSize(dimension);
        Shortcut shortcut4 = Shortcut.registerShortcut("geoimage:copypath", I18n.tr("Geoimage: {0}", I18n.tr("Copy image path", new Object[0])), 67, 5010);
        Main.registerActionShortcut(imageAction4, shortcut4);
        jButton3.getInputMap(2).put(shortcut4.getKeyStroke(), "Copy image path");
        jButton3.getActionMap().put("Copy image path", imageAction4);
        ImageAction imageAction5 = new ImageAction(COMMAND_NEXT, ImageProvider.get("dialogs", COMMAND_NEXT), I18n.tr("Next", new Object[0]));
        this.btnNext = new JButton(imageAction5);
        this.btnNext.setPreferredSize(dimension);
        Shortcut shortcut5 = Shortcut.registerShortcut("geoimage:next", I18n.tr("Geoimage: {0}", I18n.tr("Show next Image", new Object[0])), 34, 5003);
        Main.registerActionShortcut(imageAction5, shortcut5);
        this.btnNext.getInputMap(2).put(shortcut5.getKeyStroke(), "Next Image");
        this.btnNext.getActionMap().put("Next Image", imageAction5);
        this.btnNext.setEnabled(false);
        Main.registerActionShortcut(new ImageAction(COMMAND_FIRST, null, null), Shortcut.registerShortcut("geoimage:first", I18n.tr("Geoimage: {0}", I18n.tr("Show first Image", new Object[0])), 36, 5003));
        Main.registerActionShortcut(new ImageAction(COMMAND_LAST, null, null), Shortcut.registerShortcut("geoimage:last", I18n.tr("Geoimage: {0}", I18n.tr("Show last Image", new Object[0])), 35, 5003));
        this.tbCentre = new JToggleButton(new ImageAction(COMMAND_CENTERVIEW, ImageProvider.get("dialogs", "centreview"), I18n.tr("Center view", new Object[0])));
        this.tbCentre.setPreferredSize(dimension);
        JButton jButton4 = new JButton(new ImageAction(COMMAND_ZOOM, ImageProvider.get("dialogs", "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1", new Object[0])));
        jButton4.setPreferredSize(dimension);
        this.btnCollapse = new JButton(new ImageAction(COMMAND_COLLAPSE, ImageProvider.get("dialogs", COMMAND_COLLAPSE), I18n.tr("Move dialog to the side pane", new Object[0])));
        this.btnCollapse.setPreferredSize(new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.btnPrevious);
        jPanel2.add(this.btnNext);
        jPanel2.add(Box.createRigidArea(new Dimension(7, 0)));
        jPanel2.add(this.tbCentre);
        jPanel2.add(jButton4);
        jPanel2.add(Box.createRigidArea(new Dimension(7, 0)));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(7, 0)));
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)this.btnCollapse, gridBagConstraints);
        jPanel.add((Component)jPanel3, "South");
        this.createLayout(jPanel, false, null);
    }

    @Override
    public void destroy() {
        MapView.removeLayerChangeListener(this);
        super.destroy();
    }

    public static void showImage(GeoImageLayer geoImageLayer, ImageEntry imageEntry) {
        ImageViewerDialog.getInstance().displayImage(geoImageLayer, imageEntry);
        if (geoImageLayer != null) {
            geoImageLayer.checkPreviousNextButtons();
        } else {
            ImageViewerDialog.setPreviousEnabled(false);
            ImageViewerDialog.setNextEnabled(false);
        }
    }

    public static void setPreviousEnabled(boolean bl) {
        ImageViewerDialog.getInstance().btnPrevious.setEnabled(bl);
    }

    public static void setNextEnabled(boolean bl) {
        ImageViewerDialog.getInstance().btnNext.setEnabled(bl);
    }

    public static synchronized boolean setCentreEnabled(boolean bl) {
        ImageViewerDialog imageViewerDialog = ImageViewerDialog.getInstance();
        boolean bl2 = imageViewerDialog.tbCentre.isEnabled();
        imageViewerDialog.tbCentre.setEnabled(bl);
        imageViewerDialog.tbCentre.getAction().actionPerformed(new ActionEvent(imageViewerDialog.tbCentre, 0, null));
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(GeoImageLayer geoImageLayer, ImageEntry imageEntry) {
        boolean bl;
        Serializable serializable = this;
        synchronized (serializable) {
            boolean bl2 = bl = this.currentEntry != imageEntry;
            if (this.centerView && Main.isDisplayingMapView() && imageEntry != null && imageEntry.getPos() != null) {
                Main.map.mapView.zoomTo(imageEntry.getPos());
            }
            this.currentLayer = geoImageLayer;
            this.currentEntry = imageEntry;
        }
        if (imageEntry != null) {
            if (bl) {
                this.imgDisplay.setImage(imageEntry.getFile(), imageEntry.getExifOrientation());
            }
            this.setTitle(I18n.tr("Geotagged Images", new Object[0]) + (imageEntry.getFile() != null ? " - " + imageEntry.getFile().getName() : ""));
            serializable = new StringBuilder(imageEntry.getFile() != null ? imageEntry.getFile().getName() : "");
            if (imageEntry.getElevation() != null) {
                ((StringBuilder)serializable).append(I18n.tr("\nAltitude: {0} m", Math.round(imageEntry.getElevation())));
            }
            if (imageEntry.getSpeed() != null) {
                ((StringBuilder)serializable).append(I18n.tr("\nSpeed: {0} km/h", Math.round(imageEntry.getSpeed())));
            }
            if (imageEntry.getExifImgDir() != null) {
                ((StringBuilder)serializable).append(I18n.tr("\nDirection {0}\u00b0", Math.round(imageEntry.getExifImgDir())));
            }
            DateFormat dateFormat = DateUtils.getDateTimeFormat(3, 2);
            if (imageEntry.hasExifTime()) {
                ((StringBuilder)serializable).append(I18n.tr("\nEXIF time: {0}", dateFormat.format(imageEntry.getExifTime())));
            }
            if (imageEntry.hasGpsTime()) {
                ((StringBuilder)serializable).append(I18n.tr("\nGPS time: {0}", dateFormat.format(imageEntry.getGpsTime())));
            }
        } else {
            this.setTitle(I18n.tr("Geotagged Images", new Object[0]));
            this.imgDisplay.setImage(null, null);
            this.imgDisplay.setOsdText("");
            return;
        }
        this.imgDisplay.setOsdText(((StringBuilder)serializable).toString());
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    @Override
    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return true;
        }
        return false;
    }

    @Override
    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    public static ImageEntry getCurrentImage() {
        return ImageViewerDialog.getInstance().currentEntry;
    }

    public static GeoImageLayer getCurrentLayer() {
        return ImageViewerDialog.getInstance().currentLayer;
    }

    public static boolean isCenterView() {
        return ImageViewerDialog.getInstance().centerView;
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (this.currentLayer == null && layer2 instanceof GeoImageLayer) {
            ((GeoImageLayer)layer2).showFirstPhoto();
        }
    }

    @Override
    public void layerAdded(Layer layer) {
        if (this.currentLayer == null && layer instanceof GeoImageLayer) {
            ((GeoImageLayer)layer).showFirstPhoto();
        }
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (this.currentLayer != null && this.currentLayer.equals(layer)) {
            ImageViewerDialog.showImage(null, null);
        }
        if (this.currentLayer != null && layer instanceof GeoImageLayer) {
            this.currentLayer.checkPreviousNextButtons();
        }
    }

    class ImageAction
    extends AbstractAction {
        private final String action;

        ImageAction(String string, ImageIcon imageIcon, String string2) {
            this.action = string;
            this.putValue("ShortDescription", string2);
            this.putValue("SmallIcon", imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageViewerDialog.COMMAND_NEXT.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showNextPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_PREVIOUS.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showPreviousPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_FIRST.equals(this.action) && ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showFirstPhoto();
            } else if (ImageViewerDialog.COMMAND_LAST.equals(this.action) && ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showLastPhoto();
            } else if (ImageViewerDialog.COMMAND_CENTERVIEW.equals(this.action)) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                ImageViewerDialog.this.centerView = jToggleButton.isEnabled() && jToggleButton.isSelected();
                if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                    Main.map.mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
                }
            } else if (ImageViewerDialog.COMMAND_ZOOM.equals(this.action)) {
                ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
            } else if (ImageViewerDialog.COMMAND_REMOVE.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_REMOVE_FROM_DISK.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhotoFromDisk();
                }
            } else if (ImageViewerDialog.COMMAND_COPY_PATH.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.copyCurrentPhotoPath();
                }
            } else if (ImageViewerDialog.COMMAND_COLLAPSE.equals(this.action)) {
                ImageViewerDialog.this.collapseButtonClicked = true;
                ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
            }
        }
    }
}

