/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrefEntry
implements Comparable<PrefEntry> {
    private final String key;
    private Setting<?> value;
    private final Setting<?> defaultValue;
    private boolean isDefault;
    private boolean changed;

    public PrefEntry(String string, Setting<?> setting, Setting<?> setting2, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(string);
        CheckParameterUtil.ensureParameterNotNull(setting);
        CheckParameterUtil.ensureParameterNotNull(setting2);
        this.key = string;
        this.value = setting;
        this.defaultValue = setting2;
        this.isDefault = bl;
    }

    public String getKey() {
        return this.key;
    }

    public Setting<?> getValue() {
        return this.value;
    }

    public Setting<?> getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Setting<?> setting) {
        this.value = setting;
        this.changed = true;
        this.isDefault = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void markAsChanged() {
        this.changed = true;
    }

    public void reset() {
        this.value = this.defaultValue;
        this.changed = true;
        this.isDefault = true;
    }

    @Override
    public int compareTo(PrefEntry prefEntry) {
        return this.key.compareTo(prefEntry.key);
    }

    public int hashCode() {
        return 31 + (this.key == null ? 0 : this.key.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrefEntry prefEntry = (PrefEntry)object;
        return !(this.key == null ? prefEntry.key != null : !this.key.equals(prefEntry.key));
    }

    public String toString() {
        return this.value.toString();
    }
}

