/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorTestsPreference
implements SubPreferenceSetting {
    private JCheckBox prefUseIgnore;
    private JCheckBox prefUseLayer;
    private JCheckBox prefOtherUpload;
    private JCheckBox prefOther;
    private Collection<Test> allTests;

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        VerticallyScrollablePanel verticallyScrollablePanel = new VerticallyScrollablePanel(new GridBagLayout());
        verticallyScrollablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.prefUseIgnore = new JCheckBox(I18n.tr("Use ignore list.", new Object[0]), Main.pref.getBoolean("validator.ignore", true));
        this.prefUseIgnore.setToolTipText(I18n.tr("Use the ignore list to suppress warnings.", new Object[0]));
        verticallyScrollablePanel.add((Component)this.prefUseIgnore, GBC.eol());
        this.prefUseLayer = new JCheckBox(I18n.tr("Use error layer.", new Object[0]), Main.pref.getBoolean("validator.layer", true));
        this.prefUseLayer.setToolTipText(I18n.tr("Use the error layer to display problematic elements.", new Object[0]));
        verticallyScrollablePanel.add((Component)this.prefUseLayer, GBC.eol());
        this.prefOther = new JCheckBox(I18n.tr("Show informational level.", new Object[0]), (boolean)ValidatorPreference.PREF_OTHER.get());
        this.prefOther.setToolTipText(I18n.tr("Show the informational tests.", new Object[0]));
        verticallyScrollablePanel.add((Component)this.prefOther, GBC.eol());
        this.prefOtherUpload = new JCheckBox(I18n.tr("Show informational level on upload.", new Object[0]), Main.pref.getBoolean("validator.otherUpload", false));
        this.prefOtherUpload.setToolTipText(I18n.tr("Show the informational tests in the upload check windows.", new Object[0]));
        verticallyScrollablePanel.add((Component)this.prefOtherUpload, GBC.eol());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorTestsPreference.this.prefOtherUpload.setEnabled(ValidatorTestsPreference.this.prefOther.isSelected());
            }
        };
        this.prefOther.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        GBC gBC = GBC.eol().insets(-5, 0, 0, 0);
        gBC.anchor = 13;
        verticallyScrollablePanel.add((Component)new JLabel(I18n.tr("On demand", new Object[0])), GBC.std());
        verticallyScrollablePanel.add((Component)new JLabel(I18n.tr("On upload", new Object[0])), gBC);
        this.allTests = OsmValidator.getTests();
        for (Test test : this.allTests) {
            test.addGui(verticallyScrollablePanel);
        }
        preferenceTabbedPane.getValidatorPreference().addSubTab(this, I18n.tr("Tests", new Object[0]), GuiHelper.embedInVerticalScrollPane(verticallyScrollablePanel), I18n.tr("Choose tests to enable", new Object[0]));
    }

    @Override
    public boolean ok() {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (Test test : this.allTests) {
            test.ok();
            String string = test.getClass().getName();
            if (!test.enabled) {
                linkedList.add(string);
            }
            if (test.testBeforeUpload) continue;
            linkedList2.add(string);
        }
        ArrayList<Test> arrayList = new ArrayList<Test>(this.allTests);
        arrayList.remove(OsmValidator.getTest(MapCSSTagChecker.class));
        OsmValidator.initializeTests((Collection<? extends Test>)arrayList);
        Main.pref.putCollection("validator.skip", linkedList);
        Main.pref.putCollection("validator.skipBeforeUpload", linkedList2);
        Main.pref.put("validator.ignore", this.prefUseIgnore.isSelected());
        ValidatorPreference.PREF_OTHER.put(this.prefOther.isSelected());
        Main.pref.put("validator.otherUpload", this.prefOtherUpload.isSelected());
        Main.pref.put("validator.layer", this.prefUseLayer.isSelected());
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getValidatorPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ValidatorTestsPreference();
        }
    }
}

