/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.widgets.JosmTextField;

public abstract class SearchTextResultListPanel<T>
extends JPanel {
    protected final JosmTextField edSearchText;
    protected final JList<T> lsResult;
    protected final ResultListModel<T> lsResultModel = new ResultListModel();
    protected final transient List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    private transient ActionListener dblClickListener;
    private transient ActionListener clickListener;

    protected abstract void filterItems();

    public SearchTextResultListPanel() {
        super(new BorderLayout());
        this.edSearchText = new JosmTextField();
        this.edSearchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SearchTextResultListPanel.this.filterItems();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SearchTextResultListPanel.this.filterItems();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SearchTextResultListPanel.this.filterItems();
            }
        });
        this.edSearchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() + 1);
                        break;
                    }
                    case 38: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() - 1);
                        break;
                    }
                    case 34: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() + 10);
                        break;
                    }
                    case 33: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() - 10);
                        break;
                    }
                    case 36: {
                        SearchTextResultListPanel.this.selectItem(0);
                        break;
                    }
                    case 35: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResultModel.getSize());
                        break;
                    }
                }
            }
        });
        this.add((Component)this.edSearchText, "North");
        this.lsResult = new JList<T>(this.lsResultModel);
        this.lsResult.setSelectionMode(0);
        this.lsResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    if (SearchTextResultListPanel.this.dblClickListener != null) {
                        SearchTextResultListPanel.this.dblClickListener.actionPerformed(null);
                    }
                } else if (SearchTextResultListPanel.this.clickListener != null) {
                    SearchTextResultListPanel.this.clickListener.actionPerformed(null);
                }
            }
        });
        this.add((Component)new JScrollPane(this.lsResult), "Center");
    }

    public synchronized void init() {
        this.listSelectionListeners.clear();
        this.edSearchText.setText("");
        this.filterItems();
    }

    private synchronized void selectItem(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.lsResultModel.getSize() - 1) {
            n = this.lsResultModel.getSize() - 1;
        }
        this.lsResult.setSelectedIndex(n);
        this.lsResult.ensureIndexIsVisible(n);
    }

    public synchronized void clearSelection() {
        this.lsResult.clearSelection();
    }

    public synchronized int getItemCount() {
        return this.lsResultModel.getSize();
    }

    public void setDblClickListener(ActionListener actionListener) {
        this.dblClickListener = actionListener;
    }

    public void setClickListener(ActionListener actionListener) {
        this.clickListener = actionListener;
    }

    public synchronized void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.lsResult.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.listSelectionListeners.add(listSelectionListener);
    }

    public synchronized void removeSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListeners.remove(listSelectionListener);
        this.lsResult.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    protected static class ResultListModel<T>
    extends AbstractListModel<T> {
        private transient List<T> items = new ArrayList<T>();

        protected ResultListModel() {
        }

        public synchronized void setItems(List<T> list) {
            this.items = list;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        @Override
        public synchronized T getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public synchronized int getSize() {
            return this.items.size();
        }

        public synchronized boolean isEmpty() {
            return this.items.isEmpty();
        }
    }
}

