/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.Reader;
import org.openstreetmap.josm.Main;

public class InvalidXmlCharacterFilter
extends Reader {
    private final Reader reader;
    private static boolean firstWarning = true;
    private static final boolean[] INVALID_CHARS = new boolean[32];

    public InvalidXmlCharacterFilter(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.reader.read(cArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        for (int i = n; i < n + n3; ++i) {
            cArray[i] = InvalidXmlCharacterFilter.filter(cArray[i]);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static char filter(char c) {
        if (c < ' ' && INVALID_CHARS[c]) {
            if (firstWarning) {
                Main.warn("Invalid xml character encountered: '" + c + "'.");
                firstWarning = false;
            }
            return ' ';
        }
        return c;
    }

    static {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            InvalidXmlCharacterFilter.INVALID_CHARS[i] = true;
        }
        InvalidXmlCharacterFilter.INVALID_CHARS[9] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[10] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[13] = false;
    }
}

