/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("osm,xml", "osm", I18n.tr("OSM Server Files", new Object[0]) + " (*.osm, *.osm.gz, *.osm.bz2, *.osm.zip, *.xml)", ExtensionFileFilter.AddArchiveExtension.NONE, Arrays.asList("gz", "bz", "bz2", "zip"));

    public OsmImporter() {
        super(FILE_FILTER);
    }

    public OsmImporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try (InputStream inputStream = Compression.getUncompressedFileInputStream(file);){
            this.importData(inputStream, file, progressMonitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.error(fileNotFoundException);
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()), fileNotFoundException);
        }
    }

    protected void importData(InputStream inputStream, File file, ProgressMonitor progressMonitor) throws IllegalDataException {
        final OsmImporterData osmImporterData = this.loadLayer(inputStream, file, file == null ? OsmDataLayer.createNewName() : file.getName(), progressMonitor);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                OsmDataLayer osmDataLayer = osmImporterData.getLayer();
                BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                boundingXYVisitor.visit(osmDataLayer.data.getDataSourceBoundingBox());
                if (!boundingXYVisitor.hasExtend()) {
                    boundingXYVisitor.computeBoundingBox(osmDataLayer.data.getNodes());
                }
                Main.main.addLayer((Layer)osmDataLayer, boundingXYVisitor.getBounds());
                osmImporterData.getPostLayerTask().run();
                osmImporterData.getLayer().onPostLoadFromFile();
            }
        });
    }

    public OsmImporterData loadLayer(InputStream inputStream, File file, String string, ProgressMonitor progressMonitor) throws IllegalDataException {
        DataSet dataSet = this.parseDataSet(inputStream, progressMonitor);
        if (dataSet == null) {
            throw new IllegalDataException(I18n.tr("Invalid dataset", new Object[0]));
        }
        OsmDataLayer osmDataLayer = this.createLayer(dataSet, file, string);
        Runnable runnable = this.createPostLayerTask(dataSet, file, string, osmDataLayer);
        return new OsmImporterData(osmDataLayer, runnable);
    }

    protected DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        return OsmReader.parseDataSet(inputStream, progressMonitor);
    }

    protected OsmDataLayer createLayer(DataSet dataSet, File file, String string) {
        return new OsmDataLayer(dataSet, string, file);
    }

    protected Runnable createPostLayerTask(final DataSet dataSet, final File file, final String string, final OsmDataLayer osmDataLayer) {
        return new Runnable(){

            @Override
            public void run() {
                if (dataSet.allPrimitives().isEmpty()) {
                    String string2 = file == null ? I18n.tr("No data found for layer ''{0}''.", string) : I18n.tr("No data found in file ''{0}''.", file.getPath());
                    JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Open OSM file", new Object[0]), 1);
                }
                osmDataLayer.onPostLoadFromFile();
            }
        };
    }

    public static class OsmImporterData {
        private final OsmDataLayer layer;
        private final Runnable postLayerTask;

        public OsmImporterData(OsmDataLayer osmDataLayer, Runnable runnable) {
            this.layer = osmDataLayer;
            this.postLayerTask = runnable;
        }

        public OsmDataLayer getLayer() {
            return this.layer;
        }

        public Runnable getPostLayerTask() {
            return this.postLayerTask;
        }
    }
}

