/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeInterface;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class NodeClassImpl
extends NodeClass {
    private static final NodeFieldAccessor[] EMPTY_NODE_FIELD_ARRAY = new NodeFieldAccessor[0];
    private final NodeFieldAccessor[] fields;
    private final NodeFieldAccessor parentField;
    private final NodeFieldAccessor nodeClassField;
    private final NodeFieldAccessor[] childFields;
    private final NodeFieldAccessor[] childrenFields;
    private final NodeFieldAccessor[] cloneableFields;
    private final Class<? extends Node> clazz;

    NodeClassImpl(Class<? extends Node> clazz) {
        super(clazz);
        if (!Node.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        ArrayList<NodeFieldAccessor> fieldsList = new ArrayList<NodeFieldAccessor>();
        NodeFieldAccessor parentFieldTmp = null;
        NodeFieldAccessor nodeClassFieldTmp = null;
        ArrayList<NodeFieldAccessor> childFieldList = new ArrayList<NodeFieldAccessor>();
        ArrayList<NodeFieldAccessor> childrenFieldList = new ArrayList<NodeFieldAccessor>();
        ArrayList<NodeFieldAccessor> cloneableFieldList = new ArrayList<NodeFieldAccessor>();
        try {
            Field field = Node.class.getDeclaredField("parent");
            assert (Node.class.isAssignableFrom(field.getType()));
            parentFieldTmp = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.PARENT, field);
            field = Node.class.getDeclaredField("nodeClass");
            assert (NodeClass.class.isAssignableFrom(field.getType()));
            nodeClassFieldTmp = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.NODE_CLASS, field);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError("Node field not found", e);
        }
        NodeClassImpl.collectInstanceFields(clazz, fieldsList, childFieldList, childrenFieldList, cloneableFieldList);
        this.fields = fieldsList.toArray(EMPTY_NODE_FIELD_ARRAY);
        this.nodeClassField = nodeClassFieldTmp;
        this.parentField = parentFieldTmp;
        this.childFields = childFieldList.toArray(EMPTY_NODE_FIELD_ARRAY);
        this.childrenFields = childrenFieldList.toArray(EMPTY_NODE_FIELD_ARRAY);
        this.cloneableFields = cloneableFieldList.toArray(EMPTY_NODE_FIELD_ARRAY);
        this.clazz = clazz;
    }

    private static void collectInstanceFields(Class<? extends Object> clazz, List<NodeFieldAccessor> fieldsList, List<NodeFieldAccessor> childFieldList, List<NodeFieldAccessor> childrenFieldList, List<NodeFieldAccessor> cloneableFieldList) {
        Field[] declaredFields;
        if (clazz.getSuperclass() != null) {
            NodeClassImpl.collectInstanceFields(clazz.getSuperclass(), fieldsList, childFieldList, childrenFieldList, cloneableFieldList);
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            NodeFieldAccessor nodeField;
            if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || field.getDeclaringClass() == Node.class && (field.getName().equals("parent") || field.getName().equals("nodeClass"))) continue;
            if (field.getAnnotation(Node.Child.class) != null) {
                NodeClassImpl.checkChildField(field);
                nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.CHILD, field);
                childFieldList.add(nodeField);
            } else if (field.getAnnotation(Node.Children.class) != null) {
                NodeClassImpl.checkChildrenField(field);
                nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.CHILDREN, field);
                childrenFieldList.add(nodeField);
            } else {
                nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.DATA, field);
                if (NodeCloneable.class.isAssignableFrom(field.getType())) {
                    cloneableFieldList.add(nodeField);
                }
            }
            fieldsList.add(nodeField);
        }
    }

    @Override
    public NodeFieldAccessor getNodeClassField() {
        return this.nodeClassField;
    }

    @Override
    public NodeFieldAccessor[] getCloneableFields() {
        return this.cloneableFields;
    }

    private static boolean isNodeType(Class<?> clazz) {
        return Node.class.isAssignableFrom(clazz) || clazz.isInterface() && NodeInterface.class.isAssignableFrom(clazz);
    }

    private static void checkChildField(Field field) {
        if (!NodeClassImpl.isNodeType(field.getType())) {
            throw new AssertionError((Object)("@Child field type must be a subclass of Node or an interface extending NodeInterface (" + field + ")"));
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new AssertionError((Object)("@Child field must not be final (" + field + ")"));
        }
    }

    private static void checkChildrenField(Field field) {
        if (!field.getType().isArray() || !NodeClassImpl.isNodeType(field.getType().getComponentType())) {
            throw new AssertionError((Object)("@Children field type must be an array of a subclass of Node or an interface extending NodeInterface (" + field + ")"));
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            throw new AssertionError((Object)("@Children field must be final (" + field + ")"));
        }
    }

    @Override
    public NodeFieldAccessor[] getFields() {
        return this.fields;
    }

    @Override
    public NodeFieldAccessor getParentField() {
        return this.parentField;
    }

    @Override
    public NodeFieldAccessor[] getChildFields() {
        return this.childFields;
    }

    @Override
    public NodeFieldAccessor[] getChildrenFields() {
        return this.childrenFields;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeClassImpl) {
            NodeClassImpl other = (NodeClassImpl)obj;
            return this.clazz.equals(other.clazz);
        }
        return false;
    }

    @Override
    public Iterator<Node> makeIterator(Node node) {
        assert (this.clazz.isInstance(node));
        return new NodeIterator(this, node);
    }

    @Override
    public Class<? extends Node> getType() {
        return this.clazz;
    }

    private static final class NodeIterator
    implements Iterator<Node> {
        private final NodeFieldAccessor[] childFields;
        private final NodeFieldAccessor[] childrenFields;
        private final Node node;
        private final int childrenCount;
        private int index;

        protected NodeIterator(NodeClassImpl nodeClass, Node node) {
            this.childFields = nodeClass.getChildFields();
            this.childrenFields = nodeClass.getChildrenFields();
            this.node = node;
            this.childrenCount = this.childrenCount();
            this.index = 0;
        }

        private int childrenCount() {
            int nodeCount = this.childFields.length;
            for (NodeFieldAccessor childrenField : this.childrenFields) {
                Object[] children = (Object[])childrenField.getObject(this.node);
                if (children == null) continue;
                nodeCount += children.length;
            }
            return nodeCount;
        }

        private Node nodeAt(int idx) {
            int nodeCount = this.childFields.length;
            if (idx < nodeCount) {
                return (Node)this.childFields[idx].getObject(this.node);
            }
            for (NodeFieldAccessor childrenField : this.childrenFields) {
                Object[] nodeArray = (Object[])childrenField.getObject(this.node);
                if (idx < nodeCount + nodeArray.length) {
                    return (Node)nodeArray[idx - nodeCount];
                }
                nodeCount += nodeArray.length;
            }
            return null;
        }

        private void forward() {
            if (this.index < this.childrenCount) {
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.childrenCount;
        }

        @Override
        public Node next() {
            try {
                Node node = this.nodeAt(this.index);
                return node;
            }
            finally {
                this.forward();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

