/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class BranchProfile
extends Profile {
    BranchProfile() {
    }

    public abstract void enter();

    @Deprecated
    public abstract boolean isVisited();

    public static BranchProfile create() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create0();
        }
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends BranchProfile {
        static final BranchProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean isVisited() {
            return true;
        }

        public String toString() {
            return this.toStringDisabled(BranchProfile.class);
        }
    }

    static final class Enabled
    extends BranchProfile {
        @CompilerDirectives.CompilationFinal
        private boolean visited;

        Enabled() {
        }

        @Override
        public void enter() {
            if (!this.visited) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.visited = true;
            }
        }

        @Override
        public boolean isVisited() {
            return this.visited;
        }

        public String toString() {
            return this.toString(BranchProfile.class, !this.visited, false, "VISITED");
        }

        static BranchProfile create0() {
            return new Enabled();
        }
    }
}

