/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.maven.wagon.providers.http.commons.logging.Log;
import org.apache.maven.wagon.providers.http.commons.logging.LogFactory;
import org.apache.maven.wagon.providers.http.httpclient.ConnectionReuseStrategy;
import org.apache.maven.wagon.providers.http.httpclient.HttpException;
import org.apache.maven.wagon.providers.http.httpclient.HttpHost;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequest;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequestInterceptor;
import org.apache.maven.wagon.providers.http.httpclient.HttpResponseInterceptor;
import org.apache.maven.wagon.providers.http.httpclient.annotation.GuardedBy;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadSafe;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthSchemeRegistry;
import org.apache.maven.wagon.providers.http.httpclient.client.AuthenticationHandler;
import org.apache.maven.wagon.providers.http.httpclient.client.AuthenticationStrategy;
import org.apache.maven.wagon.providers.http.httpclient.client.BackoffManager;
import org.apache.maven.wagon.providers.http.httpclient.client.ClientProtocolException;
import org.apache.maven.wagon.providers.http.httpclient.client.ConnectionBackoffStrategy;
import org.apache.maven.wagon.providers.http.httpclient.client.CookieStore;
import org.apache.maven.wagon.providers.http.httpclient.client.CredentialsProvider;
import org.apache.maven.wagon.providers.http.httpclient.client.HttpRequestRetryHandler;
import org.apache.maven.wagon.providers.http.httpclient.client.RedirectHandler;
import org.apache.maven.wagon.providers.http.httpclient.client.RedirectStrategy;
import org.apache.maven.wagon.providers.http.httpclient.client.RequestDirector;
import org.apache.maven.wagon.providers.http.httpclient.client.UserTokenHandler;
import org.apache.maven.wagon.providers.http.httpclient.client.config.RequestConfig;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.CloseableHttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.client.params.HttpClientParamConfig;
import org.apache.maven.wagon.providers.http.httpclient.conn.ClientConnectionManager;
import org.apache.maven.wagon.providers.http.httpclient.conn.ClientConnectionManagerFactory;
import org.apache.maven.wagon.providers.http.httpclient.conn.ConnectionKeepAliveStrategy;
import org.apache.maven.wagon.providers.http.httpclient.conn.routing.HttpRoute;
import org.apache.maven.wagon.providers.http.httpclient.conn.routing.HttpRoutePlanner;
import org.apache.maven.wagon.providers.http.httpclient.conn.scheme.SchemeRegistry;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieSpecRegistry;
import org.apache.maven.wagon.providers.http.httpclient.impl.DefaultConnectionReuseStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.BasicSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.DigestSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.KerberosSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.NTLMSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.SPNegoSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.AuthenticationStrategyAdaptor;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.BasicCookieStore;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.BasicCredentialsProvider;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.ClientParamsStack;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.CloseableHttpClient;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.CloseableHttpResponseProxy;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultProxyAuthenticationHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultRedirectHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultRedirectStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultRedirectStrategyAdaptor;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultRequestDirector;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultTargetAuthenticationHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.DefaultUserTokenHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.ProxyAuthenticationStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.TargetAuthenticationStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.conn.BasicClientConnectionManager;
import org.apache.maven.wagon.providers.http.httpclient.impl.conn.DefaultHttpRoutePlanner;
import org.apache.maven.wagon.providers.http.httpclient.impl.conn.SchemeRegistryFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BestMatchSpecFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BrowserCompatSpecFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.IgnoreSpecFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.RFC2109SpecFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.RFC2965SpecFactory;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpParams;
import org.apache.maven.wagon.providers.http.httpclient.protocol.BasicHttpContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.BasicHttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.DefaultedHttpContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpRequestExecutor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.ImmutableHttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@ThreadSafe
public abstract class AbstractHttpClient
extends CloseableHttpClient {
    private final Log log = LogFactory.getLog(this.getClass());
    @GuardedBy(value="this")
    private HttpParams defaultParams;
    @GuardedBy(value="this")
    private HttpRequestExecutor requestExec;
    @GuardedBy(value="this")
    private ClientConnectionManager connManager;
    @GuardedBy(value="this")
    private ConnectionReuseStrategy reuseStrategy;
    @GuardedBy(value="this")
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    @GuardedBy(value="this")
    private CookieSpecRegistry supportedCookieSpecs;
    @GuardedBy(value="this")
    private AuthSchemeRegistry supportedAuthSchemes;
    @GuardedBy(value="this")
    private BasicHttpProcessor mutableProcessor;
    @GuardedBy(value="this")
    private ImmutableHttpProcessor protocolProcessor;
    @GuardedBy(value="this")
    private HttpRequestRetryHandler retryHandler;
    @GuardedBy(value="this")
    private RedirectStrategy redirectStrategy;
    @GuardedBy(value="this")
    private AuthenticationStrategy targetAuthStrategy;
    @GuardedBy(value="this")
    private AuthenticationStrategy proxyAuthStrategy;
    @GuardedBy(value="this")
    private CookieStore cookieStore;
    @GuardedBy(value="this")
    private CredentialsProvider credsProvider;
    @GuardedBy(value="this")
    private HttpRoutePlanner routePlanner;
    @GuardedBy(value="this")
    private UserTokenHandler userTokenHandler;
    @GuardedBy(value="this")
    private ConnectionBackoffStrategy connectionBackoffStrategy;
    @GuardedBy(value="this")
    private BackoffManager backoffManager;

    protected AbstractHttpClient(ClientConnectionManager conman, HttpParams params) {
        this.defaultParams = params;
        this.connManager = conman;
    }

    protected abstract HttpParams createHttpParams();

    protected abstract BasicHttpProcessor createHttpProcessor();

    protected HttpContext createHttpContext() {
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.scheme-registry", this.getConnectionManager().getSchemeRegistry());
        context.setAttribute("http.authscheme-registry", this.getAuthSchemes());
        context.setAttribute("http.cookiespec-registry", this.getCookieSpecs());
        context.setAttribute("http.cookie-store", this.getCookieStore());
        context.setAttribute("http.auth.credentials-provider", this.getCredentialsProvider());
        return context;
    }

    protected ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry registry = SchemeRegistryFactory.createDefault();
        ClientConnectionManager connManager = null;
        HttpParams params = this.getParams();
        ClientConnectionManagerFactory factory = null;
        String className = (String)params.getParameter("http.connection-manager.factory-class-name");
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                factory = (ClientConnectionManagerFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Invalid class name: " + className);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessError(ex.getMessage());
            }
            catch (InstantiationException ex) {
                throw new InstantiationError(ex.getMessage());
            }
        }
        connManager = factory != null ? factory.newInstance(params, registry) : new BasicClientConnectionManager(registry);
        return connManager;
    }

    protected AuthSchemeRegistry createAuthSchemeRegistry() {
        AuthSchemeRegistry registry = new AuthSchemeRegistry();
        registry.register("Basic", new BasicSchemeFactory());
        registry.register("Digest", new DigestSchemeFactory());
        registry.register("NTLM", new NTLMSchemeFactory());
        registry.register("negotiate", new SPNegoSchemeFactory());
        registry.register("Kerberos", new KerberosSchemeFactory());
        return registry;
    }

    protected CookieSpecRegistry createCookieSpecRegistry() {
        CookieSpecRegistry registry = new CookieSpecRegistry();
        registry.register("best-match", new BestMatchSpecFactory());
        registry.register("compatibility", new BrowserCompatSpecFactory());
        registry.register("netscape", new NetscapeDraftSpecFactory());
        registry.register("rfc2109", new RFC2109SpecFactory());
        registry.register("rfc2965", new RFC2965SpecFactory());
        registry.register("ignoreCookies", new IgnoreSpecFactory());
        return registry;
    }

    protected HttpRequestExecutor createRequestExecutor() {
        return new HttpRequestExecutor();
    }

    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy();
    }

    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler();
    }

    @Deprecated
    protected RedirectHandler createRedirectHandler() {
        return new DefaultRedirectHandler();
    }

    protected AuthenticationStrategy createTargetAuthenticationStrategy() {
        return new TargetAuthenticationStrategy();
    }

    @Deprecated
    protected AuthenticationHandler createTargetAuthenticationHandler() {
        return new DefaultTargetAuthenticationHandler();
    }

    protected AuthenticationStrategy createProxyAuthenticationStrategy() {
        return new ProxyAuthenticationStrategy();
    }

    @Deprecated
    protected AuthenticationHandler createProxyAuthenticationHandler() {
        return new DefaultProxyAuthenticationHandler();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    protected CredentialsProvider createCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new DefaultHttpRoutePlanner(this.getConnectionManager().getSchemeRegistry());
    }

    protected UserTokenHandler createUserTokenHandler() {
        return new DefaultUserTokenHandler();
    }

    @Override
    public final synchronized HttpParams getParams() {
        if (this.defaultParams == null) {
            this.defaultParams = this.createHttpParams();
        }
        return this.defaultParams;
    }

    public synchronized void setParams(HttpParams params) {
        this.defaultParams = params;
    }

    @Override
    public final synchronized ClientConnectionManager getConnectionManager() {
        if (this.connManager == null) {
            this.connManager = this.createClientConnectionManager();
        }
        return this.connManager;
    }

    public final synchronized HttpRequestExecutor getRequestExecutor() {
        if (this.requestExec == null) {
            this.requestExec = this.createRequestExecutor();
        }
        return this.requestExec;
    }

    public final synchronized AuthSchemeRegistry getAuthSchemes() {
        if (this.supportedAuthSchemes == null) {
            this.supportedAuthSchemes = this.createAuthSchemeRegistry();
        }
        return this.supportedAuthSchemes;
    }

    public synchronized void setAuthSchemes(AuthSchemeRegistry registry) {
        this.supportedAuthSchemes = registry;
    }

    public final synchronized ConnectionBackoffStrategy getConnectionBackoffStrategy() {
        return this.connectionBackoffStrategy;
    }

    public synchronized void setConnectionBackoffStrategy(ConnectionBackoffStrategy strategy) {
        this.connectionBackoffStrategy = strategy;
    }

    public final synchronized CookieSpecRegistry getCookieSpecs() {
        if (this.supportedCookieSpecs == null) {
            this.supportedCookieSpecs = this.createCookieSpecRegistry();
        }
        return this.supportedCookieSpecs;
    }

    public final synchronized BackoffManager getBackoffManager() {
        return this.backoffManager;
    }

    public synchronized void setBackoffManager(BackoffManager manager) {
        this.backoffManager = manager;
    }

    public synchronized void setCookieSpecs(CookieSpecRegistry registry) {
        this.supportedCookieSpecs = registry;
    }

    public final synchronized ConnectionReuseStrategy getConnectionReuseStrategy() {
        if (this.reuseStrategy == null) {
            this.reuseStrategy = this.createConnectionReuseStrategy();
        }
        return this.reuseStrategy;
    }

    public synchronized void setReuseStrategy(ConnectionReuseStrategy strategy) {
        this.reuseStrategy = strategy;
    }

    public final synchronized ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        if (this.keepAliveStrategy == null) {
            this.keepAliveStrategy = this.createConnectionKeepAliveStrategy();
        }
        return this.keepAliveStrategy;
    }

    public synchronized void setKeepAliveStrategy(ConnectionKeepAliveStrategy strategy) {
        this.keepAliveStrategy = strategy;
    }

    public final synchronized HttpRequestRetryHandler getHttpRequestRetryHandler() {
        if (this.retryHandler == null) {
            this.retryHandler = this.createHttpRequestRetryHandler();
        }
        return this.retryHandler;
    }

    public synchronized void setHttpRequestRetryHandler(HttpRequestRetryHandler handler) {
        this.retryHandler = handler;
    }

    @Deprecated
    public final synchronized RedirectHandler getRedirectHandler() {
        return this.createRedirectHandler();
    }

    @Deprecated
    public synchronized void setRedirectHandler(RedirectHandler handler) {
        this.redirectStrategy = new DefaultRedirectStrategyAdaptor(handler);
    }

    public final synchronized RedirectStrategy getRedirectStrategy() {
        if (this.redirectStrategy == null) {
            this.redirectStrategy = new DefaultRedirectStrategy();
        }
        return this.redirectStrategy;
    }

    public synchronized void setRedirectStrategy(RedirectStrategy strategy) {
        this.redirectStrategy = strategy;
    }

    @Deprecated
    public final synchronized AuthenticationHandler getTargetAuthenticationHandler() {
        return this.createTargetAuthenticationHandler();
    }

    @Deprecated
    public synchronized void setTargetAuthenticationHandler(AuthenticationHandler handler) {
        this.targetAuthStrategy = new AuthenticationStrategyAdaptor(handler);
    }

    public final synchronized AuthenticationStrategy getTargetAuthenticationStrategy() {
        if (this.targetAuthStrategy == null) {
            this.targetAuthStrategy = this.createTargetAuthenticationStrategy();
        }
        return this.targetAuthStrategy;
    }

    public synchronized void setTargetAuthenticationStrategy(AuthenticationStrategy strategy) {
        this.targetAuthStrategy = strategy;
    }

    @Deprecated
    public final synchronized AuthenticationHandler getProxyAuthenticationHandler() {
        return this.createProxyAuthenticationHandler();
    }

    @Deprecated
    public synchronized void setProxyAuthenticationHandler(AuthenticationHandler handler) {
        this.proxyAuthStrategy = new AuthenticationStrategyAdaptor(handler);
    }

    public final synchronized AuthenticationStrategy getProxyAuthenticationStrategy() {
        if (this.proxyAuthStrategy == null) {
            this.proxyAuthStrategy = this.createProxyAuthenticationStrategy();
        }
        return this.proxyAuthStrategy;
    }

    public synchronized void setProxyAuthenticationStrategy(AuthenticationStrategy strategy) {
        this.proxyAuthStrategy = strategy;
    }

    public final synchronized CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = this.createCookieStore();
        }
        return this.cookieStore;
    }

    public synchronized void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public final synchronized CredentialsProvider getCredentialsProvider() {
        if (this.credsProvider == null) {
            this.credsProvider = this.createCredentialsProvider();
        }
        return this.credsProvider;
    }

    public synchronized void setCredentialsProvider(CredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    public final synchronized HttpRoutePlanner getRoutePlanner() {
        if (this.routePlanner == null) {
            this.routePlanner = this.createHttpRoutePlanner();
        }
        return this.routePlanner;
    }

    public synchronized void setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    public final synchronized UserTokenHandler getUserTokenHandler() {
        if (this.userTokenHandler == null) {
            this.userTokenHandler = this.createUserTokenHandler();
        }
        return this.userTokenHandler;
    }

    public synchronized void setUserTokenHandler(UserTokenHandler handler) {
        this.userTokenHandler = handler;
    }

    protected final synchronized BasicHttpProcessor getHttpProcessor() {
        if (this.mutableProcessor == null) {
            this.mutableProcessor = this.createHttpProcessor();
        }
        return this.mutableProcessor;
    }

    private synchronized HttpProcessor getProtocolProcessor() {
        if (this.protocolProcessor == null) {
            BasicHttpProcessor proc = this.getHttpProcessor();
            int reqc = proc.getRequestInterceptorCount();
            HttpRequestInterceptor[] reqinterceptors = new HttpRequestInterceptor[reqc];
            for (int i = 0; i < reqc; ++i) {
                reqinterceptors[i] = proc.getRequestInterceptor(i);
            }
            int resc = proc.getResponseInterceptorCount();
            HttpResponseInterceptor[] resinterceptors = new HttpResponseInterceptor[resc];
            for (int i = 0; i < resc; ++i) {
                resinterceptors[i] = proc.getResponseInterceptor(i);
            }
            this.protocolProcessor = new ImmutableHttpProcessor(reqinterceptors, resinterceptors);
        }
        return this.protocolProcessor;
    }

    public synchronized int getResponseInterceptorCount() {
        return this.getHttpProcessor().getResponseInterceptorCount();
    }

    public synchronized HttpResponseInterceptor getResponseInterceptor(int index) {
        return this.getHttpProcessor().getResponseInterceptor(index);
    }

    public synchronized HttpRequestInterceptor getRequestInterceptor(int index) {
        return this.getHttpProcessor().getRequestInterceptor(index);
    }

    public synchronized int getRequestInterceptorCount() {
        return this.getHttpProcessor().getRequestInterceptorCount();
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
        this.protocolProcessor = null;
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp, int index) {
        this.getHttpProcessor().addInterceptor(itcp, index);
        this.protocolProcessor = null;
    }

    public synchronized void clearResponseInterceptors() {
        this.getHttpProcessor().clearResponseInterceptors();
        this.protocolProcessor = null;
    }

    public synchronized void removeResponseInterceptorByClass(Class<? extends HttpResponseInterceptor> clazz) {
        this.getHttpProcessor().removeResponseInterceptorByClass(clazz);
        this.protocolProcessor = null;
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
        this.protocolProcessor = null;
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp, int index) {
        this.getHttpProcessor().addInterceptor(itcp, index);
        this.protocolProcessor = null;
    }

    public synchronized void clearRequestInterceptors() {
        this.getHttpProcessor().clearRequestInterceptors();
        this.protocolProcessor = null;
    }

    public synchronized void removeRequestInterceptorByClass(Class<? extends HttpRequestInterceptor> clazz) {
        this.getHttpProcessor().removeRequestInterceptorByClass(clazz);
        this.protocolProcessor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpContext execContext = null;
        RequestDirector director = null;
        HttpRoutePlanner routePlanner = null;
        ConnectionBackoffStrategy connectionBackoffStrategy = null;
        BackoffManager backoffManager = null;
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            HttpContext defaultContext = this.createHttpContext();
            execContext = context == null ? defaultContext : new DefaultedHttpContext(context, defaultContext);
            HttpParams params = this.determineParams(request);
            RequestConfig config = HttpClientParamConfig.getRequestConfig(params);
            execContext.setAttribute("http.request-config", config);
            director = this.createClientRequestDirector(this.getRequestExecutor(), this.getConnectionManager(), this.getConnectionReuseStrategy(), this.getConnectionKeepAliveStrategy(), this.getRoutePlanner(), this.getProtocolProcessor(), this.getHttpRequestRetryHandler(), this.getRedirectStrategy(), this.getTargetAuthenticationStrategy(), this.getProxyAuthenticationStrategy(), this.getUserTokenHandler(), params);
            routePlanner = this.getRoutePlanner();
            connectionBackoffStrategy = this.getConnectionBackoffStrategy();
            backoffManager = this.getBackoffManager();
        }
        try {
            if (connectionBackoffStrategy != null && backoffManager != null) {
                CloseableHttpResponse out;
                HttpHost targetForRoute = target != null ? target : (HttpHost)this.determineParams(request).getParameter("http.default-host");
                HttpRoute route = routePlanner.determineRoute(targetForRoute, request, execContext);
                try {
                    out = CloseableHttpResponseProxy.newProxy(director.execute(target, request, execContext));
                }
                catch (RuntimeException re) {
                    if (connectionBackoffStrategy.shouldBackoff(re)) {
                        backoffManager.backOff(route);
                    }
                    throw re;
                }
                catch (Exception e) {
                    if (connectionBackoffStrategy.shouldBackoff(e)) {
                        backoffManager.backOff(route);
                    }
                    if (e instanceof HttpException) {
                        throw (HttpException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new UndeclaredThrowableException(e);
                }
                if (connectionBackoffStrategy.shouldBackoff(out)) {
                    backoffManager.backOff(route);
                } else {
                    backoffManager.probe(route);
                }
                return out;
            }
            return CloseableHttpResponseProxy.newProxy(director.execute(target, request, execContext));
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Deprecated
    protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        return new DefaultRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, userTokenHandler, params);
    }

    @Deprecated
    protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        return new DefaultRequestDirector(this.log, requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthHandler, proxyAuthHandler, userTokenHandler, params);
    }

    protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler, HttpParams params) {
        return new DefaultRequestDirector(this.log, requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthStrategy, proxyAuthStrategy, userTokenHandler, params);
    }

    protected HttpParams determineParams(HttpRequest req) {
        return new ClientParamsStack(null, this.getParams(), req.getParams(), null);
    }

    @Override
    public void close() {
        this.getConnectionManager().shutdown();
    }
}

