/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.merge;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.merge.MergeParametersBuilder;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.model.toc.ToCPolicy;

class MergeOptionsPane
extends VBox
implements TaskParametersBuildStep<MergeParametersBuilder>,
RestorableView {
    private ComboBox<KeyStringValueItem<AcroFormPolicy>> acroForms = new ComboBox();
    private CheckBox blankIfOdd;
    private CheckBox footer;
    private ComboBox<KeyStringValueItem<OutlinePolicy>> outline = new ComboBox();
    private ComboBox<KeyStringValueItem<ToCPolicy>> toc = new ComboBox();

    MergeOptionsPane() {
        super(5.0);
        I18nContext i18n = DefaultI18nContext.getInstance();
        this.blankIfOdd = new CheckBox(i18n.i18n("Add a blank page if page number is odd"));
        this.blankIfOdd.setGraphic((Node)HelpUtils.helpIcon(i18n.i18n("Adds a blank page after each merged document if the document has an odd number of pages")));
        this.blankIfOdd.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.blankIfOdd.setId("blankIfOddCheck");
        this.footer = new CheckBox(i18n.i18n("Add a footer"));
        this.footer.setGraphic((Node)HelpUtils.helpIcon(i18n.i18n("Adds a page footer with the name of the file the page belonged to.")));
        this.footer.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.footer.setId("footerCheck");
        GridPane options = new GridPane();
        this.acroForms.getItems().add(KeyStringValueItem.keyValue(AcroFormPolicy.MERGE, i18n.i18n("Merge fields")));
        this.acroForms.getItems().add(KeyStringValueItem.keyValue(AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS, i18n.i18n("Merge renaming existing fields")));
        this.acroForms.getItems().add(KeyStringValueItem.keyValue(AcroFormPolicy.DISCARD, i18n.i18n("Discard forms")));
        this.acroForms.getSelectionModel().selectFirst();
        this.acroForms.setId("acroFormsCombo");
        options.add((Node)new Label(i18n.i18n("Interactive forms (AcroForms):")), 0, 0);
        this.acroForms.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.acroForms, 1, 0);
        options.add((Node)HelpUtils.helpIcon(i18n.i18n("What to do in case one or more input documents contain Acro Forms")), 2, 0);
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.RETAIN, i18n.i18n("Retain bookmarks")));
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.DISCARD, i18n.i18n("Discard bookmarks")));
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.ONE_ENTRY_EACH_DOC, i18n.i18n("Create one entry for each merged document")));
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.RETAIN_AS_ONE_ENTRY, i18n.i18n("Retain bookmarks as one entry for each merged document")));
        this.outline.getSelectionModel().selectFirst();
        this.outline.setId("outlineCombo");
        options.add((Node)new Label(i18n.i18n("Bookmarks handling:")), 0, 1);
        this.outline.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.outline, 1, 1);
        options.add((Node)HelpUtils.helpIcon(i18n.i18n("What to do in case one or more input documents contain bookmarks")), 2, 1);
        this.toc.getItems().add(KeyStringValueItem.keyValue(ToCPolicy.NONE, i18n.i18n("Don't generate")));
        this.toc.getItems().add(KeyStringValueItem.keyValue(ToCPolicy.FILE_NAMES, i18n.i18n("Generate from file names")));
        this.toc.getItems().add(KeyStringValueItem.keyValue(ToCPolicy.DOC_TITLES, i18n.i18n("Generate from documents titles")));
        this.toc.getSelectionModel().selectFirst();
        this.toc.setId("tocCombo");
        options.add((Node)new Label(i18n.i18n("Table of contents:")), 0, 2);
        this.toc.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.toc, 1, 2);
        options.add((Node)HelpUtils.helpIcon(i18n.i18n("Set if a table of contents should be added to the generated PDF document")), 2, 2);
        options.getStyleClass().addAll((Object[])Style.GRID.css());
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{this.blankIfOdd, this.footer, options});
    }

    @Override
    public void apply(MergeParametersBuilder builder, Consumer<String> onError) {
        builder.outlinePolicy((OutlinePolicy)((KeyStringValueItem)this.outline.getSelectionModel().getSelectedItem()).getKey());
        builder.acroFormsPolicy((AcroFormPolicy)((KeyStringValueItem)this.acroForms.getSelectionModel().getSelectedItem()).getKey());
        builder.tocPolicy((ToCPolicy)((KeyStringValueItem)this.toc.getSelectionModel().getSelectedItem()).getKey());
        builder.blankPageIfOdd(this.blankIfOdd.isSelected());
        builder.footer(this.footer.isSelected());
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("outline", Optional.ofNullable(this.outline.getSelectionModel().getSelectedItem()).map(i -> ((OutlinePolicy)i.getKey()).toString()).orElse(""));
        data.put("acroForms", Optional.ofNullable(this.acroForms.getSelectionModel().getSelectedItem()).map(i -> ((AcroFormPolicy)i.getKey()).toString()).orElse(""));
        data.put("toc", Optional.ofNullable(this.toc.getSelectionModel().getSelectedItem()).map(i -> ((ToCPolicy)i.getKey()).toString()).orElse(""));
        data.put("blankIfOdd", Boolean.toString(this.blankIfOdd.isSelected()));
        data.put("footer", Boolean.toString(this.footer.isSelected()));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("outline")).map(OutlinePolicy::valueOf).map(r -> KeyStringValueItem.keyEmptyValue(r)).ifPresent(r -> this.outline.getSelectionModel().select(r));
        Optional.ofNullable(data.get("acroForms")).map(AcroFormPolicy::valueOf).map(r -> KeyStringValueItem.keyEmptyValue(r)).ifPresent(r -> this.acroForms.getSelectionModel().select(r));
        Optional.ofNullable(data.get("toc")).map(ToCPolicy::valueOf).map(r -> KeyStringValueItem.keyEmptyValue(r)).ifPresent(r -> this.toc.getSelectionModel().select(r));
        this.blankIfOdd.setSelected(Boolean.valueOf(data.get("blankIfOdd")).booleanValue());
        this.footer.setSelected(Boolean.valueOf(data.get("footer")).booleanValue());
    }
}

