/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.sejda.conversion.PdfVersionAdapter;
import org.sejda.model.pdf.PdfVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfVersionAdapterWithFallback {
    private static final Logger LOG = LoggerFactory.getLogger(PdfVersionAdapterWithFallback.class);
    private PdfVersion version;

    public PdfVersionAdapterWithFallback(String userFriendlyName) {
        if (userFriendlyName.matches("[01234567]{1}")) {
            LOG.warn("Single digit PDF version '{}' is deprecated and will be removed in future releases, please use the two digits '1.{}' format", (Object)userFriendlyName, (Object)userFriendlyName);
            this.version = (PdfVersion)new PdfVersionAdapter("1." + userFriendlyName).getEnumValue();
        } else {
            this.version = (PdfVersion)new PdfVersionAdapter(userFriendlyName).getEnumValue();
        }
    }

    public PdfVersion getVersion() {
        return this.version;
    }
}

