/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.Optional;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.util.TransitionUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.SetPagesTransitionParameters;
import org.sejda.model.pdf.viewerpreference.PdfPageMode;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.pagenavigation.PDTransition;
import org.sejda.sambox.pdmodel.interactive.pagenavigation.PDTransitionStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPagesTransitionTask
extends BaseTask<SetPagesTransitionParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetPagesTransitionTask.class);
    private PDDocumentHandler documentHandler = null;
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(SetPagesTransitionParameters parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(SetPagesTransitionParameters parameters) throws TaskException {
        this.stopTaskIfCancelled();
        ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).progressUndetermined();
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.documentHandler = source.open(this.documentLoader);
        File tmpFile = IOUtils.createTemporaryPdfBuffer();
        LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
        LOG.debug("Applying transitions");
        int current = 0;
        for (PDPage page : this.documentHandler.getPages()) {
            this.stopTaskIfCancelled();
            Optional.ofNullable(parameters.getOrDefault(++current)).ifPresent(t -> {
                LOG.trace("Applying transition {}", t);
                PDTransition transition = new PDTransition(Optional.ofNullable(TransitionUtils.getTransition(t.getStyle())).orElse(PDTransitionStyle.R));
                TransitionUtils.initTransitionDimension(t, transition);
                TransitionUtils.initTransitionMotion(t, transition);
                TransitionUtils.initTransitionDirection(t, transition);
                transition.setDuration(t.getTransitionDuration());
                page.setTransition(transition, t.getDisplayDuration());
            });
        }
        if (parameters.isFullScreen()) {
            this.documentHandler.setPageModeOnDocument(PdfPageMode.FULLSCREEN);
        }
        this.documentHandler.setCreatorOnPDDocument();
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
        this.outputWriter.setOutput(FileOutput.file(tmpFile).name(parameters.getOutputName()));
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Transitions set on {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

