/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.LookupTable;
import org.sejda.impl.sambox.component.OutlineDistiller;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageFitDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineMerger {
    private static final Logger LOG = LoggerFactory.getLogger(OutlineMerger.class);
    private OutlinePolicy policy;
    private PDDocumentOutline outline = new PDDocumentOutline();

    public OutlineMerger(OutlinePolicy policy) {
        this.policy = policy;
    }

    public void updateOutline(PDDocument document, String sourceName, LookupTable<PDPage> pagesLookup) {
        if (!pagesLookup.isEmpty()) {
            LOG.debug("Updating outline with policy {}", (Object)this.policy);
            switch (this.policy) {
                case ONE_ENTRY_EACH_DOC: {
                    this.updateOneEntryPerDoc(sourceName, pagesLookup);
                    break;
                }
                case RETAIN: {
                    new OutlineDistiller(document).appendRelevantOutlineTo(this.outline, pagesLookup);
                    break;
                }
                case RETAIN_AS_ONE_ENTRY: {
                    Optional.ofNullable(this.updateOneEntryPerDoc(sourceName, pagesLookup)).ifPresent(item -> new OutlineDistiller(document).appendRelevantOutlineTo((PDOutlineNode)item, pagesLookup));
                    break;
                }
                default: {
                    LOG.debug("Discarding outline for {}", (Object)sourceName);
                    break;
                }
            }
        } else {
            LOG.info("Skipped outline merge, no relevant page");
        }
    }

    private PDOutlineItem updateOneEntryPerDoc(String sourceName, LookupTable<PDPage> pagesLookup) {
        if (StringUtils.isNotBlank(sourceName)) {
            LOG.debug("Adding outline entry for {}", (Object)sourceName);
            PDOutlineItem item = new PDOutlineItem();
            item.setTitle(FilenameUtils.removeExtension(sourceName));
            PDPageFitDestination destination = new PDPageFitDestination();
            destination.setPage(pagesLookup.first());
            item.setDestination(destination);
            this.outline.addLast(item);
            return item;
        }
        LOG.warn("Unable to create an outline item for a source with blank name");
        return null;
    }

    public boolean hasOutline() {
        return this.outline.hasChildren();
    }

    public PDDocumentOutline getOutline() {
        return this.outline;
    }
}

