/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.output;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.validation.constraint.IsFile;

public class FileTaskOutput
implements SingleTaskOutput<File> {
    @IsFile
    private final File file;

    public FileTaskOutput(File file) {
        if (file == null || file.exists() && !file.isFile()) {
            throw new IllegalArgumentException("A valid instance is expected (not null or existing file).");
        }
        this.file = file;
    }

    @Override
    public File getDestination() {
        return this.file;
    }

    @Override
    public void accept(TaskOutputDispatcher writer) throws TaskOutputVisitException {
        try {
            writer.dispatch(this);
        }
        catch (IOException e) {
            throw new TaskOutputVisitException("Exception dispatching the file task output.", e);
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append(this.getDestination()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getDestination()).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileTaskOutput)) {
            return false;
        }
        FileTaskOutput output = (FileTaskOutput)other;
        return new EqualsBuilder().append(this.file, output.getDestination()).isEquals();
    }
}

