# -*- coding: utf-8 -*-
# Auto-generated by BabelAPI, do not modify.
"""
This namespace contains endpoints and data types for creating and managing shared links and shared folders.
"""

try:
    from . import babel_validators as bv
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import babel_validators as bv

try:
    from . import (
        async,
        common,
        files,
        team,
        users,
    )
except (SystemError, ValueError):
    import async
    import common
    import files
    import team
    import users

class AccessLevel(object):
    """
    Defines the access levels for collaborators.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar owner: The collaborator is the owner of the shared folder. Owners can
        view and edit the shared folder as well as set the folder's policies
        using update_folder_policy.
    :ivar editor: The collaborator can both view and edit the shared folder.
    :ivar viewer: The collaborator can only view the shared folder.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    owner = None
    # Attribute is overwritten below the class definition
    editor = None
    # Attribute is overwritten below the class definition
    viewer = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_owner(self):
        """
        Check if the union tag is ``owner``.

        :rtype: bool
        """
        return self._tag == 'owner'

    def is_editor(self):
        """
        Check if the union tag is ``editor``.

        :rtype: bool
        """
        return self._tag == 'editor'

    def is_viewer(self):
        """
        Check if the union tag is ``viewer``.

        :rtype: bool
        """
        return self._tag == 'viewer'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AccessLevel(%r, %r)' % (self._tag, self._value)

class AclUpdatePolicy(object):
    """
    Policy governing who can change a shared folder's access control list (ACL).
    In other words, who can add, remove, or change the privileges of members.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar owner: Only the owner can update the ACL.
    :ivar editors: Any editor can update the ACL. This may be further restricted
        to editors on the same team.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    owner = None
    # Attribute is overwritten below the class definition
    editors = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_owner(self):
        """
        Check if the union tag is ``owner``.

        :rtype: bool
        """
        return self._tag == 'owner'

    def is_editors(self):
        """
        Check if the union tag is ``editors``.

        :rtype: bool
        """
        return self._tag == 'editors'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AclUpdatePolicy(%r, %r)' % (self._tag, self._value)

class AddFolderMemberArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar members: The intended list of members to add.  Added members will
        receive invites to join the shared folder.
    :ivar quiet: Whether added members should be notified via email and device
        notifications of their invite.
    :ivar custom_message: Optional message to display to added members in their
        invitation.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_members_value',
        '_members_present',
        '_quiet_value',
        '_quiet_present',
        '_custom_message_value',
        '_custom_message_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 members=None,
                 quiet=None,
                 custom_message=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._members_value = None
        self._members_present = False
        self._quiet_value = None
        self._quiet_present = False
        self._custom_message_value = None
        self._custom_message_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if members is not None:
            self.members = members
        if quiet is not None:
            self.quiet = quiet
        if custom_message is not None:
            self.custom_message = custom_message

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def members(self):
        """
        The intended list of members to add.  Added members will receive invites
        to join the shared folder.

        :rtype: list of [AddMember]
        """
        if self._members_present:
            return self._members_value
        else:
            raise AttributeError("missing required field 'members'")

    @members.setter
    def members(self, val):
        val = self._members_validator.validate(val)
        self._members_value = val
        self._members_present = True

    @members.deleter
    def members(self):
        self._members_value = None
        self._members_present = False

    @property
    def quiet(self):
        """
        Whether added members should be notified via email and device
        notifications of their invite.

        :rtype: bool
        """
        if self._quiet_present:
            return self._quiet_value
        else:
            return False

    @quiet.setter
    def quiet(self, val):
        val = self._quiet_validator.validate(val)
        self._quiet_value = val
        self._quiet_present = True

    @quiet.deleter
    def quiet(self):
        self._quiet_value = None
        self._quiet_present = False

    @property
    def custom_message(self):
        """
        Optional message to display to added members in their invitation.

        :rtype: str
        """
        if self._custom_message_present:
            return self._custom_message_value
        else:
            return None

    @custom_message.setter
    def custom_message(self, val):
        if val is None:
            del self.custom_message
            return
        val = self._custom_message_validator.validate(val)
        self._custom_message_value = val
        self._custom_message_present = True

    @custom_message.deleter
    def custom_message(self):
        self._custom_message_value = None
        self._custom_message_present = False

    def __repr__(self):
        return 'AddFolderMemberArg(shared_folder_id={!r}, members={!r}, quiet={!r}, custom_message={!r})'.format(
            self._shared_folder_id_value,
            self._members_value,
            self._quiet_value,
            self._custom_message_value,
        )

class AddFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SharedFolderAccessError access_error: Unable to access shared folder.
    :ivar email_unverified: The current user's e-mail address is unverified.
    :ivar AddMemberSelectorError bad_member: ``AddFolderMemberArg.members``
        contains a bad invitation recipient.
    :ivar cant_share_outside_team: Your team policy does not allow sharing
        outside of the team.
    :ivar long too_many_members: The value is the member limit that was reached.
    :ivar long too_many_pending_invites: The value is the pending invite limit
        that was reached.
    :ivar rate_limit: The user has reached the rate limit for invitations.
    :ivar insufficient_plan: The current user's account doesn't support this
        action. An example of this is when adding a read-only member. This
        action can only be performed by users that have upgraded to a Pro or
        Business plan.
    :ivar team_folder: This action cannot be performed on a team shared folder.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    cant_share_outside_team = None
    # Attribute is overwritten below the class definition
    rate_limit = None
    # Attribute is overwritten below the class definition
    insufficient_plan = None
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: AddFolderMemberError
        """
        return cls('access_error', val)

    @classmethod
    def bad_member(cls, val):
        """
        Create an instance of this class set to the ``bad_member`` tag with
        value ``val``.

        :param AddMemberSelectorError val:
        :rtype: AddFolderMemberError
        """
        return cls('bad_member', val)

    @classmethod
    def too_many_members(cls, val):
        """
        Create an instance of this class set to the ``too_many_members`` tag
        with value ``val``.

        :param long val:
        :rtype: AddFolderMemberError
        """
        return cls('too_many_members', val)

    @classmethod
    def too_many_pending_invites(cls, val):
        """
        Create an instance of this class set to the ``too_many_pending_invites``
        tag with value ``val``.

        :param long val:
        :rtype: AddFolderMemberError
        """
        return cls('too_many_pending_invites', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_bad_member(self):
        """
        Check if the union tag is ``bad_member``.

        :rtype: bool
        """
        return self._tag == 'bad_member'

    def is_cant_share_outside_team(self):
        """
        Check if the union tag is ``cant_share_outside_team``.

        :rtype: bool
        """
        return self._tag == 'cant_share_outside_team'

    def is_too_many_members(self):
        """
        Check if the union tag is ``too_many_members``.

        :rtype: bool
        """
        return self._tag == 'too_many_members'

    def is_too_many_pending_invites(self):
        """
        Check if the union tag is ``too_many_pending_invites``.

        :rtype: bool
        """
        return self._tag == 'too_many_pending_invites'

    def is_rate_limit(self):
        """
        Check if the union tag is ``rate_limit``.

        :rtype: bool
        """
        return self._tag == 'rate_limit'

    def is_insufficient_plan(self):
        """
        Check if the union tag is ``insufficient_plan``.

        :rtype: bool
        """
        return self._tag == 'insufficient_plan'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Unable to access shared folder.

        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def get_bad_member(self):
        """
        ``AddFolderMemberArg.members`` contains a bad invitation recipient.

        Only call this if :meth:`is_bad_member` is true.

        :rtype: AddMemberSelectorError
        """
        if not self.is_bad_member():
            raise AttributeError("tag 'bad_member' not set")
        return self._value

    def get_too_many_members(self):
        """
        The value is the member limit that was reached.

        Only call this if :meth:`is_too_many_members` is true.

        :rtype: long
        """
        if not self.is_too_many_members():
            raise AttributeError("tag 'too_many_members' not set")
        return self._value

    def get_too_many_pending_invites(self):
        """
        The value is the pending invite limit that was reached.

        Only call this if :meth:`is_too_many_pending_invites` is true.

        :rtype: long
        """
        if not self.is_too_many_pending_invites():
            raise AttributeError("tag 'too_many_pending_invites' not set")
        return self._value

    def __repr__(self):
        return 'AddFolderMemberError(%r, %r)' % (self._tag, self._value)

class AddMember(object):
    """
    The member and type of access the member should have when added to a shared
    folder.

    :ivar member: The member to add to the shared folder.
    :ivar access_level: The access level to grant ``member`` to the shared
        folder.  ``AccessLevel.owner`` is disallowed.
    """

    __slots__ = [
        '_member_value',
        '_member_present',
        '_access_level_value',
        '_access_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 member=None,
                 access_level=None):
        self._member_value = None
        self._member_present = False
        self._access_level_value = None
        self._access_level_present = False
        if member is not None:
            self.member = member
        if access_level is not None:
            self.access_level = access_level

    @property
    def member(self):
        """
        The member to add to the shared folder.

        :rtype: MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def access_level(self):
        """
        The access level to grant ``member`` to the shared folder.
        ``AccessLevel.owner`` is disallowed.

        :rtype: AccessLevel
        """
        if self._access_level_present:
            return self._access_level_value
        else:
            return AccessLevel.viewer

    @access_level.setter
    def access_level(self, val):
        self._access_level_validator.validate_type_only(val)
        self._access_level_value = val
        self._access_level_present = True

    @access_level.deleter
    def access_level(self):
        self._access_level_value = None
        self._access_level_present = False

    def __repr__(self):
        return 'AddMember(member={!r}, access_level={!r})'.format(
            self._member_value,
            self._access_level_value,
        )

class AddMemberSelectorError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str invalid_dropbox_id: The value is the ID that could not be
        identified.
    :ivar str invalid_email: The value is the e-email address that is malformed.
    :ivar str unverified_dropbox_id: The value is the ID of the Dropbox user
        with an unverified e-mail address.  Invite unverified users by e-mail
        address instead of by their Dropbox ID.
    :ivar group_deleted: At least one of the specified groups in
        ``AddFolderMemberArg.members`` is deleted.
    :ivar group_not_on_team: Sharing to a group that is not on the current
        user's team.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    group_deleted = None
    # Attribute is overwritten below the class definition
    group_not_on_team = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def invalid_dropbox_id(cls, val):
        """
        Create an instance of this class set to the ``invalid_dropbox_id`` tag
        with value ``val``.

        :param str val:
        :rtype: AddMemberSelectorError
        """
        return cls('invalid_dropbox_id', val)

    @classmethod
    def invalid_email(cls, val):
        """
        Create an instance of this class set to the ``invalid_email`` tag with
        value ``val``.

        :param str val:
        :rtype: AddMemberSelectorError
        """
        return cls('invalid_email', val)

    @classmethod
    def unverified_dropbox_id(cls, val):
        """
        Create an instance of this class set to the ``unverified_dropbox_id``
        tag with value ``val``.

        :param str val:
        :rtype: AddMemberSelectorError
        """
        return cls('unverified_dropbox_id', val)

    def is_invalid_dropbox_id(self):
        """
        Check if the union tag is ``invalid_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_dropbox_id'

    def is_invalid_email(self):
        """
        Check if the union tag is ``invalid_email``.

        :rtype: bool
        """
        return self._tag == 'invalid_email'

    def is_unverified_dropbox_id(self):
        """
        Check if the union tag is ``unverified_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'unverified_dropbox_id'

    def is_group_deleted(self):
        """
        Check if the union tag is ``group_deleted``.

        :rtype: bool
        """
        return self._tag == 'group_deleted'

    def is_group_not_on_team(self):
        """
        Check if the union tag is ``group_not_on_team``.

        :rtype: bool
        """
        return self._tag == 'group_not_on_team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_invalid_dropbox_id(self):
        """
        The value is the ID that could not be identified.

        Only call this if :meth:`is_invalid_dropbox_id` is true.

        :rtype: str
        """
        if not self.is_invalid_dropbox_id():
            raise AttributeError("tag 'invalid_dropbox_id' not set")
        return self._value

    def get_invalid_email(self):
        """
        The value is the e-email address that is malformed.

        Only call this if :meth:`is_invalid_email` is true.

        :rtype: str
        """
        if not self.is_invalid_email():
            raise AttributeError("tag 'invalid_email' not set")
        return self._value

    def get_unverified_dropbox_id(self):
        """
        The value is the ID of the Dropbox user with an unverified e-mail
        address.  Invite unverified users by e-mail address instead of by their
        Dropbox ID.

        Only call this if :meth:`is_unverified_dropbox_id` is true.

        :rtype: str
        """
        if not self.is_unverified_dropbox_id():
            raise AttributeError("tag 'unverified_dropbox_id' not set")
        return self._value

    def __repr__(self):
        return 'AddMemberSelectorError(%r, %r)' % (self._tag, self._value)

class LinkMetadata(object):
    """
    Metadata for a shared link. This can be either a :class:`PathLinkMetadata`
    or :class:`CollectionLinkMetadata`.

    :ivar url: URL of the shared link.
    :ivar visibility: Who can access the link.
    :ivar expires: Expiration time, if set. By default the link won't expire.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_visibility_value',
        '_visibility_present',
        '_expires_value',
        '_expires_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 visibility=None,
                 expires=None):
        self._url_value = None
        self._url_present = False
        self._visibility_value = None
        self._visibility_present = False
        self._expires_value = None
        self._expires_present = False
        if url is not None:
            self.url = url
        if visibility is not None:
            self.visibility = visibility
        if expires is not None:
            self.expires = expires

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def visibility(self):
        """
        Who can access the link.

        :rtype: Visibility
        """
        if self._visibility_present:
            return self._visibility_value
        else:
            raise AttributeError("missing required field 'visibility'")

    @visibility.setter
    def visibility(self, val):
        self._visibility_validator.validate_type_only(val)
        self._visibility_value = val
        self._visibility_present = True

    @visibility.deleter
    def visibility(self):
        self._visibility_value = None
        self._visibility_present = False

    @property
    def expires(self):
        """
        Expiration time, if set. By default the link won't expire.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            return None

    @expires.setter
    def expires(self, val):
        if val is None:
            del self.expires
            return
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    def __repr__(self):
        return 'LinkMetadata(url={!r}, visibility={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._expires_value,
        )

class CollectionLinkMetadata(LinkMetadata):
    """
    Metadata for a collection-based shared link.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 visibility=None,
                 expires=None):
        super(CollectionLinkMetadata, self).__init__(url,
                                                     visibility,
                                                     expires)

    def __repr__(self):
        return 'CollectionLinkMetadata(url={!r}, visibility={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._expires_value,
        )

class CreateSharedLinkArg(object):
    """
    :ivar path: The path to share.
    :ivar short_url: Whether to return a shortened URL.
    :ivar pending_upload: If it's okay to share a path that does not yet exist,
        set this to either ``PendingUploadMode.file`` or
        ``PendingUploadMode.folder`` to indicate whether to assume it's a file
        or folder.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_short_url_value',
        '_short_url_present',
        '_pending_upload_value',
        '_pending_upload_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 short_url=None,
                 pending_upload=None):
        self._path_value = None
        self._path_present = False
        self._short_url_value = None
        self._short_url_present = False
        self._pending_upload_value = None
        self._pending_upload_present = False
        if path is not None:
            self.path = path
        if short_url is not None:
            self.short_url = short_url
        if pending_upload is not None:
            self.pending_upload = pending_upload

    @property
    def path(self):
        """
        The path to share.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def short_url(self):
        """
        Whether to return a shortened URL.

        :rtype: bool
        """
        if self._short_url_present:
            return self._short_url_value
        else:
            return False

    @short_url.setter
    def short_url(self, val):
        val = self._short_url_validator.validate(val)
        self._short_url_value = val
        self._short_url_present = True

    @short_url.deleter
    def short_url(self):
        self._short_url_value = None
        self._short_url_present = False

    @property
    def pending_upload(self):
        """
        If it's okay to share a path that does not yet exist, set this to either
        ``PendingUploadMode.file`` or ``PendingUploadMode.folder`` to indicate
        whether to assume it's a file or folder.

        :rtype: PendingUploadMode
        """
        if self._pending_upload_present:
            return self._pending_upload_value
        else:
            return None

    @pending_upload.setter
    def pending_upload(self, val):
        if val is None:
            del self.pending_upload
            return
        self._pending_upload_validator.validate_type_only(val)
        self._pending_upload_value = val
        self._pending_upload_present = True

    @pending_upload.deleter
    def pending_upload(self):
        self._pending_upload_value = None
        self._pending_upload_present = False

    def __repr__(self):
        return 'CreateSharedLinkArg(path={!r}, short_url={!r}, pending_upload={!r})'.format(
            self._path_value,
            self._short_url_value,
            self._pending_upload_value,
        )

class CreateSharedLinkError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param files.LookupError_validator val:
        :rtype: CreateSharedLinkError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: files.LookupError_validator
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'CreateSharedLinkError(%r, %r)' % (self._tag, self._value)

class CreateSharedLinkWithSettingsArg(object):
    """
    :ivar path: The path to be shared by the shared link
    :ivar settings: The requested settings for the newly created shared link
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_settings_value',
        '_settings_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 settings=None):
        self._path_value = None
        self._path_present = False
        self._settings_value = None
        self._settings_present = False
        if path is not None:
            self.path = path
        if settings is not None:
            self.settings = settings

    @property
    def path(self):
        """
        The path to be shared by the shared link

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def settings(self):
        """
        The requested settings for the newly created shared link

        :rtype: SharedLinkSettings
        """
        if self._settings_present:
            return self._settings_value
        else:
            return None

    @settings.setter
    def settings(self, val):
        if val is None:
            del self.settings
            return
        self._settings_validator.validate_type_only(val)
        self._settings_value = val
        self._settings_present = True

    @settings.deleter
    def settings(self):
        self._settings_value = None
        self._settings_present = False

    def __repr__(self):
        return 'CreateSharedLinkWithSettingsArg(path={!r}, settings={!r})'.format(
            self._path_value,
            self._settings_value,
        )

class CreateSharedLinkWithSettingsError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar email_not_verified: User's email should be verified
    :ivar shared_link_already_exists: The shared link already exists
    :ivar SharedLinkSettingsError settings_error: There is an error with the
        given settings
    :ivar access_denied: Access to the requested path is forbidden
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    email_not_verified = None
    # Attribute is overwritten below the class definition
    shared_link_already_exists = None
    # Attribute is overwritten below the class definition
    access_denied = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param files.LookupError_validator val:
        :rtype: CreateSharedLinkWithSettingsError
        """
        return cls('path', val)

    @classmethod
    def settings_error(cls, val):
        """
        Create an instance of this class set to the ``settings_error`` tag with
        value ``val``.

        :param SharedLinkSettingsError val:
        :rtype: CreateSharedLinkWithSettingsError
        """
        return cls('settings_error', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_email_not_verified(self):
        """
        Check if the union tag is ``email_not_verified``.

        :rtype: bool
        """
        return self._tag == 'email_not_verified'

    def is_shared_link_already_exists(self):
        """
        Check if the union tag is ``shared_link_already_exists``.

        :rtype: bool
        """
        return self._tag == 'shared_link_already_exists'

    def is_settings_error(self):
        """
        Check if the union tag is ``settings_error``.

        :rtype: bool
        """
        return self._tag == 'settings_error'

    def is_access_denied(self):
        """
        Check if the union tag is ``access_denied``.

        :rtype: bool
        """
        return self._tag == 'access_denied'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: files.LookupError_validator
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def get_settings_error(self):
        """
        There is an error with the given settings

        Only call this if :meth:`is_settings_error` is true.

        :rtype: SharedLinkSettingsError
        """
        if not self.is_settings_error():
            raise AttributeError("tag 'settings_error' not set")
        return self._value

    def __repr__(self):
        return 'CreateSharedLinkWithSettingsError(%r, %r)' % (self._tag, self._value)

class SharedLinkMetadata(object):
    """
    The metadata of a shared link

    :ivar url: URL of the shared link.
    :ivar id: A unique identifier for the linked file.
    :ivar name: The linked file name (including extension). This never contains
        a slash.
    :ivar expires: Expiration time, if set. By default the link won't expire.
    :ivar path_lower: The lowercased full path in the user's Dropbox. This
        always starts with a slash. This field will only be present only if the
        linked file is in the authenticated user's  dropbox.
    :ivar link_permissions: The link's access permissions.
    :ivar team_member_info: The team membership information of the link's owner.
        This field will only be present  if the link's owner is a team member.
    :ivar content_owner_team_info: The team information of the content's owner.
        This field will only be present if the content's owner is a team member
        and the content's owner team is different from the link's owner team.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_id_value',
        '_id_present',
        '_name_value',
        '_name_present',
        '_expires_value',
        '_expires_present',
        '_path_lower_value',
        '_path_lower_present',
        '_link_permissions_value',
        '_link_permissions_present',
        '_team_member_info_value',
        '_team_member_info_present',
        '_content_owner_team_info_value',
        '_content_owner_team_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 name=None,
                 link_permissions=None,
                 id=None,
                 expires=None,
                 path_lower=None,
                 team_member_info=None,
                 content_owner_team_info=None):
        self._url_value = None
        self._url_present = False
        self._id_value = None
        self._id_present = False
        self._name_value = None
        self._name_present = False
        self._expires_value = None
        self._expires_present = False
        self._path_lower_value = None
        self._path_lower_present = False
        self._link_permissions_value = None
        self._link_permissions_present = False
        self._team_member_info_value = None
        self._team_member_info_present = False
        self._content_owner_team_info_value = None
        self._content_owner_team_info_present = False
        if url is not None:
            self.url = url
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if expires is not None:
            self.expires = expires
        if path_lower is not None:
            self.path_lower = path_lower
        if link_permissions is not None:
            self.link_permissions = link_permissions
        if team_member_info is not None:
            self.team_member_info = team_member_info
        if content_owner_team_info is not None:
            self.content_owner_team_info = content_owner_team_info

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def id(self):
        """
        A unique identifier for the linked file.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            return None

    @id.setter
    def id(self, val):
        if val is None:
            del self.id
            return
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def name(self):
        """
        The linked file name (including extension). This never contains a slash.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def expires(self):
        """
        Expiration time, if set. By default the link won't expire.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            return None

    @expires.setter
    def expires(self, val):
        if val is None:
            del self.expires
            return
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    @property
    def path_lower(self):
        """
        The lowercased full path in the user's Dropbox. This always starts with
        a slash. This field will only be present only if the linked file is in
        the authenticated user's  dropbox.

        :rtype: str
        """
        if self._path_lower_present:
            return self._path_lower_value
        else:
            return None

    @path_lower.setter
    def path_lower(self, val):
        if val is None:
            del self.path_lower
            return
        val = self._path_lower_validator.validate(val)
        self._path_lower_value = val
        self._path_lower_present = True

    @path_lower.deleter
    def path_lower(self):
        self._path_lower_value = None
        self._path_lower_present = False

    @property
    def link_permissions(self):
        """
        The link's access permissions.

        :rtype: LinkPermissions
        """
        if self._link_permissions_present:
            return self._link_permissions_value
        else:
            raise AttributeError("missing required field 'link_permissions'")

    @link_permissions.setter
    def link_permissions(self, val):
        self._link_permissions_validator.validate_type_only(val)
        self._link_permissions_value = val
        self._link_permissions_present = True

    @link_permissions.deleter
    def link_permissions(self):
        self._link_permissions_value = None
        self._link_permissions_present = False

    @property
    def team_member_info(self):
        """
        The team membership information of the link's owner.  This field will
        only be present  if the link's owner is a team member.

        :rtype: TeamMemberInfo
        """
        if self._team_member_info_present:
            return self._team_member_info_value
        else:
            return None

    @team_member_info.setter
    def team_member_info(self, val):
        if val is None:
            del self.team_member_info
            return
        self._team_member_info_validator.validate_type_only(val)
        self._team_member_info_value = val
        self._team_member_info_present = True

    @team_member_info.deleter
    def team_member_info(self):
        self._team_member_info_value = None
        self._team_member_info_present = False

    @property
    def content_owner_team_info(self):
        """
        The team information of the content's owner. This field will only be
        present if the content's owner is a team member and the content's owner
        team is different from the link's owner team.

        :rtype: users.Team_validator
        """
        if self._content_owner_team_info_present:
            return self._content_owner_team_info_value
        else:
            return None

    @content_owner_team_info.setter
    def content_owner_team_info(self, val):
        if val is None:
            del self.content_owner_team_info
            return
        val = self._content_owner_team_info_validator.validate(val)
        self._content_owner_team_info_value = val
        self._content_owner_team_info_present = True

    @content_owner_team_info.deleter
    def content_owner_team_info(self):
        self._content_owner_team_info_value = None
        self._content_owner_team_info_present = False

    def __repr__(self):
        return 'SharedLinkMetadata(url={!r}, name={!r}, link_permissions={!r}, id={!r}, expires={!r}, path_lower={!r}, team_member_info={!r}, content_owner_team_info={!r})'.format(
            self._url_value,
            self._name_value,
            self._link_permissions_value,
            self._id_value,
            self._expires_value,
            self._path_lower_value,
            self._team_member_info_value,
            self._content_owner_team_info_value,
        )

class FileLinkMetadata(SharedLinkMetadata):
    """
    The metadata of a file shared link

    :ivar client_modified: The modification time set by the desktop client when
        the file was added to Dropbox. Since this time is not verified (the
        Dropbox server stores whatever the desktop client sends up), this should
        only be used for display purposes (such as sorting) and not, for
        example, to determine if a file has changed or not.
    :ivar server_modified: The last time the file was modified on Dropbox.
    :ivar rev: A unique identifier for the current revision of a file. This
        field is the same rev as elsewhere in the API and can be used to detect
        changes and avoid conflicts.
    :ivar size: The file size in bytes.
    """

    __slots__ = [
        '_client_modified_value',
        '_client_modified_present',
        '_server_modified_value',
        '_server_modified_present',
        '_rev_value',
        '_rev_present',
        '_size_value',
        '_size_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 name=None,
                 link_permissions=None,
                 client_modified=None,
                 server_modified=None,
                 rev=None,
                 size=None,
                 id=None,
                 expires=None,
                 path_lower=None,
                 team_member_info=None,
                 content_owner_team_info=None):
        super(FileLinkMetadata, self).__init__(url,
                                               name,
                                               link_permissions,
                                               id,
                                               expires,
                                               path_lower,
                                               team_member_info,
                                               content_owner_team_info)
        self._client_modified_value = None
        self._client_modified_present = False
        self._server_modified_value = None
        self._server_modified_present = False
        self._rev_value = None
        self._rev_present = False
        self._size_value = None
        self._size_present = False
        if client_modified is not None:
            self.client_modified = client_modified
        if server_modified is not None:
            self.server_modified = server_modified
        if rev is not None:
            self.rev = rev
        if size is not None:
            self.size = size

    @property
    def client_modified(self):
        """
        The modification time set by the desktop client when the file was added
        to Dropbox. Since this time is not verified (the Dropbox server stores
        whatever the desktop client sends up), this should only be used for
        display purposes (such as sorting) and not, for example, to determine if
        a file has changed or not.

        :rtype: datetime.datetime
        """
        if self._client_modified_present:
            return self._client_modified_value
        else:
            raise AttributeError("missing required field 'client_modified'")

    @client_modified.setter
    def client_modified(self, val):
        val = self._client_modified_validator.validate(val)
        self._client_modified_value = val
        self._client_modified_present = True

    @client_modified.deleter
    def client_modified(self):
        self._client_modified_value = None
        self._client_modified_present = False

    @property
    def server_modified(self):
        """
        The last time the file was modified on Dropbox.

        :rtype: datetime.datetime
        """
        if self._server_modified_present:
            return self._server_modified_value
        else:
            raise AttributeError("missing required field 'server_modified'")

    @server_modified.setter
    def server_modified(self, val):
        val = self._server_modified_validator.validate(val)
        self._server_modified_value = val
        self._server_modified_present = True

    @server_modified.deleter
    def server_modified(self):
        self._server_modified_value = None
        self._server_modified_present = False

    @property
    def rev(self):
        """
        A unique identifier for the current revision of a file. This field is
        the same rev as elsewhere in the API and can be used to detect changes
        and avoid conflicts.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            raise AttributeError("missing required field 'rev'")

    @rev.setter
    def rev(self, val):
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    @property
    def size(self):
        """
        The file size in bytes.

        :rtype: long
        """
        if self._size_present:
            return self._size_value
        else:
            raise AttributeError("missing required field 'size'")

    @size.setter
    def size(self, val):
        val = self._size_validator.validate(val)
        self._size_value = val
        self._size_present = True

    @size.deleter
    def size(self):
        self._size_value = None
        self._size_present = False

    def __repr__(self):
        return 'FileLinkMetadata(url={!r}, name={!r}, link_permissions={!r}, client_modified={!r}, server_modified={!r}, rev={!r}, size={!r}, id={!r}, expires={!r}, path_lower={!r}, team_member_info={!r}, content_owner_team_info={!r})'.format(
            self._url_value,
            self._name_value,
            self._link_permissions_value,
            self._client_modified_value,
            self._server_modified_value,
            self._rev_value,
            self._size_value,
            self._id_value,
            self._expires_value,
            self._path_lower_value,
            self._team_member_info_value,
            self._content_owner_team_info_value,
        )

class FolderAction(object):
    """
    Actions that may be taken on shared folders.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar change_options: Change folder options, such as who can be invited to
        join the folder.
    :ivar edit_contents: Change or edit contents of the folder.
    :ivar invite_editor: Invite a user or group to join the folder with read and
        write permission.
    :ivar invite_viewer: Invite a user or group to join the folder with read
        permission.
    :ivar relinquish_membership: Relinquish one's own membership in the folder.
    :ivar unmount: Unmount the folder.
    :ivar unshare: Stop sharing this folder.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    change_options = None
    # Attribute is overwritten below the class definition
    edit_contents = None
    # Attribute is overwritten below the class definition
    invite_editor = None
    # Attribute is overwritten below the class definition
    invite_viewer = None
    # Attribute is overwritten below the class definition
    relinquish_membership = None
    # Attribute is overwritten below the class definition
    unmount = None
    # Attribute is overwritten below the class definition
    unshare = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_change_options(self):
        """
        Check if the union tag is ``change_options``.

        :rtype: bool
        """
        return self._tag == 'change_options'

    def is_edit_contents(self):
        """
        Check if the union tag is ``edit_contents``.

        :rtype: bool
        """
        return self._tag == 'edit_contents'

    def is_invite_editor(self):
        """
        Check if the union tag is ``invite_editor``.

        :rtype: bool
        """
        return self._tag == 'invite_editor'

    def is_invite_viewer(self):
        """
        Check if the union tag is ``invite_viewer``.

        :rtype: bool
        """
        return self._tag == 'invite_viewer'

    def is_relinquish_membership(self):
        """
        Check if the union tag is ``relinquish_membership``.

        :rtype: bool
        """
        return self._tag == 'relinquish_membership'

    def is_unmount(self):
        """
        Check if the union tag is ``unmount``.

        :rtype: bool
        """
        return self._tag == 'unmount'

    def is_unshare(self):
        """
        Check if the union tag is ``unshare``.

        :rtype: bool
        """
        return self._tag == 'unshare'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'FolderAction(%r, %r)' % (self._tag, self._value)

class FolderLinkMetadata(SharedLinkMetadata):
    """
    The metadata of a folder shared link
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 name=None,
                 link_permissions=None,
                 id=None,
                 expires=None,
                 path_lower=None,
                 team_member_info=None,
                 content_owner_team_info=None):
        super(FolderLinkMetadata, self).__init__(url,
                                                 name,
                                                 link_permissions,
                                                 id,
                                                 expires,
                                                 path_lower,
                                                 team_member_info,
                                                 content_owner_team_info)

    def __repr__(self):
        return 'FolderLinkMetadata(url={!r}, name={!r}, link_permissions={!r}, id={!r}, expires={!r}, path_lower={!r}, team_member_info={!r}, content_owner_team_info={!r})'.format(
            self._url_value,
            self._name_value,
            self._link_permissions_value,
            self._id_value,
            self._expires_value,
            self._path_lower_value,
            self._team_member_info_value,
            self._content_owner_team_info_value,
        )

class FolderPermission(object):
    """
    Whether the user is allowed to take the action on the shared folder.

    :ivar action: The action that the user may wish to take on the folder.
    :ivar allow: True if the user is allowed to take the action.
    :ivar reason: The reason why the user is denied the permission. Not present
        if the action is allowed, or if no reason is available.
    """

    __slots__ = [
        '_action_value',
        '_action_present',
        '_allow_value',
        '_allow_present',
        '_reason_value',
        '_reason_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 action=None,
                 allow=None,
                 reason=None):
        self._action_value = None
        self._action_present = False
        self._allow_value = None
        self._allow_present = False
        self._reason_value = None
        self._reason_present = False
        if action is not None:
            self.action = action
        if allow is not None:
            self.allow = allow
        if reason is not None:
            self.reason = reason

    @property
    def action(self):
        """
        The action that the user may wish to take on the folder.

        :rtype: FolderAction
        """
        if self._action_present:
            return self._action_value
        else:
            raise AttributeError("missing required field 'action'")

    @action.setter
    def action(self, val):
        self._action_validator.validate_type_only(val)
        self._action_value = val
        self._action_present = True

    @action.deleter
    def action(self):
        self._action_value = None
        self._action_present = False

    @property
    def allow(self):
        """
        True if the user is allowed to take the action.

        :rtype: bool
        """
        if self._allow_present:
            return self._allow_value
        else:
            raise AttributeError("missing required field 'allow'")

    @allow.setter
    def allow(self, val):
        val = self._allow_validator.validate(val)
        self._allow_value = val
        self._allow_present = True

    @allow.deleter
    def allow(self):
        self._allow_value = None
        self._allow_present = False

    @property
    def reason(self):
        """
        The reason why the user is denied the permission. Not present if the
        action is allowed, or if no reason is available.

        :rtype: PermissionDeniedReason
        """
        if self._reason_present:
            return self._reason_value
        else:
            return None

    @reason.setter
    def reason(self, val):
        if val is None:
            del self.reason
            return
        self._reason_validator.validate_type_only(val)
        self._reason_value = val
        self._reason_present = True

    @reason.deleter
    def reason(self):
        self._reason_value = None
        self._reason_present = False

    def __repr__(self):
        return 'FolderPermission(action={!r}, allow={!r}, reason={!r})'.format(
            self._action_value,
            self._allow_value,
            self._reason_value,
        )

class FolderPolicy(object):
    """
    A set of policies governing membership and privileges for a shared folder.

    :ivar member_policy: Who can be a member of this shared folder, as set on
        the folder itself. The effective policy may differ from this value if
        the team-wide policy is more restrictive. Present only if the folder is
        owned by a team.
    :ivar resolved_member_policy: Who can be a member of this shared folder,
        taking into account both the folder and the team-wide policy. This value
        may differ from that of member_policy if the team-wide policy is more
        restrictive than the folder policy. Present only if the folder is owned
        by a team.
    :ivar acl_update_policy: Who can add and remove members from this shared
        folder.
    :ivar shared_link_policy: Who links can be shared with.
    """

    __slots__ = [
        '_member_policy_value',
        '_member_policy_present',
        '_resolved_member_policy_value',
        '_resolved_member_policy_present',
        '_acl_update_policy_value',
        '_acl_update_policy_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 acl_update_policy=None,
                 shared_link_policy=None,
                 member_policy=None,
                 resolved_member_policy=None):
        self._member_policy_value = None
        self._member_policy_present = False
        self._resolved_member_policy_value = None
        self._resolved_member_policy_present = False
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        if member_policy is not None:
            self.member_policy = member_policy
        if resolved_member_policy is not None:
            self.resolved_member_policy = resolved_member_policy
        if acl_update_policy is not None:
            self.acl_update_policy = acl_update_policy
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy

    @property
    def member_policy(self):
        """
        Who can be a member of this shared folder, as set on the folder itself.
        The effective policy may differ from this value if the team-wide policy
        is more restrictive. Present only if the folder is owned by a team.

        :rtype: MemberPolicy
        """
        if self._member_policy_present:
            return self._member_policy_value
        else:
            return None

    @member_policy.setter
    def member_policy(self, val):
        if val is None:
            del self.member_policy
            return
        self._member_policy_validator.validate_type_only(val)
        self._member_policy_value = val
        self._member_policy_present = True

    @member_policy.deleter
    def member_policy(self):
        self._member_policy_value = None
        self._member_policy_present = False

    @property
    def resolved_member_policy(self):
        """
        Who can be a member of this shared folder, taking into account both the
        folder and the team-wide policy. This value may differ from that of
        member_policy if the team-wide policy is more restrictive than the
        folder policy. Present only if the folder is owned by a team.

        :rtype: MemberPolicy
        """
        if self._resolved_member_policy_present:
            return self._resolved_member_policy_value
        else:
            return None

    @resolved_member_policy.setter
    def resolved_member_policy(self, val):
        if val is None:
            del self.resolved_member_policy
            return
        self._resolved_member_policy_validator.validate_type_only(val)
        self._resolved_member_policy_value = val
        self._resolved_member_policy_present = True

    @resolved_member_policy.deleter
    def resolved_member_policy(self):
        self._resolved_member_policy_value = None
        self._resolved_member_policy_present = False

    @property
    def acl_update_policy(self):
        """
        Who can add and remove members from this shared folder.

        :rtype: AclUpdatePolicy
        """
        if self._acl_update_policy_present:
            return self._acl_update_policy_value
        else:
            raise AttributeError("missing required field 'acl_update_policy'")

    @acl_update_policy.setter
    def acl_update_policy(self, val):
        self._acl_update_policy_validator.validate_type_only(val)
        self._acl_update_policy_value = val
        self._acl_update_policy_present = True

    @acl_update_policy.deleter
    def acl_update_policy(self):
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False

    @property
    def shared_link_policy(self):
        """
        Who links can be shared with.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            raise AttributeError("missing required field 'shared_link_policy'")

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    def __repr__(self):
        return 'FolderPolicy(acl_update_policy={!r}, shared_link_policy={!r}, member_policy={!r}, resolved_member_policy={!r})'.format(
            self._acl_update_policy_value,
            self._shared_link_policy_value,
            self._member_policy_value,
            self._resolved_member_policy_value,
        )

class GetMetadataArgs(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar actions: Folder actions to query.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_actions_value',
        '_actions_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 actions=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._actions_value = None
        self._actions_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if actions is not None:
            self.actions = actions

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def actions(self):
        """
        Folder actions to query.

        :rtype: list of [FolderAction]
        """
        if self._actions_present:
            return self._actions_value
        else:
            return None

    @actions.setter
    def actions(self, val):
        if val is None:
            del self.actions
            return
        val = self._actions_validator.validate(val)
        self._actions_value = val
        self._actions_present = True

    @actions.deleter
    def actions(self):
        self._actions_value = None
        self._actions_present = False

    def __repr__(self):
        return 'GetMetadataArgs(shared_folder_id={!r}, actions={!r})'.format(
            self._shared_folder_id_value,
            self._actions_value,
        )

class SharedLinkError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar shared_link_not_found: The shared link wasn't found
    :ivar shared_link_access_denied: The caller is not allowed to access this
        shared link
    :ivar other: An unspecified error
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    shared_link_not_found = None
    # Attribute is overwritten below the class definition
    shared_link_access_denied = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_shared_link_not_found(self):
        """
        Check if the union tag is ``shared_link_not_found``.

        :rtype: bool
        """
        return self._tag == 'shared_link_not_found'

    def is_shared_link_access_denied(self):
        """
        Check if the union tag is ``shared_link_access_denied``.

        :rtype: bool
        """
        return self._tag == 'shared_link_access_denied'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedLinkError(%r, %r)' % (self._tag, self._value)

class GetSharedLinkFileError(SharedLinkError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar shared_link_is_directory: Directories cannot be retrieved by this
        endpoint.
    """

    __slots__ = ['_tag', '_value']

    # Attribute is overwritten below the class definition
    shared_link_is_directory = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_shared_link_is_directory(self):
        """
        Check if the union tag is ``shared_link_is_directory``.

        :rtype: bool
        """
        return self._tag == 'shared_link_is_directory'

    def __repr__(self):
        return 'GetSharedLinkFileError(%r, %r)' % (self._tag, self._value)

class GetSharedLinkMetadataArg(object):
    """
    :ivar url: URL of the shared link.
    :ivar path: If the shared link is to a folder, this parameter can be used to
        retrieve the metadata for a specific file or sub-folder in this folder.
        A relative path should be used.
    :ivar link_password: If the shared link has a password, this parameter can
        be used.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_path_value',
        '_path_present',
        '_link_password_value',
        '_link_password_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 path=None,
                 link_password=None):
        self._url_value = None
        self._url_present = False
        self._path_value = None
        self._path_present = False
        self._link_password_value = None
        self._link_password_present = False
        if url is not None:
            self.url = url
        if path is not None:
            self.path = path
        if link_password is not None:
            self.link_password = link_password

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def path(self):
        """
        If the shared link is to a folder, this parameter can be used to
        retrieve the metadata for a specific file or sub-folder in this folder.
        A relative path should be used.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            return None

    @path.setter
    def path(self, val):
        if val is None:
            del self.path
            return
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def link_password(self):
        """
        If the shared link has a password, this parameter can be used.

        :rtype: str
        """
        if self._link_password_present:
            return self._link_password_value
        else:
            return None

    @link_password.setter
    def link_password(self, val):
        if val is None:
            del self.link_password
            return
        val = self._link_password_validator.validate(val)
        self._link_password_value = val
        self._link_password_present = True

    @link_password.deleter
    def link_password(self):
        self._link_password_value = None
        self._link_password_present = False

    def __repr__(self):
        return 'GetSharedLinkMetadataArg(url={!r}, path={!r}, link_password={!r})'.format(
            self._url_value,
            self._path_value,
            self._link_password_value,
        )

class GetSharedLinksArg(object):
    """
    :ivar path: See get_shared_links description.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        See get_shared_links description.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            return None

    @path.setter
    def path(self, val):
        if val is None:
            del self.path
            return
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetSharedLinksArg(path={!r})'.format(
            self._path_value,
        )

class GetSharedLinksError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param Optional[str] val:
        :rtype: GetSharedLinksError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: Optional[str]
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetSharedLinksError(%r, %r)' % (self._tag, self._value)

class GetSharedLinksResult(object):
    """
    :ivar links: Shared links applicable to the path argument.
    """

    __slots__ = [
        '_links_value',
        '_links_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 links=None):
        self._links_value = None
        self._links_present = False
        if links is not None:
            self.links = links

    @property
    def links(self):
        """
        Shared links applicable to the path argument.

        :rtype: list of [LinkMetadata]
        """
        if self._links_present:
            return self._links_value
        else:
            raise AttributeError("missing required field 'links'")

    @links.setter
    def links(self, val):
        val = self._links_validator.validate(val)
        self._links_value = val
        self._links_present = True

    @links.deleter
    def links(self):
        self._links_value = None
        self._links_present = False

    def __repr__(self):
        return 'GetSharedLinksResult(links={!r})'.format(
            self._links_value,
        )

class GroupInfo(team.GroupSummary):
    """
    The information about a group. Groups is a way to manage a list of users
    who need same access permission to the shared folder.

    :ivar group_type: The type of group.
    :ivar same_team: If the group is owned by the current user's team.
    """

    __slots__ = [
        '_group_type_value',
        '_group_type_present',
        '_same_team_value',
        '_same_team_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_name=None,
                 group_id=None,
                 member_count=None,
                 group_type=None,
                 same_team=None,
                 group_external_id=None):
        super(GroupInfo, self).__init__(group_name,
                                        group_id,
                                        member_count,
                                        group_external_id)
        self._group_type_value = None
        self._group_type_present = False
        self._same_team_value = None
        self._same_team_present = False
        if group_type is not None:
            self.group_type = group_type
        if same_team is not None:
            self.same_team = same_team

    @property
    def group_type(self):
        """
        The type of group.

        :rtype: team.GroupType_validator
        """
        if self._group_type_present:
            return self._group_type_value
        else:
            raise AttributeError("missing required field 'group_type'")

    @group_type.setter
    def group_type(self, val):
        self._group_type_validator.validate_type_only(val)
        self._group_type_value = val
        self._group_type_present = True

    @group_type.deleter
    def group_type(self):
        self._group_type_value = None
        self._group_type_present = False

    @property
    def same_team(self):
        """
        If the group is owned by the current user's team.

        :rtype: bool
        """
        if self._same_team_present:
            return self._same_team_value
        else:
            raise AttributeError("missing required field 'same_team'")

    @same_team.setter
    def same_team(self, val):
        val = self._same_team_validator.validate(val)
        self._same_team_value = val
        self._same_team_present = True

    @same_team.deleter
    def same_team(self):
        self._same_team_value = None
        self._same_team_present = False

    def __repr__(self):
        return 'GroupInfo(group_name={!r}, group_id={!r}, member_count={!r}, group_type={!r}, same_team={!r}, group_external_id={!r})'.format(
            self._group_name_value,
            self._group_id_value,
            self._member_count_value,
            self._group_type_value,
            self._same_team_value,
            self._group_external_id_value,
        )

class MembershipInfo(object):
    """
    The information about a member of the shared folder.

    :ivar access_type: The access type for this member.
    :ivar permissions: The permissions that requesting user has on this member.
        The set of permissions corresponds to the MemberActions in the request.
    :ivar initials: Suggested name initials for a member.
    :ivar is_inherited: True if the member's access to the file is inherited
        from a parent folder.
    """

    __slots__ = [
        '_access_type_value',
        '_access_type_present',
        '_permissions_value',
        '_permissions_present',
        '_initials_value',
        '_initials_present',
        '_is_inherited_value',
        '_is_inherited_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 permissions=None,
                 initials=None,
                 is_inherited=None):
        self._access_type_value = None
        self._access_type_present = False
        self._permissions_value = None
        self._permissions_present = False
        self._initials_value = None
        self._initials_present = False
        self._is_inherited_value = None
        self._is_inherited_present = False
        if access_type is not None:
            self.access_type = access_type
        if permissions is not None:
            self.permissions = permissions
        if initials is not None:
            self.initials = initials
        if is_inherited is not None:
            self.is_inherited = is_inherited

    @property
    def access_type(self):
        """
        The access type for this member.

        :rtype: AccessLevel
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    @property
    def permissions(self):
        """
        The permissions that requesting user has on this member. The set of
        permissions corresponds to the MemberActions in the request.

        :rtype: list of [MemberPermission]
        """
        if self._permissions_present:
            return self._permissions_value
        else:
            return None

    @permissions.setter
    def permissions(self, val):
        if val is None:
            del self.permissions
            return
        val = self._permissions_validator.validate(val)
        self._permissions_value = val
        self._permissions_present = True

    @permissions.deleter
    def permissions(self):
        self._permissions_value = None
        self._permissions_present = False

    @property
    def initials(self):
        """
        Suggested name initials for a member.

        :rtype: str
        """
        if self._initials_present:
            return self._initials_value
        else:
            return None

    @initials.setter
    def initials(self, val):
        if val is None:
            del self.initials
            return
        val = self._initials_validator.validate(val)
        self._initials_value = val
        self._initials_present = True

    @initials.deleter
    def initials(self):
        self._initials_value = None
        self._initials_present = False

    @property
    def is_inherited(self):
        """
        True if the member's access to the file is inherited from a parent
        folder.

        :rtype: bool
        """
        if self._is_inherited_present:
            return self._is_inherited_value
        else:
            return False

    @is_inherited.setter
    def is_inherited(self, val):
        val = self._is_inherited_validator.validate(val)
        self._is_inherited_value = val
        self._is_inherited_present = True

    @is_inherited.deleter
    def is_inherited(self):
        self._is_inherited_value = None
        self._is_inherited_present = False

    def __repr__(self):
        return 'MembershipInfo(access_type={!r}, permissions={!r}, initials={!r}, is_inherited={!r})'.format(
            self._access_type_value,
            self._permissions_value,
            self._initials_value,
            self._is_inherited_value,
        )

class GroupMembershipInfo(MembershipInfo):
    """
    The information about a group member of the shared folder.

    :ivar group: The information about the membership group.
    """

    __slots__ = [
        '_group_value',
        '_group_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 group=None,
                 permissions=None,
                 initials=None,
                 is_inherited=None):
        super(GroupMembershipInfo, self).__init__(access_type,
                                                  permissions,
                                                  initials,
                                                  is_inherited)
        self._group_value = None
        self._group_present = False
        if group is not None:
            self.group = group

    @property
    def group(self):
        """
        The information about the membership group.

        :rtype: GroupInfo
        """
        if self._group_present:
            return self._group_value
        else:
            raise AttributeError("missing required field 'group'")

    @group.setter
    def group(self, val):
        self._group_validator.validate_type_only(val)
        self._group_value = val
        self._group_present = True

    @group.deleter
    def group(self):
        self._group_value = None
        self._group_present = False

    def __repr__(self):
        return 'GroupMembershipInfo(access_type={!r}, group={!r}, permissions={!r}, initials={!r}, is_inherited={!r})'.format(
            self._access_type_value,
            self._group_value,
            self._permissions_value,
            self._initials_value,
            self._is_inherited_value,
        )

class InviteeInfo(object):
    """
    The information about a user invited to become a member a shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str email: E-mail address of invited user.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def email(cls, val):
        """
        Create an instance of this class set to the ``email`` tag with value
        ``val``.

        :param str val:
        :rtype: InviteeInfo
        """
        return cls('email', val)

    def is_email(self):
        """
        Check if the union tag is ``email``.

        :rtype: bool
        """
        return self._tag == 'email'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_email(self):
        """
        E-mail address of invited user.

        Only call this if :meth:`is_email` is true.

        :rtype: str
        """
        if not self.is_email():
            raise AttributeError("tag 'email' not set")
        return self._value

    def __repr__(self):
        return 'InviteeInfo(%r, %r)' % (self._tag, self._value)

class InviteeMembershipInfo(MembershipInfo):
    """
    The information about a user invited to become a member of a shared folder.

    :ivar invitee: The information for the invited user.
    """

    __slots__ = [
        '_invitee_value',
        '_invitee_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 invitee=None,
                 permissions=None,
                 initials=None,
                 is_inherited=None):
        super(InviteeMembershipInfo, self).__init__(access_type,
                                                    permissions,
                                                    initials,
                                                    is_inherited)
        self._invitee_value = None
        self._invitee_present = False
        if invitee is not None:
            self.invitee = invitee

    @property
    def invitee(self):
        """
        The information for the invited user.

        :rtype: InviteeInfo
        """
        if self._invitee_present:
            return self._invitee_value
        else:
            raise AttributeError("missing required field 'invitee'")

    @invitee.setter
    def invitee(self, val):
        self._invitee_validator.validate_type_only(val)
        self._invitee_value = val
        self._invitee_present = True

    @invitee.deleter
    def invitee(self):
        self._invitee_value = None
        self._invitee_present = False

    def __repr__(self):
        return 'InviteeMembershipInfo(access_type={!r}, invitee={!r}, permissions={!r}, initials={!r}, is_inherited={!r})'.format(
            self._access_type_value,
            self._invitee_value,
            self._permissions_value,
            self._initials_value,
            self._is_inherited_value,
        )

class JobError(object):
    """
    Error occurred while performing an asynchronous job from unshare_folder or
    remove_folder_member.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UnshareFolderError unshare_folder_error: Error occurred while
        performing unshare_folder action.
    :ivar RemoveFolderMemberError remove_folder_member_error: Error occurred
        while performing remove_folder_member action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def unshare_folder_error(cls, val):
        """
        Create an instance of this class set to the ``unshare_folder_error`` tag
        with value ``val``.

        :param UnshareFolderError val:
        :rtype: JobError
        """
        return cls('unshare_folder_error', val)

    @classmethod
    def remove_folder_member_error(cls, val):
        """
        Create an instance of this class set to the
        ``remove_folder_member_error`` tag with value ``val``.

        :param RemoveFolderMemberError val:
        :rtype: JobError
        """
        return cls('remove_folder_member_error', val)

    def is_unshare_folder_error(self):
        """
        Check if the union tag is ``unshare_folder_error``.

        :rtype: bool
        """
        return self._tag == 'unshare_folder_error'

    def is_remove_folder_member_error(self):
        """
        Check if the union tag is ``remove_folder_member_error``.

        :rtype: bool
        """
        return self._tag == 'remove_folder_member_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_unshare_folder_error(self):
        """
        Error occurred while performing unshare_folder action.

        Only call this if :meth:`is_unshare_folder_error` is true.

        :rtype: UnshareFolderError
        """
        if not self.is_unshare_folder_error():
            raise AttributeError("tag 'unshare_folder_error' not set")
        return self._value

    def get_remove_folder_member_error(self):
        """
        Error occurred while performing remove_folder_member action.

        Only call this if :meth:`is_remove_folder_member_error` is true.

        :rtype: RemoveFolderMemberError
        """
        if not self.is_remove_folder_member_error():
            raise AttributeError("tag 'remove_folder_member_error' not set")
        return self._value

    def __repr__(self):
        return 'JobError(%r, %r)' % (self._tag, self._value)

class JobStatus(async.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar complete: The asynchronous job has finished.
    :ivar JobError failed: The asynchronous job returned an error.
    """

    __slots__ = ['_tag', '_value']

    # Attribute is overwritten below the class definition
    complete = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param JobError val:
        :rtype: JobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_failed(self):
        """
        The asynchronous job returned an error.

        Only call this if :meth:`is_failed` is true.

        :rtype: JobError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'JobStatus(%r, %r)' % (self._tag, self._value)

class LinkPermissions(object):
    """
    :ivar resolved_visibility: The current visibility of the link after
        considering the shared links policies of the the team (in case the
        link's owner is part of a team) and the shared folder (in case the
        linked file is part of a shared folder). This field is shown only if the
        caller has access to this info (the link's owner always has access to
        this data).
    :ivar requested_visibility: The shared link's requested visibility. This can
        be overridden by the team and shared folder policies. The final
        visibility, after considering these policies, can be found in
        ``resolved_visibility``. This is shown only if the caller is the link's
        owner.
    :ivar can_revoke: Whether the caller can revoke the shared link
    :ivar revoke_failure_reason: The failure reason for revoking the link. This
        field will only be present if the ``can_revoke`` is ``False``.
    """

    __slots__ = [
        '_resolved_visibility_value',
        '_resolved_visibility_present',
        '_requested_visibility_value',
        '_requested_visibility_present',
        '_can_revoke_value',
        '_can_revoke_present',
        '_revoke_failure_reason_value',
        '_revoke_failure_reason_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 can_revoke=None,
                 resolved_visibility=None,
                 requested_visibility=None,
                 revoke_failure_reason=None):
        self._resolved_visibility_value = None
        self._resolved_visibility_present = False
        self._requested_visibility_value = None
        self._requested_visibility_present = False
        self._can_revoke_value = None
        self._can_revoke_present = False
        self._revoke_failure_reason_value = None
        self._revoke_failure_reason_present = False
        if resolved_visibility is not None:
            self.resolved_visibility = resolved_visibility
        if requested_visibility is not None:
            self.requested_visibility = requested_visibility
        if can_revoke is not None:
            self.can_revoke = can_revoke
        if revoke_failure_reason is not None:
            self.revoke_failure_reason = revoke_failure_reason

    @property
    def resolved_visibility(self):
        """
        The current visibility of the link after considering the shared links
        policies of the the team (in case the link's owner is part of a team)
        and the shared folder (in case the linked file is part of a shared
        folder). This field is shown only if the caller has access to this info
        (the link's owner always has access to this data).

        :rtype: ResolvedVisibility
        """
        if self._resolved_visibility_present:
            return self._resolved_visibility_value
        else:
            return None

    @resolved_visibility.setter
    def resolved_visibility(self, val):
        if val is None:
            del self.resolved_visibility
            return
        self._resolved_visibility_validator.validate_type_only(val)
        self._resolved_visibility_value = val
        self._resolved_visibility_present = True

    @resolved_visibility.deleter
    def resolved_visibility(self):
        self._resolved_visibility_value = None
        self._resolved_visibility_present = False

    @property
    def requested_visibility(self):
        """
        The shared link's requested visibility. This can be overridden by the
        team and shared folder policies. The final visibility, after considering
        these policies, can be found in ``resolved_visibility``. This is shown
        only if the caller is the link's owner.

        :rtype: RequestedVisibility
        """
        if self._requested_visibility_present:
            return self._requested_visibility_value
        else:
            return None

    @requested_visibility.setter
    def requested_visibility(self, val):
        if val is None:
            del self.requested_visibility
            return
        self._requested_visibility_validator.validate_type_only(val)
        self._requested_visibility_value = val
        self._requested_visibility_present = True

    @requested_visibility.deleter
    def requested_visibility(self):
        self._requested_visibility_value = None
        self._requested_visibility_present = False

    @property
    def can_revoke(self):
        """
        Whether the caller can revoke the shared link

        :rtype: bool
        """
        if self._can_revoke_present:
            return self._can_revoke_value
        else:
            raise AttributeError("missing required field 'can_revoke'")

    @can_revoke.setter
    def can_revoke(self, val):
        val = self._can_revoke_validator.validate(val)
        self._can_revoke_value = val
        self._can_revoke_present = True

    @can_revoke.deleter
    def can_revoke(self):
        self._can_revoke_value = None
        self._can_revoke_present = False

    @property
    def revoke_failure_reason(self):
        """
        The failure reason for revoking the link. This field will only be
        present if the ``can_revoke`` is ``False``.

        :rtype: SharedLinkAccessFailureReason
        """
        if self._revoke_failure_reason_present:
            return self._revoke_failure_reason_value
        else:
            return None

    @revoke_failure_reason.setter
    def revoke_failure_reason(self, val):
        if val is None:
            del self.revoke_failure_reason
            return
        self._revoke_failure_reason_validator.validate_type_only(val)
        self._revoke_failure_reason_value = val
        self._revoke_failure_reason_present = True

    @revoke_failure_reason.deleter
    def revoke_failure_reason(self):
        self._revoke_failure_reason_value = None
        self._revoke_failure_reason_present = False

    def __repr__(self):
        return 'LinkPermissions(can_revoke={!r}, resolved_visibility={!r}, requested_visibility={!r}, revoke_failure_reason={!r})'.format(
            self._can_revoke_value,
            self._resolved_visibility_value,
            self._requested_visibility_value,
            self._revoke_failure_reason_value,
        )

class ListFolderMembersCursorArg(object):
    """
    :ivar actions: Member actions to query.
    :ivar limit: The maximum number of results that include members, groups and
        invitees to return per request.
    """

    __slots__ = [
        '_actions_value',
        '_actions_present',
        '_limit_value',
        '_limit_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 actions=None,
                 limit=None):
        self._actions_value = None
        self._actions_present = False
        self._limit_value = None
        self._limit_present = False
        if actions is not None:
            self.actions = actions
        if limit is not None:
            self.limit = limit

    @property
    def actions(self):
        """
        Member actions to query.

        :rtype: list of [MemberAction]
        """
        if self._actions_present:
            return self._actions_value
        else:
            return None

    @actions.setter
    def actions(self, val):
        if val is None:
            del self.actions
            return
        val = self._actions_validator.validate(val)
        self._actions_value = val
        self._actions_present = True

    @actions.deleter
    def actions(self):
        self._actions_value = None
        self._actions_present = False

    @property
    def limit(self):
        """
        The maximum number of results that include members, groups and invitees
        to return per request.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    def __repr__(self):
        return 'ListFolderMembersCursorArg(actions={!r}, limit={!r})'.format(
            self._actions_value,
            self._limit_value,
        )

class ListFolderMembersArgs(ListFolderMembersCursorArg):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 actions=None,
                 limit=None):
        super(ListFolderMembersArgs, self).__init__(actions,
                                                    limit)
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'ListFolderMembersArgs(shared_folder_id={!r}, actions={!r}, limit={!r})'.format(
            self._shared_folder_id_value,
            self._actions_value,
            self._limit_value,
        )

class ListFolderMembersContinueArg(object):
    """
    :ivar cursor: The cursor returned by your last call to list_folder_members
        or list_folder_members/continue.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by your last call to list_folder_members or
        list_folder_members/continue.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFolderMembersContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

class ListFolderMembersContinueError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_cursor: ``ListFolderMembersContinueArg.cursor`` is invalid.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_cursor = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: ListFolderMembersContinueError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_invalid_cursor(self):
        """
        Check if the union tag is ``invalid_cursor``.

        :rtype: bool
        """
        return self._tag == 'invalid_cursor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'ListFolderMembersContinueError(%r, %r)' % (self._tag, self._value)

class ListFoldersArgs(object):
    """
    :ivar limit: The maximum number of results to return per request.
    :ivar actions: Folder actions to query.
    """

    __slots__ = [
        '_limit_value',
        '_limit_present',
        '_actions_value',
        '_actions_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 limit=None,
                 actions=None):
        self._limit_value = None
        self._limit_present = False
        self._actions_value = None
        self._actions_present = False
        if limit is not None:
            self.limit = limit
        if actions is not None:
            self.actions = actions

    @property
    def limit(self):
        """
        The maximum number of results to return per request.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    @property
    def actions(self):
        """
        Folder actions to query.

        :rtype: list of [FolderAction]
        """
        if self._actions_present:
            return self._actions_value
        else:
            return None

    @actions.setter
    def actions(self, val):
        if val is None:
            del self.actions
            return
        val = self._actions_validator.validate(val)
        self._actions_value = val
        self._actions_present = True

    @actions.deleter
    def actions(self):
        self._actions_value = None
        self._actions_present = False

    def __repr__(self):
        return 'ListFoldersArgs(limit={!r}, actions={!r})'.format(
            self._limit_value,
            self._actions_value,
        )

class ListFoldersContinueArg(object):
    """
    :ivar cursor: The cursor returned by the previous API call specified in the
        endpoint description.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by the previous API call specified in the endpoint
        description.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFoldersContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

class ListFoldersContinueError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_cursor: ``ListFoldersContinueArg.cursor`` is invalid.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_cursor = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_cursor(self):
        """
        Check if the union tag is ``invalid_cursor``.

        :rtype: bool
        """
        return self._tag == 'invalid_cursor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ListFoldersContinueError(%r, %r)' % (self._tag, self._value)

class ListFoldersResult(object):
    """
    Result for list_folders or list_mountable_folders, depending on which
    endpoint was requested. Unmounted shared folders can be identified by the
    absence of ``SharedFolderMetadata.path_lower``.

    :ivar entries: List of all shared folders the authenticated user has access
        to.
    :ivar cursor: Present if there are additional shared folders that have not
        been returned yet. Pass the cursor into the corresponding continue
        endpoint (either list_folders/continue or
        list_mountable_folders/continue) to list additional folders.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None,
                 cursor=None):
        self._entries_value = None
        self._entries_present = False
        self._cursor_value = None
        self._cursor_present = False
        if entries is not None:
            self.entries = entries
        if cursor is not None:
            self.cursor = cursor

    @property
    def entries(self):
        """
        List of all shared folders the authenticated user has access to.

        :rtype: list of [SharedFolderMetadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    @property
    def cursor(self):
        """
        Present if there are additional shared folders that have not been
        returned yet. Pass the cursor into the corresponding continue endpoint
        (either list_folders/continue or list_mountable_folders/continue) to
        list additional folders.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFoldersResult(entries={!r}, cursor={!r})'.format(
            self._entries_value,
            self._cursor_value,
        )

class ListSharedLinksArg(object):
    """
    :ivar path: See list_shared_links description.
    :ivar cursor: The cursor returned by your last call to list_shared_links.
    :ivar direct_only: See list_shared_links description.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_cursor_value',
        '_cursor_present',
        '_direct_only_value',
        '_direct_only_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 path=None,
                 cursor=None,
                 direct_only=None):
        self._path_value = None
        self._path_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._direct_only_value = None
        self._direct_only_present = False
        if path is not None:
            self.path = path
        if cursor is not None:
            self.cursor = cursor
        if direct_only is not None:
            self.direct_only = direct_only

    @property
    def path(self):
        """
        See list_shared_links description.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            return None

    @path.setter
    def path(self, val):
        if val is None:
            del self.path
            return
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def cursor(self):
        """
        The cursor returned by your last call to list_shared_links.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def direct_only(self):
        """
        See list_shared_links description.

        :rtype: bool
        """
        if self._direct_only_present:
            return self._direct_only_value
        else:
            return None

    @direct_only.setter
    def direct_only(self, val):
        if val is None:
            del self.direct_only
            return
        val = self._direct_only_validator.validate(val)
        self._direct_only_value = val
        self._direct_only_present = True

    @direct_only.deleter
    def direct_only(self):
        self._direct_only_value = None
        self._direct_only_present = False

    def __repr__(self):
        return 'ListSharedLinksArg(path={!r}, cursor={!r}, direct_only={!r})'.format(
            self._path_value,
            self._cursor_value,
            self._direct_only_value,
        )

class ListSharedLinksError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar reset: Indicates that the cursor has been invalidated. Call
        list_shared_links to obtain a new cursor.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param files.LookupError_validator val:
        :rtype: ListSharedLinksError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: files.LookupError_validator
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListSharedLinksError(%r, %r)' % (self._tag, self._value)

class ListSharedLinksResult(object):
    """
    :ivar links: Shared links applicable to the path argument.
    :ivar has_more: Is true if there are additional shared links that have not
        been returned yet. Pass the cursor into list_shared_links to retrieve
        them.
    :ivar cursor: Pass the cursor into list_shared_links to obtain the
        additional links. Cursor is returned only if no path is given or the
        path is empty.
    """

    __slots__ = [
        '_links_value',
        '_links_present',
        '_has_more_value',
        '_has_more_present',
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 links=None,
                 has_more=None,
                 cursor=None):
        self._links_value = None
        self._links_present = False
        self._has_more_value = None
        self._has_more_present = False
        self._cursor_value = None
        self._cursor_present = False
        if links is not None:
            self.links = links
        if has_more is not None:
            self.has_more = has_more
        if cursor is not None:
            self.cursor = cursor

    @property
    def links(self):
        """
        Shared links applicable to the path argument.

        :rtype: list of [SharedLinkMetadata]
        """
        if self._links_present:
            return self._links_value
        else:
            raise AttributeError("missing required field 'links'")

    @links.setter
    def links(self, val):
        val = self._links_validator.validate(val)
        self._links_value = val
        self._links_present = True

    @links.deleter
    def links(self):
        self._links_value = None
        self._links_present = False

    @property
    def has_more(self):
        """
        Is true if there are additional shared links that have not been returned
        yet. Pass the cursor into list_shared_links to retrieve them.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into list_shared_links to obtain the additional links.
        Cursor is returned only if no path is given or the path is empty.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListSharedLinksResult(links={!r}, has_more={!r}, cursor={!r})'.format(
            self._links_value,
            self._has_more_value,
            self._cursor_value,
        )

class MemberAction(object):
    """
    Actions that may be taken on members of a shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar make_editor: Make the member an editor of the folder.
    :ivar make_owner: Make the member an owner of the folder.
    :ivar make_viewer: Make the member a viewer of the folder.
    :ivar remove: Remove the member from the folder.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    make_editor = None
    # Attribute is overwritten below the class definition
    make_owner = None
    # Attribute is overwritten below the class definition
    make_viewer = None
    # Attribute is overwritten below the class definition
    remove = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_make_editor(self):
        """
        Check if the union tag is ``make_editor``.

        :rtype: bool
        """
        return self._tag == 'make_editor'

    def is_make_owner(self):
        """
        Check if the union tag is ``make_owner``.

        :rtype: bool
        """
        return self._tag == 'make_owner'

    def is_make_viewer(self):
        """
        Check if the union tag is ``make_viewer``.

        :rtype: bool
        """
        return self._tag == 'make_viewer'

    def is_remove(self):
        """
        Check if the union tag is ``remove``.

        :rtype: bool
        """
        return self._tag == 'remove'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'MemberAction(%r, %r)' % (self._tag, self._value)

class MemberPermission(object):
    """
    Whether the user is allowed to take the action on the associated member.

    :ivar action: The action that the user may wish to take on the member.
    :ivar allow: True if the user is allowed to take the action.
    :ivar reason: The reason why the user is denied the permission. Not present
        if the action is allowed
    """

    __slots__ = [
        '_action_value',
        '_action_present',
        '_allow_value',
        '_allow_present',
        '_reason_value',
        '_reason_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 action=None,
                 allow=None,
                 reason=None):
        self._action_value = None
        self._action_present = False
        self._allow_value = None
        self._allow_present = False
        self._reason_value = None
        self._reason_present = False
        if action is not None:
            self.action = action
        if allow is not None:
            self.allow = allow
        if reason is not None:
            self.reason = reason

    @property
    def action(self):
        """
        The action that the user may wish to take on the member.

        :rtype: MemberAction
        """
        if self._action_present:
            return self._action_value
        else:
            raise AttributeError("missing required field 'action'")

    @action.setter
    def action(self, val):
        self._action_validator.validate_type_only(val)
        self._action_value = val
        self._action_present = True

    @action.deleter
    def action(self):
        self._action_value = None
        self._action_present = False

    @property
    def allow(self):
        """
        True if the user is allowed to take the action.

        :rtype: bool
        """
        if self._allow_present:
            return self._allow_value
        else:
            raise AttributeError("missing required field 'allow'")

    @allow.setter
    def allow(self, val):
        val = self._allow_validator.validate(val)
        self._allow_value = val
        self._allow_present = True

    @allow.deleter
    def allow(self):
        self._allow_value = None
        self._allow_present = False

    @property
    def reason(self):
        """
        The reason why the user is denied the permission. Not present if the
        action is allowed

        :rtype: PermissionDeniedReason
        """
        if self._reason_present:
            return self._reason_value
        else:
            return None

    @reason.setter
    def reason(self, val):
        if val is None:
            del self.reason
            return
        self._reason_validator.validate_type_only(val)
        self._reason_value = val
        self._reason_present = True

    @reason.deleter
    def reason(self):
        self._reason_value = None
        self._reason_present = False

    def __repr__(self):
        return 'MemberPermission(action={!r}, allow={!r}, reason={!r})'.format(
            self._action_value,
            self._allow_value,
            self._reason_value,
        )

class MemberPolicy(object):
    """
    Policy governing who can be a member of a shared folder. Only applicable to
    folders owned by a user on a team.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team: Only a teammate can become a member.
    :ivar anyone: Anyone can become a member.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    anyone = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_anyone(self):
        """
        Check if the union tag is ``anyone``.

        :rtype: bool
        """
        return self._tag == 'anyone'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'MemberPolicy(%r, %r)' % (self._tag, self._value)

class MemberSelector(object):
    """
    Includes different ways to identify a member of a shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str dropbox_id: Dropbox account, team member, or group ID of member.
    :ivar str email: E-mail address of member.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def dropbox_id(cls, val):
        """
        Create an instance of this class set to the ``dropbox_id`` tag with
        value ``val``.

        :param str val:
        :rtype: MemberSelector
        """
        return cls('dropbox_id', val)

    @classmethod
    def email(cls, val):
        """
        Create an instance of this class set to the ``email`` tag with value
        ``val``.

        :param str val:
        :rtype: MemberSelector
        """
        return cls('email', val)

    def is_dropbox_id(self):
        """
        Check if the union tag is ``dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'dropbox_id'

    def is_email(self):
        """
        Check if the union tag is ``email``.

        :rtype: bool
        """
        return self._tag == 'email'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_dropbox_id(self):
        """
        Dropbox account, team member, or group ID of member.

        Only call this if :meth:`is_dropbox_id` is true.

        :rtype: str
        """
        if not self.is_dropbox_id():
            raise AttributeError("tag 'dropbox_id' not set")
        return self._value

    def get_email(self):
        """
        E-mail address of member.

        Only call this if :meth:`is_email` is true.

        :rtype: str
        """
        if not self.is_email():
            raise AttributeError("tag 'email' not set")
        return self._value

    def __repr__(self):
        return 'MemberSelector(%r, %r)' % (self._tag, self._value)

class ModifySharedLinkSettingsArgs(object):
    """
    :ivar url: URL of the shared link to change its settings
    :ivar settings: Set of settings for the shared link.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_settings_value',
        '_settings_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 settings=None):
        self._url_value = None
        self._url_present = False
        self._settings_value = None
        self._settings_present = False
        if url is not None:
            self.url = url
        if settings is not None:
            self.settings = settings

    @property
    def url(self):
        """
        URL of the shared link to change its settings

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def settings(self):
        """
        Set of settings for the shared link.

        :rtype: SharedLinkSettings
        """
        if self._settings_present:
            return self._settings_value
        else:
            raise AttributeError("missing required field 'settings'")

    @settings.setter
    def settings(self, val):
        self._settings_validator.validate_type_only(val)
        self._settings_value = val
        self._settings_present = True

    @settings.deleter
    def settings(self):
        self._settings_value = None
        self._settings_present = False

    def __repr__(self):
        return 'ModifySharedLinkSettingsArgs(url={!r}, settings={!r})'.format(
            self._url_value,
            self._settings_value,
        )

class ModifySharedLinkSettingsError(SharedLinkError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SharedLinkSettingsError settings_error: There is an error with the
        given settings
    :ivar email_not_verified: The caller's email should be verified
    """

    __slots__ = ['_tag', '_value']

    # Attribute is overwritten below the class definition
    email_not_verified = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def settings_error(cls, val):
        """
        Create an instance of this class set to the ``settings_error`` tag with
        value ``val``.

        :param SharedLinkSettingsError val:
        :rtype: ModifySharedLinkSettingsError
        """
        return cls('settings_error', val)

    def is_settings_error(self):
        """
        Check if the union tag is ``settings_error``.

        :rtype: bool
        """
        return self._tag == 'settings_error'

    def is_email_not_verified(self):
        """
        Check if the union tag is ``email_not_verified``.

        :rtype: bool
        """
        return self._tag == 'email_not_verified'

    def get_settings_error(self):
        """
        There is an error with the given settings

        Only call this if :meth:`is_settings_error` is true.

        :rtype: SharedLinkSettingsError
        """
        if not self.is_settings_error():
            raise AttributeError("tag 'settings_error' not set")
        return self._value

    def __repr__(self):
        return 'ModifySharedLinkSettingsError(%r, %r)' % (self._tag, self._value)

class MountFolderArg(object):
    """
    :ivar shared_folder_id: The ID of the shared folder to mount.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID of the shared folder to mount.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'MountFolderArg(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class MountFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar inside_shared_folder: Mounting would cause a shared folder to be
        inside another, which is disallowed.
    :ivar insufficient_quota: The current user does not have enough space to
        mount the shared folder.
    :ivar already_mounted: The shared folder is already mounted.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    :ivar not_mountable: The shared folder is not mountable. One example where
        this can occur is when the shared folder belongs within a team folder in
        the user's Dropbox.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    inside_shared_folder = None
    # Attribute is overwritten below the class definition
    insufficient_quota = None
    # Attribute is overwritten below the class definition
    already_mounted = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    not_mountable = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: MountFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_inside_shared_folder(self):
        """
        Check if the union tag is ``inside_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'inside_shared_folder'

    def is_insufficient_quota(self):
        """
        Check if the union tag is ``insufficient_quota``.

        :rtype: bool
        """
        return self._tag == 'insufficient_quota'

    def is_already_mounted(self):
        """
        Check if the union tag is ``already_mounted``.

        :rtype: bool
        """
        return self._tag == 'already_mounted'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_not_mountable(self):
        """
        Check if the union tag is ``not_mountable``.

        :rtype: bool
        """
        return self._tag == 'not_mountable'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'MountFolderError(%r, %r)' % (self._tag, self._value)

class PathLinkMetadata(LinkMetadata):
    """
    Metadata for a path-based shared link.

    :ivar path: Path in user's Dropbox.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 visibility=None,
                 path=None,
                 expires=None):
        super(PathLinkMetadata, self).__init__(url,
                                               visibility,
                                               expires)
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        Path in user's Dropbox.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'PathLinkMetadata(url={!r}, visibility={!r}, path={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._path_value,
            self._expires_value,
        )

class PendingUploadMode(object):
    """
    Flag to indicate pending upload default (for linking to not-yet-existing
    paths).

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar file: Assume pending uploads are files.
    :ivar folder: Assume pending uploads are folders.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    file = None
    # Attribute is overwritten below the class definition
    folder = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def __repr__(self):
        return 'PendingUploadMode(%r, %r)' % (self._tag, self._value)

class PermissionDeniedReason(object):
    """
    Possible reasons the user is denied a permission.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar user_not_same_team_as_owner: User is not on the same team as the
        folder owner.
    :ivar user_not_allowed_by_owner: User is prohibited by the owner from taking
        the action.
    :ivar target_is_indirect_member: Target is indirectly a member of the
        folder, for example by being part of a group.
    :ivar target_is_owner: Target is the owner of the folder.
    :ivar target_is_self: Target is the user itself.
    :ivar target_not_active: Target is not an active member of the team.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    user_not_same_team_as_owner = None
    # Attribute is overwritten below the class definition
    user_not_allowed_by_owner = None
    # Attribute is overwritten below the class definition
    target_is_indirect_member = None
    # Attribute is overwritten below the class definition
    target_is_owner = None
    # Attribute is overwritten below the class definition
    target_is_self = None
    # Attribute is overwritten below the class definition
    target_not_active = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_user_not_same_team_as_owner(self):
        """
        Check if the union tag is ``user_not_same_team_as_owner``.

        :rtype: bool
        """
        return self._tag == 'user_not_same_team_as_owner'

    def is_user_not_allowed_by_owner(self):
        """
        Check if the union tag is ``user_not_allowed_by_owner``.

        :rtype: bool
        """
        return self._tag == 'user_not_allowed_by_owner'

    def is_target_is_indirect_member(self):
        """
        Check if the union tag is ``target_is_indirect_member``.

        :rtype: bool
        """
        return self._tag == 'target_is_indirect_member'

    def is_target_is_owner(self):
        """
        Check if the union tag is ``target_is_owner``.

        :rtype: bool
        """
        return self._tag == 'target_is_owner'

    def is_target_is_self(self):
        """
        Check if the union tag is ``target_is_self``.

        :rtype: bool
        """
        return self._tag == 'target_is_self'

    def is_target_not_active(self):
        """
        Check if the union tag is ``target_not_active``.

        :rtype: bool
        """
        return self._tag == 'target_not_active'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PermissionDeniedReason(%r, %r)' % (self._tag, self._value)

class RelinquishFolderMembershipArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'RelinquishFolderMembershipArg(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class RelinquishFolderMembershipError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar folder_owner: The current user is the owner of the shared folder.
        Owners cannot relinquish membership to their own folders. Try unsharing
        or transferring ownership first.
    :ivar mounted: The shared folder is currently mounted.  Unmount the shared
        folder before relinquishing membership.
    :ivar group_access: The current user has access to the shared folder via a
        group.  You can't relinquish membership to folders shared via groups.
    :ivar team_folder: This action cannot be performed on a team shared folder.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    folder_owner = None
    # Attribute is overwritten below the class definition
    mounted = None
    # Attribute is overwritten below the class definition
    group_access = None
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: RelinquishFolderMembershipError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_folder_owner(self):
        """
        Check if the union tag is ``folder_owner``.

        :rtype: bool
        """
        return self._tag == 'folder_owner'

    def is_mounted(self):
        """
        Check if the union tag is ``mounted``.

        :rtype: bool
        """
        return self._tag == 'mounted'

    def is_group_access(self):
        """
        Check if the union tag is ``group_access``.

        :rtype: bool
        """
        return self._tag == 'group_access'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'RelinquishFolderMembershipError(%r, %r)' % (self._tag, self._value)

class RemoveFolderMemberArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar member: The member to remove from the folder.
    :ivar leave_a_copy: If true, the removed user will keep their copy of the
        folder after it's unshared, assuming it was mounted. Otherwise, it will
        be removed from their Dropbox. Also, this must be set to false when
        kicking a group.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_member_value',
        '_member_present',
        '_leave_a_copy_value',
        '_leave_a_copy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 member=None,
                 leave_a_copy=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._member_value = None
        self._member_present = False
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if member is not None:
            self.member = member
        if leave_a_copy is not None:
            self.leave_a_copy = leave_a_copy

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def member(self):
        """
        The member to remove from the folder.

        :rtype: MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def leave_a_copy(self):
        """
        If true, the removed user will keep their copy of the folder after it's
        unshared, assuming it was mounted. Otherwise, it will be removed from
        their Dropbox. Also, this must be set to false when kicking a group.

        :rtype: bool
        """
        if self._leave_a_copy_present:
            return self._leave_a_copy_value
        else:
            raise AttributeError("missing required field 'leave_a_copy'")

    @leave_a_copy.setter
    def leave_a_copy(self, val):
        val = self._leave_a_copy_validator.validate(val)
        self._leave_a_copy_value = val
        self._leave_a_copy_present = True

    @leave_a_copy.deleter
    def leave_a_copy(self):
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False

    def __repr__(self):
        return 'RemoveFolderMemberArg(shared_folder_id={!r}, member={!r}, leave_a_copy={!r})'.format(
            self._shared_folder_id_value,
            self._member_value,
            self._leave_a_copy_value,
        )

class RemoveFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar folder_owner: The target user is the owner of the shared folder. You
        can't remove this user until ownership has been transferred to another
        member.
    :ivar group_access: The target user has access to the shared folder via a
        group.
    :ivar team_folder: This action cannot be performed on a team shared folder.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    folder_owner = None
    # Attribute is overwritten below the class definition
    group_access = None
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: RemoveFolderMemberError
        """
        return cls('access_error', val)

    @classmethod
    def member_error(cls, val):
        """
        Create an instance of this class set to the ``member_error`` tag with
        value ``val``.

        :param SharedFolderMemberError val:
        :rtype: RemoveFolderMemberError
        """
        return cls('member_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_member_error(self):
        """
        Check if the union tag is ``member_error``.

        :rtype: bool
        """
        return self._tag == 'member_error'

    def is_folder_owner(self):
        """
        Check if the union tag is ``folder_owner``.

        :rtype: bool
        """
        return self._tag == 'folder_owner'

    def is_group_access(self):
        """
        Check if the union tag is ``group_access``.

        :rtype: bool
        """
        return self._tag == 'group_access'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def get_member_error(self):
        """
        Only call this if :meth:`is_member_error` is true.

        :rtype: SharedFolderMemberError
        """
        if not self.is_member_error():
            raise AttributeError("tag 'member_error' not set")
        return self._value

    def __repr__(self):
        return 'RemoveFolderMemberError(%r, %r)' % (self._tag, self._value)

class RequestedVisibility(object):
    """
    The access permission that can be requested by the caller for the shared
    link. Note that the final resolved visibility of the shared link takes into
    account other aspects, such as team and shared folder settings. Check the
    :class:`ResolvedVisibility` for more info on the possible resolved
    visibility values of shared links.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar public: Anyone who has received the link can access it. No login
        required.
    :ivar team_only: Only members of the same team can access the link. Login is
        required.
    :ivar password: A link-specific password is required to access the link.
        Login is not required.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    public = None
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    password = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_public(self):
        """
        Check if the union tag is ``public``.

        :rtype: bool
        """
        return self._tag == 'public'

    def is_team_only(self):
        """
        Check if the union tag is ``team_only``.

        :rtype: bool
        """
        return self._tag == 'team_only'

    def is_password(self):
        """
        Check if the union tag is ``password``.

        :rtype: bool
        """
        return self._tag == 'password'

    def __repr__(self):
        return 'RequestedVisibility(%r, %r)' % (self._tag, self._value)

class ResolvedVisibility(RequestedVisibility):
    """
    The actual access permissions values of shared links after taking into
    account user preferences and the team and shared folder settings. Check the
    :class:`RequestedVisibility` for more info on the possible visibility values
    that can be set by the shared link's owner.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team_and_password: Only members of the same team who have the
        link-specific password can access the link. Login is required.
    :ivar shared_folder_only: Only members of the shared folder containing the
        linked file can access the link. Login is required.
    :ivar other: An unknown restriction is in place.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team_and_password = None
    # Attribute is overwritten below the class definition
    shared_folder_only = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_team_and_password(self):
        """
        Check if the union tag is ``team_and_password``.

        :rtype: bool
        """
        return self._tag == 'team_and_password'

    def is_shared_folder_only(self):
        """
        Check if the union tag is ``shared_folder_only``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_only'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ResolvedVisibility(%r, %r)' % (self._tag, self._value)

class RevokeSharedLinkArg(object):
    """
    :ivar url: URL of the shared link.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None):
        self._url_value = None
        self._url_present = False
        if url is not None:
            self.url = url

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    def __repr__(self):
        return 'RevokeSharedLinkArg(url={!r})'.format(
            self._url_value,
        )

class RevokeSharedLinkError(SharedLinkError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar shared_link_malformed: Shared link is malformed.
    """

    __slots__ = ['_tag', '_value']

    # Attribute is overwritten below the class definition
    shared_link_malformed = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_shared_link_malformed(self):
        """
        Check if the union tag is ``shared_link_malformed``.

        :rtype: bool
        """
        return self._tag == 'shared_link_malformed'

    def __repr__(self):
        return 'RevokeSharedLinkError(%r, %r)' % (self._tag, self._value)

class ShareFolderArg(object):
    """
    :ivar path: The path to the folder to share. If it does not exist, then a
        new one is created.
    :ivar member_policy: Who can be a member of this shared folder. Only
        applicable if the current user is on a team.
    :ivar acl_update_policy: Who can add and remove members of this shared
        folder.
    :ivar shared_link_policy: The policy to apply to shared links created for
        content inside this shared folder.  The current user must be on a team
        to set this policy to ``SharedLinkPolicy.members``.
    :ivar force_async: Whether to force the share to happen asynchronously.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_member_policy_value',
        '_member_policy_present',
        '_acl_update_policy_value',
        '_acl_update_policy_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
        '_force_async_value',
        '_force_async_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 member_policy=None,
                 acl_update_policy=None,
                 shared_link_policy=None,
                 force_async=None):
        self._path_value = None
        self._path_present = False
        self._member_policy_value = None
        self._member_policy_present = False
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        self._force_async_value = None
        self._force_async_present = False
        if path is not None:
            self.path = path
        if member_policy is not None:
            self.member_policy = member_policy
        if acl_update_policy is not None:
            self.acl_update_policy = acl_update_policy
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy
        if force_async is not None:
            self.force_async = force_async

    @property
    def path(self):
        """
        The path to the folder to share. If it does not exist, then a new one is
        created.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def member_policy(self):
        """
        Who can be a member of this shared folder. Only applicable if the
        current user is on a team.

        :rtype: MemberPolicy
        """
        if self._member_policy_present:
            return self._member_policy_value
        else:
            return MemberPolicy.anyone

    @member_policy.setter
    def member_policy(self, val):
        self._member_policy_validator.validate_type_only(val)
        self._member_policy_value = val
        self._member_policy_present = True

    @member_policy.deleter
    def member_policy(self):
        self._member_policy_value = None
        self._member_policy_present = False

    @property
    def acl_update_policy(self):
        """
        Who can add and remove members of this shared folder.

        :rtype: AclUpdatePolicy
        """
        if self._acl_update_policy_present:
            return self._acl_update_policy_value
        else:
            return AclUpdatePolicy.owner

    @acl_update_policy.setter
    def acl_update_policy(self, val):
        self._acl_update_policy_validator.validate_type_only(val)
        self._acl_update_policy_value = val
        self._acl_update_policy_present = True

    @acl_update_policy.deleter
    def acl_update_policy(self):
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False

    @property
    def shared_link_policy(self):
        """
        The policy to apply to shared links created for content inside this
        shared folder.  The current user must be on a team to set this policy to
        ``SharedLinkPolicy.members``.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            return SharedLinkPolicy.anyone

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    @property
    def force_async(self):
        """
        Whether to force the share to happen asynchronously.

        :rtype: bool
        """
        if self._force_async_present:
            return self._force_async_value
        else:
            return False

    @force_async.setter
    def force_async(self, val):
        val = self._force_async_validator.validate(val)
        self._force_async_value = val
        self._force_async_present = True

    @force_async.deleter
    def force_async(self):
        self._force_async_value = None
        self._force_async_present = False

    def __repr__(self):
        return 'ShareFolderArg(path={!r}, member_policy={!r}, acl_update_policy={!r}, shared_link_policy={!r}, force_async={!r})'.format(
            self._path_value,
            self._member_policy_value,
            self._acl_update_policy_value,
            self._shared_link_policy_value,
            self._force_async_value,
        )

class ShareFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar email_unverified: The current user's e-mail address is unverified.
    :ivar SharePathError bad_path: ``ShareFolderArg.path`` is invalid.
    :ivar team_policy_disallows_member_policy: Team policy is more restrictive
        than ``ShareFolderArg.member_policy``.
    :ivar disallowed_shared_link_policy: The current user's account is not
        allowed to select the specified ``ShareFolderArg.shared_link_policy``.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    team_policy_disallows_member_policy = None
    # Attribute is overwritten below the class definition
    disallowed_shared_link_policy = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def bad_path(cls, val):
        """
        Create an instance of this class set to the ``bad_path`` tag with value
        ``val``.

        :param SharePathError val:
        :rtype: ShareFolderError
        """
        return cls('bad_path', val)

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_bad_path(self):
        """
        Check if the union tag is ``bad_path``.

        :rtype: bool
        """
        return self._tag == 'bad_path'

    def is_team_policy_disallows_member_policy(self):
        """
        Check if the union tag is ``team_policy_disallows_member_policy``.

        :rtype: bool
        """
        return self._tag == 'team_policy_disallows_member_policy'

    def is_disallowed_shared_link_policy(self):
        """
        Check if the union tag is ``disallowed_shared_link_policy``.

        :rtype: bool
        """
        return self._tag == 'disallowed_shared_link_policy'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_bad_path(self):
        """
        ``ShareFolderArg.path`` is invalid.

        Only call this if :meth:`is_bad_path` is true.

        :rtype: SharePathError
        """
        if not self.is_bad_path():
            raise AttributeError("tag 'bad_path' not set")
        return self._value

    def __repr__(self):
        return 'ShareFolderError(%r, %r)' % (self._tag, self._value)

class ShareFolderJobStatus(async.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SharedFolderMetadata complete: The share job has finished. The value
        is the metadata for the folder.
    """

    __slots__ = ['_tag', '_value']

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param SharedFolderMetadata val:
        :rtype: ShareFolderJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param ShareFolderError val:
        :rtype: ShareFolderJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_complete(self):
        """
        The share job has finished. The value is the metadata for the folder.

        Only call this if :meth:`is_complete` is true.

        :rtype: SharedFolderMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        Only call this if :meth:`is_failed` is true.

        :rtype: ShareFolderError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'ShareFolderJobStatus(%r, %r)' % (self._tag, self._value)

class ShareFolderLaunch(async.LaunchResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param SharedFolderMetadata val:
        :rtype: ShareFolderLaunch
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def get_complete(self):
        """
        Only call this if :meth:`is_complete` is true.

        :rtype: SharedFolderMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'ShareFolderLaunch(%r, %r)' % (self._tag, self._value)

class SharePathError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar is_file: A file is at the specified path.
    :ivar inside_shared_folder: We do not support sharing a folder inside a
        shared folder.
    :ivar contains_shared_folder: We do not support shared folders that contain
        shared folders.
    :ivar is_app_folder: We do not support sharing an app folder.
    :ivar inside_app_folder: We do not support sharing a folder inside an app
        folder.
    :ivar already_shared: Folder is already shared.
    :ivar invalid_path: Path is not valid.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    is_file = None
    # Attribute is overwritten below the class definition
    inside_shared_folder = None
    # Attribute is overwritten below the class definition
    contains_shared_folder = None
    # Attribute is overwritten below the class definition
    is_app_folder = None
    # Attribute is overwritten below the class definition
    inside_app_folder = None
    # Attribute is overwritten below the class definition
    already_shared = None
    # Attribute is overwritten below the class definition
    invalid_path = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_is_file(self):
        """
        Check if the union tag is ``is_file``.

        :rtype: bool
        """
        return self._tag == 'is_file'

    def is_inside_shared_folder(self):
        """
        Check if the union tag is ``inside_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'inside_shared_folder'

    def is_contains_shared_folder(self):
        """
        Check if the union tag is ``contains_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'contains_shared_folder'

    def is_is_app_folder(self):
        """
        Check if the union tag is ``is_app_folder``.

        :rtype: bool
        """
        return self._tag == 'is_app_folder'

    def is_inside_app_folder(self):
        """
        Check if the union tag is ``inside_app_folder``.

        :rtype: bool
        """
        return self._tag == 'inside_app_folder'

    def is_already_shared(self):
        """
        Check if the union tag is ``already_shared``.

        :rtype: bool
        """
        return self._tag == 'already_shared'

    def is_invalid_path(self):
        """
        Check if the union tag is ``invalid_path``.

        :rtype: bool
        """
        return self._tag == 'invalid_path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharePathError(%r, %r)' % (self._tag, self._value)

class SharedFolderAccessError(object):
    """
    There is an error accessing the shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_id: This shared folder ID is invalid.
    :ivar not_a_member: The user is not a member of the shared folder thus
        cannot access it.
    :ivar email_unverified: The current user's e-mail address is unverified.
    :ivar unmounted: The shared folder is unmounted.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_id = None
    # Attribute is overwritten below the class definition
    not_a_member = None
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    unmounted = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_id(self):
        """
        Check if the union tag is ``invalid_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_id'

    def is_not_a_member(self):
        """
        Check if the union tag is ``not_a_member``.

        :rtype: bool
        """
        return self._tag == 'not_a_member'

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_unmounted(self):
        """
        Check if the union tag is ``unmounted``.

        :rtype: bool
        """
        return self._tag == 'unmounted'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedFolderAccessError(%r, %r)' % (self._tag, self._value)

class SharedFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_dropbox_id: The target dropbox_id is invalid.
    :ivar not_a_member: The target dropbox_id is not a member of the shared
        folder.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_dropbox_id = None
    # Attribute is overwritten below the class definition
    not_a_member = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_dropbox_id(self):
        """
        Check if the union tag is ``invalid_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_dropbox_id'

    def is_not_a_member(self):
        """
        Check if the union tag is ``not_a_member``.

        :rtype: bool
        """
        return self._tag == 'not_a_member'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedFolderMemberError(%r, %r)' % (self._tag, self._value)

class SharedFolderMembers(object):
    """
    Shared folder user and group membership.

    :ivar users: The list of user members of the shared folder.
    :ivar groups: The list of group members of the shared folder.
    :ivar invitees: The list of invited members of the shared folder. This list
        will not include invitees that have already accepted or declined to join
        the shared folder.
    :ivar cursor: Present if there are additional shared folder members that
        have not been returned yet. Pass the cursor into
        list_folder_members/continue to list additional members.
    """

    __slots__ = [
        '_users_value',
        '_users_present',
        '_groups_value',
        '_groups_present',
        '_invitees_value',
        '_invitees_present',
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 users=None,
                 groups=None,
                 invitees=None,
                 cursor=None):
        self._users_value = None
        self._users_present = False
        self._groups_value = None
        self._groups_present = False
        self._invitees_value = None
        self._invitees_present = False
        self._cursor_value = None
        self._cursor_present = False
        if users is not None:
            self.users = users
        if groups is not None:
            self.groups = groups
        if invitees is not None:
            self.invitees = invitees
        if cursor is not None:
            self.cursor = cursor

    @property
    def users(self):
        """
        The list of user members of the shared folder.

        :rtype: list of [UserMembershipInfo]
        """
        if self._users_present:
            return self._users_value
        else:
            raise AttributeError("missing required field 'users'")

    @users.setter
    def users(self, val):
        val = self._users_validator.validate(val)
        self._users_value = val
        self._users_present = True

    @users.deleter
    def users(self):
        self._users_value = None
        self._users_present = False

    @property
    def groups(self):
        """
        The list of group members of the shared folder.

        :rtype: list of [GroupMembershipInfo]
        """
        if self._groups_present:
            return self._groups_value
        else:
            raise AttributeError("missing required field 'groups'")

    @groups.setter
    def groups(self, val):
        val = self._groups_validator.validate(val)
        self._groups_value = val
        self._groups_present = True

    @groups.deleter
    def groups(self):
        self._groups_value = None
        self._groups_present = False

    @property
    def invitees(self):
        """
        The list of invited members of the shared folder. This list will not
        include invitees that have already accepted or declined to join the
        shared folder.

        :rtype: list of [InviteeMembershipInfo]
        """
        if self._invitees_present:
            return self._invitees_value
        else:
            raise AttributeError("missing required field 'invitees'")

    @invitees.setter
    def invitees(self, val):
        val = self._invitees_validator.validate(val)
        self._invitees_value = val
        self._invitees_present = True

    @invitees.deleter
    def invitees(self):
        self._invitees_value = None
        self._invitees_present = False

    @property
    def cursor(self):
        """
        Present if there are additional shared folder members that have not been
        returned yet. Pass the cursor into list_folder_members/continue to list
        additional members.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'SharedFolderMembers(users={!r}, groups={!r}, invitees={!r}, cursor={!r})'.format(
            self._users_value,
            self._groups_value,
            self._invitees_value,
            self._cursor_value,
        )

class SharedFolderMetadataBase(object):
    """
    Properties of the shared folder.

    :ivar access_type: The current user's access level for this shared folder.
    :ivar is_team_folder: Whether this folder is a `team folder
        <https://www.dropbox.com/en/help/986>`_.
    :ivar policy: Policies governing this shared folder.
    :ivar permissions: Actions the current user may perform on the folder and
        its contents. The set of permissions corresponds to the FolderActions in
        the request.
    :ivar owner_team: The team that owns the folder. This field is not present
        if the folder is not owned by a team.
    :ivar parent_shared_folder_id: The ID of the parent shared folder. This
        field is present only if the folder is contained within another shared
        folder.
    """

    __slots__ = [
        '_access_type_value',
        '_access_type_present',
        '_is_team_folder_value',
        '_is_team_folder_present',
        '_policy_value',
        '_policy_present',
        '_permissions_value',
        '_permissions_present',
        '_owner_team_value',
        '_owner_team_present',
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 is_team_folder=None,
                 policy=None,
                 permissions=None,
                 owner_team=None,
                 parent_shared_folder_id=None):
        self._access_type_value = None
        self._access_type_present = False
        self._is_team_folder_value = None
        self._is_team_folder_present = False
        self._policy_value = None
        self._policy_present = False
        self._permissions_value = None
        self._permissions_present = False
        self._owner_team_value = None
        self._owner_team_present = False
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        if access_type is not None:
            self.access_type = access_type
        if is_team_folder is not None:
            self.is_team_folder = is_team_folder
        if policy is not None:
            self.policy = policy
        if permissions is not None:
            self.permissions = permissions
        if owner_team is not None:
            self.owner_team = owner_team
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id

    @property
    def access_type(self):
        """
        The current user's access level for this shared folder.

        :rtype: AccessLevel
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    @property
    def is_team_folder(self):
        """
        Whether this folder is a `team folder
        <https://www.dropbox.com/en/help/986>`_.

        :rtype: bool
        """
        if self._is_team_folder_present:
            return self._is_team_folder_value
        else:
            raise AttributeError("missing required field 'is_team_folder'")

    @is_team_folder.setter
    def is_team_folder(self, val):
        val = self._is_team_folder_validator.validate(val)
        self._is_team_folder_value = val
        self._is_team_folder_present = True

    @is_team_folder.deleter
    def is_team_folder(self):
        self._is_team_folder_value = None
        self._is_team_folder_present = False

    @property
    def policy(self):
        """
        Policies governing this shared folder.

        :rtype: FolderPolicy
        """
        if self._policy_present:
            return self._policy_value
        else:
            raise AttributeError("missing required field 'policy'")

    @policy.setter
    def policy(self, val):
        self._policy_validator.validate_type_only(val)
        self._policy_value = val
        self._policy_present = True

    @policy.deleter
    def policy(self):
        self._policy_value = None
        self._policy_present = False

    @property
    def permissions(self):
        """
        Actions the current user may perform on the folder and its contents. The
        set of permissions corresponds to the FolderActions in the request.

        :rtype: list of [FolderPermission]
        """
        if self._permissions_present:
            return self._permissions_value
        else:
            return None

    @permissions.setter
    def permissions(self, val):
        if val is None:
            del self.permissions
            return
        val = self._permissions_validator.validate(val)
        self._permissions_value = val
        self._permissions_present = True

    @permissions.deleter
    def permissions(self):
        self._permissions_value = None
        self._permissions_present = False

    @property
    def owner_team(self):
        """
        The team that owns the folder. This field is not present if the folder
        is not owned by a team.

        :rtype: users.Team_validator
        """
        if self._owner_team_present:
            return self._owner_team_value
        else:
            return None

    @owner_team.setter
    def owner_team(self, val):
        if val is None:
            del self.owner_team
            return
        self._owner_team_validator.validate_type_only(val)
        self._owner_team_value = val
        self._owner_team_present = True

    @owner_team.deleter
    def owner_team(self):
        self._owner_team_value = None
        self._owner_team_present = False

    @property
    def parent_shared_folder_id(self):
        """
        The ID of the parent shared folder. This field is present only if the
        folder is contained within another shared folder.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            return None

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        if val is None:
            del self.parent_shared_folder_id
            return
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    def __repr__(self):
        return 'SharedFolderMetadataBase(access_type={!r}, is_team_folder={!r}, policy={!r}, permissions={!r}, owner_team={!r}, parent_shared_folder_id={!r})'.format(
            self._access_type_value,
            self._is_team_folder_value,
            self._policy_value,
            self._permissions_value,
            self._owner_team_value,
            self._parent_shared_folder_id_value,
        )

class SharedFolderMetadata(SharedFolderMetadataBase):
    """
    The metadata which includes basic information about the shared folder.

    :ivar path_lower: The lower-cased full path of this shared folder. Absent
        for unmounted folders.
    :ivar name: The name of the this shared folder.
    :ivar shared_folder_id: The ID of the shared folder.
    """

    __slots__ = [
        '_path_lower_value',
        '_path_lower_present',
        '_name_value',
        '_name_present',
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 is_team_folder=None,
                 policy=None,
                 name=None,
                 shared_folder_id=None,
                 permissions=None,
                 owner_team=None,
                 parent_shared_folder_id=None,
                 path_lower=None):
        super(SharedFolderMetadata, self).__init__(access_type,
                                                   is_team_folder,
                                                   policy,
                                                   permissions,
                                                   owner_team,
                                                   parent_shared_folder_id)
        self._path_lower_value = None
        self._path_lower_present = False
        self._name_value = None
        self._name_present = False
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if path_lower is not None:
            self.path_lower = path_lower
        if name is not None:
            self.name = name
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def path_lower(self):
        """
        The lower-cased full path of this shared folder. Absent for unmounted
        folders.

        :rtype: str
        """
        if self._path_lower_present:
            return self._path_lower_value
        else:
            return None

    @path_lower.setter
    def path_lower(self, val):
        if val is None:
            del self.path_lower
            return
        val = self._path_lower_validator.validate(val)
        self._path_lower_value = val
        self._path_lower_present = True

    @path_lower.deleter
    def path_lower(self):
        self._path_lower_value = None
        self._path_lower_present = False

    @property
    def name(self):
        """
        The name of the this shared folder.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def shared_folder_id(self):
        """
        The ID of the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'SharedFolderMetadata(access_type={!r}, is_team_folder={!r}, policy={!r}, name={!r}, shared_folder_id={!r}, permissions={!r}, owner_team={!r}, parent_shared_folder_id={!r}, path_lower={!r})'.format(
            self._access_type_value,
            self._is_team_folder_value,
            self._policy_value,
            self._name_value,
            self._shared_folder_id_value,
            self._permissions_value,
            self._owner_team_value,
            self._parent_shared_folder_id_value,
            self._path_lower_value,
        )

class SharedLinkAccessFailureReason(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar login_required: User is not logged in.
    :ivar email_verify_required: User's email is not verified.
    :ivar password_required: The link is password protected.
    :ivar team_only: Access is allowed for team members only.
    :ivar owner_only: Access is allowed for the shared link's owner only.
    :ivar other: An unknown accessibility failure.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    login_required = None
    # Attribute is overwritten below the class definition
    email_verify_required = None
    # Attribute is overwritten below the class definition
    password_required = None
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    owner_only = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_login_required(self):
        """
        Check if the union tag is ``login_required``.

        :rtype: bool
        """
        return self._tag == 'login_required'

    def is_email_verify_required(self):
        """
        Check if the union tag is ``email_verify_required``.

        :rtype: bool
        """
        return self._tag == 'email_verify_required'

    def is_password_required(self):
        """
        Check if the union tag is ``password_required``.

        :rtype: bool
        """
        return self._tag == 'password_required'

    def is_team_only(self):
        """
        Check if the union tag is ``team_only``.

        :rtype: bool
        """
        return self._tag == 'team_only'

    def is_owner_only(self):
        """
        Check if the union tag is ``owner_only``.

        :rtype: bool
        """
        return self._tag == 'owner_only'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedLinkAccessFailureReason(%r, %r)' % (self._tag, self._value)

class SharedLinkPolicy(object):
    """
    Policy governing who can view shared links.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar anyone: Links can be shared with anyone.
    :ivar members: Links can only be shared among members of the shared folder.
    :ivar other: An unknown shared link policy.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    anyone = None
    # Attribute is overwritten below the class definition
    members = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_anyone(self):
        """
        Check if the union tag is ``anyone``.

        :rtype: bool
        """
        return self._tag == 'anyone'

    def is_members(self):
        """
        Check if the union tag is ``members``.

        :rtype: bool
        """
        return self._tag == 'members'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedLinkPolicy(%r, %r)' % (self._tag, self._value)

class SharedLinkSettings(object):
    """
    :ivar requested_visibility: The requested access for this shared link.
    :ivar link_password: If ``requested_visibility`` is
        ``RequestedVisibility.password`` this is needed to specify the password
        to access the link.
    :ivar expires: Expiration time of the shared link. By default the link won't
        expire.
    """

    __slots__ = [
        '_requested_visibility_value',
        '_requested_visibility_present',
        '_link_password_value',
        '_link_password_present',
        '_expires_value',
        '_expires_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 requested_visibility=None,
                 link_password=None,
                 expires=None):
        self._requested_visibility_value = None
        self._requested_visibility_present = False
        self._link_password_value = None
        self._link_password_present = False
        self._expires_value = None
        self._expires_present = False
        if requested_visibility is not None:
            self.requested_visibility = requested_visibility
        if link_password is not None:
            self.link_password = link_password
        if expires is not None:
            self.expires = expires

    @property
    def requested_visibility(self):
        """
        The requested access for this shared link.

        :rtype: RequestedVisibility
        """
        if self._requested_visibility_present:
            return self._requested_visibility_value
        else:
            return None

    @requested_visibility.setter
    def requested_visibility(self, val):
        if val is None:
            del self.requested_visibility
            return
        self._requested_visibility_validator.validate_type_only(val)
        self._requested_visibility_value = val
        self._requested_visibility_present = True

    @requested_visibility.deleter
    def requested_visibility(self):
        self._requested_visibility_value = None
        self._requested_visibility_present = False

    @property
    def link_password(self):
        """
        If ``requested_visibility`` is ``RequestedVisibility.password`` this is
        needed to specify the password to access the link.

        :rtype: str
        """
        if self._link_password_present:
            return self._link_password_value
        else:
            return None

    @link_password.setter
    def link_password(self, val):
        if val is None:
            del self.link_password
            return
        val = self._link_password_validator.validate(val)
        self._link_password_value = val
        self._link_password_present = True

    @link_password.deleter
    def link_password(self):
        self._link_password_value = None
        self._link_password_present = False

    @property
    def expires(self):
        """
        Expiration time of the shared link. By default the link won't expire.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            return None

    @expires.setter
    def expires(self, val):
        if val is None:
            del self.expires
            return
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    def __repr__(self):
        return 'SharedLinkSettings(requested_visibility={!r}, link_password={!r}, expires={!r})'.format(
            self._requested_visibility_value,
            self._link_password_value,
            self._expires_value,
        )

class SharedLinkSettingsError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_settings: The given settings are invalid (for example, all
        attributes of the :class:`SharedLinkSettings` are empty, the requested
        visibility is ``RequestedVisibility.password`` but the
        ``SharedLinkSettings.link_password`` is missing,
        ``SharedLinkSettings.expires`` is set to the past, etc.)
    :ivar not_authorized: User is not allowed to modify the settings of this
        link. Note that basic users can only set ``RequestedVisibility.public``
        as the ``SharedLinkSettings.requested_visibility`` and cannot set
        ``SharedLinkSettings.expires``
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    invalid_settings = None
    # Attribute is overwritten below the class definition
    not_authorized = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_settings(self):
        """
        Check if the union tag is ``invalid_settings``.

        :rtype: bool
        """
        return self._tag == 'invalid_settings'

    def is_not_authorized(self):
        """
        Check if the union tag is ``not_authorized``.

        :rtype: bool
        """
        return self._tag == 'not_authorized'

    def __repr__(self):
        return 'SharedLinkSettingsError(%r, %r)' % (self._tag, self._value)

class TeamMemberInfo(object):
    """
    Information about a team member.

    :ivar team_info: Information about the member's team
    :ivar display_name: The display name of the user.
    :ivar member_id: ID of user as a member of a team. This field will only be
        present if the member is in the same team as current user.
    """

    __slots__ = [
        '_team_info_value',
        '_team_info_present',
        '_display_name_value',
        '_display_name_present',
        '_member_id_value',
        '_member_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 team_info=None,
                 display_name=None,
                 member_id=None):
        self._team_info_value = None
        self._team_info_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._member_id_value = None
        self._member_id_present = False
        if team_info is not None:
            self.team_info = team_info
        if display_name is not None:
            self.display_name = display_name
        if member_id is not None:
            self.member_id = member_id

    @property
    def team_info(self):
        """
        Information about the member's team

        :rtype: users.Team_validator
        """
        if self._team_info_present:
            return self._team_info_value
        else:
            raise AttributeError("missing required field 'team_info'")

    @team_info.setter
    def team_info(self, val):
        val = self._team_info_validator.validate(val)
        self._team_info_value = val
        self._team_info_present = True

    @team_info.deleter
    def team_info(self):
        self._team_info_value = None
        self._team_info_present = False

    @property
    def display_name(self):
        """
        The display name of the user.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            raise AttributeError("missing required field 'display_name'")

    @display_name.setter
    def display_name(self, val):
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def member_id(self):
        """
        ID of user as a member of a team. This field will only be present if the
        member is in the same team as current user.

        :rtype: str
        """
        if self._member_id_present:
            return self._member_id_value
        else:
            return None

    @member_id.setter
    def member_id(self, val):
        if val is None:
            del self.member_id
            return
        val = self._member_id_validator.validate(val)
        self._member_id_value = val
        self._member_id_present = True

    @member_id.deleter
    def member_id(self):
        self._member_id_value = None
        self._member_id_present = False

    def __repr__(self):
        return 'TeamMemberInfo(team_info={!r}, display_name={!r}, member_id={!r})'.format(
            self._team_info_value,
            self._display_name_value,
            self._member_id_value,
        )

class TransferFolderArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar to_dropbox_id: A account or team member ID to transfer ownership to.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_to_dropbox_id_value',
        '_to_dropbox_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 to_dropbox_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._to_dropbox_id_value = None
        self._to_dropbox_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if to_dropbox_id is not None:
            self.to_dropbox_id = to_dropbox_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def to_dropbox_id(self):
        """
        A account or team member ID to transfer ownership to.

        :rtype: str
        """
        if self._to_dropbox_id_present:
            return self._to_dropbox_id_value
        else:
            raise AttributeError("missing required field 'to_dropbox_id'")

    @to_dropbox_id.setter
    def to_dropbox_id(self, val):
        val = self._to_dropbox_id_validator.validate(val)
        self._to_dropbox_id_value = val
        self._to_dropbox_id_present = True

    @to_dropbox_id.deleter
    def to_dropbox_id(self):
        self._to_dropbox_id_value = None
        self._to_dropbox_id_present = False

    def __repr__(self):
        return 'TransferFolderArg(shared_folder_id={!r}, to_dropbox_id={!r})'.format(
            self._shared_folder_id_value,
            self._to_dropbox_id_value,
        )

class TransferFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_dropbox_id: ``TransferFolderArg.to_dropbox_id`` is invalid.
    :ivar new_owner_not_a_member: The new designated owner is not currently a
        member of the shared folder.
    :ivar new_owner_unmounted: The new designated owner does not have the shared
        folder mounted.
    :ivar new_owner_email_unverified: The new designated owner's e-mail address
        is unverified.
    :ivar team_folder: This action cannot be performed on a team shared folder.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_dropbox_id = None
    # Attribute is overwritten below the class definition
    new_owner_not_a_member = None
    # Attribute is overwritten below the class definition
    new_owner_unmounted = None
    # Attribute is overwritten below the class definition
    new_owner_email_unverified = None
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: TransferFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_invalid_dropbox_id(self):
        """
        Check if the union tag is ``invalid_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_dropbox_id'

    def is_new_owner_not_a_member(self):
        """
        Check if the union tag is ``new_owner_not_a_member``.

        :rtype: bool
        """
        return self._tag == 'new_owner_not_a_member'

    def is_new_owner_unmounted(self):
        """
        Check if the union tag is ``new_owner_unmounted``.

        :rtype: bool
        """
        return self._tag == 'new_owner_unmounted'

    def is_new_owner_email_unverified(self):
        """
        Check if the union tag is ``new_owner_email_unverified``.

        :rtype: bool
        """
        return self._tag == 'new_owner_email_unverified'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'TransferFolderError(%r, %r)' % (self._tag, self._value)

class UnmountFolderArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'UnmountFolderArg(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class UnmountFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar no_permission: The current user does not have permission to perform
        this action.
    :ivar not_unmountable: The shared folder can't be unmounted. One example
        where this can occur is when the shared folder's parent folder is also a
        shared folder that resides in the current user's Dropbox.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    not_unmountable = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UnmountFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_not_unmountable(self):
        """
        Check if the union tag is ``not_unmountable``.

        :rtype: bool
        """
        return self._tag == 'not_unmountable'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'UnmountFolderError(%r, %r)' % (self._tag, self._value)

class UnshareFolderArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar leave_a_copy: If true, members of this shared folder will get a copy
        of this folder after it's unshared. Otherwise, it will be removed from
        their Dropbox. The current user, who is an owner, will always retain
        their copy.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_leave_a_copy_value',
        '_leave_a_copy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 leave_a_copy=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if leave_a_copy is not None:
            self.leave_a_copy = leave_a_copy

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def leave_a_copy(self):
        """
        If true, members of this shared folder will get a copy of this folder
        after it's unshared. Otherwise, it will be removed from their Dropbox.
        The current user, who is an owner, will always retain their copy.

        :rtype: bool
        """
        if self._leave_a_copy_present:
            return self._leave_a_copy_value
        else:
            return False

    @leave_a_copy.setter
    def leave_a_copy(self, val):
        val = self._leave_a_copy_validator.validate(val)
        self._leave_a_copy_value = val
        self._leave_a_copy_present = True

    @leave_a_copy.deleter
    def leave_a_copy(self):
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False

    def __repr__(self):
        return 'UnshareFolderArg(shared_folder_id={!r}, leave_a_copy={!r})'.format(
            self._shared_folder_id_value,
            self._leave_a_copy_value,
        )

class UnshareFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team_folder: This action cannot be performed on a team shared folder.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UnshareFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'UnshareFolderError(%r, %r)' % (self._tag, self._value)

class UpdateFolderMemberArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar member: The member of the shared folder to update.  Only the
        ``MemberSelector.dropbox_id`` may be set at this time.
    :ivar access_level: The new access level for ``member``.
        ``AccessLevel.owner`` is disallowed.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_member_value',
        '_member_present',
        '_access_level_value',
        '_access_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 member=None,
                 access_level=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._member_value = None
        self._member_present = False
        self._access_level_value = None
        self._access_level_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if member is not None:
            self.member = member
        if access_level is not None:
            self.access_level = access_level

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def member(self):
        """
        The member of the shared folder to update.  Only the
        ``MemberSelector.dropbox_id`` may be set at this time.

        :rtype: MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def access_level(self):
        """
        The new access level for ``member``. ``AccessLevel.owner`` is
        disallowed.

        :rtype: AccessLevel
        """
        if self._access_level_present:
            return self._access_level_value
        else:
            raise AttributeError("missing required field 'access_level'")

    @access_level.setter
    def access_level(self, val):
        self._access_level_validator.validate_type_only(val)
        self._access_level_value = val
        self._access_level_present = True

    @access_level.deleter
    def access_level(self):
        self._access_level_value = None
        self._access_level_present = False

    def __repr__(self):
        return 'UpdateFolderMemberArg(shared_folder_id={!r}, member={!r}, access_level={!r})'.format(
            self._shared_folder_id_value,
            self._member_value,
            self._access_level_value,
        )

class UpdateFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar insufficient_plan: The current user's account doesn't support this
        action. An example of this is when downgrading a member from editor to
        viewer. This action can only be performed by users that have upgraded to
        a Pro or Business plan.
    :ivar no_permission: The current user does not have permission to perform
        this action.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    insufficient_plan = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UpdateFolderMemberError
        """
        return cls('access_error', val)

    @classmethod
    def member_error(cls, val):
        """
        Create an instance of this class set to the ``member_error`` tag with
        value ``val``.

        :param SharedFolderMemberError val:
        :rtype: UpdateFolderMemberError
        """
        return cls('member_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_member_error(self):
        """
        Check if the union tag is ``member_error``.

        :rtype: bool
        """
        return self._tag == 'member_error'

    def is_insufficient_plan(self):
        """
        Check if the union tag is ``insufficient_plan``.

        :rtype: bool
        """
        return self._tag == 'insufficient_plan'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def get_member_error(self):
        """
        Only call this if :meth:`is_member_error` is true.

        :rtype: SharedFolderMemberError
        """
        if not self.is_member_error():
            raise AttributeError("tag 'member_error' not set")
        return self._value

    def __repr__(self):
        return 'UpdateFolderMemberError(%r, %r)' % (self._tag, self._value)

class UpdateFolderPolicyArg(object):
    """
    If any of the policy's are unset, then they retain their current setting.

    :ivar shared_folder_id: The ID for the shared folder.
    :ivar member_policy: Who can be a member of this shared folder. Only
        applicable if the current user is on a team.
    :ivar acl_update_policy: Who can add and remove members of this shared
        folder.
    :ivar shared_link_policy: The policy to apply to shared links created for
        content inside this shared folder. The current user must be on a team to
        set this policy to ``SharedLinkPolicy.members``.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_member_policy_value',
        '_member_policy_present',
        '_acl_update_policy_value',
        '_acl_update_policy_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 member_policy=None,
                 acl_update_policy=None,
                 shared_link_policy=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._member_policy_value = None
        self._member_policy_present = False
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if member_policy is not None:
            self.member_policy = member_policy
        if acl_update_policy is not None:
            self.acl_update_policy = acl_update_policy
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def member_policy(self):
        """
        Who can be a member of this shared folder. Only applicable if the
        current user is on a team.

        :rtype: MemberPolicy
        """
        if self._member_policy_present:
            return self._member_policy_value
        else:
            return None

    @member_policy.setter
    def member_policy(self, val):
        if val is None:
            del self.member_policy
            return
        self._member_policy_validator.validate_type_only(val)
        self._member_policy_value = val
        self._member_policy_present = True

    @member_policy.deleter
    def member_policy(self):
        self._member_policy_value = None
        self._member_policy_present = False

    @property
    def acl_update_policy(self):
        """
        Who can add and remove members of this shared folder.

        :rtype: AclUpdatePolicy
        """
        if self._acl_update_policy_present:
            return self._acl_update_policy_value
        else:
            return None

    @acl_update_policy.setter
    def acl_update_policy(self, val):
        if val is None:
            del self.acl_update_policy
            return
        self._acl_update_policy_validator.validate_type_only(val)
        self._acl_update_policy_value = val
        self._acl_update_policy_present = True

    @acl_update_policy.deleter
    def acl_update_policy(self):
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False

    @property
    def shared_link_policy(self):
        """
        The policy to apply to shared links created for content inside this
        shared folder. The current user must be on a team to set this policy to
        ``SharedLinkPolicy.members``.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            return None

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        if val is None:
            del self.shared_link_policy
            return
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    def __repr__(self):
        return 'UpdateFolderPolicyArg(shared_folder_id={!r}, member_policy={!r}, acl_update_policy={!r}, shared_link_policy={!r})'.format(
            self._shared_folder_id_value,
            self._member_policy_value,
            self._acl_update_policy_value,
            self._shared_link_policy_value,
        )

class UpdateFolderPolicyError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_on_team: ``UpdateFolderPolicyArg.member_policy`` was set even
        though user is not on a team.
    :ivar team_policy_disallows_member_policy: Team policy is more restrictive
        than ``ShareFolderArg.member_policy``.
    :ivar disallowed_shared_link_policy: The current account is not allowed to
        select the specified ``ShareFolderArg.shared_link_policy``.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_on_team = None
    # Attribute is overwritten below the class definition
    team_policy_disallows_member_policy = None
    # Attribute is overwritten below the class definition
    disallowed_shared_link_policy = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UpdateFolderPolicyError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_not_on_team(self):
        """
        Check if the union tag is ``not_on_team``.

        :rtype: bool
        """
        return self._tag == 'not_on_team'

    def is_team_policy_disallows_member_policy(self):
        """
        Check if the union tag is ``team_policy_disallows_member_policy``.

        :rtype: bool
        """
        return self._tag == 'team_policy_disallows_member_policy'

    def is_disallowed_shared_link_policy(self):
        """
        Check if the union tag is ``disallowed_shared_link_policy``.

        :rtype: bool
        """
        return self._tag == 'disallowed_shared_link_policy'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'UpdateFolderPolicyError(%r, %r)' % (self._tag, self._value)

class UserInfo(object):
    """
    Basic information about a user. Use users.get_account and
    users.get_account_batch to obtain more detailed information.

    :ivar account_id: The account ID of the user.
    :ivar same_team: If the user is in the same team as current user.
    :ivar team_member_id: The team member ID of the shared folder member. Only
        present if ``same_team`` is true.
    """

    __slots__ = [
        '_account_id_value',
        '_account_id_present',
        '_same_team_value',
        '_same_team_present',
        '_team_member_id_value',
        '_team_member_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_id=None,
                 same_team=None,
                 team_member_id=None):
        self._account_id_value = None
        self._account_id_present = False
        self._same_team_value = None
        self._same_team_present = False
        self._team_member_id_value = None
        self._team_member_id_present = False
        if account_id is not None:
            self.account_id = account_id
        if same_team is not None:
            self.same_team = same_team
        if team_member_id is not None:
            self.team_member_id = team_member_id

    @property
    def account_id(self):
        """
        The account ID of the user.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            raise AttributeError("missing required field 'account_id'")

    @account_id.setter
    def account_id(self, val):
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def same_team(self):
        """
        If the user is in the same team as current user.

        :rtype: bool
        """
        if self._same_team_present:
            return self._same_team_value
        else:
            raise AttributeError("missing required field 'same_team'")

    @same_team.setter
    def same_team(self, val):
        val = self._same_team_validator.validate(val)
        self._same_team_value = val
        self._same_team_present = True

    @same_team.deleter
    def same_team(self):
        self._same_team_value = None
        self._same_team_present = False

    @property
    def team_member_id(self):
        """
        The team member ID of the shared folder member. Only present if
        ``same_team`` is true.

        :rtype: str
        """
        if self._team_member_id_present:
            return self._team_member_id_value
        else:
            return None

    @team_member_id.setter
    def team_member_id(self, val):
        if val is None:
            del self.team_member_id
            return
        val = self._team_member_id_validator.validate(val)
        self._team_member_id_value = val
        self._team_member_id_present = True

    @team_member_id.deleter
    def team_member_id(self):
        self._team_member_id_value = None
        self._team_member_id_present = False

    def __repr__(self):
        return 'UserInfo(account_id={!r}, same_team={!r}, team_member_id={!r})'.format(
            self._account_id_value,
            self._same_team_value,
            self._team_member_id_value,
        )

class UserMembershipInfo(MembershipInfo):
    """
    The information about a user member of the shared folder.

    :ivar user: The account information for the membership user.
    """

    __slots__ = [
        '_user_value',
        '_user_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 user=None,
                 permissions=None,
                 initials=None,
                 is_inherited=None):
        super(UserMembershipInfo, self).__init__(access_type,
                                                 permissions,
                                                 initials,
                                                 is_inherited)
        self._user_value = None
        self._user_present = False
        if user is not None:
            self.user = user

    @property
    def user(self):
        """
        The account information for the membership user.

        :rtype: UserInfo
        """
        if self._user_present:
            return self._user_value
        else:
            raise AttributeError("missing required field 'user'")

    @user.setter
    def user(self, val):
        self._user_validator.validate_type_only(val)
        self._user_value = val
        self._user_present = True

    @user.deleter
    def user(self):
        self._user_value = None
        self._user_present = False

    def __repr__(self):
        return 'UserMembershipInfo(access_type={!r}, user={!r}, permissions={!r}, initials={!r}, is_inherited={!r})'.format(
            self._access_type_value,
            self._user_value,
            self._permissions_value,
            self._initials_value,
            self._is_inherited_value,
        )

class Visibility(object):
    """
    Who can access a shared link. The most open visibility is ``public``. The
    default depends on many aspects, such as team and user preferences and
    shared folder settings.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar public: Anyone who has received the link can access it. No login
        required.
    :ivar team_only: Only members of the same team can access the link. Login is
        required.
    :ivar password: A link-specific password is required to access the link.
        Login is not required.
    :ivar team_and_password: Only members of the same team who have the
        link-specific password can access the link.
    :ivar shared_folder_only: Only members of the shared folder containing the
        linked file can access the link. Login is required.
    :ivar other: An unknown restriction is in place.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    public = None
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    password = None
    # Attribute is overwritten below the class definition
    team_and_password = None
    # Attribute is overwritten below the class definition
    shared_folder_only = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_public(self):
        """
        Check if the union tag is ``public``.

        :rtype: bool
        """
        return self._tag == 'public'

    def is_team_only(self):
        """
        Check if the union tag is ``team_only``.

        :rtype: bool
        """
        return self._tag == 'team_only'

    def is_password(self):
        """
        Check if the union tag is ``password``.

        :rtype: bool
        """
        return self._tag == 'password'

    def is_team_and_password(self):
        """
        Check if the union tag is ``team_and_password``.

        :rtype: bool
        """
        return self._tag == 'team_and_password'

    def is_shared_folder_only(self):
        """
        Check if the union tag is ``shared_folder_only``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_only'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'Visibility(%r, %r)' % (self._tag, self._value)

DropboxId_validator = bv.String(min_length=1)
GetSharedLinkFileArg_validator = bv.Struct(GetSharedLinkMetadataArg)
GetSharedLinkFileArg = GetSharedLinkMetadataArg
Id_validator = files.Id_validator
Path_validator = files.Path_validator
ReadPath_validator = files.ReadPath_validator
Rev_validator = files.Rev_validator
TeamInfo_validator = bv.Struct(users.Team)
TeamInfo = users.Team
AccessLevel._owner_validator = bv.Void()
AccessLevel._editor_validator = bv.Void()
AccessLevel._viewer_validator = bv.Void()
AccessLevel._other_validator = bv.Void()
AccessLevel._tagmap = {
    'owner': AccessLevel._owner_validator,
    'editor': AccessLevel._editor_validator,
    'viewer': AccessLevel._viewer_validator,
    'other': AccessLevel._other_validator,
}

AccessLevel.owner = AccessLevel('owner')
AccessLevel.editor = AccessLevel('editor')
AccessLevel.viewer = AccessLevel('viewer')
AccessLevel.other = AccessLevel('other')

AclUpdatePolicy._owner_validator = bv.Void()
AclUpdatePolicy._editors_validator = bv.Void()
AclUpdatePolicy._other_validator = bv.Void()
AclUpdatePolicy._tagmap = {
    'owner': AclUpdatePolicy._owner_validator,
    'editors': AclUpdatePolicy._editors_validator,
    'other': AclUpdatePolicy._other_validator,
}

AclUpdatePolicy.owner = AclUpdatePolicy('owner')
AclUpdatePolicy.editors = AclUpdatePolicy('editors')
AclUpdatePolicy.other = AclUpdatePolicy('other')

AddFolderMemberArg._shared_folder_id_validator = common.SharedFolderId_validator
AddFolderMemberArg._members_validator = bv.List(bv.Struct(AddMember))
AddFolderMemberArg._quiet_validator = bv.Boolean()
AddFolderMemberArg._custom_message_validator = bv.Nullable(bv.String(min_length=1))
AddFolderMemberArg._all_field_names_ = set([
    'shared_folder_id',
    'members',
    'quiet',
    'custom_message',
])
AddFolderMemberArg._all_fields_ = [
    ('shared_folder_id', AddFolderMemberArg._shared_folder_id_validator),
    ('members', AddFolderMemberArg._members_validator),
    ('quiet', AddFolderMemberArg._quiet_validator),
    ('custom_message', AddFolderMemberArg._custom_message_validator),
]

AddFolderMemberError._access_error_validator = bv.Union(SharedFolderAccessError)
AddFolderMemberError._email_unverified_validator = bv.Void()
AddFolderMemberError._bad_member_validator = bv.Union(AddMemberSelectorError)
AddFolderMemberError._cant_share_outside_team_validator = bv.Void()
AddFolderMemberError._too_many_members_validator = bv.UInt64()
AddFolderMemberError._too_many_pending_invites_validator = bv.UInt64()
AddFolderMemberError._rate_limit_validator = bv.Void()
AddFolderMemberError._insufficient_plan_validator = bv.Void()
AddFolderMemberError._team_folder_validator = bv.Void()
AddFolderMemberError._no_permission_validator = bv.Void()
AddFolderMemberError._other_validator = bv.Void()
AddFolderMemberError._tagmap = {
    'access_error': AddFolderMemberError._access_error_validator,
    'email_unverified': AddFolderMemberError._email_unverified_validator,
    'bad_member': AddFolderMemberError._bad_member_validator,
    'cant_share_outside_team': AddFolderMemberError._cant_share_outside_team_validator,
    'too_many_members': AddFolderMemberError._too_many_members_validator,
    'too_many_pending_invites': AddFolderMemberError._too_many_pending_invites_validator,
    'rate_limit': AddFolderMemberError._rate_limit_validator,
    'insufficient_plan': AddFolderMemberError._insufficient_plan_validator,
    'team_folder': AddFolderMemberError._team_folder_validator,
    'no_permission': AddFolderMemberError._no_permission_validator,
    'other': AddFolderMemberError._other_validator,
}

AddFolderMemberError.email_unverified = AddFolderMemberError('email_unverified')
AddFolderMemberError.cant_share_outside_team = AddFolderMemberError('cant_share_outside_team')
AddFolderMemberError.rate_limit = AddFolderMemberError('rate_limit')
AddFolderMemberError.insufficient_plan = AddFolderMemberError('insufficient_plan')
AddFolderMemberError.team_folder = AddFolderMemberError('team_folder')
AddFolderMemberError.no_permission = AddFolderMemberError('no_permission')
AddFolderMemberError.other = AddFolderMemberError('other')

AddMember._member_validator = bv.Union(MemberSelector)
AddMember._access_level_validator = bv.Union(AccessLevel)
AddMember._all_field_names_ = set([
    'member',
    'access_level',
])
AddMember._all_fields_ = [
    ('member', AddMember._member_validator),
    ('access_level', AddMember._access_level_validator),
]

AddMemberSelectorError._invalid_dropbox_id_validator = DropboxId_validator
AddMemberSelectorError._invalid_email_validator = common.EmailAddress_validator
AddMemberSelectorError._unverified_dropbox_id_validator = DropboxId_validator
AddMemberSelectorError._group_deleted_validator = bv.Void()
AddMemberSelectorError._group_not_on_team_validator = bv.Void()
AddMemberSelectorError._other_validator = bv.Void()
AddMemberSelectorError._tagmap = {
    'invalid_dropbox_id': AddMemberSelectorError._invalid_dropbox_id_validator,
    'invalid_email': AddMemberSelectorError._invalid_email_validator,
    'unverified_dropbox_id': AddMemberSelectorError._unverified_dropbox_id_validator,
    'group_deleted': AddMemberSelectorError._group_deleted_validator,
    'group_not_on_team': AddMemberSelectorError._group_not_on_team_validator,
    'other': AddMemberSelectorError._other_validator,
}

AddMemberSelectorError.group_deleted = AddMemberSelectorError('group_deleted')
AddMemberSelectorError.group_not_on_team = AddMemberSelectorError('group_not_on_team')
AddMemberSelectorError.other = AddMemberSelectorError('other')

LinkMetadata._url_validator = bv.String()
LinkMetadata._visibility_validator = bv.Union(Visibility)
LinkMetadata._expires_validator = bv.Nullable(common.DropboxTimestamp_validator)
LinkMetadata._field_names_ = set([
    'url',
    'visibility',
    'expires',
])
LinkMetadata._all_field_names_ = LinkMetadata._field_names_
LinkMetadata._fields_ = [
    ('url', LinkMetadata._url_validator),
    ('visibility', LinkMetadata._visibility_validator),
    ('expires', LinkMetadata._expires_validator),
]
LinkMetadata._all_fields_ = LinkMetadata._fields_

LinkMetadata._tag_to_subtype_ = {
    (u'path',): bv.Struct(PathLinkMetadata),
    (u'collection',): bv.Struct(CollectionLinkMetadata),
}
LinkMetadata._pytype_to_tag_and_subtype_ = {
    PathLinkMetadata: ((u'path',), bv.Struct(PathLinkMetadata)),
    CollectionLinkMetadata: ((u'collection',), bv.Struct(CollectionLinkMetadata)),
}
LinkMetadata._is_catch_all_ = True

CollectionLinkMetadata._field_names_ = set([])
CollectionLinkMetadata._all_field_names_ = LinkMetadata._all_field_names_.union(CollectionLinkMetadata._field_names_)
CollectionLinkMetadata._fields_ = []
CollectionLinkMetadata._all_fields_ = LinkMetadata._all_fields_ + CollectionLinkMetadata._fields_

CreateSharedLinkArg._path_validator = bv.String()
CreateSharedLinkArg._short_url_validator = bv.Boolean()
CreateSharedLinkArg._pending_upload_validator = bv.Nullable(bv.Union(PendingUploadMode))
CreateSharedLinkArg._all_field_names_ = set([
    'path',
    'short_url',
    'pending_upload',
])
CreateSharedLinkArg._all_fields_ = [
    ('path', CreateSharedLinkArg._path_validator),
    ('short_url', CreateSharedLinkArg._short_url_validator),
    ('pending_upload', CreateSharedLinkArg._pending_upload_validator),
]

CreateSharedLinkError._path_validator = bv.Union(files.LookupError)
CreateSharedLinkError._other_validator = bv.Void()
CreateSharedLinkError._tagmap = {
    'path': CreateSharedLinkError._path_validator,
    'other': CreateSharedLinkError._other_validator,
}

CreateSharedLinkError.other = CreateSharedLinkError('other')

CreateSharedLinkWithSettingsArg._path_validator = ReadPath_validator
CreateSharedLinkWithSettingsArg._settings_validator = bv.Nullable(bv.Struct(SharedLinkSettings))
CreateSharedLinkWithSettingsArg._all_field_names_ = set([
    'path',
    'settings',
])
CreateSharedLinkWithSettingsArg._all_fields_ = [
    ('path', CreateSharedLinkWithSettingsArg._path_validator),
    ('settings', CreateSharedLinkWithSettingsArg._settings_validator),
]

CreateSharedLinkWithSettingsError._path_validator = bv.Union(files.LookupError)
CreateSharedLinkWithSettingsError._email_not_verified_validator = bv.Void()
CreateSharedLinkWithSettingsError._shared_link_already_exists_validator = bv.Void()
CreateSharedLinkWithSettingsError._settings_error_validator = bv.Union(SharedLinkSettingsError)
CreateSharedLinkWithSettingsError._access_denied_validator = bv.Void()
CreateSharedLinkWithSettingsError._tagmap = {
    'path': CreateSharedLinkWithSettingsError._path_validator,
    'email_not_verified': CreateSharedLinkWithSettingsError._email_not_verified_validator,
    'shared_link_already_exists': CreateSharedLinkWithSettingsError._shared_link_already_exists_validator,
    'settings_error': CreateSharedLinkWithSettingsError._settings_error_validator,
    'access_denied': CreateSharedLinkWithSettingsError._access_denied_validator,
}

CreateSharedLinkWithSettingsError.email_not_verified = CreateSharedLinkWithSettingsError('email_not_verified')
CreateSharedLinkWithSettingsError.shared_link_already_exists = CreateSharedLinkWithSettingsError('shared_link_already_exists')
CreateSharedLinkWithSettingsError.access_denied = CreateSharedLinkWithSettingsError('access_denied')

SharedLinkMetadata._url_validator = bv.String()
SharedLinkMetadata._id_validator = bv.Nullable(Id_validator)
SharedLinkMetadata._name_validator = bv.String()
SharedLinkMetadata._expires_validator = bv.Nullable(common.DropboxTimestamp_validator)
SharedLinkMetadata._path_lower_validator = bv.Nullable(bv.String())
SharedLinkMetadata._link_permissions_validator = bv.Struct(LinkPermissions)
SharedLinkMetadata._team_member_info_validator = bv.Nullable(bv.Struct(TeamMemberInfo))
SharedLinkMetadata._content_owner_team_info_validator = bv.Nullable(TeamInfo_validator)
SharedLinkMetadata._field_names_ = set([
    'url',
    'id',
    'name',
    'expires',
    'path_lower',
    'link_permissions',
    'team_member_info',
    'content_owner_team_info',
])
SharedLinkMetadata._all_field_names_ = SharedLinkMetadata._field_names_
SharedLinkMetadata._fields_ = [
    ('url', SharedLinkMetadata._url_validator),
    ('id', SharedLinkMetadata._id_validator),
    ('name', SharedLinkMetadata._name_validator),
    ('expires', SharedLinkMetadata._expires_validator),
    ('path_lower', SharedLinkMetadata._path_lower_validator),
    ('link_permissions', SharedLinkMetadata._link_permissions_validator),
    ('team_member_info', SharedLinkMetadata._team_member_info_validator),
    ('content_owner_team_info', SharedLinkMetadata._content_owner_team_info_validator),
]
SharedLinkMetadata._all_fields_ = SharedLinkMetadata._fields_

SharedLinkMetadata._tag_to_subtype_ = {
    (u'file',): bv.Struct(FileLinkMetadata),
    (u'folder',): bv.Struct(FolderLinkMetadata),
}
SharedLinkMetadata._pytype_to_tag_and_subtype_ = {
    FileLinkMetadata: ((u'file',), bv.Struct(FileLinkMetadata)),
    FolderLinkMetadata: ((u'folder',), bv.Struct(FolderLinkMetadata)),
}
SharedLinkMetadata._is_catch_all_ = True

FileLinkMetadata._client_modified_validator = common.DropboxTimestamp_validator
FileLinkMetadata._server_modified_validator = common.DropboxTimestamp_validator
FileLinkMetadata._rev_validator = Rev_validator
FileLinkMetadata._size_validator = bv.UInt64()
FileLinkMetadata._field_names_ = set([
    'client_modified',
    'server_modified',
    'rev',
    'size',
])
FileLinkMetadata._all_field_names_ = SharedLinkMetadata._all_field_names_.union(FileLinkMetadata._field_names_)
FileLinkMetadata._fields_ = [
    ('client_modified', FileLinkMetadata._client_modified_validator),
    ('server_modified', FileLinkMetadata._server_modified_validator),
    ('rev', FileLinkMetadata._rev_validator),
    ('size', FileLinkMetadata._size_validator),
]
FileLinkMetadata._all_fields_ = SharedLinkMetadata._all_fields_ + FileLinkMetadata._fields_

FolderAction._change_options_validator = bv.Void()
FolderAction._edit_contents_validator = bv.Void()
FolderAction._invite_editor_validator = bv.Void()
FolderAction._invite_viewer_validator = bv.Void()
FolderAction._relinquish_membership_validator = bv.Void()
FolderAction._unmount_validator = bv.Void()
FolderAction._unshare_validator = bv.Void()
FolderAction._other_validator = bv.Void()
FolderAction._tagmap = {
    'change_options': FolderAction._change_options_validator,
    'edit_contents': FolderAction._edit_contents_validator,
    'invite_editor': FolderAction._invite_editor_validator,
    'invite_viewer': FolderAction._invite_viewer_validator,
    'relinquish_membership': FolderAction._relinquish_membership_validator,
    'unmount': FolderAction._unmount_validator,
    'unshare': FolderAction._unshare_validator,
    'other': FolderAction._other_validator,
}

FolderAction.change_options = FolderAction('change_options')
FolderAction.edit_contents = FolderAction('edit_contents')
FolderAction.invite_editor = FolderAction('invite_editor')
FolderAction.invite_viewer = FolderAction('invite_viewer')
FolderAction.relinquish_membership = FolderAction('relinquish_membership')
FolderAction.unmount = FolderAction('unmount')
FolderAction.unshare = FolderAction('unshare')
FolderAction.other = FolderAction('other')

FolderLinkMetadata._field_names_ = set([])
FolderLinkMetadata._all_field_names_ = SharedLinkMetadata._all_field_names_.union(FolderLinkMetadata._field_names_)
FolderLinkMetadata._fields_ = []
FolderLinkMetadata._all_fields_ = SharedLinkMetadata._all_fields_ + FolderLinkMetadata._fields_

FolderPermission._action_validator = bv.Union(FolderAction)
FolderPermission._allow_validator = bv.Boolean()
FolderPermission._reason_validator = bv.Nullable(bv.Union(PermissionDeniedReason))
FolderPermission._all_field_names_ = set([
    'action',
    'allow',
    'reason',
])
FolderPermission._all_fields_ = [
    ('action', FolderPermission._action_validator),
    ('allow', FolderPermission._allow_validator),
    ('reason', FolderPermission._reason_validator),
]

FolderPolicy._member_policy_validator = bv.Nullable(bv.Union(MemberPolicy))
FolderPolicy._resolved_member_policy_validator = bv.Nullable(bv.Union(MemberPolicy))
FolderPolicy._acl_update_policy_validator = bv.Union(AclUpdatePolicy)
FolderPolicy._shared_link_policy_validator = bv.Union(SharedLinkPolicy)
FolderPolicy._all_field_names_ = set([
    'member_policy',
    'resolved_member_policy',
    'acl_update_policy',
    'shared_link_policy',
])
FolderPolicy._all_fields_ = [
    ('member_policy', FolderPolicy._member_policy_validator),
    ('resolved_member_policy', FolderPolicy._resolved_member_policy_validator),
    ('acl_update_policy', FolderPolicy._acl_update_policy_validator),
    ('shared_link_policy', FolderPolicy._shared_link_policy_validator),
]

GetMetadataArgs._shared_folder_id_validator = common.SharedFolderId_validator
GetMetadataArgs._actions_validator = bv.Nullable(bv.List(bv.Union(FolderAction)))
GetMetadataArgs._all_field_names_ = set([
    'shared_folder_id',
    'actions',
])
GetMetadataArgs._all_fields_ = [
    ('shared_folder_id', GetMetadataArgs._shared_folder_id_validator),
    ('actions', GetMetadataArgs._actions_validator),
]

SharedLinkError._shared_link_not_found_validator = bv.Void()
SharedLinkError._shared_link_access_denied_validator = bv.Void()
SharedLinkError._other_validator = bv.Void()
SharedLinkError._tagmap = {
    'shared_link_not_found': SharedLinkError._shared_link_not_found_validator,
    'shared_link_access_denied': SharedLinkError._shared_link_access_denied_validator,
    'other': SharedLinkError._other_validator,
}

SharedLinkError.shared_link_not_found = SharedLinkError('shared_link_not_found')
SharedLinkError.shared_link_access_denied = SharedLinkError('shared_link_access_denied')
SharedLinkError.other = SharedLinkError('other')

GetSharedLinkFileError._shared_link_is_directory_validator = bv.Void()
GetSharedLinkFileError._tagmap = {
    'shared_link_is_directory': GetSharedLinkFileError._shared_link_is_directory_validator,
}
GetSharedLinkFileError._tagmap.update(SharedLinkError._tagmap)

GetSharedLinkFileError.shared_link_is_directory = GetSharedLinkFileError('shared_link_is_directory')

GetSharedLinkMetadataArg._url_validator = bv.String()
GetSharedLinkMetadataArg._path_validator = bv.Nullable(Path_validator)
GetSharedLinkMetadataArg._link_password_validator = bv.Nullable(bv.String())
GetSharedLinkMetadataArg._all_field_names_ = set([
    'url',
    'path',
    'link_password',
])
GetSharedLinkMetadataArg._all_fields_ = [
    ('url', GetSharedLinkMetadataArg._url_validator),
    ('path', GetSharedLinkMetadataArg._path_validator),
    ('link_password', GetSharedLinkMetadataArg._link_password_validator),
]

GetSharedLinksArg._path_validator = bv.Nullable(bv.String())
GetSharedLinksArg._all_field_names_ = set(['path'])
GetSharedLinksArg._all_fields_ = [('path', GetSharedLinksArg._path_validator)]

GetSharedLinksError._path_validator = files.MalformedPathError_validator
GetSharedLinksError._other_validator = bv.Void()
GetSharedLinksError._tagmap = {
    'path': GetSharedLinksError._path_validator,
    'other': GetSharedLinksError._other_validator,
}

GetSharedLinksError.other = GetSharedLinksError('other')

GetSharedLinksResult._links_validator = bv.List(bv.StructTree(LinkMetadata))
GetSharedLinksResult._all_field_names_ = set(['links'])
GetSharedLinksResult._all_fields_ = [('links', GetSharedLinksResult._links_validator)]

GroupInfo._group_type_validator = bv.Union(team.GroupType)
GroupInfo._same_team_validator = bv.Boolean()
GroupInfo._all_field_names_ = team.GroupSummary._all_field_names_.union(set([
    'group_type',
    'same_team',
]))
GroupInfo._all_fields_ = team.GroupSummary._all_fields_ + [
    ('group_type', GroupInfo._group_type_validator),
    ('same_team', GroupInfo._same_team_validator),
]

MembershipInfo._access_type_validator = bv.Union(AccessLevel)
MembershipInfo._permissions_validator = bv.Nullable(bv.List(bv.Struct(MemberPermission)))
MembershipInfo._initials_validator = bv.Nullable(bv.String())
MembershipInfo._is_inherited_validator = bv.Boolean()
MembershipInfo._all_field_names_ = set([
    'access_type',
    'permissions',
    'initials',
    'is_inherited',
])
MembershipInfo._all_fields_ = [
    ('access_type', MembershipInfo._access_type_validator),
    ('permissions', MembershipInfo._permissions_validator),
    ('initials', MembershipInfo._initials_validator),
    ('is_inherited', MembershipInfo._is_inherited_validator),
]

GroupMembershipInfo._group_validator = bv.Struct(GroupInfo)
GroupMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['group']))
GroupMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('group', GroupMembershipInfo._group_validator)]

InviteeInfo._email_validator = common.EmailAddress_validator
InviteeInfo._other_validator = bv.Void()
InviteeInfo._tagmap = {
    'email': InviteeInfo._email_validator,
    'other': InviteeInfo._other_validator,
}

InviteeInfo.other = InviteeInfo('other')

InviteeMembershipInfo._invitee_validator = bv.Union(InviteeInfo)
InviteeMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['invitee']))
InviteeMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('invitee', InviteeMembershipInfo._invitee_validator)]

JobError._unshare_folder_error_validator = bv.Union(UnshareFolderError)
JobError._remove_folder_member_error_validator = bv.Union(RemoveFolderMemberError)
JobError._other_validator = bv.Void()
JobError._tagmap = {
    'unshare_folder_error': JobError._unshare_folder_error_validator,
    'remove_folder_member_error': JobError._remove_folder_member_error_validator,
    'other': JobError._other_validator,
}

JobError.other = JobError('other')

JobStatus._complete_validator = bv.Void()
JobStatus._failed_validator = bv.Union(JobError)
JobStatus._tagmap = {
    'complete': JobStatus._complete_validator,
    'failed': JobStatus._failed_validator,
}
JobStatus._tagmap.update(async.PollResultBase._tagmap)

JobStatus.complete = JobStatus('complete')

LinkPermissions._resolved_visibility_validator = bv.Nullable(bv.Union(ResolvedVisibility))
LinkPermissions._requested_visibility_validator = bv.Nullable(bv.Union(RequestedVisibility))
LinkPermissions._can_revoke_validator = bv.Boolean()
LinkPermissions._revoke_failure_reason_validator = bv.Nullable(bv.Union(SharedLinkAccessFailureReason))
LinkPermissions._all_field_names_ = set([
    'resolved_visibility',
    'requested_visibility',
    'can_revoke',
    'revoke_failure_reason',
])
LinkPermissions._all_fields_ = [
    ('resolved_visibility', LinkPermissions._resolved_visibility_validator),
    ('requested_visibility', LinkPermissions._requested_visibility_validator),
    ('can_revoke', LinkPermissions._can_revoke_validator),
    ('revoke_failure_reason', LinkPermissions._revoke_failure_reason_validator),
]

ListFolderMembersCursorArg._actions_validator = bv.Nullable(bv.List(bv.Union(MemberAction)))
ListFolderMembersCursorArg._limit_validator = bv.UInt32(min_value=1, max_value=1000)
ListFolderMembersCursorArg._all_field_names_ = set([
    'actions',
    'limit',
])
ListFolderMembersCursorArg._all_fields_ = [
    ('actions', ListFolderMembersCursorArg._actions_validator),
    ('limit', ListFolderMembersCursorArg._limit_validator),
]

ListFolderMembersArgs._shared_folder_id_validator = common.SharedFolderId_validator
ListFolderMembersArgs._all_field_names_ = ListFolderMembersCursorArg._all_field_names_.union(set(['shared_folder_id']))
ListFolderMembersArgs._all_fields_ = ListFolderMembersCursorArg._all_fields_ + [('shared_folder_id', ListFolderMembersArgs._shared_folder_id_validator)]

ListFolderMembersContinueArg._cursor_validator = bv.String()
ListFolderMembersContinueArg._all_field_names_ = set(['cursor'])
ListFolderMembersContinueArg._all_fields_ = [('cursor', ListFolderMembersContinueArg._cursor_validator)]

ListFolderMembersContinueError._access_error_validator = bv.Union(SharedFolderAccessError)
ListFolderMembersContinueError._invalid_cursor_validator = bv.Void()
ListFolderMembersContinueError._other_validator = bv.Void()
ListFolderMembersContinueError._tagmap = {
    'access_error': ListFolderMembersContinueError._access_error_validator,
    'invalid_cursor': ListFolderMembersContinueError._invalid_cursor_validator,
    'other': ListFolderMembersContinueError._other_validator,
}

ListFolderMembersContinueError.invalid_cursor = ListFolderMembersContinueError('invalid_cursor')
ListFolderMembersContinueError.other = ListFolderMembersContinueError('other')

ListFoldersArgs._limit_validator = bv.UInt32(min_value=1, max_value=1000)
ListFoldersArgs._actions_validator = bv.Nullable(bv.List(bv.Union(FolderAction)))
ListFoldersArgs._all_field_names_ = set([
    'limit',
    'actions',
])
ListFoldersArgs._all_fields_ = [
    ('limit', ListFoldersArgs._limit_validator),
    ('actions', ListFoldersArgs._actions_validator),
]

ListFoldersContinueArg._cursor_validator = bv.String()
ListFoldersContinueArg._all_field_names_ = set(['cursor'])
ListFoldersContinueArg._all_fields_ = [('cursor', ListFoldersContinueArg._cursor_validator)]

ListFoldersContinueError._invalid_cursor_validator = bv.Void()
ListFoldersContinueError._other_validator = bv.Void()
ListFoldersContinueError._tagmap = {
    'invalid_cursor': ListFoldersContinueError._invalid_cursor_validator,
    'other': ListFoldersContinueError._other_validator,
}

ListFoldersContinueError.invalid_cursor = ListFoldersContinueError('invalid_cursor')
ListFoldersContinueError.other = ListFoldersContinueError('other')

ListFoldersResult._entries_validator = bv.List(bv.Struct(SharedFolderMetadata))
ListFoldersResult._cursor_validator = bv.Nullable(bv.String())
ListFoldersResult._all_field_names_ = set([
    'entries',
    'cursor',
])
ListFoldersResult._all_fields_ = [
    ('entries', ListFoldersResult._entries_validator),
    ('cursor', ListFoldersResult._cursor_validator),
]

ListSharedLinksArg._path_validator = bv.Nullable(ReadPath_validator)
ListSharedLinksArg._cursor_validator = bv.Nullable(bv.String())
ListSharedLinksArg._direct_only_validator = bv.Nullable(bv.Boolean())
ListSharedLinksArg._all_field_names_ = set([
    'path',
    'cursor',
    'direct_only',
])
ListSharedLinksArg._all_fields_ = [
    ('path', ListSharedLinksArg._path_validator),
    ('cursor', ListSharedLinksArg._cursor_validator),
    ('direct_only', ListSharedLinksArg._direct_only_validator),
]

ListSharedLinksError._path_validator = bv.Union(files.LookupError)
ListSharedLinksError._reset_validator = bv.Void()
ListSharedLinksError._other_validator = bv.Void()
ListSharedLinksError._tagmap = {
    'path': ListSharedLinksError._path_validator,
    'reset': ListSharedLinksError._reset_validator,
    'other': ListSharedLinksError._other_validator,
}

ListSharedLinksError.reset = ListSharedLinksError('reset')
ListSharedLinksError.other = ListSharedLinksError('other')

ListSharedLinksResult._links_validator = bv.List(bv.StructTree(SharedLinkMetadata))
ListSharedLinksResult._has_more_validator = bv.Boolean()
ListSharedLinksResult._cursor_validator = bv.Nullable(bv.String())
ListSharedLinksResult._all_field_names_ = set([
    'links',
    'has_more',
    'cursor',
])
ListSharedLinksResult._all_fields_ = [
    ('links', ListSharedLinksResult._links_validator),
    ('has_more', ListSharedLinksResult._has_more_validator),
    ('cursor', ListSharedLinksResult._cursor_validator),
]

MemberAction._make_editor_validator = bv.Void()
MemberAction._make_owner_validator = bv.Void()
MemberAction._make_viewer_validator = bv.Void()
MemberAction._remove_validator = bv.Void()
MemberAction._other_validator = bv.Void()
MemberAction._tagmap = {
    'make_editor': MemberAction._make_editor_validator,
    'make_owner': MemberAction._make_owner_validator,
    'make_viewer': MemberAction._make_viewer_validator,
    'remove': MemberAction._remove_validator,
    'other': MemberAction._other_validator,
}

MemberAction.make_editor = MemberAction('make_editor')
MemberAction.make_owner = MemberAction('make_owner')
MemberAction.make_viewer = MemberAction('make_viewer')
MemberAction.remove = MemberAction('remove')
MemberAction.other = MemberAction('other')

MemberPermission._action_validator = bv.Union(MemberAction)
MemberPermission._allow_validator = bv.Boolean()
MemberPermission._reason_validator = bv.Nullable(bv.Union(PermissionDeniedReason))
MemberPermission._all_field_names_ = set([
    'action',
    'allow',
    'reason',
])
MemberPermission._all_fields_ = [
    ('action', MemberPermission._action_validator),
    ('allow', MemberPermission._allow_validator),
    ('reason', MemberPermission._reason_validator),
]

MemberPolicy._team_validator = bv.Void()
MemberPolicy._anyone_validator = bv.Void()
MemberPolicy._other_validator = bv.Void()
MemberPolicy._tagmap = {
    'team': MemberPolicy._team_validator,
    'anyone': MemberPolicy._anyone_validator,
    'other': MemberPolicy._other_validator,
}

MemberPolicy.team = MemberPolicy('team')
MemberPolicy.anyone = MemberPolicy('anyone')
MemberPolicy.other = MemberPolicy('other')

MemberSelector._dropbox_id_validator = DropboxId_validator
MemberSelector._email_validator = common.EmailAddress_validator
MemberSelector._other_validator = bv.Void()
MemberSelector._tagmap = {
    'dropbox_id': MemberSelector._dropbox_id_validator,
    'email': MemberSelector._email_validator,
    'other': MemberSelector._other_validator,
}

MemberSelector.other = MemberSelector('other')

ModifySharedLinkSettingsArgs._url_validator = bv.String()
ModifySharedLinkSettingsArgs._settings_validator = bv.Struct(SharedLinkSettings)
ModifySharedLinkSettingsArgs._all_field_names_ = set([
    'url',
    'settings',
])
ModifySharedLinkSettingsArgs._all_fields_ = [
    ('url', ModifySharedLinkSettingsArgs._url_validator),
    ('settings', ModifySharedLinkSettingsArgs._settings_validator),
]

ModifySharedLinkSettingsError._settings_error_validator = bv.Union(SharedLinkSettingsError)
ModifySharedLinkSettingsError._email_not_verified_validator = bv.Void()
ModifySharedLinkSettingsError._tagmap = {
    'settings_error': ModifySharedLinkSettingsError._settings_error_validator,
    'email_not_verified': ModifySharedLinkSettingsError._email_not_verified_validator,
}
ModifySharedLinkSettingsError._tagmap.update(SharedLinkError._tagmap)

ModifySharedLinkSettingsError.email_not_verified = ModifySharedLinkSettingsError('email_not_verified')

MountFolderArg._shared_folder_id_validator = common.SharedFolderId_validator
MountFolderArg._all_field_names_ = set(['shared_folder_id'])
MountFolderArg._all_fields_ = [('shared_folder_id', MountFolderArg._shared_folder_id_validator)]

MountFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
MountFolderError._inside_shared_folder_validator = bv.Void()
MountFolderError._insufficient_quota_validator = bv.Void()
MountFolderError._already_mounted_validator = bv.Void()
MountFolderError._no_permission_validator = bv.Void()
MountFolderError._not_mountable_validator = bv.Void()
MountFolderError._other_validator = bv.Void()
MountFolderError._tagmap = {
    'access_error': MountFolderError._access_error_validator,
    'inside_shared_folder': MountFolderError._inside_shared_folder_validator,
    'insufficient_quota': MountFolderError._insufficient_quota_validator,
    'already_mounted': MountFolderError._already_mounted_validator,
    'no_permission': MountFolderError._no_permission_validator,
    'not_mountable': MountFolderError._not_mountable_validator,
    'other': MountFolderError._other_validator,
}

MountFolderError.inside_shared_folder = MountFolderError('inside_shared_folder')
MountFolderError.insufficient_quota = MountFolderError('insufficient_quota')
MountFolderError.already_mounted = MountFolderError('already_mounted')
MountFolderError.no_permission = MountFolderError('no_permission')
MountFolderError.not_mountable = MountFolderError('not_mountable')
MountFolderError.other = MountFolderError('other')

PathLinkMetadata._path_validator = bv.String()
PathLinkMetadata._field_names_ = set(['path'])
PathLinkMetadata._all_field_names_ = LinkMetadata._all_field_names_.union(PathLinkMetadata._field_names_)
PathLinkMetadata._fields_ = [('path', PathLinkMetadata._path_validator)]
PathLinkMetadata._all_fields_ = LinkMetadata._all_fields_ + PathLinkMetadata._fields_

PendingUploadMode._file_validator = bv.Void()
PendingUploadMode._folder_validator = bv.Void()
PendingUploadMode._tagmap = {
    'file': PendingUploadMode._file_validator,
    'folder': PendingUploadMode._folder_validator,
}

PendingUploadMode.file = PendingUploadMode('file')
PendingUploadMode.folder = PendingUploadMode('folder')

PermissionDeniedReason._user_not_same_team_as_owner_validator = bv.Void()
PermissionDeniedReason._user_not_allowed_by_owner_validator = bv.Void()
PermissionDeniedReason._target_is_indirect_member_validator = bv.Void()
PermissionDeniedReason._target_is_owner_validator = bv.Void()
PermissionDeniedReason._target_is_self_validator = bv.Void()
PermissionDeniedReason._target_not_active_validator = bv.Void()
PermissionDeniedReason._other_validator = bv.Void()
PermissionDeniedReason._tagmap = {
    'user_not_same_team_as_owner': PermissionDeniedReason._user_not_same_team_as_owner_validator,
    'user_not_allowed_by_owner': PermissionDeniedReason._user_not_allowed_by_owner_validator,
    'target_is_indirect_member': PermissionDeniedReason._target_is_indirect_member_validator,
    'target_is_owner': PermissionDeniedReason._target_is_owner_validator,
    'target_is_self': PermissionDeniedReason._target_is_self_validator,
    'target_not_active': PermissionDeniedReason._target_not_active_validator,
    'other': PermissionDeniedReason._other_validator,
}

PermissionDeniedReason.user_not_same_team_as_owner = PermissionDeniedReason('user_not_same_team_as_owner')
PermissionDeniedReason.user_not_allowed_by_owner = PermissionDeniedReason('user_not_allowed_by_owner')
PermissionDeniedReason.target_is_indirect_member = PermissionDeniedReason('target_is_indirect_member')
PermissionDeniedReason.target_is_owner = PermissionDeniedReason('target_is_owner')
PermissionDeniedReason.target_is_self = PermissionDeniedReason('target_is_self')
PermissionDeniedReason.target_not_active = PermissionDeniedReason('target_not_active')
PermissionDeniedReason.other = PermissionDeniedReason('other')

RelinquishFolderMembershipArg._shared_folder_id_validator = common.SharedFolderId_validator
RelinquishFolderMembershipArg._all_field_names_ = set(['shared_folder_id'])
RelinquishFolderMembershipArg._all_fields_ = [('shared_folder_id', RelinquishFolderMembershipArg._shared_folder_id_validator)]

RelinquishFolderMembershipError._access_error_validator = bv.Union(SharedFolderAccessError)
RelinquishFolderMembershipError._folder_owner_validator = bv.Void()
RelinquishFolderMembershipError._mounted_validator = bv.Void()
RelinquishFolderMembershipError._group_access_validator = bv.Void()
RelinquishFolderMembershipError._team_folder_validator = bv.Void()
RelinquishFolderMembershipError._no_permission_validator = bv.Void()
RelinquishFolderMembershipError._other_validator = bv.Void()
RelinquishFolderMembershipError._tagmap = {
    'access_error': RelinquishFolderMembershipError._access_error_validator,
    'folder_owner': RelinquishFolderMembershipError._folder_owner_validator,
    'mounted': RelinquishFolderMembershipError._mounted_validator,
    'group_access': RelinquishFolderMembershipError._group_access_validator,
    'team_folder': RelinquishFolderMembershipError._team_folder_validator,
    'no_permission': RelinquishFolderMembershipError._no_permission_validator,
    'other': RelinquishFolderMembershipError._other_validator,
}

RelinquishFolderMembershipError.folder_owner = RelinquishFolderMembershipError('folder_owner')
RelinquishFolderMembershipError.mounted = RelinquishFolderMembershipError('mounted')
RelinquishFolderMembershipError.group_access = RelinquishFolderMembershipError('group_access')
RelinquishFolderMembershipError.team_folder = RelinquishFolderMembershipError('team_folder')
RelinquishFolderMembershipError.no_permission = RelinquishFolderMembershipError('no_permission')
RelinquishFolderMembershipError.other = RelinquishFolderMembershipError('other')

RemoveFolderMemberArg._shared_folder_id_validator = common.SharedFolderId_validator
RemoveFolderMemberArg._member_validator = bv.Union(MemberSelector)
RemoveFolderMemberArg._leave_a_copy_validator = bv.Boolean()
RemoveFolderMemberArg._all_field_names_ = set([
    'shared_folder_id',
    'member',
    'leave_a_copy',
])
RemoveFolderMemberArg._all_fields_ = [
    ('shared_folder_id', RemoveFolderMemberArg._shared_folder_id_validator),
    ('member', RemoveFolderMemberArg._member_validator),
    ('leave_a_copy', RemoveFolderMemberArg._leave_a_copy_validator),
]

RemoveFolderMemberError._access_error_validator = bv.Union(SharedFolderAccessError)
RemoveFolderMemberError._member_error_validator = bv.Union(SharedFolderMemberError)
RemoveFolderMemberError._folder_owner_validator = bv.Void()
RemoveFolderMemberError._group_access_validator = bv.Void()
RemoveFolderMemberError._team_folder_validator = bv.Void()
RemoveFolderMemberError._no_permission_validator = bv.Void()
RemoveFolderMemberError._other_validator = bv.Void()
RemoveFolderMemberError._tagmap = {
    'access_error': RemoveFolderMemberError._access_error_validator,
    'member_error': RemoveFolderMemberError._member_error_validator,
    'folder_owner': RemoveFolderMemberError._folder_owner_validator,
    'group_access': RemoveFolderMemberError._group_access_validator,
    'team_folder': RemoveFolderMemberError._team_folder_validator,
    'no_permission': RemoveFolderMemberError._no_permission_validator,
    'other': RemoveFolderMemberError._other_validator,
}

RemoveFolderMemberError.folder_owner = RemoveFolderMemberError('folder_owner')
RemoveFolderMemberError.group_access = RemoveFolderMemberError('group_access')
RemoveFolderMemberError.team_folder = RemoveFolderMemberError('team_folder')
RemoveFolderMemberError.no_permission = RemoveFolderMemberError('no_permission')
RemoveFolderMemberError.other = RemoveFolderMemberError('other')

RequestedVisibility._public_validator = bv.Void()
RequestedVisibility._team_only_validator = bv.Void()
RequestedVisibility._password_validator = bv.Void()
RequestedVisibility._tagmap = {
    'public': RequestedVisibility._public_validator,
    'team_only': RequestedVisibility._team_only_validator,
    'password': RequestedVisibility._password_validator,
}

RequestedVisibility.public = RequestedVisibility('public')
RequestedVisibility.team_only = RequestedVisibility('team_only')
RequestedVisibility.password = RequestedVisibility('password')

ResolvedVisibility._team_and_password_validator = bv.Void()
ResolvedVisibility._shared_folder_only_validator = bv.Void()
ResolvedVisibility._other_validator = bv.Void()
ResolvedVisibility._tagmap = {
    'team_and_password': ResolvedVisibility._team_and_password_validator,
    'shared_folder_only': ResolvedVisibility._shared_folder_only_validator,
    'other': ResolvedVisibility._other_validator,
}
ResolvedVisibility._tagmap.update(RequestedVisibility._tagmap)

ResolvedVisibility.team_and_password = ResolvedVisibility('team_and_password')
ResolvedVisibility.shared_folder_only = ResolvedVisibility('shared_folder_only')
ResolvedVisibility.other = ResolvedVisibility('other')

RevokeSharedLinkArg._url_validator = bv.String()
RevokeSharedLinkArg._all_field_names_ = set(['url'])
RevokeSharedLinkArg._all_fields_ = [('url', RevokeSharedLinkArg._url_validator)]

RevokeSharedLinkError._shared_link_malformed_validator = bv.Void()
RevokeSharedLinkError._tagmap = {
    'shared_link_malformed': RevokeSharedLinkError._shared_link_malformed_validator,
}
RevokeSharedLinkError._tagmap.update(SharedLinkError._tagmap)

RevokeSharedLinkError.shared_link_malformed = RevokeSharedLinkError('shared_link_malformed')

ShareFolderArg._path_validator = files.Path_validator
ShareFolderArg._member_policy_validator = bv.Union(MemberPolicy)
ShareFolderArg._acl_update_policy_validator = bv.Union(AclUpdatePolicy)
ShareFolderArg._shared_link_policy_validator = bv.Union(SharedLinkPolicy)
ShareFolderArg._force_async_validator = bv.Boolean()
ShareFolderArg._all_field_names_ = set([
    'path',
    'member_policy',
    'acl_update_policy',
    'shared_link_policy',
    'force_async',
])
ShareFolderArg._all_fields_ = [
    ('path', ShareFolderArg._path_validator),
    ('member_policy', ShareFolderArg._member_policy_validator),
    ('acl_update_policy', ShareFolderArg._acl_update_policy_validator),
    ('shared_link_policy', ShareFolderArg._shared_link_policy_validator),
    ('force_async', ShareFolderArg._force_async_validator),
]

ShareFolderError._email_unverified_validator = bv.Void()
ShareFolderError._bad_path_validator = bv.Union(SharePathError)
ShareFolderError._team_policy_disallows_member_policy_validator = bv.Void()
ShareFolderError._disallowed_shared_link_policy_validator = bv.Void()
ShareFolderError._no_permission_validator = bv.Void()
ShareFolderError._other_validator = bv.Void()
ShareFolderError._tagmap = {
    'email_unverified': ShareFolderError._email_unverified_validator,
    'bad_path': ShareFolderError._bad_path_validator,
    'team_policy_disallows_member_policy': ShareFolderError._team_policy_disallows_member_policy_validator,
    'disallowed_shared_link_policy': ShareFolderError._disallowed_shared_link_policy_validator,
    'no_permission': ShareFolderError._no_permission_validator,
    'other': ShareFolderError._other_validator,
}

ShareFolderError.email_unverified = ShareFolderError('email_unverified')
ShareFolderError.team_policy_disallows_member_policy = ShareFolderError('team_policy_disallows_member_policy')
ShareFolderError.disallowed_shared_link_policy = ShareFolderError('disallowed_shared_link_policy')
ShareFolderError.no_permission = ShareFolderError('no_permission')
ShareFolderError.other = ShareFolderError('other')

ShareFolderJobStatus._complete_validator = bv.Struct(SharedFolderMetadata)
ShareFolderJobStatus._failed_validator = bv.Union(ShareFolderError)
ShareFolderJobStatus._tagmap = {
    'complete': ShareFolderJobStatus._complete_validator,
    'failed': ShareFolderJobStatus._failed_validator,
}
ShareFolderJobStatus._tagmap.update(async.PollResultBase._tagmap)

ShareFolderLaunch._complete_validator = bv.Struct(SharedFolderMetadata)
ShareFolderLaunch._tagmap = {
    'complete': ShareFolderLaunch._complete_validator,
}
ShareFolderLaunch._tagmap.update(async.LaunchResultBase._tagmap)

SharePathError._is_file_validator = bv.Void()
SharePathError._inside_shared_folder_validator = bv.Void()
SharePathError._contains_shared_folder_validator = bv.Void()
SharePathError._is_app_folder_validator = bv.Void()
SharePathError._inside_app_folder_validator = bv.Void()
SharePathError._already_shared_validator = bv.Void()
SharePathError._invalid_path_validator = bv.Void()
SharePathError._other_validator = bv.Void()
SharePathError._tagmap = {
    'is_file': SharePathError._is_file_validator,
    'inside_shared_folder': SharePathError._inside_shared_folder_validator,
    'contains_shared_folder': SharePathError._contains_shared_folder_validator,
    'is_app_folder': SharePathError._is_app_folder_validator,
    'inside_app_folder': SharePathError._inside_app_folder_validator,
    'already_shared': SharePathError._already_shared_validator,
    'invalid_path': SharePathError._invalid_path_validator,
    'other': SharePathError._other_validator,
}

SharePathError.is_file = SharePathError('is_file')
SharePathError.inside_shared_folder = SharePathError('inside_shared_folder')
SharePathError.contains_shared_folder = SharePathError('contains_shared_folder')
SharePathError.is_app_folder = SharePathError('is_app_folder')
SharePathError.inside_app_folder = SharePathError('inside_app_folder')
SharePathError.already_shared = SharePathError('already_shared')
SharePathError.invalid_path = SharePathError('invalid_path')
SharePathError.other = SharePathError('other')

SharedFolderAccessError._invalid_id_validator = bv.Void()
SharedFolderAccessError._not_a_member_validator = bv.Void()
SharedFolderAccessError._email_unverified_validator = bv.Void()
SharedFolderAccessError._unmounted_validator = bv.Void()
SharedFolderAccessError._other_validator = bv.Void()
SharedFolderAccessError._tagmap = {
    'invalid_id': SharedFolderAccessError._invalid_id_validator,
    'not_a_member': SharedFolderAccessError._not_a_member_validator,
    'email_unverified': SharedFolderAccessError._email_unverified_validator,
    'unmounted': SharedFolderAccessError._unmounted_validator,
    'other': SharedFolderAccessError._other_validator,
}

SharedFolderAccessError.invalid_id = SharedFolderAccessError('invalid_id')
SharedFolderAccessError.not_a_member = SharedFolderAccessError('not_a_member')
SharedFolderAccessError.email_unverified = SharedFolderAccessError('email_unverified')
SharedFolderAccessError.unmounted = SharedFolderAccessError('unmounted')
SharedFolderAccessError.other = SharedFolderAccessError('other')

SharedFolderMemberError._invalid_dropbox_id_validator = bv.Void()
SharedFolderMemberError._not_a_member_validator = bv.Void()
SharedFolderMemberError._other_validator = bv.Void()
SharedFolderMemberError._tagmap = {
    'invalid_dropbox_id': SharedFolderMemberError._invalid_dropbox_id_validator,
    'not_a_member': SharedFolderMemberError._not_a_member_validator,
    'other': SharedFolderMemberError._other_validator,
}

SharedFolderMemberError.invalid_dropbox_id = SharedFolderMemberError('invalid_dropbox_id')
SharedFolderMemberError.not_a_member = SharedFolderMemberError('not_a_member')
SharedFolderMemberError.other = SharedFolderMemberError('other')

SharedFolderMembers._users_validator = bv.List(bv.Struct(UserMembershipInfo))
SharedFolderMembers._groups_validator = bv.List(bv.Struct(GroupMembershipInfo))
SharedFolderMembers._invitees_validator = bv.List(bv.Struct(InviteeMembershipInfo))
SharedFolderMembers._cursor_validator = bv.Nullable(bv.String())
SharedFolderMembers._all_field_names_ = set([
    'users',
    'groups',
    'invitees',
    'cursor',
])
SharedFolderMembers._all_fields_ = [
    ('users', SharedFolderMembers._users_validator),
    ('groups', SharedFolderMembers._groups_validator),
    ('invitees', SharedFolderMembers._invitees_validator),
    ('cursor', SharedFolderMembers._cursor_validator),
]

SharedFolderMetadataBase._access_type_validator = bv.Union(AccessLevel)
SharedFolderMetadataBase._is_team_folder_validator = bv.Boolean()
SharedFolderMetadataBase._policy_validator = bv.Struct(FolderPolicy)
SharedFolderMetadataBase._permissions_validator = bv.Nullable(bv.List(bv.Struct(FolderPermission)))
SharedFolderMetadataBase._owner_team_validator = bv.Nullable(bv.Struct(users.Team))
SharedFolderMetadataBase._parent_shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
SharedFolderMetadataBase._all_field_names_ = set([
    'access_type',
    'is_team_folder',
    'policy',
    'permissions',
    'owner_team',
    'parent_shared_folder_id',
])
SharedFolderMetadataBase._all_fields_ = [
    ('access_type', SharedFolderMetadataBase._access_type_validator),
    ('is_team_folder', SharedFolderMetadataBase._is_team_folder_validator),
    ('policy', SharedFolderMetadataBase._policy_validator),
    ('permissions', SharedFolderMetadataBase._permissions_validator),
    ('owner_team', SharedFolderMetadataBase._owner_team_validator),
    ('parent_shared_folder_id', SharedFolderMetadataBase._parent_shared_folder_id_validator),
]

SharedFolderMetadata._path_lower_validator = bv.Nullable(bv.String())
SharedFolderMetadata._name_validator = bv.String()
SharedFolderMetadata._shared_folder_id_validator = common.SharedFolderId_validator
SharedFolderMetadata._all_field_names_ = SharedFolderMetadataBase._all_field_names_.union(set([
    'path_lower',
    'name',
    'shared_folder_id',
]))
SharedFolderMetadata._all_fields_ = SharedFolderMetadataBase._all_fields_ + [
    ('path_lower', SharedFolderMetadata._path_lower_validator),
    ('name', SharedFolderMetadata._name_validator),
    ('shared_folder_id', SharedFolderMetadata._shared_folder_id_validator),
]

SharedLinkAccessFailureReason._login_required_validator = bv.Void()
SharedLinkAccessFailureReason._email_verify_required_validator = bv.Void()
SharedLinkAccessFailureReason._password_required_validator = bv.Void()
SharedLinkAccessFailureReason._team_only_validator = bv.Void()
SharedLinkAccessFailureReason._owner_only_validator = bv.Void()
SharedLinkAccessFailureReason._other_validator = bv.Void()
SharedLinkAccessFailureReason._tagmap = {
    'login_required': SharedLinkAccessFailureReason._login_required_validator,
    'email_verify_required': SharedLinkAccessFailureReason._email_verify_required_validator,
    'password_required': SharedLinkAccessFailureReason._password_required_validator,
    'team_only': SharedLinkAccessFailureReason._team_only_validator,
    'owner_only': SharedLinkAccessFailureReason._owner_only_validator,
    'other': SharedLinkAccessFailureReason._other_validator,
}

SharedLinkAccessFailureReason.login_required = SharedLinkAccessFailureReason('login_required')
SharedLinkAccessFailureReason.email_verify_required = SharedLinkAccessFailureReason('email_verify_required')
SharedLinkAccessFailureReason.password_required = SharedLinkAccessFailureReason('password_required')
SharedLinkAccessFailureReason.team_only = SharedLinkAccessFailureReason('team_only')
SharedLinkAccessFailureReason.owner_only = SharedLinkAccessFailureReason('owner_only')
SharedLinkAccessFailureReason.other = SharedLinkAccessFailureReason('other')

SharedLinkPolicy._anyone_validator = bv.Void()
SharedLinkPolicy._members_validator = bv.Void()
SharedLinkPolicy._other_validator = bv.Void()
SharedLinkPolicy._tagmap = {
    'anyone': SharedLinkPolicy._anyone_validator,
    'members': SharedLinkPolicy._members_validator,
    'other': SharedLinkPolicy._other_validator,
}

SharedLinkPolicy.anyone = SharedLinkPolicy('anyone')
SharedLinkPolicy.members = SharedLinkPolicy('members')
SharedLinkPolicy.other = SharedLinkPolicy('other')

SharedLinkSettings._requested_visibility_validator = bv.Nullable(bv.Union(RequestedVisibility))
SharedLinkSettings._link_password_validator = bv.Nullable(bv.String())
SharedLinkSettings._expires_validator = bv.Nullable(common.DropboxTimestamp_validator)
SharedLinkSettings._all_field_names_ = set([
    'requested_visibility',
    'link_password',
    'expires',
])
SharedLinkSettings._all_fields_ = [
    ('requested_visibility', SharedLinkSettings._requested_visibility_validator),
    ('link_password', SharedLinkSettings._link_password_validator),
    ('expires', SharedLinkSettings._expires_validator),
]

SharedLinkSettingsError._invalid_settings_validator = bv.Void()
SharedLinkSettingsError._not_authorized_validator = bv.Void()
SharedLinkSettingsError._tagmap = {
    'invalid_settings': SharedLinkSettingsError._invalid_settings_validator,
    'not_authorized': SharedLinkSettingsError._not_authorized_validator,
}

SharedLinkSettingsError.invalid_settings = SharedLinkSettingsError('invalid_settings')
SharedLinkSettingsError.not_authorized = SharedLinkSettingsError('not_authorized')

TeamMemberInfo._team_info_validator = TeamInfo_validator
TeamMemberInfo._display_name_validator = bv.String()
TeamMemberInfo._member_id_validator = bv.Nullable(bv.String())
TeamMemberInfo._all_field_names_ = set([
    'team_info',
    'display_name',
    'member_id',
])
TeamMemberInfo._all_fields_ = [
    ('team_info', TeamMemberInfo._team_info_validator),
    ('display_name', TeamMemberInfo._display_name_validator),
    ('member_id', TeamMemberInfo._member_id_validator),
]

TransferFolderArg._shared_folder_id_validator = common.SharedFolderId_validator
TransferFolderArg._to_dropbox_id_validator = DropboxId_validator
TransferFolderArg._all_field_names_ = set([
    'shared_folder_id',
    'to_dropbox_id',
])
TransferFolderArg._all_fields_ = [
    ('shared_folder_id', TransferFolderArg._shared_folder_id_validator),
    ('to_dropbox_id', TransferFolderArg._to_dropbox_id_validator),
]

TransferFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
TransferFolderError._invalid_dropbox_id_validator = bv.Void()
TransferFolderError._new_owner_not_a_member_validator = bv.Void()
TransferFolderError._new_owner_unmounted_validator = bv.Void()
TransferFolderError._new_owner_email_unverified_validator = bv.Void()
TransferFolderError._team_folder_validator = bv.Void()
TransferFolderError._no_permission_validator = bv.Void()
TransferFolderError._other_validator = bv.Void()
TransferFolderError._tagmap = {
    'access_error': TransferFolderError._access_error_validator,
    'invalid_dropbox_id': TransferFolderError._invalid_dropbox_id_validator,
    'new_owner_not_a_member': TransferFolderError._new_owner_not_a_member_validator,
    'new_owner_unmounted': TransferFolderError._new_owner_unmounted_validator,
    'new_owner_email_unverified': TransferFolderError._new_owner_email_unverified_validator,
    'team_folder': TransferFolderError._team_folder_validator,
    'no_permission': TransferFolderError._no_permission_validator,
    'other': TransferFolderError._other_validator,
}

TransferFolderError.invalid_dropbox_id = TransferFolderError('invalid_dropbox_id')
TransferFolderError.new_owner_not_a_member = TransferFolderError('new_owner_not_a_member')
TransferFolderError.new_owner_unmounted = TransferFolderError('new_owner_unmounted')
TransferFolderError.new_owner_email_unverified = TransferFolderError('new_owner_email_unverified')
TransferFolderError.team_folder = TransferFolderError('team_folder')
TransferFolderError.no_permission = TransferFolderError('no_permission')
TransferFolderError.other = TransferFolderError('other')

UnmountFolderArg._shared_folder_id_validator = common.SharedFolderId_validator
UnmountFolderArg._all_field_names_ = set(['shared_folder_id'])
UnmountFolderArg._all_fields_ = [('shared_folder_id', UnmountFolderArg._shared_folder_id_validator)]

UnmountFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
UnmountFolderError._no_permission_validator = bv.Void()
UnmountFolderError._not_unmountable_validator = bv.Void()
UnmountFolderError._other_validator = bv.Void()
UnmountFolderError._tagmap = {
    'access_error': UnmountFolderError._access_error_validator,
    'no_permission': UnmountFolderError._no_permission_validator,
    'not_unmountable': UnmountFolderError._not_unmountable_validator,
    'other': UnmountFolderError._other_validator,
}

UnmountFolderError.no_permission = UnmountFolderError('no_permission')
UnmountFolderError.not_unmountable = UnmountFolderError('not_unmountable')
UnmountFolderError.other = UnmountFolderError('other')

UnshareFolderArg._shared_folder_id_validator = common.SharedFolderId_validator
UnshareFolderArg._leave_a_copy_validator = bv.Boolean()
UnshareFolderArg._all_field_names_ = set([
    'shared_folder_id',
    'leave_a_copy',
])
UnshareFolderArg._all_fields_ = [
    ('shared_folder_id', UnshareFolderArg._shared_folder_id_validator),
    ('leave_a_copy', UnshareFolderArg._leave_a_copy_validator),
]

UnshareFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
UnshareFolderError._team_folder_validator = bv.Void()
UnshareFolderError._no_permission_validator = bv.Void()
UnshareFolderError._other_validator = bv.Void()
UnshareFolderError._tagmap = {
    'access_error': UnshareFolderError._access_error_validator,
    'team_folder': UnshareFolderError._team_folder_validator,
    'no_permission': UnshareFolderError._no_permission_validator,
    'other': UnshareFolderError._other_validator,
}

UnshareFolderError.team_folder = UnshareFolderError('team_folder')
UnshareFolderError.no_permission = UnshareFolderError('no_permission')
UnshareFolderError.other = UnshareFolderError('other')

UpdateFolderMemberArg._shared_folder_id_validator = common.SharedFolderId_validator
UpdateFolderMemberArg._member_validator = bv.Union(MemberSelector)
UpdateFolderMemberArg._access_level_validator = bv.Union(AccessLevel)
UpdateFolderMemberArg._all_field_names_ = set([
    'shared_folder_id',
    'member',
    'access_level',
])
UpdateFolderMemberArg._all_fields_ = [
    ('shared_folder_id', UpdateFolderMemberArg._shared_folder_id_validator),
    ('member', UpdateFolderMemberArg._member_validator),
    ('access_level', UpdateFolderMemberArg._access_level_validator),
]

UpdateFolderMemberError._access_error_validator = bv.Union(SharedFolderAccessError)
UpdateFolderMemberError._member_error_validator = bv.Union(SharedFolderMemberError)
UpdateFolderMemberError._insufficient_plan_validator = bv.Void()
UpdateFolderMemberError._no_permission_validator = bv.Void()
UpdateFolderMemberError._other_validator = bv.Void()
UpdateFolderMemberError._tagmap = {
    'access_error': UpdateFolderMemberError._access_error_validator,
    'member_error': UpdateFolderMemberError._member_error_validator,
    'insufficient_plan': UpdateFolderMemberError._insufficient_plan_validator,
    'no_permission': UpdateFolderMemberError._no_permission_validator,
    'other': UpdateFolderMemberError._other_validator,
}

UpdateFolderMemberError.insufficient_plan = UpdateFolderMemberError('insufficient_plan')
UpdateFolderMemberError.no_permission = UpdateFolderMemberError('no_permission')
UpdateFolderMemberError.other = UpdateFolderMemberError('other')

UpdateFolderPolicyArg._shared_folder_id_validator = common.SharedFolderId_validator
UpdateFolderPolicyArg._member_policy_validator = bv.Nullable(bv.Union(MemberPolicy))
UpdateFolderPolicyArg._acl_update_policy_validator = bv.Nullable(bv.Union(AclUpdatePolicy))
UpdateFolderPolicyArg._shared_link_policy_validator = bv.Nullable(bv.Union(SharedLinkPolicy))
UpdateFolderPolicyArg._all_field_names_ = set([
    'shared_folder_id',
    'member_policy',
    'acl_update_policy',
    'shared_link_policy',
])
UpdateFolderPolicyArg._all_fields_ = [
    ('shared_folder_id', UpdateFolderPolicyArg._shared_folder_id_validator),
    ('member_policy', UpdateFolderPolicyArg._member_policy_validator),
    ('acl_update_policy', UpdateFolderPolicyArg._acl_update_policy_validator),
    ('shared_link_policy', UpdateFolderPolicyArg._shared_link_policy_validator),
]

UpdateFolderPolicyError._access_error_validator = bv.Union(SharedFolderAccessError)
UpdateFolderPolicyError._not_on_team_validator = bv.Void()
UpdateFolderPolicyError._team_policy_disallows_member_policy_validator = bv.Void()
UpdateFolderPolicyError._disallowed_shared_link_policy_validator = bv.Void()
UpdateFolderPolicyError._other_validator = bv.Void()
UpdateFolderPolicyError._tagmap = {
    'access_error': UpdateFolderPolicyError._access_error_validator,
    'not_on_team': UpdateFolderPolicyError._not_on_team_validator,
    'team_policy_disallows_member_policy': UpdateFolderPolicyError._team_policy_disallows_member_policy_validator,
    'disallowed_shared_link_policy': UpdateFolderPolicyError._disallowed_shared_link_policy_validator,
    'other': UpdateFolderPolicyError._other_validator,
}

UpdateFolderPolicyError.not_on_team = UpdateFolderPolicyError('not_on_team')
UpdateFolderPolicyError.team_policy_disallows_member_policy = UpdateFolderPolicyError('team_policy_disallows_member_policy')
UpdateFolderPolicyError.disallowed_shared_link_policy = UpdateFolderPolicyError('disallowed_shared_link_policy')
UpdateFolderPolicyError.other = UpdateFolderPolicyError('other')

UserInfo._account_id_validator = users.AccountId_validator
UserInfo._same_team_validator = bv.Boolean()
UserInfo._team_member_id_validator = bv.Nullable(bv.String())
UserInfo._all_field_names_ = set([
    'account_id',
    'same_team',
    'team_member_id',
])
UserInfo._all_fields_ = [
    ('account_id', UserInfo._account_id_validator),
    ('same_team', UserInfo._same_team_validator),
    ('team_member_id', UserInfo._team_member_id_validator),
]

UserMembershipInfo._user_validator = bv.Struct(UserInfo)
UserMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['user']))
UserMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('user', UserMembershipInfo._user_validator)]

Visibility._public_validator = bv.Void()
Visibility._team_only_validator = bv.Void()
Visibility._password_validator = bv.Void()
Visibility._team_and_password_validator = bv.Void()
Visibility._shared_folder_only_validator = bv.Void()
Visibility._other_validator = bv.Void()
Visibility._tagmap = {
    'public': Visibility._public_validator,
    'team_only': Visibility._team_only_validator,
    'password': Visibility._password_validator,
    'team_and_password': Visibility._team_and_password_validator,
    'shared_folder_only': Visibility._shared_folder_only_validator,
    'other': Visibility._other_validator,
}

Visibility.public = Visibility('public')
Visibility.team_only = Visibility('team_only')
Visibility.password = Visibility('password')
Visibility.team_and_password = Visibility('team_and_password')
Visibility.shared_folder_only = Visibility('shared_folder_only')
Visibility.other = Visibility('other')

