/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import java.io.IOException;
import java.io.OutputStream;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ErrorNotifiable;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.Window;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;

public final class ChannelOutputStream
extends OutputStream
implements ErrorNotifiable {
    private final Channel chan;
    private final Transport trans;
    private final Window.Remote win;
    private final DataBuffer buffer = new DataBuffer();
    private final byte[] b = new byte[1];
    private boolean closed;
    private SSHException error;

    public ChannelOutputStream(Channel chan, Transport trans, Window.Remote win) {
        this.chan = chan;
        this.trans = trans;
        this.win = win;
    }

    @Override
    public synchronized void write(int w) throws IOException {
        this.b[0] = (byte)w;
        this.write(this.b, 0, 1);
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        this.checkClose();
        while (len > 0) {
            int n = this.buffer.write(data, off, len);
            off += n;
            len -= n;
        }
    }

    @Override
    public synchronized void notifyError(SSHException error) {
        this.error = error;
    }

    private void checkClose() throws SSHException {
        if (this.closed) {
            if (this.error != null) {
                throw this.error;
            }
            throw new ConnectionException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                this.buffer.flush();
                this.chan.sendEOF();
            }
            finally {
                this.setClosed();
            }
        }
    }

    public synchronized void setClosed() {
        this.closed = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkClose();
        this.buffer.flush();
    }

    public String toString() {
        return "< ChannelOutputStream for Channel #" + this.chan.getID() + " >";
    }

    private final class DataBuffer {
        private final int headerOffset;
        private final int dataOffset;
        private final SSHPacket packet = new SSHPacket(Message.CHANNEL_DATA);
        private final Buffer.PlainBuffer leftOvers = new Buffer.PlainBuffer();

        DataBuffer() {
            this.headerOffset = this.packet.rpos();
            this.packet.putUInt32(0L);
            this.packet.putUInt32(0L);
            this.dataOffset = this.packet.wpos();
        }

        int write(byte[] data, int off, int len) throws TransportException, ConnectionException {
            int bufferSize = this.packet.wpos() - this.dataOffset;
            if (bufferSize >= ChannelOutputStream.this.win.getMaxPacketSize()) {
                this.flush(bufferSize);
                return 0;
            }
            int n = Math.min(len, ChannelOutputStream.this.win.getMaxPacketSize() - bufferSize);
            this.packet.putRawBytes(data, off, n);
            return n;
        }

        void flush() throws TransportException, ConnectionException {
            this.flush(this.packet.wpos() - this.dataOffset);
        }

        void flush(int bufferSize) throws TransportException, ConnectionException {
            while (bufferSize > 0) {
                long remoteWindowSize = ChannelOutputStream.this.win.getSize();
                if (remoteWindowSize == 0L) {
                    remoteWindowSize = ChannelOutputStream.this.win.awaitExpansion(remoteWindowSize);
                }
                int writeNow = Math.min(bufferSize, (int)Math.min((long)ChannelOutputStream.this.win.getMaxPacketSize(), remoteWindowSize));
                this.packet.wpos(this.headerOffset);
                this.packet.putMessageID(Message.CHANNEL_DATA);
                this.packet.putUInt32(ChannelOutputStream.this.chan.getRecipient());
                this.packet.putUInt32(writeNow);
                this.packet.wpos(this.dataOffset + writeNow);
                int leftOverBytes = bufferSize - writeNow;
                if (leftOverBytes > 0) {
                    this.leftOvers.putRawBytes(this.packet.array(), this.packet.wpos(), leftOverBytes);
                }
                ChannelOutputStream.this.trans.write(this.packet);
                ChannelOutputStream.this.win.consume(writeNow);
                this.packet.rpos(this.headerOffset);
                this.packet.wpos(this.dataOffset);
                if (leftOverBytes > 0) {
                    this.packet.putBuffer(this.leftOvers);
                    this.leftOvers.clear();
                }
                bufferSize = leftOverBytes;
            }
        }
    }
}

