/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.ProcessTask;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.StaticMethodTask;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;

public class CronParser {
    private CronParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskTable parse(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            TaskTable taskTable = CronParser.parse(fileInputStream);
            return taskTable;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskTable parse(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            TaskTable taskTable = CronParser.parse(inputStream);
            return taskTable;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static TaskTable parse(InputStream inputStream) throws IOException {
        return CronParser.parse(new InputStreamReader(inputStream, "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskTable parse(Reader reader) throws IOException {
        TaskTable taskTable = new TaskTable();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    CronParser.parseLine(taskTable, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        finally {
            reader.close();
        }
        return taskTable;
    }

    public static void parseLine(TaskTable taskTable, String string) throws Exception {
        Task task;
        Object object;
        Object object2;
        int n;
        CharSequence charSequence;
        if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') {
            return;
        }
        int n2 = string.length();
        String string2 = null;
        for (int i = n2; i >= 0; --i) {
            charSequence = string.substring(0, i);
            if (!SchedulingPattern.validate((String)charSequence)) continue;
            string2 = charSequence;
            break;
        }
        if (string2 == null) {
            throw new Exception("Invalid cron line: " + string);
        }
        string = string.substring(string2.length());
        n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        charSequence = null;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            boolean bl2;
            char c = string.charAt(n);
            if (charSequence == null) {
                if (c == '\"') {
                    charSequence = new StringBuffer();
                    bl = true;
                    continue;
                }
                if (c <= ' ') continue;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(c);
                bl = false;
                continue;
            }
            if (bl) {
                bl2 = c == '\"';
            } else {
                boolean bl3 = bl2 = c <= ' ';
            }
            if (bl2) {
                if (charSequence != null && ((StringBuffer)charSequence).length() > 0) {
                    object2 = ((StringBuffer)charSequence).toString();
                    if (bl) {
                        object2 = CronParser.escape((String)object2);
                    }
                    arrayList.add((String)object2);
                }
                charSequence = null;
                continue;
            }
            ((StringBuffer)charSequence).append(c);
        }
        if (charSequence != null && ((StringBuffer)charSequence).length() > 0) {
            String string3 = ((StringBuffer)charSequence).toString();
            if (bl) {
                string3 = CronParser.escape(string3);
            }
            arrayList.add(string3);
            charSequence = null;
        }
        n2 = arrayList.size();
        n = 0;
        String string4 = null;
        File file = null;
        object2 = null;
        File file2 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = null;
        ArrayList<String[]> arrayList3 = new ArrayList<String[]>();
        for (int i = 0; i < n2; ++i) {
            object = (String[])arrayList.get(i);
            if (n == 0) {
                if (object.startsWith("ENV:")) {
                    arrayList2.add(object.substring(4));
                    continue;
                }
                if (object.startsWith("DIR:")) {
                    string4 = object.substring(4);
                    continue;
                }
                if (object.startsWith("IN:")) {
                    file = new File(object.substring(3));
                    continue;
                }
                if (object.startsWith("OUT:")) {
                    object2 = new File(object.substring(4));
                    continue;
                }
                if (object.startsWith("ERR:")) {
                    file2 = new File(object.substring(4));
                    continue;
                }
                n = 1;
            }
            if (n != 1) continue;
            if (stringArray == null) {
                stringArray = object;
                continue;
            }
            arrayList3.add((String[])object);
        }
        if (stringArray == null) {
            throw new Exception("Invalid cron line: " + string);
        }
        if (stringArray.startsWith("java:")) {
            String string5;
            object = stringArray.substring(5);
            if (object.length() == 0) {
                throw new Exception("Invalid Java class name on line: " + string);
            }
            int n3 = object.indexOf(35);
            if (n3 == -1) {
                string5 = "main";
            } else {
                string5 = object.substring(n3 + 1);
                object = object.substring(0, n3);
                if (string5.length() == 0) {
                    throw new Exception("Invalid Java method name on line: " + string);
                }
            }
            String[] stringArray2 = new String[arrayList3.size()];
            for (int i = 0; i < arrayList3.size(); ++i) {
                stringArray2[i] = (String)arrayList3.get(i);
            }
            task = new StaticMethodTask((String)object, string5, stringArray2);
        } else {
            object = new String[1 + arrayList3.size()];
            object[0] = stringArray;
            for (int i = 0; i < arrayList3.size(); ++i) {
                object[i + 1] = (String)arrayList3.get(i);
            }
            String[] stringArray3 = null;
            n2 = arrayList2.size();
            if (n2 > 0) {
                stringArray3 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray3[i] = (String)arrayList2.get(i);
                }
            }
            File file3 = null;
            if (!(string4 == null || (file3 = new File(string4)).exists() && file3.isDirectory())) {
                throw new Exception("Invalid cron working directory parameter at line: " + string, new FileNotFoundException(string4 + " doesn't exist or it is not a directory"));
            }
            ProcessTask processTask = new ProcessTask((String[])object, stringArray3, file3);
            if (file != null) {
                processTask.setStdinFile(file);
            }
            if (object2 != null) {
                processTask.setStdoutFile((File)object2);
            }
            if (file2 != null) {
                processTask.setStderrFile(file2);
            }
            task = processTask;
        }
        taskTable.add(new SchedulingPattern(string2), task);
    }

    private static String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            char c = string.charAt(i);
            if (c == '\\' && i < n - 1) {
                char c2 = string.charAt(i + 1);
                if (c2 == '\"') {
                    stringBuffer.append('\"');
                    n2 = 2;
                } else if (c2 == '\\') {
                    stringBuffer.append('\\');
                    n2 = 2;
                } else if (c2 == '/') {
                    stringBuffer.append('/');
                    n2 = 2;
                } else if (c2 == 'b') {
                    stringBuffer.append('\b');
                    n2 = 2;
                } else if (c2 == 'f') {
                    stringBuffer.append('\f');
                    n2 = 2;
                } else if (c2 == 'n') {
                    stringBuffer.append('\n');
                    n2 = 2;
                } else if (c2 == 'r') {
                    stringBuffer.append('\r');
                    n2 = 2;
                } else if (c2 == 't') {
                    stringBuffer.append('\t');
                    n2 = 2;
                } else if (c2 == 'u' && i < n - 5) {
                    String string2 = string.substring(i + 2, i + 6);
                    try {
                        int n3 = Integer.parseInt(string2, 16);
                        if (n3 >= 0) {
                            stringBuffer.append((char)n3);
                            n2 = 6;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (n2 == 0) {
                stringBuffer.append(c);
                continue;
            }
            i += n2 - 1;
        }
        return stringBuffer.toString();
    }
}

