/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ShardValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ShardValidateQueryResponse;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportValidateQueryAction
extends TransportBroadcastAction<ValidateQueryRequest, ValidateQueryResponse, ShardValidateQueryRequest, ShardValidateQueryResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;

    @Inject
    public TransportValidateQueryAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/validate/query", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ValidateQueryRequest.class, ShardValidateQueryRequest.class, "search");
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
    }

    @Override
    protected void doExecute(Task task, ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(task, request, listener);
    }

    @Override
    protected ShardValidateQueryRequest newShardRequest(int numShards, ShardRouting shard, ValidateQueryRequest request) {
        String[] filteringAliases = this.indexNameExpressionResolver.filteringAliases(this.clusterService.state(), shard.index(), request.indices());
        return new ShardValidateQueryRequest(shard.shardId(), filteringAliases, request);
    }

    @Override
    protected ShardValidateQueryResponse newShardResponse() {
        return new ShardValidateQueryResponse();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, ValidateQueryRequest request, String[] concreteIndices) {
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, Integer.toString(ThreadLocalRandom.current().nextInt(1000)), request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, "_local");
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ValidateQueryRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ValidateQueryRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected ValidateQueryResponse newResponse(ValidateQueryRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        boolean valid = true;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        ArrayList<QueryExplanation> queryExplanations = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ShardValidateQueryResponse validateQueryResponse = (ShardValidateQueryResponse)shardResponse;
            boolean bl = valid = valid && validateQueryResponse.isValid();
            if (request.explain() || request.rewrite()) {
                if (queryExplanations == null) {
                    queryExplanations = new ArrayList<QueryExplanation>();
                }
                queryExplanations.add(new QueryExplanation(validateQueryResponse.getIndex(), validateQueryResponse.isValid(), validateQueryResponse.getExplanation(), validateQueryResponse.getError()));
            }
            ++successfulShards;
        }
        return new ValidateQueryResponse(valid, queryExplanations, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ShardValidateQueryResponse shardOperation(ShardValidateQueryRequest request) {
        boolean valid;
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexQueryParserService queryParserService = indexService.queryParserService();
        IndexShard indexShard = indexService.shardSafe(request.shardId().id());
        String explanation = null;
        String error = null;
        Engine.Searcher searcher = indexShard.acquireSearcher("validate_query");
        DefaultSearchContext searchContext = new DefaultSearchContext(0L, new ShardSearchLocalRequest(request.types(), request.nowInMillis(), request.filteringAliases()), null, searcher, indexService, indexShard, this.scriptService, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), this.parseFieldMatcher, SearchService.NO_TIMEOUT);
        SearchContext.setCurrent(searchContext);
        try {
            if (request.source() != null && request.source().length() > 0) {
                searchContext.parsedQuery(queryParserService.parseQuery(request.source()));
            }
            searchContext.preProcess();
            valid = true;
            if (request.rewrite()) {
                explanation = this.getRewrittenQuery(searcher.searcher(), searchContext.query());
            } else if (request.explain()) {
                explanation = searchContext.filteredQuery().query().toString();
            }
        }
        catch (QueryParsingException e) {
            valid = false;
            error = e.getDetailedMessage();
        }
        catch (IOException | AssertionError e) {
            valid = false;
            error = ((Throwable)e).getMessage();
        }
        finally {
            searchContext.close();
            SearchContext.removeCurrent();
        }
        return new ShardValidateQueryResponse(request.shardId(), valid, explanation, error);
    }

    private String getRewrittenQuery(IndexSearcher searcher, Query query) throws IOException {
        Query queryRewrite = searcher.rewrite(query);
        if (queryRewrite instanceof MatchNoDocsQuery) {
            return query.toString();
        }
        return queryRewrite.toString();
    }
}

