/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.hooks.PermanentMindMapNodeHookAdapter;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewVisitor;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class BlinkingNodeHook
extends PermanentMindMapNodeHookAdapter {
    private Timer timer = null;
    static Vector colors = new Vector();

    @Override
    public void invoke(MindMapNode node) {
        super.invoke(node);
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new TimerColorChanger(), 500L, 500L);
            this.nodeChanged(this.getNode());
        }
    }

    @Override
    public void shutdownMapHook() {
        this.timer.cancel();
        this.nodeChanged(this.getNode());
        this.timer = null;
        super.shutdownMapHook();
    }

    protected class TimerColorChanger
    extends TimerTask {
        TimerColorChanger() {
            colors.clear();
            colors.add(Color.BLUE);
            colors.add(Color.RED);
            colors.add(Color.MAGENTA);
            colors.add(Color.CYAN);
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (BlinkingNodeHook.this.getNode() == null || BlinkingNodeHook.this.getController().isBlocked()) {
                        return;
                    }
                    BlinkingNodeHook.this.getNode().acceptViewVisitor(new NodeViewVisitor(){

                        @Override
                        public void visit(NodeView view) {
                            if (!view.isVisible()) {
                                return;
                            }
                            Color col = view.getMainView().getForeground();
                            int index = -1;
                            if (col != null && colors.contains(col)) {
                                index = colors.indexOf(col);
                            }
                            if (++index >= colors.size()) {
                                index = 0;
                            }
                            view.getMainView().setForeground((Color)colors.get(index));
                        }
                    });
                }
            });
        }
    }
}

